/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.busi.ContractSignatureUploadBusiService;
import com.tydic.contract.busi.bo.ContractSignatureUploadBusiReqBO;
import com.tydic.contract.busi.bo.ContractSignatureUploadBusiRspBO;
import com.tydic.contract.utils.FileHelper;
import com.tydic.contract.utils.HttpUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class ContractSignatureUploadBusiServiceImpl
implements ContractSignatureUploadBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractSignatureUploadBusiServiceImpl.class);
    @Value(value="${SIGNATURE_UPLOAD_IP}")
    private String fileUploadIp;
    private static final String FILE_UPLOAD_URL = "/files/upload";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContractSignatureUploadBusiRspBO contractSignatureUpload(ContractSignatureUploadBusiReqBO reqBO) {
        ContractSignatureUploadBusiRspBO rspBO = new ContractSignatureUploadBusiRspBO();
        String preName = "signDocument-";
        String fileName = preName + String.valueOf(Sequence.getInstance().nextId() + ".pdf");
        HttpUtil.httpDownload(reqBO.getAccessoryUrl(), fileName);
        log.info("\u5408\u540c\u7b7e\u7f72\u5b8c\u6210-\u4e0b\u8f7d\u5230\u672c\u5730");
        String result = null;
        FileOutputStream fos = null;
        File file = null;
        try {
            int temp;
            byte[] bytes = FileHelper.getBytes(fileName);
            ByteArrayInputStream input = new ByteArrayInputStream(bytes);
            file = new File(fileName);
            fos = new FileOutputStream(file);
            byte[] bt = new byte[10240];
            while ((temp = input.read(bt)) != -1) {
                fos.write(bt, 0, temp);
            }
            reqBO.setFile(file);
            result = HttpUtil.httpUploadSignature2(this.fileUploadIp + FILE_UPLOAD_URL, reqBO);
        }
        catch (Exception e) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528\u5916\u90e8\u7535\u5b50\u7b7e\u7ae0\u4e0a\u4f20\u6587\u4ef6\u63a5\u53e3\u63a5\u53e3\u5f02\u5e38");
            ContractSignatureUploadBusiRspBO input = rspBO;
            return input;
        }
        finally {
            try {
                if (null != fos) {
                    fos.close();
                }
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
            if (ObjectUtils.isEmpty((Object)file)) {
                log.error("file\u5bf9\u8c61\u662f\u7a7a\u7684");
            } else if (!file.exists()) {
                log.info("\u5220\u9664\u6587\u4ef6\u5931\u8d25:" + fileName + "\u4e0d\u5b58\u5728\uff01");
            } else if (file.isFile()) {
                if (file.delete()) {
                    log.info("\u5220\u9664\u6587\u4ef6" + fileName + "\u6210\u529f\uff01");
                } else {
                    log.info("\u5220\u9664\u6587\u4ef6" + fileName + "\u5931\u8d25\uff01");
                }
            }
        }
        log.info("\u8c03\u7528\u5916\u90e8\u7535\u5b50\u7b7e\u7ae0\u4e0a\u4f20\u6587\u4ef6\u63a5\u53e3\u51fa\u53c2\uff1a" + result);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        if (jsonObject.get((Object)"code").equals("200")) {
            Object content = jsonObject.get((Object)"content");
            ContractSignatureUploadBusiRspBO contractSignatureUploadBusiRspBO = (ContractSignatureUploadBusiRspBO)((Object)JSONObject.parseObject((String)content.toString(), ContractSignatureUploadBusiRspBO.class));
            rspBO.setFileId(contractSignatureUploadBusiRspBO.getFileId());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        rspBO.setRespCode("\u5931\u8d25");
        rspBO.setRespDesc("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01");
        return rspBO;
    }
}

