/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.tydic.contract.ability.bo.ContractApprovalListTabAmountInfoBO;
import com.tydic.contract.busi.QueryContractApprovalListTabAmountBusiService;
import com.tydic.contract.busi.bo.QueryContractApprovalListTabAmountBusiReqBO;
import com.tydic.contract.busi.bo.QueryContractApprovalListTabAmountBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractMapper;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.po.TabAmountPo;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class QueryContractApprovalListTabAmountBusiServiceImpl
implements QueryContractApprovalListTabAmountBusiService {
    @Autowired
    private ContractMapper contractMapper;
    @Autowired
    private ContractInfoMapper contractInfoMapper;

    @Override
    public QueryContractApprovalListTabAmountBusiRspBO queryContractApprovalListTabAmount(QueryContractApprovalListTabAmountBusiReqBO reqBO) {
        ContractInfoPO queryContractPo = new ContractInfoPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)queryContractPo);
        ArrayList<Long> stationIdList = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty(reqBO.getUmcStationsListWebExt())) {
            reqBO.getUmcStationsListWebExt().forEach(busiCommonStationWebBO -> stationIdList.add(busiCommonStationWebBO.getStationId()));
            queryContractPo.setStationIdList(stationIdList);
        }
        if (reqBO.getContractType() != null && 5 == reqBO.getContractType()) {
            queryContractPo.setContractTypes(Lists.newArrayList((Object[])new Integer[]{5, 6}));
        } else {
            queryContractPo.setContractTypes(Lists.newArrayList((Object[])new Integer[]{reqBO.getContractType()}));
        }
        List<TabAmountPo> tabAmountPos = this.contractInfoMapper.qryApprovalListTabAmount(queryContractPo);
        if (ContractConstant.ContractType.LONG_TERM_CONTRACT_TYPE.equals(reqBO.getContractType())) {
            TabAmountPo tabAmountAllPo = new TabAmountPo();
            tabAmountAllPo.setTabAmount(tabAmountPos.stream().collect(Collectors.summingInt(TabAmountPo::getTabAmount)));
            tabAmountAllPo.setTabId(2002);
            tabAmountAllPo.setTabName("\u5168\u90e8");
            tabAmountAllPo.setTabOrder(3);
            tabAmountPos.add(tabAmountAllPo);
        }
        String resultJsonStr = JSON.toJSONString(tabAmountPos);
        List rows = JSONArray.parseArray((String)resultJsonStr).toJavaList(ContractApprovalListTabAmountInfoBO.class);
        QueryContractApprovalListTabAmountBusiRspBO rspBO = new QueryContractApprovalListTabAmountBusiRspBO();
        rspBO.setRows(rows);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc(" \u5408\u540c\u5ba1\u6279\u5217\u8868\u9875\u7b7e\u6570\u91cf\u67e5\u8be2\u6210\u529f");
        return rspBO;
    }
}

