/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.tydic.fsc.bill.busi.api.FscBillOrderFeedbackBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderFeedbackBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderFeedbackBusiRspBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscCheckResultMapper;
import com.tydic.fsc.exception.FscBusinessException;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillOrderFeedbackBusiServiceImpl
implements FscBillOrderFeedbackBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderFeedbackBusiServiceImpl.class);
    @Autowired
    private FscCheckResultMapper fscCheckResultMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    public static final String BUSI_NAME = "\u5f00\u7968\u4e3b\u5355\u53cd\u9988";
    public static final String BUSI_CODE = "1006";

    @Override
    public FscBillOrderFeedbackBusiRspBO dealOrderFeedback(FscBillOrderFeedbackBusiReqBO reqBO) {
        List fscCheckResultPos = this.fscCheckResultMapper.selectListByOrderId(reqBO.getOrderId());
        if (null != reqBO.getOrderSource() && !"2".equals(reqBO.getOrderSource().toString())) {
            boolean allMatch = fscCheckResultPos.stream().allMatch(fscCheckResultPo -> FscConstants.BillCheck.CONFIRMED.equals(fscCheckResultPo.getStatus()));
            if (CollectionUtils.isEmpty((Collection)fscCheckResultPos) || !allMatch) {
                throw new FscBusinessException("193010", "\u672c\u7ed3\u7b97\u5355\u6240\u5c5e\u4e0a\u6e38\u7ed3\u7b97\u5355\u8fd8\u672a\u5b8c\u6210\u5bf9\u8d26\u786e\u8ba4\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002");
            }
        }
        FscOrderStatusFlowAtomReqBO flowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        flowAtomReqBO.setOrderId(reqBO.getOrderId());
        flowAtomReqBO.setCurStatus(FscBillStatus.PENDING_FEEDBACK.getCode());
        flowAtomReqBO.setBusiName(BUSI_NAME);
        flowAtomReqBO.setBusiCode(BUSI_CODE);
        FscOrderStatusFlowAtomRspBO flowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(flowAtomReqBO);
        if (!"0000".equals(flowAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193010", flowAtomRspBO.getRespDesc());
        }
        return new FscBillOrderFeedbackBusiRspBO();
    }
}

