/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.api.FscBillAddPushLogAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillDealPushLogAbilityReqBO;
import com.tydic.fsc.bill.busi.api.FscBillOrderInvoiceSignToYCBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceSignToYCBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceSignToYCBusiRspBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscBillTaxSendPurFscOrderToYCBO;
import com.tydic.fsc.busibase.external.api.bo.FscBillTaxSendPurFscOrderToYCInvoiceItemBO;
import com.tydic.fsc.busibase.external.api.bo.FscBillTaxSendPurFscOrderToYCReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscBillTaxSendPurFscOrderToYCRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscBillTaxSendPurFscOrderToYCVerificationBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetErpCustInfoReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetErpCustInfoRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscBillTaxSendPurFscOrderToYCService;
import com.tydic.fsc.busibase.external.api.esb.FscGetErpCustInfoService;
import com.tydic.fsc.common.ability.api.FscPayVerificationAbilityService;
import com.tydic.fsc.common.ability.bo.FscPayVerificationAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPayVerificationAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscDicDictionaryExernalMapper;
import com.tydic.fsc.dao.FscInvoiceItemMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscInvoicePoolMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscPushLogMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscDicDictionaryExernalPO;
import com.tydic.fsc.po.FscInvoiceItemPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscInvoicePoolPO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscPushLogPO;
import com.tydic.fsc.util.AmountUtils;
import com.tydic.fsc.util.DateUtil;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class FscBillOrderInvoiceSignToYCBusiServiceImpl
implements FscBillOrderInvoiceSignToYCBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderInvoiceSignToYCBusiServiceImpl.class);
    private static final String BUSI_NAME_SUCCESS = "\u63a8\u9001\u91c7\u8d2d\u7ed3\u7b97\u5355\u6210\u529f";
    private static final String BUSI_NAME_FAIL = "\u63a8\u9001\u91c7\u8d2d\u7ed3\u7b97\u5355\u5931\u8d25";
    @Autowired
    private FscBillTaxSendPurFscOrderToYCService fscBillTaxSendPurFscOrderToYCService;
    @Autowired
    private FscPayVerificationAbilityService fscPayVerificationAbilityService;
    @Autowired
    private FscDicDictionaryExernalMapper fscDicDictionaryExernalMapper;
    @Autowired
    private FscBillAddPushLogAbilityService fscBillAddPushLogAbilityService;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService umcEnterpriseOrgQryDetailAbilityService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscInvoicePoolMapper fscInvoicePoolMapper;
    @Autowired
    private FscPushLogMapper fscPushLogMapper;
    @Autowired
    private FscInvoiceItemMapper fscInvoiceItemMapper;
    @Value(value="${OPER_ORG_ID}")
    private String operOrgId;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscGetErpCustInfoService fscGetErpCustInfoService;
    @Value(value="${OPER_ORG_NAME}")
    private String operOrgName;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Value(value="${fsc.main.electricity.pro.org:100100}")
    private String electricityOrg;

    @Override
    public FscBillOrderInvoiceSignToYCBusiRspBO dealOrderInvoiceSignToYC(FscBillOrderInvoiceSignToYCBusiReqBO reqBO) {
        FscBillOrderInvoiceSignToYCBusiRspBO busiRspBO = new FscBillOrderInvoiceSignToYCBusiRspBO();
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getOrderId());
        fscOrderPo = this.fscOrderMapper.getModelBy(fscOrderPo);
        if (fscOrderPo == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u4fe1\u606f!");
        }
        if (!(FscConstants.FscInvoiceOrderState.BILLSIGNFAIL.equals(fscOrderPo.getOrderState()) || FscConstants.FscInvoiceOrderState.BILL_APPLY.equals(fscOrderPo.getOrderState()) || FscConstants.FscInvoiceOrderState.BILL_SIGN_PASS.equals(fscOrderPo.getOrderState()))) {
            throw new FscBusinessException("198888", "\u53ea\u6709\u63a8\u9001\u5931\u8d25\u548c\u5ba1\u6279\u901a\u8fc7\u7684\u72b6\u6001\u53ef\u4ee5\u8fdb\u884c\u63a8\u9001");
        }
        FscOrderPO signTemp = this.fscOrderMapper.getOrderSignTemp(reqBO.getOrderId());
        FscPushLogPO queryVo = new FscPushLogPO();
        queryVo.setObjectId(signTemp.getFscOrderId());
        FscPushLogPO lastPushLog = this.fscPushLogMapper.getLastPushLog(queryVo);
        if (lastPushLog != null && lastPushLog.getStatus().equals(FscConstants.FscPushStatus.SUCCESS)) {
            busiRspBO.setRespCode("0000");
            busiRspBO.setRespDesc("\u5f53\u524d\u7ed3\u7b97\u5355\u5df2\u63a8\u9001\uff0c\u8bf7\u52ff\u91cd\u590d\u8fdb\u884c\u63a8\u9001\uff01");
            return busiRspBO;
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(signTemp.getFscOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        FscDicDictionaryExernalPO dicDictionaryExernalPO = new FscDicDictionaryExernalPO();
        dicDictionaryExernalPO.setExernalSysCode("YC");
        List fscDicDictionaryExernalPOList = this.fscDicDictionaryExernalMapper.getListByCondition(dicDictionaryExernalPO);
        FscInvoicePO fscInvoicePO = new FscInvoicePO();
        fscInvoicePO.setFscOrderId(signTemp.getFscOrderId());
        List fscInvoicePOList = this.fscInvoiceMapper.getList(fscInvoicePO);
        BigDecimal untaxAmt = new BigDecimal(0);
        BigDecimal taxAmt = new BigDecimal(0);
        BigDecimal orderWriteOffAmt = new BigDecimal(0);
        for (FscInvoicePO fscInvoicePOFor : fscInvoicePOList) {
            orderWriteOffAmt = orderWriteOffAmt.add(fscInvoicePOFor.getAmt());
        }
        FscInvoiceItemPO invoiceItemPO = new FscInvoiceItemPO();
        invoiceItemPO.setFscOrderId(reqBO.getOrderId());
        List list = this.fscInvoiceItemMapper.getList(invoiceItemPO);
        for (FscInvoiceItemPO fscInvoiceItemPO : list) {
            untaxAmt = untaxAmt.add(null == fscInvoiceItemPO.getUntaxAmt() ? BigDecimal.ZERO : fscInvoiceItemPO.getUntaxAmt().setScale(2, 4));
            taxAmt = taxAmt.add(null == fscInvoiceItemPO.getTaxAmt() ? BigDecimal.ZERO : fscInvoiceItemPO.getTaxAmt().setScale(2, 4));
        }
        String orderSource = fscOrderPO.getOrderType() + "";
        List fscTypeList = fscDicDictionaryExernalPOList.stream().filter(p -> p.getPCode().equals("FSC_ORDER_SOURCE")).filter(p -> p.getCode().equals(orderSource)).map(FscDicDictionaryExernalPO::getExernalCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(fscTypeList)) {
            throw new FscBusinessException("193128", "\u7ed3\u7b97\u7c7b\u578b\u672a\u5339\u914d\u5230\u7801\u503c\uff0c\u8bf7\u901a\u77e5\u8fd0\u7ef4\u7ef4\u62a4[SYS_DIC_DICTIONARY_EXERNAL]");
        }
        UmcEnterpriseOrgQryDetailAbilityReqBO umcEnterpriseOrgQryDetailAbilityReqBO = new UmcEnterpriseOrgQryDetailAbilityReqBO();
        umcEnterpriseOrgQryDetailAbilityReqBO.setOrgIdWeb(fscOrderPO.getPayeeId());
        UmcEnterpriseOrgQryDetailAbilityRspBO umcEnterpriseOrgQryDetailAbilityRspBO = this.umcEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(umcEnterpriseOrgQryDetailAbilityReqBO);
        if (!umcEnterpriseOrgQryDetailAbilityRspBO.getRespCode().equals("0000") || ObjectUtils.isEmpty((Object)umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO())) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u4f9b\u5e94\u5546\u76f8\u5173\u4fe1\u606f\uff01");
        }
        FscBillTaxSendPurFscOrderToYCReqBO fscBillTaxSendPurFscOrderToYCReqBO = new FscBillTaxSendPurFscOrderToYCReqBO();
        FscBillTaxSendPurFscOrderToYCBO purchaseSettlement = new FscBillTaxSendPurFscOrderToYCBO();
        purchaseSettlement.setORG_ID(this.operOrgId);
        purchaseSettlement.setORG_NAME(this.operOrgName);
        purchaseSettlement.setDEPT_ID(signTemp.getYcDeptId());
        purchaseSettlement.setDEPT_NAME(signTemp.getYcDeptName());
        purchaseSettlement.setPERSON_ID(signTemp.getYcUserId());
        purchaseSettlement.setPERSON_NAME(signTemp.getYcPersonName());
        purchaseSettlement.setSETTLE_NUMBER(fscOrderPO.getOrderNo());
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setFscOrderId(fscOrderPo.getFscOrderId());
        List fscOrderItemPOList = this.fscOrderItemMapper.getList(fscOrderItemPO);
        StringBuilder SETTLE_NAME = new StringBuilder(fscOrderPO.getOrderNo());
        if (!CollectionUtils.isEmpty((Collection)fscOrderItemPOList) && "1".equals(fscOrderPO.getOrderSource() + "") && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)fscOrderPO.getOperationNo()) && !this.electricityOrg.equals(fscOrderPO.getOperationNo())) {
            SETTLE_NAME = new StringBuilder("");
            for (Object item : fscOrderItemPOList) {
                if (SETTLE_NAME.toString().contains(item.getOrderCode())) continue;
                SETTLE_NAME.append(item.getOrderCode()).append(",");
            }
            if (SETTLE_NAME.toString().length() > 3000) {
                SETTLE_NAME = new StringBuilder(SETTLE_NAME.substring(0, 3000));
            }
            if (SETTLE_NAME.toString().endsWith(",")) {
                SETTLE_NAME = new StringBuilder(SETTLE_NAME.substring(0, SETTLE_NAME.length() - 1));
            }
        }
        purchaseSettlement.setSETTLE_NAME(SETTLE_NAME.toString());
        purchaseSettlement.setSETTLE_TYPE((String)fscTypeList.get(0));
        purchaseSettlement.setCONTRACT_NUMBER(fscOrderPO.getContractNo());
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getErpOrgCode())) {
            purchaseSettlement.setVENDOR_NUMBER(Long.valueOf(Long.parseLong(umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getErpOrgCode())));
        }
        purchaseSettlement.setVENDOR_NAME(umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getErpOrgName());
        purchaseSettlement.setSETTLE_DATE(DateUtil.dateToStr((Date)new Date()));
        purchaseSettlement.setSETTLE_AMT(null == fscOrderPO.getTotalCharge() ? BigDecimal.ZERO : fscOrderPO.getTotalCharge().setScale(2, 4));
        purchaseSettlement.setINVOICE_AMT_WITHOUT_TAX(null == untaxAmt ? BigDecimal.ZERO : untaxAmt);
        purchaseSettlement.setTAX_AMT(null == taxAmt ? BigDecimal.ZERO : taxAmt);
        purchaseSettlement.setTESCO_ID(signTemp.getFscOrderId());
        fscBillTaxSendPurFscOrderToYCReqBO.setPurchaseSettlement(purchaseSettlement);
        ArrayList<FscBillTaxSendPurFscOrderToYCInvoiceItemBO> invoiceList = new ArrayList<FscBillTaxSendPurFscOrderToYCInvoiceItemBO>();
        if (!CollectionUtils.isEmpty((Collection)fscInvoicePOList)) {
            for (FscInvoicePO fscInvoicePOFor : fscInvoicePOList) {
                FscBillTaxSendPurFscOrderToYCInvoiceItemBO fscInvoiceItemBO = new FscBillTaxSendPurFscOrderToYCInvoiceItemBO();
                List invoiceTypeList = fscDicDictionaryExernalPOList.stream().filter(p -> p.getPCode().equals("FSC_INVOICE_TYPE")).filter(p -> p.getCode().equals(fscInvoicePOFor.getInvoiceType())).map(FscDicDictionaryExernalPO::getExernalCode).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(invoiceTypeList)) {
                    throw new FscBusinessException("193128", "\u53d1\u7968\u7c7b\u578b\u672a\u5339\u914d\u5230\u7801\u503c\uff0c\u8bf7\u901a\u77e5\u8fd0\u7ef4\u7ef4\u62a4[SYS_DIC_DICTIONARY_EXERNAL]");
                }
                FscInvoicePoolPO fscInvoicePoolPO = new FscInvoicePoolPO();
                fscInvoicePoolPO.setInvoiceNo(fscInvoicePOFor.getInvoiceNo());
                fscInvoicePoolPO.setInvoiceCode(fscInvoicePOFor.getInvoiceCode());
                fscInvoicePoolPO.setBillDate(fscInvoicePOFor.getBillDate());
                fscInvoicePoolPO = this.fscInvoicePoolMapper.getModelBy(fscInvoicePoolPO);
                if (null == fscInvoicePoolPO) {
                    fscInvoicePoolPO = new FscInvoicePoolPO();
                }
                fscInvoiceItemBO.setINVOICE_TYPE((String)invoiceTypeList.get(0));
                fscInvoiceItemBO.setINVOICE_ID(fscInvoicePoolPO.getId() + "");
                fscInvoiceItemBO.setINVOICE_NUM(fscInvoicePOFor.getInvoiceNo());
                fscInvoiceItemBO.setDRAWER_NAME(fscInvoicePOFor.getCreateOperName());
                fscInvoiceItemBO.setINVOICE_DATE(DateUtil.dateToStr((Date)fscInvoicePOFor.getCreateTime()));
                fscInvoiceItemBO.setTAX_RATE(AmountUtils.calcTaxRate((BigDecimal)fscInvoicePOFor.getTaxAmt(), (BigDecimal)fscInvoicePOFor.getUntaxAmt()).toString());
                fscInvoiceItemBO.setINVOICE_AMOUNT(null == fscInvoicePOFor.getUntaxAmt() ? BigDecimal.ZERO : fscInvoicePOFor.getUntaxAmt().setScale(2, 4));
                fscInvoiceItemBO.setTAX_AMOUNT(null == fscInvoicePOFor.getTaxAmt() ? BigDecimal.ZERO : fscInvoicePOFor.getTaxAmt().setScale(2, 4));
                fscInvoiceItemBO.setTOTAL_AMOUNT(null == fscInvoicePOFor.getAmt() ? BigDecimal.ZERO : fscInvoicePOFor.getAmt().setScale(2, 4));
                fscInvoiceItemBO.setREST_AMOUNT(fscInvoiceItemBO.getTOTAL_AMOUNT().subtract(null == fscInvoiceItemBO.getSETTLE_AMOUNT() ? BigDecimal.ZERO : fscInvoiceItemBO.getSETTLE_AMOUNT()).setScale(2, 4));
                fscInvoiceItemBO.setSETTLE_AMOUNT(null == fscInvoicePOFor.getAmt() ? BigDecimal.ZERO : fscInvoicePOFor.getAmt().setScale(2, 4));
                fscInvoiceItemBO.setTESCO_ID(fscInvoicePOFor.getInvoiceId());
                invoiceList.add(fscInvoiceItemBO);
            }
        }
        fscBillTaxSendPurFscOrderToYCReqBO.setInvoice(invoiceList);
        List orderIds = this.fscOrderRelationMapper.getOrderIdList(Collections.singletonList(reqBO.getOrderId()));
        String customerName = this.fscOrderMapper.selectPurInoviceBuyName(orderIds);
        if (!StringUtils.isEmpty((Object)customerName)) {
            FscGetErpCustInfoReqBO custInfoReqBO = new FscGetErpCustInfoReqBO();
            custInfoReqBO.setCustomerName(customerName);
            FscGetErpCustInfoRspBO erpCustInfo = this.fscGetErpCustInfoService.getErpCustInfo(custInfoReqBO);
            if (erpCustInfo.getRespCode().equals("0000")) {
                purchaseSettlement.setCUSTOMER_ID(erpCustInfo.getCustAccountId());
                purchaseSettlement.setCUSTOMER_NAME(erpCustInfo.getCustAccountName());
            }
        }
        ArrayList<FscBillTaxSendPurFscOrderToYCVerificationBO> advanceCharge = new ArrayList<FscBillTaxSendPurFscOrderToYCVerificationBO>();
        BigDecimal writeOffAmt = new BigDecimal(0);
        List ycAbilityBOList = this.fscOrderMapper.getOrderAmount(signTemp.getFscOrderId());
        if (!CollectionUtils.isEmpty((Collection)ycAbilityBOList)) {
            for (FscOrderPO writeOffamt : ycAbilityBOList) {
                FscOrderPO fscOrderPOPay = this.fscOrderMapper.qryByFscOrderId(writeOffamt.getShouldPayId());
                if (null == fscOrderPOPay) {
                    throw new FscBusinessException("191026", "\u9884\u4ed8\u6b3e\u4e0d\u5b58\u5728");
                }
                if (!FscConstants.FscPayOrderState.PAIED.equals(fscOrderPOPay.getOrderState())) {
                    throw new FscBusinessException("198888", "\u4ed8\u6b3e\u672a\u5b8c\u6210\uff0c\u8bf7\u786e\u8ba4\u540e\u63d0\u4ea4");
                }
                if (null == fscOrderPOPay.getPaidAmount()) {
                    fscOrderPOPay.setPaidAmount(new BigDecimal(0));
                }
                if (fscOrderPOPay.getPaidAmount().subtract(null == fscOrderPOPay.getWriteOffAmount() ? BigDecimal.ZERO : fscOrderPOPay.getWriteOffAmount()).compareTo(null == writeOffamt.getWriteOffAmount() ? BigDecimal.ZERO : writeOffamt.getWriteOffAmount()) < 0) {
                    throw new FscBusinessException("191026", "\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u4ed8\u6b3e\u7533\u8bf7\u5355\u5269\u4f59\u6838\u9500\u91d1\u989d");
                }
                writeOffAmt = writeOffAmt.add(null == writeOffamt.getWriteOffAmount() ? BigDecimal.ZERO : writeOffamt.getWriteOffAmount());
                FscBillTaxSendPurFscOrderToYCVerificationBO verificationBO = new FscBillTaxSendPurFscOrderToYCVerificationBO();
                verificationBO.setPREPAY_NUMBER(fscOrderPOPay.getOrderNo());
                verificationBO.setPREPAY_NAME(fscOrderPOPay.getOrderNo());
                verificationBO.setAMOUNT(fscOrderPOPay.getPaidAmount().setScale(2, 4));
                verificationBO.setAMOUNT_APPLIED(null == fscOrderPOPay.getWriteOffAmount() ? BigDecimal.ZERO : fscOrderPOPay.getWriteOffAmount().setScale(2, 4));
                verificationBO.setAMOUNT_UNAPPLIED(fscOrderPOPay.getPaidAmount().subtract(null == fscOrderPOPay.getWriteOffAmount() ? BigDecimal.ZERO : fscOrderPOPay.getWriteOffAmount()).setScale(2, 4));
                verificationBO.setAPPLY_AMOUNT(writeOffamt.getWriteOffAmount().setScale(2, 4));
                verificationBO.setTESCO_ID(fscOrderPOPay.getFscOrderId());
                advanceCharge.add(verificationBO);
            }
        }
        if (orderWriteOffAmt.compareTo(writeOffAmt) < 0) {
            throw new FscBusinessException("191026", "\u6240\u6709\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u8ba2\u5355\u603b\u91d1\u989d");
        }
        if (fscOrderPO.getTotalCharge().compareTo(writeOffAmt) < 0) {
            throw new FscBusinessException("191026", "\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u7ed3\u7b97\u91d1\u989d");
        }
        if (writeOffAmt.compareTo(BigDecimal.ZERO) == 0) {
            FscPayVerificationAbilityReqBO verificationAbilityReqBO = new FscPayVerificationAbilityReqBO();
            verificationAbilityReqBO.setFscOrderId(fscOrderPO.getFscOrderId());
            verificationAbilityReqBO.setPageNo(Integer.valueOf(1));
            verificationAbilityReqBO.setPageSize(Integer.valueOf(1));
            FscPayVerificationAbilityRspBO verificationAbilityRspBO = this.fscPayVerificationAbilityService.queryPayVerificationPageList(verificationAbilityReqBO);
            if (verificationAbilityRspBO.getRespCode().equals("0000") && !CollectionUtils.isEmpty((Collection)verificationAbilityRspBO.getRows())) {
                throw new FscBusinessException("191026", "\u7ed3\u7b97\u5355\u4e2d\u6709\u8ba2\u5355\u4e3a\u8fdb\u884c\u9884\u6536\u8ba4\u9886\uff0c\u8bf7\u5148\u8ba4\u9886\u540e\u518d\u8fdb\u884c\u7ed3\u7b97\u5f00\u7968\u3002");
            }
        }
        fscBillTaxSendPurFscOrderToYCReqBO.setAdvanceCharge(advanceCharge);
        fscBillTaxSendPurFscOrderToYCReqBO.setPurchaseSettlement(purchaseSettlement);
        fscBillTaxSendPurFscOrderToYCReqBO.setYcUserId(Long.valueOf(Long.parseLong(signTemp.getYcUserId())));
        FscBillDealPushLogAbilityReqBO abilityReqBO = new FscBillDealPushLogAbilityReqBO();
        abilityReqBO.setCreateTime(new Date());
        abilityReqBO.setObjectId(fscOrderPO.getFscOrderId());
        abilityReqBO.setObjectNo(fscOrderPO.getOrderNo());
        abilityReqBO.setType(FscConstants.FscPushType.SETTLE);
        abilityReqBO.setObjData(JSONObject.toJSONString((Object)fscBillTaxSendPurFscOrderToYCReqBO));
        FscBillTaxSendPurFscOrderToYCRspBO fscBillTaxSendPurFscOrderToYCRspBO = this.fscBillTaxSendPurFscOrderToYCService.sendPurFscOrder(fscBillTaxSendPurFscOrderToYCReqBO);
        if (!fscBillTaxSendPurFscOrderToYCRspBO.getRespCode().equals("0000")) {
            abilityReqBO.setStatus(FscConstants.FscPushStatus.FAIL);
            this.fscBillAddPushLogAbilityService.savePushLog(abilityReqBO);
            throw new FscBusinessException("191026", "\u63a8\u9001\u4e1a\u8d22\u5931\u8d25\uff01" + fscBillTaxSendPurFscOrderToYCRspBO.getRespDesc());
        }
        if (fscOrderPO.getOrderState().equals(FscConstants.FscInvoiceOrderState.BILLSIGNFAIL)) {
            this.dealWorkFlow(fscOrderPO);
        }
        abilityReqBO.setStatus(FscConstants.FscPushStatus.SUCCESS);
        this.fscBillAddPushLogAbilityService.savePushLog(abilityReqBO);
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u6210\u529f");
        return busiRspBO;
    }

    private void dealWorkFlow(FscOrderPO fscOrderPo) {
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME_SUCCESS);
        if (fscOrderPo.getOrderState().equals(FscConstants.FscInvoiceOrderState.BILL_APPLY)) {
            return;
        }
        fscOrderStatusFlowAtomReqBO.setOrderId(fscOrderPo.getFscOrderId());
        fscOrderStatusFlowAtomReqBO.setCurStatus(fscOrderPo.getOrderState());
        FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!"0000".equals(fscOrderStatusFlowAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193011", fscOrderStatusFlowAtomRspBO.getRespDesc());
        }
    }
}

