/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.tydic.fsc.bill.ability.api.FscBillSendSaleFscOrderApplyAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillSendSaleFscOrderApplyAbilityReqBO;
import com.tydic.fsc.bill.busi.api.FscBillOrderUpdateBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderUpdateBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderUpdateBusiRspBO;
import com.tydic.fsc.bo.FscApprovalTaskQueryBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.enums.FscOrderSendStateEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscTaskCandidatePO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillOrderUpdateBusiServiceImpl
implements FscBillOrderUpdateBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderUpdateBusiServiceImpl.class);
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscBillSendSaleFscOrderApplyAbilityService fscBillSendSaleFscOrderApplyAbilityService;
    @Autowired
    private FscOrderStatusStartAtomService fscOrderStatusStartAtomService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;
    @Value(value="${fsc.main.pro.org:100096,100100}")
    private String proOrg;
    @Value(value="${fsc.main.electricity.pro.org:100100}")
    private String electricityOrg;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    private static final String BUSI_NAME = "\u8fd0\u8425\u63d0\u4ea4";

    @Override
    public FscBillOrderUpdateBusiRspBO dealUpdate(FscBillOrderUpdateBusiReqBO reqBO) {
        int count;
        FscBillOrderUpdateBusiRspBO rspBO = new FscBillOrderUpdateBusiRspBO();
        FscOrderInvoicePO fscOrderInvoicePO = (FscOrderInvoicePO)JSON.parseObject((String)JSONObject.toJSONString((Object)((Object)reqBO)), FscOrderInvoicePO.class);
        this.fscOrderInvoiceMapper.updateById(fscOrderInvoicePO);
        if (reqBO.getOperType() == 1) {
            if (FscConstants.FscInvoiceOrderState.DRAFT.equals(reqBO.getCurStatus())) {
                FscOrderStatusStartAtomReqBO fscOrderStatusStartAtomReqBO = (FscOrderStatusStartAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscOrderStatusStartAtomReqBO.class);
                fscOrderStatusStartAtomReqBO.setOrderId(reqBO.getFscOrderId());
                FscOrderStatusStartAtomRspBO fscOrderStatusStartAtomRspBO = this.fscOrderStatusStartAtomService.dealStatusStart(fscOrderStatusStartAtomReqBO);
                if (!"0000".equals(fscOrderStatusStartAtomRspBO.getRespCode())) {
                    throw new FscBusinessException("193008", fscOrderStatusStartAtomRspBO.getRespDesc());
                }
            } else if ("1".equals(reqBO.getIsprofess())) {
                FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
                fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
                fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
                fscOrderStatusFlowAtomReqBO.setOrderId(reqBO.getFscOrderId());
                fscOrderStatusFlowAtomReqBO.setCurStatus(reqBO.getCurStatus());
                this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
            }
            if ("0".equals(reqBO.getIsprofess())) {
                FscBillSendSaleFscOrderApplyAbilityReqBO abilityReqBO = (FscBillSendSaleFscOrderApplyAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscBillSendSaleFscOrderApplyAbilityReqBO.class);
                this.dealApproval(abilityReqBO, reqBO.getFscOrderId());
            }
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderPO.setRemark(reqBO.getRemark());
        fscOrderPO.setInvoiceRemark(reqBO.getInvoiceRemark());
        fscOrderPO.setUpdateOperId(reqBO.getUserId().toString());
        fscOrderPO.setUpdateOperName(reqBO.getName());
        fscOrderPO.setUpdateTime(new Date());
        this.fscOrderMapper.updateById(fscOrderPO);
        ArrayList fscOrderItemList = new ArrayList();
        reqBO.getFscOrderItemBOList().forEach(e -> {
            if (Objects.isNull(e.getInspectionItemId())) {
                log.error("\u9a8c\u6536\u5355\u660e\u7ec6id\u5f53\u524d\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u66f4\u65b0");
            }
            FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
            BeanUtils.copyProperties((Object)e, (Object)fscOrderItemPO);
            fscOrderItemPO.setFscOrderId(reqBO.getFscOrderId());
            fscOrderItemPO.setOrderItemId(e.getInspectionItemId());
            fscOrderItemList.add(fscOrderItemPO);
        });
        if (!CollectionUtils.isEmpty(fscOrderItemList) && (count = this.fscOrderItemMapper.updateBatchByList(fscOrderItemList)) < 1) {
            throw new FscBusinessException("190000", "\u7ed3\u7b97\u660e\u7ec6\u66f4\u65b0\u5931\u8d25\uff01");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealApproval(FscBillSendSaleFscOrderApplyAbilityReqBO reqBO, Long fscOrderId) {
        FscOrderPO order = new FscOrderPO();
        order.setFscOrderId(fscOrderId);
        order = this.fscOrderMapper.getModelBy(order);
        this.fscOrderMapper.deleteOrderSendTemp(fscOrderId);
        FscOrderPO fscSendTemp = (FscOrderPO)JSON.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscOrderPO.class);
        fscSendTemp.setFscOrderId(fscOrderId);
        fscSendTemp.setYcDeptId(reqBO.getDeptId().toString());
        fscSendTemp.setYcDeptName(reqBO.getDeptName());
        fscSendTemp.setYcPersonId(reqBO.getPersonId().toString());
        fscSendTemp.setYcPersonName(reqBO.getPersonName());
        fscSendTemp.setBuynerNo(order.getBuynerNo());
        fscSendTemp.setBuynerName(order.getBuynerName());
        log.debug("========\u63a8\u9001\u9500\u552e\u5355\u7533\u8bf7\u4e34\u65f6\u4fdd\u5b58\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)fscSendTemp));
        this.fscOrderMapper.insertOrderSendTemp(fscSendTemp);
        this.invokeUacTask(reqBO, fscOrderId);
        FscTaskCandidatePO taskPo = new FscTaskCandidatePO();
        taskPo.setFscOrderId(fscOrderId);
        List pendAuditPostIdList = this.fscTaskCandidateMapper.getPendAuditPostIdList(taskPo);
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setSignApplyTime(new Date());
        if (!CollectionUtils.isEmpty((Collection)pendAuditPostIdList)) {
            List auditedPostIdList = pendAuditPostIdList.stream().map(FscApprovalTaskQueryBO::getTaskOperId).distinct().collect(Collectors.toList());
            fscOrderPO.setSendStation(Joiner.on((String)",").join(auditedPostIdList) + ",");
        }
        fscOrderPO.setFscOrderId(fscOrderId);
        fscOrderPO.setSendState(FscOrderSendStateEnum.NO_AUDIT.getCode());
        fscOrderPO.setSendApplyTime(new Date());
        fscOrderPO.setSendUserId(reqBO.getUserId());
        fscOrderPO.setSendUserName(reqBO.getName());
        fscOrderPO.setOperatorId(reqBO.getUserId());
        fscOrderPO.setOperatorName(reqBO.getName());
        String operationNo = String.valueOf(reqBO.getOrgId());
        String[] org = this.proOrg.split(",");
        String[] pur = reqBO.getOrgPath().split("-");
        block0: for (String pro : org) {
            for (String t : pur) {
                if (!pro.equals(t)) continue;
                operationNo = pro;
                continue block0;
            }
        }
        fscOrderPO.setOperationNo(operationNo);
        this.fscOrderMapper.updateById(fscOrderPO);
        if (reqBO.getWebSource() != null && reqBO.getWebSource().equals(FscConstants.FscWebSource.AGR_DOWN)) {
            this.dealWorkFlow(order);
        }
    }

    private void invokeUacTask(FscBillSendSaleFscOrderApplyAbilityReqBO reqBO, Long l) {
        UacNoTaskAuditCreateReqBO auditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        auditCreateReqBO.setCreateOperId(reqBO.getUserId().toString());
        auditCreateReqBO.setCreateOperName(reqBO.getName());
        auditCreateReqBO.setCreateOperDept(reqBO.getOrgName());
        auditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        auditCreateReqBO.setMenuId("M001007");
        auditCreateReqBO.setOrgId(reqBO.getOrgId().toString());
        ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.ORDER_INVOICE_APPROVAL);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(l);
        ArrayList<ApprovalObjBO> approvalObjBOList = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjId(l.toString());
        approvalObjBO.setObjName("\u9500\u552e\u7ed3\u7b97\u5355\u5ba1\u6279");
        approvalObjBO.setObjType(FscConstants.AuditObjType.ORDER_INVOICE_APPROVAL);
        approvalObjBOList.add(approvalObjBO);
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjBOList);
        createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
        auditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
        log.info("\u5ba1\u6279\u5165\u53c2================" + JSON.toJSONString((Object)auditCreateReqBO));
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(auditCreateReqBO);
        log.info("\u5ba1\u6279\u51fa\u53c2================" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new FscBusinessException("191019", uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        if (uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue()) {
            throw new FscBusinessException("190000", "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u7ed3\u7b97\u5355\u5ba1\u6279\u6d41\uff01");
        }
    }

    private void dealWorkFlow(FscOrderPO fscOrderPo) {
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
        fscOrderStatusFlowAtomReqBO.setOrderId(fscOrderPo.getFscOrderId());
        fscOrderStatusFlowAtomReqBO.setCurStatus(fscOrderPo.getOrderState());
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("confirmFlag", FscConstants.BillOrderConfirmFlag.CONFIRM);
        fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!fscOrderStatusFlowAtomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(fscOrderStatusFlowAtomRspBO.getRespCode(), fscOrderStatusFlowAtomRspBO.getRespDesc());
        }
    }
}

