/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.tydic.fsc.bill.busi.api.FscPayBillDeleteBusiService;
import com.tydic.fsc.bill.busi.bo.FscPayBillDeleteBusiReqBo;
import com.tydic.fsc.bill.busi.bo.FscPayBillDeleteBusiRspBo;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscPayBillDeleteBusiServiceImpl
implements FscPayBillDeleteBusiService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    public static final String BUSI_NAME = "\u652f\u4ed8\u5355\u5220\u9664";
    public static final String BUSI_CODE = "1199";

    @Override
    public FscPayBillDeleteBusiRspBo payBillDelete(FscPayBillDeleteBusiReqBo reqBo) {
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBo.getOrderId());
        FscOrderPO fscOrder = this.fscOrderMapper.getModelBy(fscOrderPo);
        this.var(fscOrder);
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>(4);
        paramMap.put("cancelFlag", FscConstants.BillOrderCancelFlag.DELETE_ORDER);
        FscOrderStatusFlowAtomReqBO flowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        flowAtomReqBO.setOrderId(reqBo.getOrderId());
        flowAtomReqBO.setCurStatus(fscOrder.getOrderState());
        flowAtomReqBO.setBusiName(BUSI_NAME);
        flowAtomReqBO.setBusiCode(BUSI_CODE);
        flowAtomReqBO.setParamMap(paramMap);
        FscOrderStatusFlowAtomRspBO flowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(flowAtomReqBO);
        if (!"0000".equals(flowAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193108", flowAtomRspBO.getRespDesc());
        }
        this.paymentRejectionProcess(fscOrder);
        FscPayBillDeleteBusiRspBo rspBo = new FscPayBillDeleteBusiRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void var(FscOrderPO fscOrder) {
        if (fscOrder == null) {
            throw new FscBusinessException("198888", "\u672a\u627e\u5230\u4ed8\u6b3e\u7533\u8bf7\u5355\u4fe1\u606f");
        }
        if (!FscConstants.FscPayOrderState.CANCEL.equals(fscOrder.getOrderState())) {
            throw new FscBusinessException("198888", "\u53ea\u6709\u5ba1\u6279\u9a73\u56de\u72b6\u6001\u4e0b\u624d\u80fd\u5220\u9664");
        }
        if (!FscConstants.OrderFlow.PAY.equals(fscOrder.getOrderFlow())) {
            throw new FscBusinessException("198888", "\u672a\u627e\u5230\u8be5\u4ed8\u6b3e\u7533\u8bf7\u5355");
        }
    }

    private void paymentRejectionProcess(FscOrderPO reqBO) {
        FscOrderPayItemPO fscOrderPayItemPo = new FscOrderPayItemPO();
        fscOrderPayItemPo.setFscOrderId(reqBO.getFscOrderId());
        List fscOrderPayItemPos = this.fscOrderPayItemMapper.getList(fscOrderPayItemPo);
        for (FscOrderPayItemPO orderPayItemPo : fscOrderPayItemPos) {
            int n = this.fscShouldPayMapper.updatePayingAmt(orderPayItemPo.getShouldPayId(), orderPayItemPo.getPayAmount());
        }
    }
}

