/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bill.busi.api.FscRecvClaimListQueryBusiService;
import com.tydic.fsc.bill.busi.bo.FscRecvClaimListQueryBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscRecvClaimListQueryBusiRspBO;
import com.tydic.fsc.bo.FscClaimDetailBO;
import com.tydic.fsc.bo.FscRecvClaimBO;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.enums.FscClaimPushStatusEnum;
import com.tydic.fsc.enums.FscClaimRecvStatusEnum;
import com.tydic.fsc.enums.FscClaimStatusEnum;
import com.tydic.fsc.enums.FscRecvTypeEnum;
import com.tydic.fsc.enums.FscSystemSourceEnum;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscRecvClaimPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FscRecvClaimListQueryBusiServiceImpl
implements FscRecvClaimListQueryBusiService {
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;

    @Override
    public FscRecvClaimListQueryBusiRspBO qryRecvClaimList(FscRecvClaimListQueryBusiReqBO reqBO) {
        List claimIdList;
        Object claimDetailList;
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        FscRecvClaimPO fscRecvClaimPO = new FscRecvClaimPO();
        fscRecvClaimPO = (FscRecvClaimPO)JSON.parseObject((String)JSONObject.toJSONString((Object)((Object)reqBO)), FscRecvClaimPO.class);
        if (reqBO.getWebSource() != null && reqBO.getWebSource() == 1) {
            ArrayList<String> claimStatusList = new ArrayList<String>();
            claimStatusList.add(FscClaimStatusEnum.NOT_CLAIM.getCode());
            claimStatusList.add(FscClaimStatusEnum.PART_CLAIM.getCode());
            fscRecvClaimPO.setRecvStatus(FscClaimRecvStatusEnum.EFFECTIVE.getCode());
            fscRecvClaimPO.setClaimStatusList(claimStatusList);
        }
        fscRecvClaimPO.setExcludeRecvStatus(FscClaimRecvStatusEnum.DELETE.getCode());
        List listPage = this.fscRecvClaimMapper.getListPage(fscRecvClaimPO, page);
        HashMap<Long, List<FscClaimDetailPO>> detailPOMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)listPage) && CollectionUtils.isNotEmpty((Collection)(claimDetailList = this.fscClaimDetailMapper.queryByClaimIdList(claimIdList = listPage.stream().map(FscRecvClaimPO::getClaimId).collect(Collectors.toList()))))) {
            detailPOMap = claimDetailList.stream().collect(Collectors.groupingBy(FscClaimDetailPO::getClaimId));
        }
        LinkedList<FscRecvClaimBO> rows = new LinkedList<FscRecvClaimBO>();
        for (FscRecvClaimPO recvClaimPo : listPage) {
            FscRecvClaimBO fscRecvClaimBo = new FscRecvClaimBO();
            BeanUtils.copyProperties((Object)recvClaimPo, (Object)fscRecvClaimBo);
            this.transform(fscRecvClaimBo);
            FscAttachmentPO fscAttachmentPo = new FscAttachmentPO();
            fscAttachmentPo.setObjId(recvClaimPo.getClaimId());
            fscRecvClaimBo.setAttachmentList(this.fscAttachmentMapper.getExtensionList(fscAttachmentPo));
            fscRecvClaimBo.setClaimAmount(fscRecvClaimBo.getRecvAmt().subtract(fscRecvClaimBo.getNoClaimAmt()));
            fscRecvClaimBo.setClaimDetailList(this.transDetailInfo(fscRecvClaimBo, detailPOMap));
            rows.add(fscRecvClaimBo);
        }
        FscRecvClaimListQueryBusiRspBO rspBO = new FscRecvClaimListQueryBusiRspBO();
        rspBO.setRows(rows);
        rspBO.setRecvAmt(this.fscRecvClaimMapper.selectRecvAmt());
        rspBO.setNoClaimAmt(this.fscRecvClaimMapper.selectNoClaimAmt());
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void transform(FscRecvClaimBO fscRecvClaimBo) {
        if (!StringUtils.isEmpty((Object)fscRecvClaimBo.getRecvType())) {
            fscRecvClaimBo.setRecvTypeStr(FscRecvTypeEnum.getCodeDesc((String)fscRecvClaimBo.getRecvType()));
        }
        if (!StringUtils.isEmpty((Object)fscRecvClaimBo.getClaimStatus())) {
            fscRecvClaimBo.setClaimStatusStr(FscClaimStatusEnum.getCodeDsc((String)fscRecvClaimBo.getClaimStatus()));
        }
        if (!StringUtils.isEmpty((Object)fscRecvClaimBo.getRecvStatus())) {
            fscRecvClaimBo.setRecvStatusStr(FscClaimRecvStatusEnum.getCodeDesc((String)fscRecvClaimBo.getRecvStatus()));
        }
    }

    private List<FscClaimDetailBO> transDetailInfo(FscRecvClaimBO fscRecvClaimBo, Map<Long, List<FscClaimDetailPO>> detailPOMap) {
        List<FscClaimDetailPO> detailPOList = detailPOMap.get(fscRecvClaimBo.getClaimId());
        ArrayList<FscClaimDetailBO> detailBOList = new ArrayList<FscClaimDetailBO>();
        if (CollectionUtils.isNotEmpty(detailPOList)) {
            detailPOList.forEach(e -> {
                FscClaimDetailBO fscClaimDetailBO = new FscClaimDetailBO();
                BeanUtils.copyProperties((Object)e, (Object)fscClaimDetailBO);
                fscClaimDetailBO.setPushStatusStr(FscClaimPushStatusEnum.getCodeDesc((Integer)e.getPushStatus()));
                fscClaimDetailBO.setSysSourceStr(FscSystemSourceEnum.getCodeDesc((Integer)e.getSysSource()));
                if (FscSystemSourceEnum.YC.getCode().equals(fscClaimDetailBO.getSysSource())) {
                    fscClaimDetailBO.setClaimAmtForYC(fscClaimDetailBO.getClaimAmt());
                } else {
                    fscClaimDetailBO.setClaimAmtForYG(fscClaimDetailBO.getClaimAmt());
                }
                detailBOList.add(fscClaimDetailBO);
            });
        }
        return detailBOList;
    }
}

