/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.fsc.bill.ability.api.FscBillListPrintService;
import com.tydic.fsc.bill.ability.api.FscBillPurchaseListPrintAbilityService;
import com.tydic.fsc.bill.ability.api.FscPrintPdfMergerAbilityService;
import com.tydic.fsc.bill.ability.api.FscRefundBillListPrintService;
import com.tydic.fsc.bill.ability.bo.FscBillListPrintReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillListPrintRspBO;
import com.tydic.fsc.bill.ability.bo.FscBillListPrintYcBO;
import com.tydic.fsc.bill.ability.bo.FscPrintPdfMergerReqBO;
import com.tydic.fsc.bill.ability.bo.FscPrintPdfMergerRspBO;
import com.tydic.fsc.bill.ability.bo.FscPurchaseListPrintReqBO;
import com.tydic.fsc.bill.ability.bo.FscPurchaseListPrintRspBO;
import com.tydic.fsc.bill.ability.bo.FscRefundBillListPrintReqBO;
import com.tydic.fsc.bill.ability.bo.FscRefundBillListPrintRspBO;
import com.tydic.fsc.bill.busi.api.FscBillValidOverdraftBusiService;
import com.tydic.fsc.busibase.busi.api.FscEsQryComOrderListBusiService;
import com.tydic.fsc.busibase.busi.bo.FscComOrderListPageQueryBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscComOrderListPageQueryBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscAdvPayManagerPrintService;
import com.tydic.fsc.pay.ability.api.FscPayManagerPrintService;
import com.tydic.fsc.pay.ability.bo.FscAdvPayManagerPrintReqBO;
import com.tydic.fsc.pay.ability.bo.FscAdvPayManagerPrintRspBO;
import com.tydic.fsc.pay.ability.bo.FscPayManagerPrintReqBO;
import com.tydic.fsc.pay.ability.bo.FscPayManagerPrintRspBO;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.fsc.util.FscThreadPoolExecutorConfig;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscPrintPdfMergerAbilityService"})
public class FscPrintPdfMergerAbilityServiceImpl
implements FscPrintPdfMergerAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscPrintPdfMergerAbilityServiceImpl.class);
    @Autowired
    private FscBillPurchaseListPrintAbilityService fscBillPurchaseListPrintAbilityService;
    @Autowired
    private FileClient fileClient;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    @Autowired
    private FscEsQryComOrderListBusiService fscEsQryComOrderListBusiService;
    @Autowired
    private FscPayManagerPrintService fscPayManagerPrintService;
    @Autowired
    private FscAdvPayManagerPrintService fscAdvPayManagerPrintService;
    private static final ThreadPoolExecutor executor = FscThreadPoolExecutorConfig.poolExecutor;
    private static final String PATH = "fsc/pdf";
    private static final String FILE_TYPE_OSS = "OSS";
    private static final String FILE_TYPE_FASTDFS = "FASTDFS";
    @Value(value="${MERGER_PDF_MAX_COUNT:200}")
    private int count;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscBillListPrintService fscBillListPrintService;
    @Autowired
    private FscBillValidOverdraftBusiService fscBillValidOverdraftBusiService;
    @Autowired
    private FscRefundBillListPrintService fscRefundBillListPrintService;

    @FscDuplicateCommitLimit
    @PostMapping(value={"fscPrintPdfMerger"})
    public FscPrintPdfMergerRspBO fscPrintPdfMerger(@RequestBody FscPrintPdfMergerReqBO reqBO) {
        List<Object> bos;
        this.val(reqBO);
        FscComOrderListPageQueryBusiReqBO busiReqBO = new FscComOrderListPageQueryBusiReqBO();
        busiReqBO.setFscOrderIds(reqBO.getFscOrderIds());
        busiReqBO.setPageSize(Integer.valueOf(10000));
        FscComOrderListPageQueryBusiRspBO busiRspBO = this.fscEsQryComOrderListBusiService.esQryComOrderList(busiReqBO);
        if (CollectionUtils.isEmpty((Collection)busiRspBO.getRows())) {
            throw new FscBusinessException("198888", "\u7ed3\u7b97\u5355\u636e\u4e0d\u5b58\u5728");
        }
        if (reqBO.getType() == 1) {
            bos = busiRspBO.getRows().stream().filter(x -> FscConstants.FscInvoiceOrderState.BILLED.equals(x.getOrderState()) || FscConstants.FscInvoiceOrderState.SIGNED.equals(x.getOrderState())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(bos)) {
                throw new FscBusinessException("198888", "\u91c7\u8d2d\u7ed3\u7b97\u5355\u65e0\u8be5\u72b6\u6001\u4e0b[\u5df2\u5f00\u7968\u3001\u6d41\u7a0b\u7ed3\u675f]\u5355\u636e");
            }
        } else {
            bos = busiRspBO.getRows().stream().filter(x -> FscConstants.FscPayOrderState.PAIED.equals(x.getOrderState()) || FscConstants.FscPayOrderState.TY_PAIED.equals(x.getOrderState()) || FscConstants.FscPayOrderState.TO_REGISTER.equals(x.getOrderState())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(bos)) {
                throw new FscBusinessException("198888", "\u4ed8\u6b3e\u7533\u8bf7\u5355\u65e0\u8be5\u72b6\u6001\u4e0b[\u5f85\u767b\u8bb0\u3001\u4ed8\u6b3e\u6210\u529f\u3001\u4ed8\u6b3e\u6210\u529f\u5f85\u786e\u8ba4]\u5355\u636e");
            }
        }
        if (bos.size() > this.count) {
            throw new FscBusinessException("198888", "\u5408\u5e76\u6253\u5370\u8d85\u51fa\u6700\u5927\u6570\u91cf" + this.count + "\u9650\u5236");
        }
        FscPrintPdfMergerRspBO rspBO = new FscPrintPdfMergerRspBO();
        URL rootPath = FscPrintPdfMergerAbilityServiceImpl.class.getResource("/");
        String rootPathStr = rootPath.getPath() + "temp" + System.currentTimeMillis();
        File directoryFile = new File(rootPathStr);
        if (!directoryFile.exists()) {
            directoryFile.mkdir();
        }
        try {
            CountDownLatch countDownLatch = new CountDownLatch(bos.size());
            bos.forEach(x -> {
                if (reqBO.getType() == 1) {
                    executor.submit(() -> {
                        try {
                            FscPurchaseListPrintReqBO printReqBO = new FscPurchaseListPrintReqBO();
                            printReqBO.setOrderId(x.getFscOrderId());
                            printReqBO.setMergerFlag(Boolean.valueOf(true));
                            FscPurchaseListPrintRspBO printRspBO = this.fscBillPurchaseListPrintAbilityService.billPurchaseListPrintAbilityService(printReqBO);
                            if (Objects.nonNull(printRspBO.getByteArrayOutputStream())) {
                                FscPrintPdfMergerAbilityServiceImpl.writeBytesToFile(printRspBO.getByteArrayOutputStream().toByteArray(), rootPathStr + "/" + x.getFscOrderId() + ".pdf");
                            }
                        }
                        catch (Exception e) {
                            log.error("\u7ed3\u7b97\u5355\u6253\u5370\u5f02\u5e38" + e.getMessage());
                        }
                        finally {
                            countDownLatch.countDown();
                        }
                    });
                } else {
                    executor.submit(() -> {
                        try {
                            if (Objects.nonNull(x.getShouldPayMethod()) && FscConstants.PaymentMethod.PRE_PAY.equals(x.getShouldPayMethod())) {
                                FscAdvPayManagerPrintReqBO advPayManagerPrintReqBO = new FscAdvPayManagerPrintReqBO();
                                advPayManagerPrintReqBO.setOrderId(x.getFscOrderId());
                                advPayManagerPrintReqBO.setMergerFlag(Boolean.valueOf(true));
                                FscAdvPayManagerPrintRspBO fscAdvPayManagerPrintRspBO = this.fscAdvPayManagerPrintService.fscAdvPayManagerPrint(advPayManagerPrintReqBO);
                                if (Objects.nonNull(fscAdvPayManagerPrintRspBO.getByteArrayOutputStream())) {
                                    FscPrintPdfMergerAbilityServiceImpl.writeBytesToFile(fscAdvPayManagerPrintRspBO.getByteArrayOutputStream().toByteArray(), rootPathStr + "/" + x.getFscOrderId() + ".pdf");
                                }
                            } else {
                                FscPayManagerPrintReqBO fscPayManagerPrintReqBO = new FscPayManagerPrintReqBO();
                                fscPayManagerPrintReqBO.setOrderId(x.getFscOrderId());
                                fscPayManagerPrintReqBO.setMergerFlag(Boolean.valueOf(true));
                                FscPayManagerPrintRspBO fscPayManagerPrintRspBO = this.fscPayManagerPrintService.fscPayManagerPrint(fscPayManagerPrintReqBO);
                                if (Objects.nonNull(fscPayManagerPrintRspBO.getByteArrayOutputStream())) {
                                    FscPrintPdfMergerAbilityServiceImpl.writeBytesToFile(fscPayManagerPrintRspBO.getByteArrayOutputStream().toByteArray(), rootPathStr + "/" + x.getFscOrderId() + ".pdf");
                                }
                            }
                        }
                        catch (Exception e) {
                            log.error("\u4ed8\u6b3e\u5355\u6253\u5370\u5f02\u5e38" + e.getMessage());
                        }
                        finally {
                            countDownLatch.countDown();
                        }
                    });
                }
            });
            log.info("FscPrintPdfMergerAbilityServiceImpl countDownLatch:{}", (Object)bos.size());
            countDownLatch.await();
            PDFMergerUtility merger = new PDFMergerUtility();
            for (File file : directoryFile.listFiles()) {
                merger.addSource(file);
            }
            String filePath = rootPathStr + "/" + UUID.randomUUID() + ".pdf";
            merger.setDestinationFileName(filePath);
            merger.mergeDocuments(null);
            String pathUrl = this.uploadFile(this.convertPdfToByteArrayOutputStream(filePath));
            rspBO.setPrintUrl(pathUrl);
        }
        catch (Exception e) {
            throw new FscBusinessException("190000", "\u7cfb\u7edf\u5f02\u5e38:" + e.getMessage());
        }
        finally {
            this.deleteTempFile(directoryFile);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void val(FscPrintPdfMergerReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getFscOrderIds())) {
            throw new FscBusinessException("191000", "\u7ed3\u7b97\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBO.getType())) {
            throw new FscBusinessException("191000", "\u7c7b\u578bTYPE\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getType() != 1 && reqBO.getType() != 2) {
            throw new FscBusinessException("191000", "\u7c7b\u578bTYPE\u65e0\u6548");
        }
    }

    private static void writeBytesToFile(byte[] bytes, String filePath) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(filePath);){
            fos.write(bytes);
            fos.flush();
        }
    }

    public String uploadFile(ByteArrayOutputStream byteArrayOutputStream) {
        String exportUrl;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        String fileName = UUID.randomUUID().toString() + System.currentTimeMillis() + ".pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            exportUrl = this.ossFileUrl + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        return exportUrl;
    }

    /*
     * Exception decompiling
     */
    public ByteArrayOutputStream convertPdfToByteArrayOutputStream(String filePath) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean deleteTempFile(File file) {
        if (file.isDirectory()) {
            File[] subFiles = file.listFiles();
            if (subFiles != null) {
                int subFileCount = subFiles.length;
                int deleteFileCount = 0;
                for (File subFile : subFiles) {
                    if (!subFile.delete()) continue;
                    ++deleteFileCount;
                }
                if (subFileCount == deleteFileCount) {
                    return file.delete();
                }
                return false;
            }
            return file.delete();
        }
        return file.delete();
    }

    @PostMapping(value={"fscPrintYcPdf"})
    public FscPrintPdfMergerRspBO fscPrintYcPdf(@RequestBody FscPrintPdfMergerReqBO reqBO) {
        FscAttachmentPO po;
        List list = null;
        if (reqBO.getType() == null) {
            po = new FscAttachmentPO();
            po.setFscOrderIds(reqBO.getFscOrderIds());
            po.setAttachmentType(FscConstants.AttachmentType.DOWN_PDF_SNAPSHOT);
            List pos = this.fscAttachmentMapper.getList(po);
            Map<Long, String> urlMap = pos.stream().collect(Collectors.toMap(FscAttachmentPO::getFscOrderId, FscAttachmentPO::getAttachmentUrl));
            list = reqBO.getFscOrderIds().stream().map(x -> {
                FscBillListPrintYcBO bo = new FscBillListPrintYcBO();
                bo.setOrderId(x + "");
                bo.setPrintUrl((String)urlMap.get(x));
                if (StringUtils.isEmpty((Object)bo.getPrintUrl())) {
                    FscBillListPrintReqBO fscBillListPrintReqBO = new FscBillListPrintReqBO();
                    fscBillListPrintReqBO.setOrderId(x);
                    FscBillListPrintRspBO fscBillListPrintRspBO = this.fscBillListPrintService.fscBillListPrint(fscBillListPrintReqBO);
                    if (!"0000".equals(fscBillListPrintRspBO.getRespCode())) {
                        throw new FscBusinessException("190000", "\u7ed3\u7b97\u5355:" + x + "\u6253\u5370\u5931\u8d25:" + fscBillListPrintRspBO.getRespDesc());
                    }
                    bo.setPrintUrl(fscBillListPrintRspBO.getPrintUrl());
                }
                return bo;
            }).collect(Collectors.toList());
        } else if (reqBO.getType() == 3) {
            po = new FscAttachmentPO();
            po.setFscOrderIds(reqBO.getFscOrderIds());
            po.setAttachmentType(FscConstants.AttachmentType.DOWN_REFUND_PDF_SNAPSHOT);
            List pos = this.fscAttachmentMapper.getList(po);
            Map<Long, String> urlMap = !CollectionUtils.isEmpty((Collection)pos) ? pos.stream().collect(Collectors.toMap(FscAttachmentPO::getFscOrderId, FscAttachmentPO::getAttachmentUrl)) : null;
            list = reqBO.getFscOrderIds().stream().map(x -> {
                FscBillListPrintYcBO bo = new FscBillListPrintYcBO();
                bo.setOrderId(x + "");
                if (urlMap != null) {
                    bo.setPrintUrl((String)urlMap.get(x));
                }
                if (StringUtils.isEmpty((Object)bo.getPrintUrl())) {
                    FscRefundBillListPrintReqBO fscRefundBillListPrintReqBO = new FscRefundBillListPrintReqBO();
                    fscRefundBillListPrintReqBO.setOrderId(x);
                    FscRefundBillListPrintRspBO fscRefundBillListPrint = this.fscRefundBillListPrintService.fscRefundBillListPrint(fscRefundBillListPrintReqBO);
                    if (!"0000".equals(fscRefundBillListPrint.getRespCode())) {
                        throw new FscBusinessException("190000", "\u4e0b\u6e38\u9000\u7968\u5355:" + x + "\u6253\u5370\u5931\u8d25:" + fscRefundBillListPrint.getRespDesc());
                    }
                    bo.setPrintUrl(fscRefundBillListPrint.getPrintUrl());
                }
                return bo;
            }).collect(Collectors.toList());
        }
        FscPrintPdfMergerRspBO rspBO = new FscPrintPdfMergerRspBO();
        rspBO.setList(list);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

