/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.tydic.fsc.bill.ability.api.FscRefundItemQryAbilityService;
import com.tydic.fsc.bill.ability.bo.FscRefundItemQryAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscRefundItemQryAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscRefundItemQryAbilityService"})
public class FscRefundItemQryAbilityServiceImpl
implements FscRefundItemQryAbilityService {
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;

    @PostMapping(value={"qryRefundItem"})
    public FscRefundItemQryAbilityRspBO qryRefundItem(@RequestBody FscRefundItemQryAbilityReqBO reqBO) {
        if (reqBO.getRefundId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u9000\u6b3e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getRefundId());
        refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
        if (refundPO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u9000\u7968\u5355\u76f8\u5173\u4fe1\u606f\uff01");
        }
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(refundPO.getFscOrderId());
        orderPO.setOrderFlow(FscConstants.OrderFlow.INVOICE);
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        if (orderPO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u4fe1\u606f\uff01");
        }
        ArrayList orderIdList = new ArrayList();
        ArrayList acceptOrderIdList = new ArrayList();
        ArrayList acceptOrderItemIdList = new ArrayList();
        HashMap<Long, BigDecimal> acceptOrderItemIdMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> acceptOrderItemNumMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> ordItemIdRefundAmtMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> ordItemIdRefundNumMap = new HashMap<Long, BigDecimal>();
        FscOrderRelationPO relationPO = new FscOrderRelationPO();
        relationPO.setRefundId(reqBO.getRefundId());
        List fscOrderRelationPOS = this.fscOrderRelationMapper.getListNoPage(relationPO);
        if (!CollectionUtils.isEmpty((Collection)fscOrderRelationPOS)) {
            fscOrderRelationPOS = fscOrderRelationPOS.stream().filter(e -> e.getSettleAmt().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
            Set orderIdSet = fscOrderRelationPOS.stream().filter(e -> e.getOrderId() != null).map(e -> e.getOrderId()).collect(Collectors.toSet());
            orderIdList.addAll(orderIdSet);
            Set acceptOrderIdSet = fscOrderRelationPOS.stream().filter(e -> e.getAcceptOrderId() != null).map(e -> e.getAcceptOrderId()).collect(Collectors.toSet());
            acceptOrderIdList.addAll(acceptOrderIdSet);
        }
        FscOrderItemPO searchOrderItemPO = new FscOrderItemPO();
        searchOrderItemPO.setRefundId(reqBO.getRefundId());
        List refundItemPOList = this.fscOrderItemMapper.getListNoPage(searchOrderItemPO);
        if (!CollectionUtils.isEmpty((Collection)refundItemPOList)) {
            Integer settleType = orderPO.getSettleType();
            if (FscConstants.SettleType.ORDER.equals(settleType)) {
                Map<Long, List<FscOrderItemPO>> orderItemIdMap = refundItemPOList.stream().filter(e -> e.getOrderItemId() != null).collect(Collectors.groupingBy(FscOrderItemPO::getOrderItemId));
                for (Long acceptOrderItemId : orderItemIdMap.keySet()) {
                    BigDecimal refundAmt = orderItemIdMap.get(acceptOrderItemId).stream().map(e -> e.getRefundAmt()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal refundNum = orderItemIdMap.get(acceptOrderItemId).stream().map(e -> e.getNum()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    ordItemIdRefundAmtMap.put(acceptOrderItemId, refundAmt);
                    ordItemIdRefundNumMap.put(acceptOrderItemId, refundNum);
                }
            } else {
                Set acceptOrderItemIdSet = refundItemPOList.stream().filter(e -> e.getOrderItemId() != null).map(e -> e.getOrderItemId()).collect(Collectors.toSet());
                acceptOrderItemIdList.addAll(acceptOrderItemIdSet);
                Map<Long, List<FscOrderItemPO>> orderItemIdMap = refundItemPOList.stream().filter(e -> e.getOrderItemId() != null).collect(Collectors.groupingBy(FscOrderItemPO::getOrderItemId));
                for (Long acceptOrderItemId : orderItemIdMap.keySet()) {
                    BigDecimal refundAmt = orderItemIdMap.get(acceptOrderItemId).stream().map(e -> e.getRefundAmt()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal refundNum = orderItemIdMap.get(acceptOrderItemId).stream().map(e -> e.getNum()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    acceptOrderItemIdMap.put(acceptOrderItemId, refundAmt);
                    acceptOrderItemNumMap.put(acceptOrderItemId, refundNum);
                }
            }
        }
        FscRefundItemQryAbilityRspBO rspBO = new FscRefundItemQryAbilityRspBO();
        rspBO.setOrderIdList(orderIdList);
        rspBO.setAcceptOrderIdList(acceptOrderIdList);
        rspBO.setAcceptOrderItemIdList(acceptOrderItemIdList);
        rspBO.setAcceptOrderItemIdMap(acceptOrderItemIdMap);
        rspBO.setAcceptOrderItemNumMap(acceptOrderItemNumMap);
        rspBO.setOrdItemIdRefundNumMap(ordItemIdRefundNumMap);
        rspBO.setOrdItemIdRefundAmtMap(ordItemIdRefundAmtMap);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

