/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl.finance;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.api.finance.FscFinanceInvoiceFolderCreateAbilityService;
import com.tydic.fsc.bill.ability.api.finance.FscFinanceInvoiceFolderQryByUserAbilityService;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceInvoiceFolderCreateReqBo;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceInvoiceFolderCreateRspBo;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceInvoiceFolderQryByUserReqBo;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceInvoiceFolderQryByUserRspBO;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceInvoiceFolderQryByUserRspList;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinanceShareTokenRspBO;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceShareRelatedInterfacesAtomService;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.utils.EntityToMapUtil;
import com.tydic.fsc.utils.SSLClient;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.finance.FscFinanceInvoiceFolderQryByUserAbilityService"})
public class FscFinanceInvoiceFolderQryByUserAbilityServiceImpl
implements FscFinanceInvoiceFolderQryByUserAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceInvoiceFolderQryByUserAbilityServiceImpl.class);
    @Autowired
    private FscFinanceShareRelatedInterfacesAtomService fscFinanceShareRelatedInterfacesAtomService;
    @Autowired
    private FscFinanceInvoiceFolderCreateAbilityService folderCreateAbilityService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Value(value="${finance.invoice.query.url:}")
    private String queryUrl;

    @PostMapping(value={"queryInvoiceFolderByUser"})
    public FscFinanceInvoiceFolderQryByUserRspBO queryInvoiceFolderByUser(@RequestBody FscFinanceInvoiceFolderQryByUserReqBo reqBo) {
        if (StringUtils.isEmpty((CharSequence)reqBo.getUid())) {
            throw new FscBusinessException("191000", "\u5fc5\u4f20\u53c2\u6570[uid]\u4e3a\u7a7a!");
        }
        if (null == reqBo.getFscOrderId()) {
            throw new FscBusinessException("191000", "\u5fc5\u4f20\u53c2\u6570[fscOrderId]\u4e3a\u7a7a!");
        }
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", this.getToken());
        HashMap<String, String> reqParam = new HashMap<String, String>();
        reqParam.put("userId", reqBo.getUid());
        if (StringUtils.isNotEmpty((CharSequence)reqBo.getInvoiceFolderName())) {
            reqParam.put("invoiceFolderName", reqBo.getInvoiceFolderName());
        }
        log.info("\u8d22\u52a1\u5171\u4eab\u7528\u6237\u67e5\u8be2\u7968\u5939\u5217\u8868\u63a5\u53e3\u8bf7\u6c42param:{},\u8bf7\u6c42url:{}", reqParam, (Object)this.queryUrl);
        String resString = SSLClient.doGet((String)(this.queryUrl + EntityToMapUtil.transferParam(reqParam)), header);
        log.info("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u7cfb\u7edf-\u7528\u6237\u67e5\u8be2\u7968\u5939\u5217\u8868\u63a5\u53e3-\u8fd4\u56de\u62a5\u6587:{}", (Object)resString);
        if (StringUtils.isEmpty((CharSequence)resString)) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u7528\u6237\u67e5\u8be2\u7968\u5939\u5217\u8868\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
        }
        FscFinanceInvoiceFolderQryByUserRspBO rspBo = new FscFinanceInvoiceFolderQryByUserRspBO();
        JSONObject jsonObject = JSONObject.parseObject((String)resString);
        if (!"0".equals(jsonObject.getString("code"))) {
            rspBo.setRespCode("190000");
            rspBo.setRespDesc(jsonObject.getString("msg"));
            return rspBo;
        }
        JSONArray array = jsonObject.getJSONArray("data");
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        if (null == array || array.isEmpty()) {
            rspBo.setRespCode("191138");
            rspBo.setRespDesc("\u6210\u529f");
            FscFinanceInvoiceFolderCreateReqBo createReqBo = new FscFinanceInvoiceFolderCreateReqBo();
            FscOrderPO fscOrderPO = this.fscOrderMapper.qryByFscOrderId(reqBo.getFscOrderId());
            if (null == fscOrderPO) {
                throw new FscBusinessException("190000", "\u521b\u5efa\u7968\u5939\u83b7\u53d6\u7ed3\u7b97\u5355\u4fe1\u606f\u5931\u8d25");
            }
            createReqBo.setCreateUser(fscOrderPO.getCreateOperNo());
            createReqBo.setCreateUserName(fscOrderPO.getCreateOperName());
            createReqBo.setRelationUser(reqBo.getUserName());
            createReqBo.setRelationUserName(reqBo.getName());
            FscFinanceInvoiceFolderCreateRspBo invoiceFolder = this.folderCreateAbilityService.createInvoiceFolder(createReqBo);
            FscFinanceInvoiceFolderQryByUserRspList object = (FscFinanceInvoiceFolderQryByUserRspList)JSONObject.parseObject((String)JSONObject.toJSONString(invoiceFolder.getData().get("data")), FscFinanceInvoiceFolderQryByUserRspList.class);
            rspBo.setDate(Collections.singletonList(object));
            return rspBo;
        }
        List date = JSONObject.parseArray((String)array.toJSONString(), FscFinanceInvoiceFolderQryByUserRspList.class);
        rspBo.setDate(date);
        return rspBo;
    }

    private String getToken() {
        FscFinanceShareTokenRspBO tokenRspBO = this.fscFinanceShareRelatedInterfacesAtomService.getFinanceShareToken();
        if (StringUtils.isEmpty((CharSequence)tokenRspBO.getToken())) {
            throw new FscBusinessException("198888", "\u83b7\u53d6\u8d22\u52a1\u5171\u4eabtoken\u5931\u8d25:" + tokenRspBO.getRespDesc());
        }
        return tokenRspBO.getToken();
    }
}

