/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl.finance;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.ability.api.finance.FscFinanceInvoiceFolderUploadAbilityService;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceInvoiceFolderUploadReqBo;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceInvoiceFolderUploadRspBo;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceInvoiceFolderUploadRspBoData;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceShareRelatedInterfacesAtomService;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.util.HttpUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.CharsetUtils;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.finance.FscFinanceInvoiceFolderUploadAbilityService"})
public class FscFinanceInvoiceFolderUploadAbilityServiceImpl
implements FscFinanceInvoiceFolderUploadAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceInvoiceFolderUploadAbilityServiceImpl.class);
    @Autowired
    private FscFinanceShareRelatedInterfacesAtomService fscFinanceShareRelatedInterfacesAtomService;
    @Value(value="${finance.invoice.upload.url:}")
    private String uploadUrl;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping(value={"uploadInvoiceFolder"})
    public FscFinanceInvoiceFolderUploadRspBo uploadInvoiceFolder(@RequestBody FscFinanceInvoiceFolderUploadReqBo reqBo) {
        String fileUrl = reqBo.getFileUrl();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)fileUrl)) {
            throw new FscBusinessException("191000", "\u5fc5\u4f20\u53c2\u6570[fileUrl]\u4e3a\u7a7a");
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)reqBo.getGuid())) {
            throw new FscBusinessException("191000", "\u5fc5\u4f20\u53c2\u6570[guid]\u4e3a\u7a7a");
        }
        FscFinanceInvoiceFolderUploadRspBo rspBo = new FscFinanceInvoiceFolderUploadRspBo();
        String result = null;
        File file = null;
        try {
            String fileName = Sequence.getInstance().nextId() + fileUrl.substring(fileUrl.lastIndexOf("."));
            HttpUtils.httpDownload((String)fileUrl, (String)fileName);
            byte[] bytes = FscFinanceInvoiceFolderUploadAbilityServiceImpl.getBytes(fileName);
            try (ByteArrayInputStream input = new ByteArrayInputStream(bytes);){
                file = new File(fileName);
                try (FileOutputStream fos = new FileOutputStream(file);){
                    int temp;
                    byte[] bt = new byte[10240];
                    while ((temp = input.read(bt)) != -1) {
                        fos.write(bt, 0, temp);
                    }
                }
                catch (Exception e) {
                    rspBo.setRespCode("8888");
                    rspBo.setRespDesc("\u4e0b\u8f7d\u672c\u5730\u6587\u4ef6\u5904\u7406\u5931\u8d25\uff01" + e.getMessage());
                    FscFinanceInvoiceFolderUploadRspBo fscFinanceInvoiceFolderUploadRspBo = rspBo;
                    if (input == null) return fscFinanceInvoiceFolderUploadRspBo;
                    if (var9_12 == null) {
                        input.close();
                        return fscFinanceInvoiceFolderUploadRspBo;
                    }
                    try {
                        input.close();
                        return fscFinanceInvoiceFolderUploadRspBo;
                    }
                    catch (Throwable throwable) {
                        var9_12.addSuppressed(throwable);
                        return fscFinanceInvoiceFolderUploadRspBo;
                    }
                }
            }
            catch (Exception e) {
                rspBo.setRespCode("8888");
                rspBo.setRespDesc("\u4e0b\u8f7d\u672c\u5730\u6587\u4ef6\u5904\u7406\u5931\u8d25\uff01" + e.getMessage());
                return rspBo;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u4e0b\u8f7d\u672c\u5730\u6587\u4ef6\u5904\u7406\u5931\u8d25\uff01" + e.getMessage());
            return rspBo;
        }
        try {
            result = this.httpUpload(this.uploadUrl, file, reqBo.getGuid());
            return this.parse(result);
        }
        catch (IOException e) {
            e.printStackTrace();
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5171\u4eab\u53d1\u7968\u4e0a\u4f20ocr\u5931\u8d25");
            return rspBo;
        }
    }

    private FscFinanceInvoiceFolderUploadRspBo parse(String result) {
        FscFinanceInvoiceFolderUploadRspBo rspBO = new FscFinanceInvoiceFolderUploadRspBo();
        if (StringUtils.isEmpty((String)result)) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u6587\u4ef6\u4e0a\u4f20ocr\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        JSONObject object = JSONObject.parseObject((String)result);
        String code = object.getString("code");
        if (StringUtils.isEmpty((String)code)) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u6587\u4ef6\u4e0a\u4f20ocr\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u72b6\u6001\u7801code\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        if (!"0".equals(code)) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u6587\u4ef6\u4e0a\u4f20ocr\u63a5\u53e3\u5931\u8d25\uff1a" + object.getString("msg"));
            return rspBO;
        }
        JSONArray jsonArray = object.getJSONArray("data");
        if (jsonArray.isEmpty()) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u6587\u4ef6\u4e0a\u4f20ocr\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587data\u4e3a\u7a7a\uff1a");
            return rspBO;
        }
        String respArray = jsonArray.toJSONString();
        List list = JSONObject.parseArray((String)respArray, FscFinanceInvoiceFolderUploadRspBoData.class);
        rspBO.setData(list);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public static byte[] getBytes(String filePath) throws IOException {
        File file = new File(filePath);
        byte[] buffer = new byte[(int)file.length()];
        try (FileInputStream fis = new FileInputStream(file);){
            int bytesRead = fis.read(buffer);
            if (bytesRead != buffer.length) {
                throw new IOException("\u53ea\u8bfb\u53d6\u4e86\u90e8\u5206\u6587\u4ef6\u5185\u5bb9\uff0c\u9884\u671f=" + buffer.length + ", \u5b9e\u9645=" + bytesRead);
            }
        }
        catch (Exception e) {
            throw new IOException("\u83b7\u53d6\u6587\u4ef6\u5b57\u8282\u6d41\u5931\u8d25", e.getCause());
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String httpUpload(String actionUrl, File file, String guid) throws IOException {
        String charset = "utf-8";
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost httpPost = new HttpPost(actionUrl);
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(20000).setSocketTimeout(30000).setConnectTimeout(20000).build();
        httpPost.setConfig(requestConfig);
        httpPost.setHeader("Authorization", this.fscFinanceShareRelatedInterfacesAtomService.getFinanceShareToken().getToken());
        String result = null;
        String boundary = "--------------4585696313564699";
        HashMap<String, Object> mapParam = new HashMap<String, Object>();
        mapParam.put("guid", new StringBody(guid, StandardCharsets.UTF_8));
        mapParam.put("file", new FileBody(file));
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.RFC6532);
        for (Map.Entry param : mapParam.entrySet()) {
            multipartEntityBuilder.addPart((String)param.getKey(), (ContentBody)param.getValue()).setCharset(CharsetUtils.get((String)"UTF-8"));
        }
        multipartEntityBuilder.setCharset(StandardCharsets.UTF_8);
        multipartEntityBuilder.setBoundary(boundary);
        HttpEntity reqEntity = multipartEntityBuilder.build();
        httpPost.setEntity(reqEntity);
        httpPost.setHeader("Content-Type", "multipart/form-data;boundary=" + boundary);
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                System.out.println("--------------------------------------");
                result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                System.out.println("Response content: " + result);
                System.out.println("--------------------------------------");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }
}

