/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.busi.api.FscBillOrderCreatePayBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderCreatePayBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderCreatePayBusiRspBO;
import com.tydic.fsc.bo.FscShouldPayBO;
import com.tydic.fsc.busibase.atom.api.FscPayShouldPayCreateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayCreateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayCreateAtomRspBO;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscShouldPayDetailMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscShouldPayDetailPO;
import com.tydic.fsc.po.FscShouldPayPO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillOrderCreatePayBusiServiceImpl
implements FscBillOrderCreatePayBusiService {
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscShouldPayDetailMapper fscShouldPayDetailMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscPayShouldPayCreateAtomService fscPayShouldPayCreateAtomService;

    @Override
    public FscBillOrderCreatePayBusiRspBO dealBillOrderPayCreate(FscBillOrderCreatePayBusiReqBO reqBO) {
        if (reqBO.getCreateShouldPayFlag().booleanValue()) {
            FscShouldPayPO payPO = new FscShouldPayPO();
            payPO.setObjectId(reqBO.getFscOrderId());
            List list = this.fscShouldPayMapper.getList(payPO);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                throw new FscBusinessException("198888", "\u8be5\u7ed3\u7b97\u5355\u5df2\u751f\u6210\u5e94\u4ed8\u5355\u636e\uff01");
            }
            if (!CollectionUtils.isEmpty(reqBO.getFscShouldPayBOS())) {
                FscPayShouldPayCreateAtomReqBO fscPayShouldPayCreateAtomReqBO = new FscPayShouldPayCreateAtomReqBO();
                fscPayShouldPayCreateAtomReqBO.setFscShouldPayBOS(reqBO.getFscShouldPayBOS());
                fscPayShouldPayCreateAtomReqBO.setUserId(reqBO.getUserId());
                fscPayShouldPayCreateAtomReqBO.setName(reqBO.getName());
                fscPayShouldPayCreateAtomReqBO.setUserName(reqBO.getUserName());
                fscPayShouldPayCreateAtomReqBO.setCompanyId(reqBO.getCompanyId());
                fscPayShouldPayCreateAtomReqBO.setCompanyName(reqBO.getCompanyName());
                fscPayShouldPayCreateAtomReqBO.setOrgId(reqBO.getOrgId());
                fscPayShouldPayCreateAtomReqBO.setOrgName(reqBO.getOrgName());
                List acceptOrderCodes = this.fscShouldPayMapper.selectAcceptOrderCode(reqBO.getFscOrderId());
                String acceptOrderCode = String.join((CharSequence)",", acceptOrderCodes);
                for (FscShouldPayBO bo : reqBO.getFscShouldPayBOS()) {
                    bo.setAcceptOrderCode(acceptOrderCode);
                }
                FscPayShouldPayCreateAtomRspBO fscPayShouldPayCreateAtomRspBO = this.fscPayShouldPayCreateAtomService.dealShouldPayCreate(fscPayShouldPayCreateAtomReqBO);
                if (!"0000".equals(fscPayShouldPayCreateAtomRspBO.getRespCode())) {
                    throw new FscBusinessException("193011", fscPayShouldPayCreateAtomRspBO.getRespDesc());
                }
            }
        }
        FscBillOrderCreatePayBusiRspBO rspBO = new FscBillOrderCreatePayBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public FscBillOrderCreatePayBusiRspBO createShouldPayDetail(FscBillOrderCreatePayBusiReqBO reqBO) {
        if (reqBO.getShouldPayId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u5e94\u4ed8id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscShouldPayPO fscShouldPayBO = new FscShouldPayPO();
        fscShouldPayBO.setShouldPayId(reqBO.getShouldPayId());
        fscShouldPayBO = this.fscShouldPayMapper.getModelBy(fscShouldPayBO);
        if (fscShouldPayBO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u5e94\u4ed8\u5355\u4fe1\u606f\uff01");
        }
        int count = this.fscShouldPayDetailMapper.checkCount(fscShouldPayBO.getShouldPayId());
        if (count > 0) {
            throw new FscBusinessException("198888", "\u8bf7\u52ff\u91cd\u590d\u62c6\u5206\u5e94\u4ed8\u660e\u7ec6\uff01");
        }
        ArrayList<FscShouldPayDetailPO> insertPayDetailPOS = new ArrayList<FscShouldPayDetailPO>();
        FscOrderRelationPO orderRelationPO = new FscOrderRelationPO();
        orderRelationPO.setFscOrderIds(Collections.singletonList(fscShouldPayBO.getObjectId()));
        List orderList = this.fscOrderRelationMapper.getListNoPage(orderRelationPO);
        if (!CollectionUtils.isEmpty((Collection)orderList)) {
            Map<Long, List<FscOrderRelationPO>> fscOrderIdRelationMap = orderList.stream().collect(Collectors.groupingBy(FscOrderRelationPO::getFscOrderId));
            List<FscOrderRelationPO> orderRelationPOS = fscOrderIdRelationMap.get(fscShouldPayBO.getObjectId());
            Map<Long, List<FscOrderRelationPO>> orderIdRelationMap = orderRelationPOS.stream().collect(Collectors.groupingBy(FscOrderRelationPO::getOrderId));
            if (fscShouldPayBO.getNodePayRatio() == null) {
                fscShouldPayBO.setNodePayRatio(new BigDecimal(100));
            }
            if (!orderIdRelationMap.containsKey(fscShouldPayBO.getOrderId())) {
                return new FscBillOrderCreatePayBusiRspBO();
            }
            if (fscShouldPayBO.getNodePayRatio().compareTo(BigDecimal.ZERO) == 0) {
                fscShouldPayBO.setNodePayRatio(new BigDecimal(100));
            }
            BigDecimal orderAmt = BigDecimal.ZERO;
            for (FscOrderRelationPO fscOrderRelationPO : orderIdRelationMap.get(fscShouldPayBO.getOrderId())) {
                orderAmt = orderAmt.add(fscOrderRelationPO.getSettleAmt());
            }
            BigDecimal shouldPayAmt = orderAmt.multiply(fscShouldPayBO.getNodePayRatio().divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
            FscShouldPayDetailPO shouldPayDetailPO = new FscShouldPayDetailPO();
            shouldPayDetailPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            shouldPayDetailPO.setShouldPayId(fscShouldPayBO.getShouldPayId());
            shouldPayDetailPO.setFscOrderId(fscShouldPayBO.getObjectId());
            shouldPayDetailPO.setOrderId(fscShouldPayBO.getOrderId());
            shouldPayDetailPO.setShouldPayAmt(shouldPayAmt);
            insertPayDetailPOS.add(shouldPayDetailPO);
        }
        if (!CollectionUtils.isEmpty(insertPayDetailPOS)) {
            this.fscShouldPayDetailMapper.insertBatch(insertPayDetailPOS);
        }
        return new FscBillOrderCreatePayBusiRspBO();
    }
}

