/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.tydic.fsc.bill.busi.api.FscBillPayRefundRefuseBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillPayRefundRefuseBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillPayRefundRefuseBusiRspBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscPayClaimRefundDetailMapper;
import com.tydic.fsc.dao.FscPayClaimRefundMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscPayClaimRefundPO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillPayRefundRefuseBusiServiceImpl
implements FscBillPayRefundRefuseBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillPayRefundRefuseBusiServiceImpl.class);
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscPayClaimRefundMapper fscPayClaimRefundMapper;
    @Autowired
    private FscPayClaimRefundDetailMapper fscPayClaimRefundDetailMapper;
    private static final String BUSI_NAME = "\u9000\u6b3e\u4e3b\u5355\u56de\u9000";
    @Value(value="${OPERATION_SUP_ID:1001693}")
    private String operationSupId;

    @Override
    public FscBillPayRefundRefuseBusiRspBO dealPayRefundRefuse(FscBillPayRefundRefuseBusiReqBO reqBO) {
        FscBillPayRefundRefuseBusiRspBO rspBO = new FscBillPayRefundRefuseBusiRspBO();
        FscOrderRefundPO refundPO = this.fscOrderRefundMapper.queryById(reqBO.getRefundId());
        if (1 == refundPO.getUserType() && refundPO.getTradeMode() == 1 || refundPO.getTradeMode() == 2 && this.operationSupId.equals(refundPO.getPayeeId().toString())) {
            if (FscConstants.AuditResultStatus.REFUSE.equals(refundPO.getAuditStatus())) {
                List fscPayClaimRefundPOList = this.fscPayClaimRefundMapper.queryByRefundId(reqBO.getRefundId());
                if (CollectionUtils.isEmpty((Collection)fscPayClaimRefundPOList)) {
                    throw new FscBusinessException("190000", "\u67e5\u8be2\u9000\u6b3e\u5355\u5173\u8054\u8ba4\u9886\u4fe1\u606f\u4e3a\u7a7a");
                }
                for (FscPayClaimRefundPO po : fscPayClaimRefundPOList) {
                    po.setRefundAmt(po.getRefundAmt().multiply(new BigDecimal(-1)));
                }
                int count = this.fscPayClaimRefundMapper.updateRefundAmountBatch(fscPayClaimRefundPOList);
                if (count != fscPayClaimRefundPOList.size()) {
                    throw new FscBusinessException("190000", "\u66f4\u65b0\u5e94\u9000\u5355\u660e\u7ec6\u91d1\u989d\u5931\u8d25");
                }
                count = this.fscPayClaimRefundMapper.deleteByRefundId(reqBO.getRefundId());
                if (count != fscPayClaimRefundPOList.size()) {
                    throw new FscBusinessException("190000", "\u5220\u9664\u9000\u6b3e\u5355\u5173\u8054\u8ba4\u9886\u4fe1\u606f\u5931\u8d25");
                }
                count = this.fscPayClaimRefundDetailMapper.deleteByRefundId(reqBO.getRefundId());
                if (count < 1) {
                    throw new FscBusinessException("190000", "\u5220\u9664\u9000\u6b3e\u5355\u5173\u8054\u8ba4\u9886\u660e\u7ec6\u4fe1\u606f\u5931\u8d25");
                }
                this.fscOrderRefundMapper.updateClaimInfo(reqBO.getRefundId());
                FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
                fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
                fscOrderStatusFlowAtomReqBO.setOrderId(refundPO.getRefundId());
                fscOrderStatusFlowAtomReqBO.setCurStatus(refundPO.getRefundStatus());
                HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
                paramMap.put("deleteFlag", FscConstants.BillOrderDeleteFlag.DELETE_BAKE);
                fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
                FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealRefundStatusFlow(fscOrderStatusFlowAtomReqBO);
                if (!fscOrderStatusFlowAtomRspBO.getRespCode().equals("0000")) {
                    throw new FscBusinessException(fscOrderStatusFlowAtomRspBO.getRespCode(), fscOrderStatusFlowAtomRspBO.getRespDesc());
                }
            } else {
                FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
                fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
                fscOrderStatusFlowAtomReqBO.setOrderId(refundPO.getRefundId());
                fscOrderStatusFlowAtomReqBO.setCurStatus(refundPO.getRefundStatus());
                HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
                paramMap.put("confirmFlag", FscConstants.BillOrderConfirmFlag.REJECT);
                fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
                FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealRefundStatusFlow(fscOrderStatusFlowAtomReqBO);
                if (!fscOrderStatusFlowAtomRspBO.getRespCode().equals("0000")) {
                    throw new FscBusinessException(fscOrderStatusFlowAtomRspBO.getRespCode(), fscOrderStatusFlowAtomRspBO.getRespDesc());
                }
            }
        } else if (refundPO.getUserType() == 2 || refundPO.getTradeMode() == 2 && !this.operationSupId.equals(refundPO.getPayeeId().toString())) {
            refundPO = new FscOrderRefundPO();
            refundPO.setRefundId(reqBO.getRefundId());
            refundPO.setRefundStatus(FscConstants.RefundPayOrderState.REFUSED);
            this.fscOrderRefundMapper.updateById(refundPO);
        }
        refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getRefundId());
        refundPO.setBillStatus(FscConstants.RefundBillStatus.SAVE);
        refundPO.setReason(reqBO.getReason());
        this.fscOrderRefundMapper.updateById(refundPO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

