/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.tydic.fsc.bill.ability.bo.FscYcCancleInvoiceAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscYcCancleInvoiceAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscCancleInvoiceYcBusiService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscShouldPayPO;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscCancleInvoiceYcBusiServiceImpl
implements FscCancleInvoiceYcBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscCancleInvoiceYcBusiServiceImpl.class);
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;

    @Override
    public FscYcCancleInvoiceAbilityRspBO ycCancleInvoice(FscYcCancleInvoiceAbilityReqBO reqBO) {
        this.fscInvoiceMapper.cancleInvoiceByNos(reqBO.getInvoiceNos(), FscConstants.FscInvoiceStatus.INVALID);
        List fscOrderIds = this.fscInvoiceMapper.getFscOrderIdsByNos(reqBO.getInvoiceNos());
        FscInvoicePO invoicePO = new FscInvoicePO();
        invoicePO.setFscOrderIds(fscOrderIds);
        List invoicePOS = this.fscInvoiceMapper.getBillDateMaxList(invoicePO);
        Map<Long, String> billMap = invoicePOS.stream().collect(Collectors.toMap(FscInvoicePO::getFscOrderId, FscInvoicePO::getBillDate));
        List shouldPayPOs = fscOrderIds.stream().map(x -> {
            FscShouldPayPO po = new FscShouldPayPO();
            po.setObjectId(x);
            po.setBillDate(billMap.get(x) == null ? null : (String)billMap.get(x));
            return po;
        }).collect(Collectors.toList());
        this.fscShouldPayMapper.updateBathBillDate(shouldPayPOs);
        FscYcCancleInvoiceAbilityRspBO rspBO = new FscYcCancleInvoiceAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setFscOrderIds(fscOrderIds);
        return rspBO;
    }
}

