/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.api.FscBillRefundInvoiceYcRollBackAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillRefundInvoiceYcRollBackAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillRefundInvoiceYcRollBackAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillAddPushLogBusiService;
import com.tydic.fsc.bill.busi.api.FscBillRefundInvoiceYcRollBackBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillAddPushLogBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillRefundInvoiceYcRollBackBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillRefundInvoiceYcRollBackBusiRspBO;
import com.tydic.fsc.common.ability.api.FscComInvoiceSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import java.util.Collections;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillRefundInvoiceYcRollBackAbilityService"})
public class FscBillRefundInvoiceYcRollBackAbilityServiceImpl
implements FscBillRefundInvoiceYcRollBackAbilityService {
    @Autowired
    private FscBillRefundInvoiceYcRollBackBusiService fscBillRefundInvoiceYcRollBackBusiService;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;
    @Autowired
    private FscComInvoiceSyncAbilityService fscComInvoiceSyncAbilityService;
    @Autowired
    private FscBillAddPushLogBusiService fscBillAddPushLogBusiService;

    @PostMapping(value={"dealYcRefundInvoiceRollBack"})
    public FscBillRefundInvoiceYcRollBackAbilityRspBO dealYcRefundInvoiceRollBack(@RequestBody FscBillRefundInvoiceYcRollBackAbilityReqBO reqBO) {
        this.valid(reqBO);
        String reqString = JSONObject.toJSONString((Object)reqBO);
        FscBillRefundInvoiceYcRollBackBusiReqBO busiReqBO = (FscBillRefundInvoiceYcRollBackBusiReqBO)JSONObject.parseObject((String)reqString, FscBillRefundInvoiceYcRollBackBusiReqBO.class);
        FscBillRefundInvoiceYcRollBackBusiRspBO busiRspBO = this.fscBillRefundInvoiceYcRollBackBusiService.dealYcRefundInvoiceRollBack(busiReqBO);
        if (busiRspBO.getRespCode().equals("0000")) {
            this.syncEs(reqBO.getRefundId());
        }
        FscBillAddPushLogBusiReqBO logBusiReqBO = new FscBillAddPushLogBusiReqBO();
        logBusiReqBO.setObjectId(reqBO.getRefundId());
        logBusiReqBO.setObjectNo(reqBO.getRefundNo());
        logBusiReqBO.setObjData(JSONObject.toJSONString((Object)reqBO));
        logBusiReqBO.setRespData(JSONObject.toJSONString((Object)((Object)busiRspBO)));
        logBusiReqBO.setType(FscConstants.FscPushType.REFUND_INVOICE_BACK);
        logBusiReqBO.setCreateTime(new Date());
        this.fscBillAddPushLogBusiService.addPushLog(logBusiReqBO);
        return (FscBillRefundInvoiceYcRollBackAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), FscBillRefundInvoiceYcRollBackAbilityRspBO.class);
    }

    private void valid(FscBillRefundInvoiceYcRollBackAbilityReqBO reqBO) {
        if (reqBO.getRefundId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getRefundNo())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getBackRemark())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[backRemark]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void syncEs(Long refundId) {
        FscComRefundSyncAbilityReqBO syncAbilityReqBO = new FscComRefundSyncAbilityReqBO();
        syncAbilityReqBO.setRefundIds(Collections.singletonList(refundId));
        this.fscComRefundSyncAbilityService.syncRefund(syncAbilityReqBO);
    }
}

