/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.bean.BeanUtil;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.authority.busi.api.DycStationSelectService;
import com.tydic.authority.busi.bo.DycStationSelectReqBO;
import com.tydic.authority.busi.bo.DycStationSelectRspBO;
import com.tydic.fsc.bill.ability.api.FscBillTrafficFeePrintService;
import com.tydic.fsc.bill.ability.bo.FscBillListPrintReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillListPrintRspBO;
import com.tydic.fsc.bo.FscApprovalprocessListBO;
import com.tydic.fsc.bo.FscOrderItemDetailBO;
import com.tydic.fsc.bo.OrderInvoiceBO;
import com.tydic.fsc.common.ability.api.FscComApprovalprocessListQryAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderDetailQueryAbilityService;
import com.tydic.fsc.common.ability.api.FscOrderItemDetailQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscComApprovalprocessListQryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComApprovalprocessListQryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscComOrderDetailQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderDetailQueryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscOrderItemDetailQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscOrderItemDetailQueryAbilityRspBO;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.util.CheckUtils;
import com.tydic.fsc.util.FscStringUtils;
import com.tydic.fsc.util.PdfUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillTrafficFeePrintService"})
public class FscBillTrafficFeePrintServiceImpl
implements FscBillTrafficFeePrintService {
    private static final Logger log = LoggerFactory.getLogger(FscBillTrafficFeePrintServiceImpl.class);
    private FscOrderItemDetailQueryAbilityService fscOrderItemDetailQueryAbilityService;
    private FscComOrderDetailQueryAbilityService fscComOrderDetailQueryAbilityService;
    private FscComApprovalprocessListQryAbilityService fscComApprovalprocessListQryAbilityService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    private static final String PATH = "fsc/pdf";
    private static final String FILE_TYPE_OSS = "OSS";
    private static final String FILE_TYPE_FASTDFS = "FASTDFS";
    private FileClient fileClient;
    private DycStationSelectService dycStationSelectService;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;

    @PostMapping(value={"fscBillTrafficFeePrint"})
    public FscBillListPrintRspBO fscBillTrafficFeePrint(@RequestBody FscBillListPrintReqBO reqBO) {
        if (CheckUtils.isBlank((Object)reqBO.getOrderId())) {
            throw new FscBusinessException("191000", "\u7ed3\u7b97\u5355ID\u4e3a\u7a7a");
        }
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getOrderId());
        fscOrderPo = this.fscOrderMapper.getModelBy(fscOrderPo);
        String pdfUrl = this.createBillPdfPrint(reqBO, fscOrderPo);
        return new FscBillListPrintRspBO(pdfUrl, fscOrderPo.getOrderNo(), reqBO.getOrderId());
    }

    private String createBillPdfPrint(FscBillListPrintReqBO reqBO, FscOrderPO fscOrderPo) {
        Document document = PdfUtils.newDefaultDocument();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        document.open();
        List<PdfPTable> list = this.addPdfTable(reqBO, fscOrderPo);
        PdfUtils.addTableListToDoc((Document)document, list);
        document.close();
        return this.uploadFile("\u5e73\u53f0\u6d41\u91cf\u8d39", byteArrayOutputStream);
    }

    private List<PdfPTable> addPdfTable(FscBillListPrintReqBO reqBO, FscOrderPO fscOrderPo) {
        FscComOrderDetailQueryAbilityReqBO orderDetailReqBO = new FscComOrderDetailQueryAbilityReqBO();
        orderDetailReqBO.setOrderId(reqBO.getOrderId());
        FscComOrderDetailQueryAbilityRspBO orderDetail = this.fscComOrderDetailQueryAbilityService.qryOrderDetail(orderDetailReqBO);
        FscOrderItemDetailQueryAbilityReqBO orderItemDetailBO = new FscOrderItemDetailQueryAbilityReqBO();
        orderItemDetailBO.setFscOrderIdList(Stream.of(reqBO.getOrderId()).collect(Collectors.toList()));
        FscOrderItemDetailQueryAbilityRspBO fscOrderItemDetailQueryAbilityRspBO = this.fscOrderItemDetailQueryAbilityService.queryOrderItemDetail(orderItemDetailBO);
        FscComApprovalprocessListQryAbilityReqBO fscComApprovalprocessListQryAbilityReqBO = (FscComApprovalprocessListQryAbilityReqBO)BeanUtil.copyProperties((Object)reqBO, FscComApprovalprocessListQryAbilityReqBO.class);
        fscComApprovalprocessListQryAbilityReqBO.setFscOrderId(reqBO.getOrderId());
        fscComApprovalprocessListQryAbilityReqBO.setObjType(Integer.valueOf(7));
        ArrayList<FscApprovalprocessListBO> approvalList = new ArrayList();
        FscComApprovalprocessListQryAbilityRspBO fscApprovalList = this.fscComApprovalprocessListQryAbilityService.getFscApprovalprocessListQry(fscComApprovalprocessListQryAbilityReqBO);
        if (!CollectionUtils.isEmpty((Collection)fscApprovalList.getRows())) {
            approvalList = fscApprovalList.getRows();
            this.dealStationInfo(approvalList);
        }
        LinkedList<PdfPTable> tableList = new LinkedList<PdfPTable>();
        this.addHeadTable(tableList, orderDetail);
        this.addMiddleTable(tableList, fscOrderItemDetailQueryAbilityRspBO, fscOrderPo);
        this.addFootTable(tableList, orderDetail);
        this.addAuditTable(tableList, approvalList);
        return tableList;
    }

    private void addHeadTable(List<PdfPTable> tableList, FscComOrderDetailQueryAbilityRspBO orderDetail) {
        PdfPTable titleTable1 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)orderDetail.getOperatorDeptName(), (Font)PdfUtils.DEFAULT_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(50.0f), (Integer)23, null);
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)("\u9644\u4ef6" + (orderDetail.getAttachmentList() == null ? 0 : orderDetail.getAttachmentList().size()) + "\u5f20"), (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)1, null);
        tableList.add(titleTable1);
        PdfPTable pageTable2 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable2, (Object)"\u5e73\u53f0\u6d41\u91cf\u8d39", (Font)PdfUtils.DEFAULT_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(40.0f), (Integer)24, null);
        tableList.add(pageTable2);
        PdfPTable pageTable3 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable3, (Object)"\u7ecf\u529e\u90e8\u95e8\uff1a", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable3, (Object)orderDetail.getOperationName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)8, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable3, (Object)"\u7ecf\u529e\u4eba", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable3, (Object)orderDetail.getOperatorName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)8, null);
        tableList.add(pageTable3);
    }

    private void addMiddleTable(List<PdfPTable> tableList, FscOrderItemDetailQueryAbilityRspBO orderItemDetail, FscOrderPO fscOrderPo) {
        List orderItemDetailBOList = orderItemDetail.getFscOrderItemDetailBOS();
        FscOrderItemPO fscOrderItemPO = this.fscOrderItemMapper.getSumAmt(fscOrderPo.getFscOrderId());
        PdfPTable pageTable4 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)"\u9500\u552e\u7ed3\u7b97\u7f16\u7801", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)fscOrderPo.getOrderNo(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)"\u5ba2\u6237\u540d\u79f0", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)(fscOrderPo.getBuyName() == null ? "-" : fscOrderPo.getBuyName()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)"\u4e1a\u52a1\u7c7b\u578b", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)"\u5e73\u53f0\u6d41\u91cf\u8d39", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(pageTable4);
        PdfPTable pageTable5 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)"\u5408\u540c\u7f16\u53f7", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)fscOrderPo.getContractNo(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)"\u5408\u540c\u540d\u79f0", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)"-", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)12, null);
        tableList.add(pageTable5);
        PdfPTable pageTable6 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable6, (Object)"\u5e01\u79cd", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable6, (Object)"\u4eba\u6c11\u5e01", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable6, (Object)"\u6c47\u7387", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable6, (Object)"1", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable6, (Object)"\u7a0e\u7387", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable6, (Object)(CollectionUtils.isEmpty((Collection)orderItemDetailBOList) || StringUtils.isEmpty((Object)((FscOrderItemDetailBO)orderItemDetailBOList.get(0)).getTaxRate()) ? "" : ((FscOrderItemDetailBO)orderItemDetailBOList.get(0)).getTaxRate().multiply(new BigDecimal("100")) + "%"), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(pageTable6);
        PdfPTable pageTable7 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable7, (Object)"\u672c\u6b21\u5f00\u7968\u91d1\u989d\uff08\u4e0d\u542b\u7a0e\uff09", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable7, (Object)(fscOrderItemPO.getUntaxAmt() == null ? BigDecimal.ZERO : fscOrderItemPO.getUntaxAmt().setScale(2, 4)), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable7, (Object)"\u672c\u6b21\u5f00\u7968\u7a0e\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable7, (Object)fscOrderItemPO.getAmt().subtract(fscOrderItemPO.getUntaxAmt()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable7, (Object)"\u672c\u6b21\u5f00\u7968\u91d1\u989d\uff08\u542b\u7a0e\uff09", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable7, (Object)(fscOrderItemPO.getAmt() == null ? BigDecimal.ZERO : fscOrderItemPO.getAmt().setScale(2, 4)), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(pageTable7);
        PdfPTable pageTable8 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable8, (Object)"\u91c7\u8d2d\u4ed8\u6b3e\u91d1\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable8, (Object)(fscOrderItemPO.getPurchaseUntaxAmt() == null ? BigDecimal.ZERO : fscOrderItemPO.getPurchaseUntaxAmt().setScale(2, 4)), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable8, (Object)"\u8fd4\u70b9\u767e\u5206\u767e", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable8, (Object)(CollectionUtils.isEmpty((Collection)orderItemDetailBOList) || StringUtils.isEmpty((Object)((FscOrderItemDetailBO)orderItemDetailBOList.get(0)).getFdPercent()) ? "-" : ((FscOrderItemDetailBO)orderItemDetailBOList.get(0)).getFdPercent() + "%"), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(pageTable8);
    }

    private void addFootTable(List<PdfPTable> tableList, FscComOrderDetailQueryAbilityRspBO orderDetail) {
        PdfPTable pageTable15 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable15, (Object)"\u5f00\u7968\u5907\u6ce8", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable15, (Object)orderDetail.getOrderDesc(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)20, null);
        tableList.add(pageTable15);
        if (!CollectionUtils.isEmpty((Collection)orderDetail.getOrderInvoiceInfo())) {
            OrderInvoiceBO orderInvoiceInfo = (OrderInvoiceBO)orderDetail.getOrderInvoiceInfo().get(0);
            PdfPTable pageTableAuditTitle = PdfUtils.newPdfTable();
            PdfUtils.addCellToTable((PdfPTable)pageTableAuditTitle, (Object)"\u5f00\u7968\u4fe1\u606f", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(35.0f), (Integer)24, null);
            tableList.add(pageTableAuditTitle);
            PdfPTable pageTable161 = PdfUtils.newPdfTable();
            PdfUtils.addCellToTable((PdfPTable)pageTable161, (Object)"\u5e8f\u53f7 ", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable161, (Object)"\u53d1\u7968\u62ac\u5934", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable161, (Object)"\u53d1\u7968\u7c7b\u578b", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable161, (Object)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable161, (Object)"\u5730\u5740/\u7535\u8bdd", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable161, (Object)"\u5f00\u6237\u94f6\u884c/\u94f6\u884c\u8d26\u53f7", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            tableList.add(pageTable161);
            PdfPTable pageTable162 = PdfUtils.newPdfTable();
            PdfUtils.addCellToTable((PdfPTable)pageTable162, (Object)"1", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable162, (Object)(org.apache.commons.lang3.StringUtils.isBlank((CharSequence)orderInvoiceInfo.getBuyName()) ? "-" : orderInvoiceInfo.getBuyName()), (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable162, (Object)orderInvoiceInfo.getInvoiceTypeStr(), (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable162, (Object)orderInvoiceInfo.getTaxNo(), (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable162, (Object)(orderInvoiceInfo.getAddress() + "/" + orderInvoiceInfo.getPhone()), (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable162, (Object)(orderInvoiceInfo.getBank() + "/" + orderInvoiceInfo.getAccount()), (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            tableList.add(pageTable162);
        }
    }

    public void addAuditTable(List<PdfPTable> tableList, List<FscApprovalprocessListBO> auditList) {
        PdfPTable pageTableAuditTitle = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTableAuditTitle, (Object)"\u7b7e\u5b57\u5ba1\u6279", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(35.0f), (Integer)24, null);
        tableList.add(pageTableAuditTitle);
        PdfPTable pageTableAudit = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTableAudit, (Object)"\u5ba1\u6279\u65f6\u95f4", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTableAudit, (Object)"\u5ba1\u6279\u8282\u70b9", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTableAudit, (Object)"\u5ba1\u6279\u4eba", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTableAudit, (Object)"\u5ba1\u6279\u72b6\u6001", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTableAudit, (Object)"\u5ba1\u6279\u610f\u89c1", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(pageTableAudit);
        if (!CollectionUtils.isEmpty(auditList)) {
            for (int i = 0; i < auditList.size(); ++i) {
                PdfPTable auditTable = PdfUtils.newPdfTable();
                PdfUtils.addCellToTable((PdfPTable)auditTable, (Object)String.valueOf(i + 1), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)auditTable, (Object)FscStringUtils.convertValue((Object)auditList.get(i).getTime()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)auditTable, (Object)FscStringUtils.convertValue((Object)auditList.get(i).getStationName()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)auditTable, (Object)FscStringUtils.convertValue((Object)auditList.get(i).getOperName()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)auditTable, (Object)FscStringUtils.convertValue((Object)auditList.get(i).getAudit()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)auditTable, (Object)FscStringUtils.convertValue((Object)auditList.get(i).getAdvice()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                tableList.add(auditTable);
            }
        }
    }

    public String uploadFile(String name, ByteArrayOutputStream byteArrayOutputStream) {
        String exportUrl;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        String fileName = name + System.currentTimeMillis() + ".pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            exportUrl = this.ossFileUrl + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        return exportUrl;
    }

    public void dealStationInfo(List<FscApprovalprocessListBO> approvalList) {
        approvalList.get(0).setStationName("\u63d0\u4ea4\u4eba");
        for (int i = 0; i < approvalList.size() - 1; ++i) {
            if (approvalList.get(i).getNextStationId() == null) continue;
            approvalList.get(i + 1).setStationId(approvalList.get(i).getNextStationId());
            DycStationSelectReqBO dycStationSelectReqBO = new DycStationSelectReqBO();
            dycStationSelectReqBO.setStationId(Long.valueOf(approvalList.get(i).getNextStationId()));
            DycStationSelectRspBO dycStationSelectRspBO = this.dycStationSelectService.stationSelectById(dycStationSelectReqBO);
            if (!ObjectUtils.isEmpty((Object)dycStationSelectRspBO.getData())) {
                approvalList.get(i + 1).setStationName(dycStationSelectRspBO.getData().getStationName());
                continue;
            }
            approvalList.get(i + 1).setStationName(approvalList.get(i).getNextStationId());
        }
        log.info("\u4e8c\u6b21\u5904\u7406\u4fe1\u606f\u4eba\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014:" + approvalList.toString());
    }

    @Autowired
    public void setFscOrderItemDetailQueryAbilityService(FscOrderItemDetailQueryAbilityService fscOrderItemDetailQueryAbilityService) {
        this.fscOrderItemDetailQueryAbilityService = fscOrderItemDetailQueryAbilityService;
    }

    @Autowired
    public void setFscComOrderDetailQueryAbilityService(FscComOrderDetailQueryAbilityService fscComOrderDetailQueryAbilityService) {
        this.fscComOrderDetailQueryAbilityService = fscComOrderDetailQueryAbilityService;
    }

    @Autowired
    public void setFscComApprovalprocessListQryAbilityService(FscComApprovalprocessListQryAbilityService fscComApprovalprocessListQryAbilityService) {
        this.fscComApprovalprocessListQryAbilityService = fscComApprovalprocessListQryAbilityService;
    }

    @Autowired
    public void setFileClient(FileClient fileClient) {
        this.fileClient = fileClient;
    }

    @Autowired
    public void setDycStationSelectService(DycStationSelectService dycStationSelectService) {
        this.dycStationSelectService = dycStationSelectService;
    }
}

