/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.atom.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.atom.api.FscBillOrderRefundChangeNewAtomService;
import com.tydic.fsc.bill.atom.bo.FscBillOrderRefundChangeAtomReqBO;
import com.tydic.fsc.bill.atom.bo.FscBillOrderRefundChangeAtomRspBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.FscEncodedSerialGetPublicAbilityService;
import com.tydic.fsc.common.ability.bo.FscEncodedSerialGetPublicAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscEncodedSerialGetPublicAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscOrderFlowEnum;
import com.tydic.fsc.dao.FscAccountChargeMapper;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscClaimChangeOrginalDetailMapper;
import com.tydic.fsc.dao.FscClaimDetailChangeMapper;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscInvoiceRefundRelationMapper;
import com.tydic.fsc.dao.FscOrdStateChgLogMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscOrderWriteRelationMapper;
import com.tydic.fsc.dao.FscPushLogMapper;
import com.tydic.fsc.dao.FscRecvClaimChangeMapper;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.dao.FscRefundChangeItemMapper;
import com.tydic.fsc.dao.FscRefundChangeMapper;
import com.tydic.fsc.dao.FscRefundWriteRelationMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.enums.FscClaimTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountChargePO;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscClaimChangeOrginalDetailPO;
import com.tydic.fsc.po.FscClaimDetailChangePO;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscOrdStateChgLogPO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscOrderWriteRelationPO;
import com.tydic.fsc.po.FscPushLogPO;
import com.tydic.fsc.po.FscRecvClaimChangePO;
import com.tydic.fsc.po.FscRecvClaimPO;
import com.tydic.fsc.po.FscRefundChangeItemPO;
import com.tydic.fsc.po.FscRefundChangePO;
import com.tydic.fsc.po.FscRefundWriteRelationPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.umc.general.ability.api.DycUmcRefundChangeCreateCodeAbilityService;
import com.tydic.umc.general.ability.bo.DycUmcRefundChangeCreateCodeAbilityReqBO;
import com.tydic.umc.general.ability.bo.DycUmcRefundChangeCreateCodeAbilityRspBO;
import com.tydic.uoc.common.ability.api.UocOrderRelUpdateAbilityService;
import com.tydic.uoc.common.ability.bo.UocOrderRefundUpdateReqBo;
import com.tydic.uoc.common.ability.bo.UocOrderRefundUpdateRspBo;
import com.tydic.uoc.common.ability.bo.UocOrderRelItemBo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillOrderRefundChangeNewAtomServiceImpl
implements FscBillOrderRefundChangeNewAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderRefundChangeNewAtomServiceImpl.class);
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscOrderWriteRelationMapper fscOrderWriteRelationMapper;
    @Autowired
    private FscRefundChangeMapper fscRefundChangeMapper;
    @Autowired
    private FscRefundChangeItemMapper fscRefundChangeItemMapper;
    @Autowired
    private DycUmcRefundChangeCreateCodeAbilityService dycUmcRefundChangeCreateCodeAbilityService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscRefundWriteRelationMapper fscRefundWriteRelationMapper;
    @Value(value="${OPER_ORG_ID}")
    private String operationOrgId;
    @Value(value="${OPER_ORG_NAME}")
    private String operationOrgName;
    @Autowired
    private FscEncodedSerialGetPublicAbilityService fscEncodedSerialGetPublicAbilityService;
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;
    @Autowired
    private FscRecvClaimChangeMapper fscRecvClaimChangeMapper;
    @Autowired
    private FscClaimDetailChangeMapper fscClaimDetailChangeMapper;
    @Autowired
    private FscClaimChangeOrginalDetailMapper fscClaimChangeOrginalDetailMapper;
    @Autowired
    private FscAccountChargeMapper fscAccountChargeMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscInvoiceRefundRelationMapper fscInvoiceRefundRelationMapper;
    @Autowired
    private FscOrdStateChgLogMapper fscOrdStateChgLogMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private UocOrderRelUpdateAbilityService uocOrderRelUpdateAbilityService;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscPushLogMapper fscPushLogMapper;

    @Override
    public FscBillOrderRefundChangeAtomRspBO recordRefundChangeNew(FscBillOrderRefundChangeAtomReqBO reqBO) {
        FscBillOrderRefundChangeAtomRspBO rspBO = new FscBillOrderRefundChangeAtomRspBO();
        if (reqBO.getRefundId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getRefundId());
        refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
        if (refundPO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u9000\u7968\u5355\u76f8\u5173\u4fe1\u606f\uff01");
        }
        ArrayList<FscClaimDetailPO> detailPOList = new ArrayList<FscClaimDetailPO>();
        FscClaimDetailPO detailPO = new FscClaimDetailPO();
        detailPO.setFscOrderId(refundPO.getFscOrderId());
        List payPaidList = this.fscClaimDetailMapper.getList(detailPO);
        if (!CollectionUtil.isEmpty((Collection)payPaidList)) {
            payPaidList.forEach(x -> {
                if (Objects.nonNull(x.getClaimAmt()) && x.getClaimAmt().compareTo(BigDecimal.ZERO) > 0) {
                    x.setRefundAmt(x.getClaimAmt());
                    detailPOList.add((FscClaimDetailPO)x);
                }
            });
        }
        FscOrderWriteRelationPO writeRelationPO = new FscOrderWriteRelationPO();
        writeRelationPO.setFscOrderId(refundPO.getFscOrderId());
        List writeOffList = this.fscOrderWriteRelationMapper.getWritteSum(writeRelationPO);
        if (CollectionUtils.isEmpty((Collection)writeOffList) && CollectionUtils.isEmpty(detailPOList)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        Map<Long, BigDecimal> claimItemIdMap = writeOffList.stream().collect(Collectors.toMap(FscOrderWriteRelationPO::getClaimDetailId, FscOrderWriteRelationPO::getWriteOffAmount));
        ArrayList<FscRefundWriteRelationPO> refundWriteRelationPOS = new ArrayList<FscRefundWriteRelationPO>();
        if (!CollectionUtils.isEmpty(claimItemIdMap)) {
            FscClaimDetailPO qryVo = new FscClaimDetailPO();
            qryVo.setClaimDetailIds(claimItemIdMap.keySet());
            List claimList = this.fscClaimDetailMapper.getListNoPage(qryVo);
            claimList.forEach(e -> e.setRefundAmt((BigDecimal)claimItemIdMap.get(e.getClaimDetailId())));
            detailPOList.addAll(claimList);
            FscOrderWriteRelationPO writeRelationPO1 = new FscOrderWriteRelationPO();
            writeRelationPO1.setFscOrderId(refundPO.getFscOrderId());
            List writeList = this.fscOrderWriteRelationMapper.getList(writeRelationPO1);
            refundWriteRelationPOS.addAll(writeList.stream().map(x -> {
                FscRefundWriteRelationPO refundWritePO = new FscRefundWriteRelationPO();
                BeanUtils.copyProperties((Object)x, (Object)refundWritePO);
                refundWritePO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                refundWritePO.setWriteOffId(x.getId());
                refundWritePO.setCreateTime(new Date());
                refundWritePO.setDelFlag(FscConstants.DicDelFlag.NO);
                refundWritePO.setRefundId(reqBO.getRefundId());
                refundWritePO.setAmount(x.getWriteOffAmount());
                refundWritePO.setWriteOffAmount(BigDecimal.ZERO);
                return refundWritePO;
            }).collect(Collectors.toList()));
        }
        this.dealChangeInfo(refundPO, detailPOList, refundWriteRelationPOS);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealChangeInfo(FscOrderRefundPO refundPO, List<FscClaimDetailPO> updateClaimDetailList, List<FscRefundWriteRelationPO> refundRelationPOList) {
        if (CollectionUtils.isEmpty(updateClaimDetailList)) {
            return;
        }
        Map<Long, List<FscClaimDetailPO>> claimDetailMap = updateClaimDetailList.stream().collect(Collectors.groupingBy(FscClaimDetailPO::getClaimId));
        HashMap<Long, String> changeCodeMap = new HashMap<Long, String>();
        for (FscClaimDetailPO fscClaimDetailPO : updateClaimDetailList) {
            if (changeCodeMap.containsKey(fscClaimDetailPO.getClaimId())) continue;
            changeCodeMap.put(fscClaimDetailPO.getClaimId(), fscClaimDetailPO.getClaimNo());
        }
        this.getClaimChangeCode(changeCodeMap);
        ArrayList<FscRefundChangePO> changePOList = new ArrayList<FscRefundChangePO>();
        ArrayList<FscRefundChangeItemPO> changeItemPOList = new ArrayList<FscRefundChangeItemPO>();
        HashMap<Long, Long> changeItemMap = new HashMap<Long, Long>();
        Map claimTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_VIRTUAL_CHANGE_CLAIM_TYPE_NEW");
        for (Long claimId : claimDetailMap.keySet()) {
            FscClaimDetailPO fscClaimDetailPO = claimDetailMap.get(claimId).get(0);
            FscRefundChangePO fscRefundChangePO = new FscRefundChangePO();
            fscRefundChangePO.setChangeId(Long.valueOf(Sequence.getInstance().nextId()));
            fscRefundChangePO.setRefundId(refundPO.getRefundId());
            fscRefundChangePO.setChangeNo((String)changeCodeMap.get(fscClaimDetailPO.getClaimId()));
            fscRefundChangePO.setYcUserId(refundPO.getYcUserId());
            fscRefundChangePO.setYcUserName(refundPO.getYcPersonName());
            fscRefundChangePO.setYcDeptId(refundPO.getYcDeptId());
            fscRefundChangePO.setYcDeptName(refundPO.getYcDeptName());
            fscRefundChangePO.setYcOrgId(Long.valueOf(this.operationOrgId));
            fscRefundChangePO.setYcOrgName(this.operationOrgName);
            fscRefundChangePO.setCreateUserId(refundPO.getOperatorId());
            fscRefundChangePO.setCreateTime(new Date());
            fscRefundChangePO.setClaimId(fscClaimDetailPO.getClaimId());
            fscRefundChangePO.setClaimNo(fscClaimDetailPO.getClaimNo());
            fscRefundChangePO.setDelFlag(FscConstants.DicDelFlag.NO);
            BigDecimal changeAmt = BigDecimal.ZERO;
            for (FscClaimDetailPO claimDetailPO : claimDetailMap.get(claimId)) {
                if ("7".equals(claimDetailPO.getClaimType()) && Objects.isNull(claimDetailPO.getObjectId())) {
                    throw new FscBusinessException("198888", "\u81ea\u8425\u9884\u6536\u8ba4\u9886\u884cobjectId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                FscRefundChangeItemPO changeItemPO = new FscRefundChangeItemPO();
                changeItemPO.setChangeItemId(Long.valueOf(Sequence.getInstance().nextId()));
                changeItemMap.put(claimDetailPO.getClaimDetailId(), changeItemPO.getChangeItemId());
                changeItemPO.setPreClaimType(Integer.valueOf(claimDetailPO.getClaimType()));
                changeItemPO.setRefundId(refundPO.getRefundId());
                changeItemPO.setPreFscOrderId(claimDetailPO.getFscOrderId());
                changeItemPO.setPreFscOrderNo(claimDetailPO.getFscOrderNo());
                changeItemPO.setPreClaimId(claimDetailPO.getClaimId());
                changeItemPO.setPreClaimDetailId(claimDetailPO.getClaimDetailId());
                changeItemPO.setPreHandleUserId(claimDetailPO.getHandleUserId());
                changeItemPO.setPreHandleUserName(claimDetailPO.getHandleUserName());
                changeItemPO.setPreHandleDeptId(claimDetailPO.getHandleDeptId());
                changeItemPO.setPreHandleDeptName(claimDetailPO.getHandleDeptName());
                changeItemPO.setChangeAmt(claimDetailPO.getRefundAmt());
                if (StringUtils.isEmpty((CharSequence)((CharSequence)claimTypeMap.get(claimDetailPO.getClaimType())))) {
                    throw new FscBusinessException("198888", "FSC_VIRTUAL_CHANGE_CLAIM_TYPE_NEW:" + claimDetailPO.getClaimType() + "\u5b57\u5178\u8f6c\u6362\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u5b57\u5178\uff01");
                }
                changeItemPO.setClaimType(Integer.valueOf((String)claimTypeMap.get(claimDetailPO.getClaimType())));
                changeItemPO.setHandleUserName(refundPO.getYcPersonName());
                changeItemPO.setHandleUserId(refundPO.getYcUserId());
                changeItemPO.setHandleDeptId(refundPO.getYcDeptId());
                changeItemPO.setHandleDeptName(refundPO.getYcDeptName());
                changeItemPO.setClaimAmt(changeItemPO.getChangeAmt());
                changeItemPO.setDelFlag(FscConstants.DicDelFlag.NO);
                if (claimDetailPO.getOrderId() != null) {
                    changeItemPO.setExt1(claimDetailPO.getOrderId().toString());
                }
                changeAmt = changeAmt.add(claimDetailPO.getRefundAmt());
                changeItemPOList.add(changeItemPO);
            }
            if (changeAmt.compareTo(BigDecimal.ZERO) == 0) {
                fscRefundChangePO.setDelFlag(FscConstants.DicDelFlag.YES);
            }
            fscRefundChangePO.setChangeAmt(changeAmt);
            changePOList.add(fscRefundChangePO);
        }
        int count = this.fscRefundChangeMapper.insertBatch(changePOList);
        if (count != changePOList.size()) {
            throw new FscBusinessException("198888", "\u5b58\u50a8\u865a\u62df\u53d8\u66f4\u5934\u4fe1\u606f\u5931\u8d25!");
        }
        count = this.fscRefundChangeItemMapper.insertBatch(changeItemPOList);
        if (count != changeItemPOList.size()) {
            throw new FscBusinessException("198888", "\u5b58\u50a8\u865a\u62df\u53d8\u66f4\u884c\u4fe1\u606f\u5931\u8d25!");
        }
        if (!CollectionUtils.isEmpty(refundRelationPOList)) {
            refundRelationPOList.forEach(e -> e.setChangeItemId((Long)changeItemMap.get(e.getClaimDetailId())));
            count = this.fscRefundWriteRelationMapper.insertBatch(refundRelationPOList);
            if (count != refundRelationPOList.size()) {
                throw new FscBusinessException("198888", "\u5b58\u50a8\u51b2\u9500\u6838\u9500\u660e\u7ec6\u4fe1\u606f\u5931\u8d25!");
            }
        }
    }

    private void getClaimChangeCode(Map<Long, String> changeCodeMap) {
        ArrayList<String> claimNoList = new ArrayList<String>();
        claimNoList.addAll(changeCodeMap.values());
        DycUmcRefundChangeCreateCodeAbilityReqBO abilityReqBO = new DycUmcRefundChangeCreateCodeAbilityReqBO();
        abilityReqBO.setClaimNoList(claimNoList);
        DycUmcRefundChangeCreateCodeAbilityRspBO abilityRspBO = this.dycUmcRefundChangeCreateCodeAbilityService.createRefundChangeCode(abilityReqBO);
        Map claimNoMap = abilityRspBO.getClaimNoMap();
        if (!CollectionUtils.isEmpty((Map)claimNoMap)) {
            for (Long claimId : changeCodeMap.keySet()) {
                String claimIdCode = changeCodeMap.get(claimId);
                if (claimNoMap.containsKey(claimIdCode)) {
                    changeCodeMap.put(claimId, (String)claimNoMap.get(claimIdCode));
                    continue;
                }
                throw new ZTBusinessException("\u751f\u6210\u53d8\u66f4\u5355\u53f7\u5931\u8d25");
            }
        } else {
            throw new ZTBusinessException("\u751f\u6210\u53d8\u66f4\u5355\u53f7\u5931\u8d25");
        }
    }

    @Override
    public FscBillOrderRefundChangeAtomRspBO recordRefundPostStatus(FscBillOrderRefundChangeAtomReqBO reqBO) {
        FscBillOrderRefundChangeAtomRspBO rspBO = new FscBillOrderRefundChangeAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getRefundId());
        refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
        if (refundPO.getOrderType() != 15) {
            if (!FscConstants.FscPostingStatus.POST.equals(refundPO.getPostStatus())) {
                throw new ZTBusinessException("\u51b2\u9500\u5355\u56de\u5199\u672a\u8fc7\u8d26\uff01");
            }
            if (!FscConstants.RefundInvoiceStatus.AUDIT_PASS.equals(refundPO.getRefundStatus())) {
                throw new ZTBusinessException("\u51b2\u9500\u5355\u56de\u5199\u72b6\u6001\u5f02\u5e38\uff01");
            }
            List fscRefundChangePOS = this.fscRefundChangeMapper.queryByRefundId(reqBO.getRefundId());
            if (!CollectionUtils.isEmpty((Collection)fscRefundChangePOS)) {
                List fscAccountChargePOS;
                List fscRefundChangeItemPOS = this.fscRefundChangeItemMapper.queryByRefundId(reqBO.getRefundId());
                Map<Long, List<FscRefundChangeItemPO>> changeClaimDetailMap = fscRefundChangeItemPOS.stream().collect(Collectors.groupingBy(FscRefundChangeItemPO::getPreClaimId));
                List fscClaimDetailPOS = this.fscClaimDetailMapper.queryItemInfo(fscRefundChangeItemPOS.stream().map(FscRefundChangeItemPO::getPreClaimDetailId).collect(Collectors.toList()));
                Map<Long, FscClaimDetailPO> claimDetailMap = fscClaimDetailPOS.stream().collect(Collectors.toMap(FscClaimDetailPO::getClaimDetailId, o -> o));
                List fscRecvClaimPOS = this.fscRecvClaimMapper.queryByIds(fscRefundChangeItemPOS.stream().map(FscRefundChangeItemPO::getPreClaimId).distinct().collect(Collectors.toList()));
                Map<Long, FscRecvClaimPO> claimMap = fscRecvClaimPOS.stream().collect(Collectors.toMap(FscRecvClaimPO::getClaimId, o -> o));
                List chargeIds = fscClaimDetailPOS.stream().filter(x -> FscClaimTypeEnum.ELECTRONIC_SUPERMARKET_SAVE_CLAIM.getCode().equals(x.getClaimType()) && Objects.nonNull(x.getObjectId())).map(FscClaimDetailPO::getObjectId).collect(Collectors.toList());
                Map<Object, Object> chargeMap = new HashMap();
                List<Object> advanceDepositNoList = new ArrayList();
                if (!CollectionUtils.isEmpty(chargeIds) && !(chargeMap = (fscAccountChargePOS = this.fscAccountChargeMapper.queryByIds(chargeIds)).stream().collect(Collectors.toMap(FscAccountChargePO::getChargeId, o -> o))).isEmpty()) {
                    advanceDepositNoList = this.getAdvanceDepositNo(chargeMap.size());
                }
                Date pushDate = this.dealPushDate(reqBO.getRefundId());
                ArrayList updateClaimDetailPOS = new ArrayList();
                ArrayList insertClaimDetailPOS = new ArrayList();
                ArrayList insertClaimChangePOs = new ArrayList();
                ArrayList insertClaimDetailChangePOs = new ArrayList();
                ArrayList insertClaimDetailOrginalChangePOs = new ArrayList();
                ArrayList updateChargeList = new ArrayList();
                ArrayList chargeInsertList = new ArrayList();
                ArrayList updateFscShouldPayPOS = new ArrayList();
                Date now = new Date();
                List<Object> finalAdvanceDepositNoList = advanceDepositNoList;
                Map<Object, Object> finalChargeMap = chargeMap;
                fscRefundChangePOS.forEach(x -> {
                    FscRecvClaimChangePO claimChangePO = (FscRecvClaimChangePO)JSON.parseObject((String)JSONObject.toJSONString(claimMap.get(x.getClaimId())), FscRecvClaimChangePO.class);
                    claimChangePO.setChangeAmt(x.getChangeAmt());
                    claimChangePO.setChangeNo(x.getChangeNo());
                    claimChangePO.setChangeDate(x.getCreateTime());
                    claimChangePO.setChangeDeptId(x.getYcDeptId());
                    claimChangePO.setChangeDeptName(x.getYcDeptName());
                    claimChangePO.setChangeUserId(x.getYcUserId());
                    claimChangePO.setChangeUserName(x.getYcUserName());
                    claimChangePO.setPushStatus(FscConstants.FscClaimChangePushStatus.SUCCESS);
                    claimChangePO.setBillStatus(FscConstants.ChangeBillStatus.CONFIRMED);
                    claimChangePO.setChangeId(x.getChangeId());
                    claimChangePO.setCreateTime(now);
                    claimChangePO.setPostingDate(now);
                    claimChangePO.setPushDate(pushDate);
                    insertClaimChangePOs.add(claimChangePO);
                    List changeItem = (List)changeClaimDetailMap.get(x.getClaimId());
                    AtomicInteger serialNumber = new AtomicInteger();
                    AtomicInteger advanceIndex = new AtomicInteger();
                    changeItem.forEach(y -> {
                        FscClaimDetailPO insertDetailPO = new FscClaimDetailPO();
                        FscClaimDetailPO updateDetailPO = new FscClaimDetailPO();
                        FscAccountChargePO fscAccountChargePO = new FscAccountChargePO();
                        FscClaimDetailChangePO detailChangePO = new FscClaimDetailChangePO();
                        if (y.getPreClaimType() == 1 || y.getPreClaimType() == 11 || y.getPreClaimType() == 17 || y.getPreClaimType() == 22 || y.getPreClaimType() == 8 || y.getPreClaimType() == 9 || y.getPreClaimType() == 9 || y.getPreClaimType() == 38 || y.getPreClaimType() == 4 || y.getPreClaimType() == 6) {
                            insertDetailPO.setBalanceType("2");
                            insertDetailPO.setOrderCode(x.getClaimNo() + "-CWYRL-" + String.format("%02d", serialNumber.incrementAndGet()));
                            detailChangePO.setChangeBusiType(FscConstants.ChangeBusiType.REFUND);
                            updateDetailPO.setWriteOffAmount(BigDecimal.ZERO);
                        } else {
                            insertDetailPO = (FscClaimDetailPO)claimDetailMap.get(y.getPreClaimDetailId());
                            updateDetailPO.setWriteOffAmount(y.getChangeAmt());
                            if (y.getPreClaimType() == 5) {
                                detailChangePO.setChangeBusiType(FscConstants.ChangeBusiType.ADVANCE);
                                fscAccountChargePO = (FscAccountChargePO)finalChargeMap.get(insertDetailPO.getObjectId());
                                FscAccountChargePO po = new FscAccountChargePO();
                                po.setChargeId(insertDetailPO.getObjectId());
                                po.setChargeAmount(fscAccountChargePO.getChargeAmount().subtract(y.getChangeAmt()));
                                updateChargeList.add(po);
                                Long chargeId = Sequence.getInstance().nextId();
                                insertDetailPO.setObjectId(chargeId);
                                insertDetailPO.setObjectNo((String)finalAdvanceDepositNoList.get(advanceIndex.getAndIncrement()));
                                fscAccountChargePO.setChargeId(chargeId);
                                fscAccountChargePO.setAdvanceDepositNo(insertDetailPO.getObjectNo());
                                fscAccountChargePO.setClaimDetailId(y.getChangeItemId());
                                fscAccountChargePO.setChargeAmount(y.getChangeAmt());
                                fscAccountChargePO.setUserId(y.getHandleUserId());
                                fscAccountChargePO.setUserName(y.getHandleUserName());
                                fscAccountChargePO.setDeptId(y.getHandleDeptId());
                                fscAccountChargePO.setDeptName(y.getHandleDeptName());
                                fscAccountChargePO.setCreateTime(now);
                                chargeInsertList.add(fscAccountChargePO);
                            } else {
                                detailChangePO.setChangeBusiType(FscConstants.ChangeBusiType.ORDER);
                                FscShouldPayPO bo = new FscShouldPayPO();
                                bo.setShouldPayId(insertDetailPO.getObjectId());
                                bo.setWriteOffAmount(y.getChangeAmt());
                                updateFscShouldPayPOS.add(bo);
                            }
                        }
                        insertDetailPO.setDetailNo(x.getChangeNo() + String.format("%02d", serialNumber.incrementAndGet()));
                        insertDetailPO.setClaimDetailId(y.getChangeItemId());
                        insertDetailPO.setClaimType(y.getClaimType() + "");
                        insertDetailPO.setClaimAmt(y.getChangeAmt());
                        insertDetailPO.setClaimDate(x.getCreateTime());
                        insertDetailPO.setClaimId(y.getPreClaimId());
                        insertDetailPO.setStatus("1");
                        insertDetailPO.setHandleUserId(y.getHandleUserId());
                        insertDetailPO.setHandleUserName(y.getHandleUserName());
                        insertDetailPO.setHandleDeptId(y.getHandleDeptId());
                        insertDetailPO.setHandleDeptName(y.getHandleDeptName());
                        insertDetailPO.setPushStatus(Integer.valueOf(1));
                        insertDetailPO.setWriteOffAmount(BigDecimal.ZERO);
                        insertDetailPO.setSysSource(Integer.valueOf(1));
                        insertDetailPO.setPostingStatus("1");
                        insertClaimDetailPOS.add(insertDetailPO);
                        updateDetailPO.setClaimAmt(y.getChangeAmt());
                        updateDetailPO.setClaimDetailId(y.getPreClaimDetailId());
                        updateClaimDetailPOS.add(updateDetailPO);
                        FscClaimDetailPO detailPO = (FscClaimDetailPO)claimDetailMap.get(y.getPreClaimDetailId());
                        FscClaimChangeOrginalDetailPO orginalDetailPO = new FscClaimChangeOrginalDetailPO();
                        orginalDetailPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                        orginalDetailPO.setChangeId(x.getChangeId());
                        orginalDetailPO.setClaimId(x.getClaimId());
                        orginalDetailPO.setClaimDetailId(y.getPreClaimDetailId());
                        orginalDetailPO.setClaimant(detailPO.getHandleUserName());
                        orginalDetailPO.setClaimDept(detailPO.getHandleDeptName());
                        orginalDetailPO.setClaimType(detailPO.getClaimType());
                        orginalDetailPO.setFscOrderNo(detailPO.getFscOrderNo());
                        orginalDetailPO.setRechargeNo(detailPO.getObjectNo());
                        orginalDetailPO.setClaimAmt(FscConstants.ChangeBusiType.REFUND.equals(detailChangePO.getChangeBusiType()) ? detailPO.getClaimAmt() : y.getChangeAmt());
                        orginalDetailPO.setWriteOffAmount(FscConstants.ChangeBusiType.REFUND.equals(detailChangePO.getChangeBusiType()) ? detailPO.getWriteOffAmount() : BigDecimal.ZERO);
                        orginalDetailPO.setVariableAmount(orginalDetailPO.getClaimAmt().subtract(orginalDetailPO.getWriteOffAmount()));
                        orginalDetailPO.setChangeAmount(y.getChangeAmt());
                        insertClaimDetailOrginalChangePOs.add(orginalDetailPO);
                        detailChangePO.setChangeDetailId(y.getChangeItemId());
                        detailChangePO.setChangeId(x.getChangeId());
                        detailChangePO.setClaimId(x.getClaimId());
                        detailChangePO.setChangeDetailNo(insertDetailPO.getDetailNo());
                        detailChangePO.setChangeAmt(y.getChangeAmt());
                        detailChangePO.setConfirmDate(now);
                        detailChangePO.setCreateTime(now);
                        detailChangePO.setConfirmUserId(x.getCreateUserId());
                        detailChangePO.setConfirmUserName(x.getYcUserName());
                        detailChangePO.setCreateUserId(x.getCreateUserId());
                        detailChangePO.setChangeClaimType(y.getClaimType());
                        detailChangePO.setDelFlag(Integer.valueOf(0));
                        detailChangePO.setPostingStatus("1");
                        detailChangePO.setHandleDeptId(y.getHandleDeptId());
                        detailChangePO.setHandleUserId(y.getHandleUserId());
                        detailChangePO.setHandleDeptName(y.getHandleDeptName());
                        detailChangePO.setHandleUserName(y.getHandleUserName());
                        detailChangePO.setRemainingChangeAmt(BigDecimal.ZERO);
                        detailChangePO.setChangeSource(Integer.valueOf(1));
                        if (FscConstants.ChangeBusiType.ORDER.equals(detailChangePO.getChangeBusiType())) {
                            detailChangePO.setChangeOrderId(detailPO.getOrderId());
                            detailChangePO.setChangeOrderCode(detailPO.getOrderCode());
                            detailChangePO.setChangeShouldPayId(detailPO.getObjectId());
                            detailChangePO.setChangeShouldPayNo(detailPO.getObjectNo());
                            detailChangePO.setPayOrderId(detailPO.getPayOrderId());
                            detailChangePO.setPayOrderNo(detailPO.getPayOrderNo());
                            detailChangePO.setChangePayOrderId(detailPO.getPayOrderId());
                        }
                        if (FscConstants.ChangeBusiType.ADVANCE.equals(detailChangePO.getChangeBusiType())) {
                            detailChangePO.setChangeChargeId(insertDetailPO.getObjectId());
                            detailChangePO.setChangeChargeNo(insertDetailPO.getObjectNo());
                            detailChangePO.setChangeAccountId(fscAccountChargePO.getAccountId());
                            detailChangePO.setOrgCode(fscAccountChargePO.getUseDeptCode());
                            detailChangePO.setOrgName(fscAccountChargePO.getUseDeptName());
                        }
                        insertClaimDetailChangePOs.add(detailChangePO);
                    });
                });
                if (!CollectionUtils.isEmpty(insertClaimDetailChangePOs)) {
                    Map<Object, Object> fscAccountPOMap;
                    Map<Object, Object> shouldPayPOMap;
                    List shouldPayIds = insertClaimDetailChangePOs.stream().filter(x -> FscConstants.ChangeBusiType.ORDER.equals(x.getChangeBusiType())).map(FscClaimDetailChangePO::getChangeShouldPayId).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(shouldPayIds)) {
                        FscShouldPayPO shouldPayPO = new FscShouldPayPO();
                        shouldPayPO.setShouldPayIds(shouldPayIds);
                        List shouldPayPOs = this.fscShouldPayMapper.getList(shouldPayPO);
                        shouldPayPOMap = shouldPayPOs.stream().collect(Collectors.toMap(FscShouldPayPO::getShouldPayId, e -> e));
                    } else {
                        shouldPayPOMap = new HashMap();
                    }
                    List accountIds = insertClaimDetailChangePOs.stream().filter(x -> FscConstants.ChangeBusiType.ADVANCE.equals(x.getChangeBusiType())).map(FscClaimDetailChangePO::getChangeAccountId).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(accountIds)) {
                        FscAccountPO accountPO = new FscAccountPO();
                        accountPO.setIds(accountIds);
                        List accountPOS = this.fscAccountMapper.getList(accountPO);
                        fscAccountPOMap = accountPOS.stream().collect(Collectors.toMap(FscAccountPO::getId, e -> e));
                    } else {
                        fscAccountPOMap = new HashMap();
                    }
                    insertClaimDetailChangePOs.forEach(x -> {
                        if (Objects.nonNull(shouldPayPOMap.get(x.getChangeShouldPayId()))) {
                            x.setBuynerNo(((FscShouldPayPO)shouldPayPOMap.get(x.getChangeShouldPayId())).getBuyerNo());
                            x.setBuynerName(((FscShouldPayPO)shouldPayPOMap.get(x.getChangeShouldPayId())).getBuyerName());
                        }
                        if (Objects.nonNull(fscAccountPOMap.get(x.getChangeAccountId()))) {
                            x.setChangeAccountNo(((FscAccountPO)fscAccountPOMap.get(x.getChangeAccountId())).getAccountNo());
                            x.setBankAccount(((FscAccountPO)fscAccountPOMap.get(x.getChangeAccountId())).getBankAccount());
                            x.setAdvanceAmount(((FscAccountPO)fscAccountPOMap.get(x.getChangeAccountId())).getAdvanceAmount());
                            x.setRemainAmount(((FscAccountPO)fscAccountPOMap.get(x.getChangeAccountId())).getRemainAmount());
                        }
                    });
                    this.fscClaimDetailChangeMapper.insertBatch(insertClaimDetailChangePOs);
                }
                if (!CollectionUtils.isEmpty(insertClaimDetailOrginalChangePOs)) {
                    this.fscClaimChangeOrginalDetailMapper.insertBatch(insertClaimDetailOrginalChangePOs);
                }
                if (!CollectionUtils.isEmpty(insertClaimChangePOs)) {
                    this.fscRecvClaimChangeMapper.insertBatch(insertClaimChangePOs);
                }
                if (!CollectionUtils.isEmpty(updateClaimDetailPOS)) {
                    this.fscClaimDetailMapper.updateBatchPostingStatus(updateClaimDetailPOS);
                }
                if (!CollectionUtils.isEmpty(insertClaimDetailPOS)) {
                    this.fscClaimDetailMapper.insertBatch(insertClaimDetailPOS);
                }
                if (!CollectionUtils.isEmpty(updateChargeList)) {
                    this.fscAccountChargeMapper.updateBathList(updateChargeList);
                }
                if (!CollectionUtils.isEmpty(chargeInsertList)) {
                    this.fscAccountChargeMapper.insertBatch(chargeInsertList);
                }
                if (!CollectionUtils.isEmpty(updateFscShouldPayPOS)) {
                    this.fscShouldPayMapper.updateWriteOffAmountSub(updateFscShouldPayPOS);
                }
                FscRefundWriteRelationPO writeRelationPO = new FscRefundWriteRelationPO();
                writeRelationPO.setRefundId(reqBO.getRefundId());
                List refundWriteRelationPOS = this.fscRefundWriteRelationMapper.getList(writeRelationPO);
                if (!CollectionUtils.isEmpty((Collection)refundWriteRelationPOS)) {
                    List writeRelationPOSList = refundWriteRelationPOS.stream().map(x -> {
                        FscOrderWriteRelationPO y = new FscOrderWriteRelationPO();
                        y.setId(x.getWriteOffId());
                        y.setWriteOffAmount(x.getAmount());
                        return y;
                    }).collect(Collectors.toList());
                    this.fscOrderWriteRelationMapper.updateWriteOffBatchById(writeRelationPOSList);
                }
            }
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(refundPO.getFscOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        Boolean tpSign = false;
        FscOrderRefundPO refundPO1 = new FscOrderRefundPO();
        refundPO1.setFscOrderId(fscOrderPO.getFscOrderId());
        List refundPOs = this.fscOrderRefundMapper.queryAll(refundPO);
        BigDecimal refundAmount = refundPOs.stream().filter(e -> !FscConstants.RefundInvoiceStatus.DELETE.equals(e.getRefundStatus()) || !FscConstants.RefundInvoiceStatus.CANCEL.equals(e.getRefundStatus())).map(FscOrderRefundPO::getRefundAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (refundAmount.compareTo(fscOrderPO.getTotalCharge()) == 0) {
            this.insertState(fscOrderPO.getFscOrderId(), FscConstants.FscInvoiceOrderState.REFUND, fscOrderPO.getOrderState(), "\u9000\u7968\u5355\u4e1a\u8d22\u8fc7\u8d26");
            tpSign = true;
        }
        if (FscOrderFlowEnum.MEMBER_FEE_INVOICE.getCode().equals(fscOrderPO.getOrderFlow())) {
            FscOrderRelationPO relationPO = new FscOrderRelationPO();
            relationPO.setFscOrderId(fscOrderPO.getFscOrderId());
            List relationList = this.fscOrderRelationMapper.getList(relationPO);
            Long memPayId = ((FscOrderRelationPO)relationList.get(0)).getOrderId();
            this.insertState(memPayId, FscConstants.FscInvoiceOrderState.UNBILLED, FscConstants.FscInvoiceOrderState.BILLED, "\u4f1a\u5458\u8d39\u9000\u7968\u5355\u4e1a\u8d22\u8fc7\u8d26");
        } else if (!FscOrderFlowEnum.TRACFFIC_FEE.getCode().equals(fscOrderPO.getOrderFlow())) {
            UocOrderRefundUpdateReqBo uocOrderRelUpdateReqBo = new UocOrderRefundUpdateReqBo();
            uocOrderRelUpdateReqBo.setRelId(fscOrderPO.getFscOrderId());
            uocOrderRelUpdateReqBo.setSettleType(fscOrderPO.getSettleType());
            uocOrderRelUpdateReqBo.setDealType(Integer.valueOf(1));
            if (!tpSign.booleanValue()) {
                FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
                fscOrderItemPO.setRefundId(reqBO.getRefundId());
                List fscOrderItemPOS = this.fscOrderItemMapper.getList(fscOrderItemPO);
                uocOrderRelUpdateReqBo.setUocOrderRelItemBos(fscOrderItemPOS.stream().map(x -> {
                    UocOrderRelItemBo y = new UocOrderRelItemBo();
                    y.setOrdItemId(x.getOrdItemId());
                    y.setOrderId(x.getOrderId());
                    y.setNum(x.getNum());
                    y.setAmt(x.getAmt());
                    return y;
                }).collect(Collectors.toList()));
                uocOrderRelUpdateReqBo.setDealType(Integer.valueOf(2));
            }
            log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uocOrderRelUpdateReqBo));
            UocOrderRefundUpdateRspBo uocOrderRelUpdateRspBo = this.uocOrderRelUpdateAbilityService.dealUpdateBatch(uocOrderRelUpdateReqBo);
            log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uocOrderRelUpdateRspBo));
            if (!"0000".equals(uocOrderRelUpdateRspBo.getRespCode())) {
                throw new FscBusinessException("194323", "\u8fc7\u8d26\u91ca\u653e\u8ba2\u5355\u5931\u8d25\uff1a" + uocOrderRelUpdateRspBo.getRespDesc());
            }
        }
        rspBO.setFscOrderId(refundPO.getFscOrderId());
        return rspBO;
    }

    private List<String> getAdvanceDepositNo(Integer size) {
        ArrayList<String> advanceDepositNoList = new ArrayList();
        FscEncodedSerialGetPublicAbilityReqBO fscEncodedSerialGetPublicAbilityReqBO = new FscEncodedSerialGetPublicAbilityReqBO();
        fscEncodedSerialGetPublicAbilityReqBO.setCenter("FSC");
        fscEncodedSerialGetPublicAbilityReqBO.setEncodedRuleCode("ADVANCE_DEPOSIT_NO");
        fscEncodedSerialGetPublicAbilityReqBO.setNum(size);
        fscEncodedSerialGetPublicAbilityReqBO.setOrgType("-1");
        FscEncodedSerialGetPublicAbilityRspBO fscEncodedSerialGetPublicAbilityRspBO = this.fscEncodedSerialGetPublicAbilityService.getEncodedSerialPublic(fscEncodedSerialGetPublicAbilityReqBO);
        if (!"0000".equals(fscEncodedSerialGetPublicAbilityRspBO.getRespCode())) {
            throw new FscBusinessException("190000", "\u751f\u6210\u9884\u5b58\u6b3e\u7f16\u53f7\u5f02\u5e38\uff01");
        }
        advanceDepositNoList = fscEncodedSerialGetPublicAbilityRspBO.getSerialNoList();
        return advanceDepositNoList;
    }

    private void insertState(Long fscOrderId, Integer newState, Integer oldState, String desc) {
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(fscOrderId);
        fscOrderPO.setOrderState(newState);
        this.fscOrderMapper.updateById(fscOrderPO);
        FscOrdStateChgLogPO fscOrdStateChgLogPO = new FscOrdStateChgLogPO();
        fscOrdStateChgLogPO.setNewState(newState);
        fscOrdStateChgLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        fscOrdStateChgLogPO.setFscOrderId(fscOrderId);
        fscOrdStateChgLogPO.setOldState(oldState);
        fscOrdStateChgLogPO.setChgTime(new Date());
        fscOrdStateChgLogPO.setChgDesc(desc);
        this.fscOrdStateChgLogMapper.insert(fscOrdStateChgLogPO);
    }

    private Date dealPushDate(Long refundId) {
        FscPushLogPO pushLogPO = new FscPushLogPO();
        pushLogPO.setObjectId(refundId);
        pushLogPO.setStatus(Integer.valueOf(1));
        pushLogPO.setType(FscConstants.FscPushType.SALE_SETTLE_CHARGE_AGAINST);
        FscPushLogPO lastPushLog = this.fscPushLogMapper.getLastPushLog(pushLogPO);
        return Objects.isNull(lastPushLog) ? null : lastPushLog.getCreateTime();
    }
}

