/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.google.common.base.Joiner;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.busi.api.FscBillOrderInvoiceSignWelfareApplyBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceSignApplyBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceSignApplyBusiRspBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceSignWriteOffBusiReqBO;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscShouldPayBO;
import com.tydic.fsc.busibase.atom.api.FscPayShouldPayCreateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayCreateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayCreateAtomRspBO;
import com.tydic.fsc.common.ability.api.FscPayVerificationAbilityService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscInvoiceCheckResultMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgNameListQryAbilityService;
import com.tydic.umc.general.ability.bo.UmcDycEnterpriseOrgBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgNameListQryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgNameListQryAbilityRspBO;
import com.tydic.uoc.common.ability.api.UocSalesSingleDetailsListQueryAbilityService;
import com.tydic.uoc.common.ability.bo.UocPebChildOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocPebUpperOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocPhasePayListBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscBillOrderInvoiceSignWelfareApplyBusiServiceImpl
implements FscBillOrderInvoiceSignWelfareApplyBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderInvoiceSignWelfareApplyBusiServiceImpl.class);
    @Autowired
    private FscInvoiceCheckResultMapper fscInvoiceCheckResultMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Value(value="${saleOrderTabId:30001}")
    private Integer SALE_ORDER_TAB_ID;
    @Value(value="${fsc.main.pro.org:100096,100100}")
    private String proOrg;
    @Autowired
    private UmcEnterpriseOrgNameListQryAbilityService umcEnterpriseOrgNameListQryAbilityService;
    @Autowired
    private FscPayVerificationAbilityService fscPayVerificationAbilityService;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private UocSalesSingleDetailsListQueryAbilityService uocSalesSingleDetailsListQueryAbilityService;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscPayShouldPayCreateAtomService fscPayShouldPayCreateAtomService;

    @Override
    public FscBillOrderInvoiceSignApplyBusiRspBO dealOrderInvoiceSignWelfareApply(FscBillOrderInvoiceSignApplyBusiReqBO reqBO) {
        FscOrderPO set = new FscOrderPO();
        FscOrderPO where = new FscOrderPO();
        where.setFscOrderId(reqBO.getOrderId());
        set.setSignApplyTime(new Date());
        FscInvoicePO fscInvoicePO = new FscInvoicePO();
        fscInvoicePO.setFscOrderId(reqBO.getOrderId());
        List invoicePOList = this.fscInvoiceMapper.getList(fscInvoicePO);
        StringBuilder invoiceNo = new StringBuilder();
        if (!CollectionUtils.isEmpty((Collection)invoicePOList)) {
            StringBuilder invoiceCode = new StringBuilder();
            for (FscInvoicePO i : invoicePOList) {
                invoiceNo.append(",").append(i.getInvoiceNo());
                invoiceCode.append(",").append(i.getInvoiceCode());
            }
            set.setInvoiceNo(invoiceNo.toString());
            set.setInvoiceCode(invoiceCode.toString());
            set.setBuyName(((FscInvoicePO)invoicePOList.get(0)).getBuyName());
        }
        set.setOperatorId(reqBO.getUserId());
        set.setOperatorName(reqBO.getName());
        String operationNo = String.valueOf(reqBO.getOrgId());
        String[] org = this.proOrg.split(",");
        String[] pur = reqBO.getOrgPath().split("-");
        block1: for (String pro : org) {
            for (String t : pur) {
                if (!pro.equals(t)) continue;
                operationNo = pro;
                continue block1;
            }
        }
        set.setOperationNo(operationNo);
        if (!StringUtils.isEmpty((Object)set.getOperationNo())) {
            UmcEnterpriseOrgNameListQryAbilityReqBO abilityReqBO = new UmcEnterpriseOrgNameListQryAbilityReqBO();
            ArrayList<Long> operationNos = new ArrayList<Long>();
            operationNos.add(Long.parseLong(set.getOperationNo()));
            abilityReqBO.setOrgIdList(operationNos);
            UmcEnterpriseOrgNameListQryAbilityRspBO rspBO = this.umcEnterpriseOrgNameListQryAbilityService.qryEnterpriseOrgNameList(abilityReqBO);
            if (rspBO.getRespCode().equals("0000") && !CollectionUtils.isEmpty((Map)rspBO.getOrgMap())) {
                Map orgMap = rspBO.getOrgMap();
                set.setOperationName(((UmcDycEnterpriseOrgBO)orgMap.get(Long.valueOf(set.getOperationNo()))).getOrgName());
            }
        }
        if (where.getFscOrderId() == null) {
            throw new FscBusinessException("190000", "\u7ed3\u7b97\u5355ID\u4e0d\u53ef\u4e3a\u7a7a");
        }
        set.setOrderState(FscConstants.FscServiceOrderState.SIGNED_INVOICE);
        this.fscOrderMapper.updateBy(set, where);
        this.insertAttachment(reqBO.getAttachmentList(), reqBO.getOrderId());
        this.checkAmtTax(invoicePOList, reqBO.getOrderId());
        this.createShouldPay(reqBO.getFscShouldPayBOS(), reqBO, invoiceNo.toString());
        return new FscBillOrderInvoiceSignApplyBusiRspBO();
    }

    private void checkWriteOffAmt(BigDecimal writeOffAmt, Long fscOrderId, List<FscBillOrderInvoiceSignWriteOffBusiReqBO> purWriteOffAmountList) {
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(fscOrderId);
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        FscOrderRelationPO relationPO = new FscOrderRelationPO();
        relationPO.setFscOrderId(fscOrderId);
        List orderRelationPOS = this.fscOrderRelationMapper.getList(relationPO);
        Long orderId = ((FscOrderRelationPO)orderRelationPOS.get(0)).getOrderId();
        UocSalesSingleDetailsListQueryReqBO saleDetailsReqBO = new UocSalesSingleDetailsListQueryReqBO();
        saleDetailsReqBO.setOrderId(orderId);
        saleDetailsReqBO.setTabId(this.SALE_ORDER_TAB_ID);
        saleDetailsReqBO.setIndividually("1");
        UocSalesSingleDetailsListQueryRspBO saleDetailsRspBO = this.uocSalesSingleDetailsListQueryAbilityService.getUocSalesSingleDetailsListQuery(saleDetailsReqBO);
        if (!saleDetailsRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(saleDetailsRspBO.getRespCode(), "\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25:" + saleDetailsRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)saleDetailsRspBO.getRows())) {
            throw new FscBusinessException("194203", "\u672a\u67e5\u8be2\u5230\u9500\u552e\u5355\u4fe1\u606f");
        }
        BigDecimal shouldPayRadio = BigDecimal.ZERO;
        if (((UocPebChildOrderAbilityBO)((UocPebUpperOrderAbilityBO)saleDetailsRspBO.getRows().get(0)).getChildOrderList().get(0)).getProPayType() != null && ((UocPebChildOrderAbilityBO)((UocPebUpperOrderAbilityBO)saleDetailsRspBO.getRows().get(0)).getChildOrderList().get(0)).getProPayType().equals(FscConstants.FscPayType.FSC_PAY_TYPE_STAGE) && !CollectionUtils.isEmpty((Collection)((UocPebChildOrderAbilityBO)((UocPebUpperOrderAbilityBO)saleDetailsRspBO.getRows().get(0)).getChildOrderList().get(0)).getProPayList())) {
            List proPayList = ((UocPebChildOrderAbilityBO)((UocPebUpperOrderAbilityBO)saleDetailsRspBO.getRows().get(0)).getChildOrderList().get(0)).getProPayList();
            for (UocPhasePayListBO uocPhasePayListBO : proPayList) {
                if (!uocPhasePayListBO.getPayType().equals(FscConstants.PaymentMethod.SHOULD_PAY) && !uocPhasePayListBO.getPayType().equals(FscConstants.PaymentMethod.DEPOSIT)) continue;
                shouldPayRadio = shouldPayRadio.add(uocPhasePayListBO.getNodePayRatio());
            }
        }
        if (shouldPayRadio.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        if (orderPO.getSettleType() != null && orderPO.getSettleType().equals(FscConstants.SettleType.ORDER)) {
            shouldPayRadio = BigDecimal.ONE;
        }
        BigDecimal shouldPayAmount = orderPO.getTotalCharge().multiply(shouldPayRadio).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP);
        BigDecimal shouldWriteOffAmount = orderPO.getTotalCharge().subtract(shouldPayAmount).setScale(2, RoundingMode.HALF_UP);
        if (writeOffAmt.compareTo(shouldWriteOffAmount) > 0) {
            throw new FscBusinessException("198888", "\u6838\u9500\u91d1\u989d[" + writeOffAmt + "]\u4e0d\u80fd\u5927\u4e8e\u7ed3\u7b97\u9884\u4ed8\u6bd4\u4f8b\u91d1\u989d[" + shouldWriteOffAmount + "]\u3002");
        }
    }

    private void insertAttachment(List<AttachmentBO> attachmentBOList, Long fscOrderId) {
        if (!CollectionUtils.isEmpty(attachmentBOList)) {
            FscAttachmentPO deletPo = new FscAttachmentPO();
            deletPo.setFscOrderId(fscOrderId);
            deletPo.setObjType(FscConstants.AttachmentObjType.INVOICE_SIGN_APPLY);
            ArrayList<FscAttachmentPO> fscAttachmentPOS = this.fscAttachmentMapper.getList(deletPo);
            if (!CollectionUtils.isEmpty((Collection)fscAttachmentPOS)) {
                this.fscAttachmentMapper.deleteBy(deletPo);
            }
            fscAttachmentPOS = new ArrayList<FscAttachmentPO>();
            for (AttachmentBO attachmentBO : attachmentBOList) {
                FscAttachmentPO fscAttachmentPo = new FscAttachmentPO();
                fscAttachmentPo.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                fscAttachmentPo.setAttachmentUrl(attachmentBO.getAttachmentUrl());
                fscAttachmentPo.setAttachmentName(attachmentBO.getAttachmentName());
                fscAttachmentPo.setAttachmentType(FscConstants.AttachmentType.INVOICE_SIGN_APPLY);
                fscAttachmentPo.setObjId(fscOrderId);
                fscAttachmentPo.setObjType(FscConstants.AttachmentObjType.INVOICE_SIGN_APPLY);
                fscAttachmentPo.setFscOrderId(fscOrderId);
                fscAttachmentPOS.add(fscAttachmentPo);
            }
            this.fscAttachmentMapper.insertBatch(fscAttachmentPOS);
        }
    }

    private void createShouldPay(List<FscShouldPayBO> fscShouldPayBOS, FscBillOrderInvoiceSignApplyBusiReqBO reqBO, String invoiceNo) {
        if (!CollectionUtils.isEmpty(fscShouldPayBOS)) {
            for (FscShouldPayBO fscShouldPayBO : fscShouldPayBOS) {
                fscShouldPayBO.setInvoiceNo(invoiceNo);
                fscShouldPayBO.setOperatorName(reqBO.getName());
                fscShouldPayBO.setOperatorId(reqBO.getUserId());
            }
            FscPayShouldPayCreateAtomReqBO fscPayShouldPayCreateAtomReqBO = new FscPayShouldPayCreateAtomReqBO();
            fscPayShouldPayCreateAtomReqBO.setFscShouldPayBOS(fscShouldPayBOS);
            fscPayShouldPayCreateAtomReqBO.setUserId(reqBO.getUserId());
            fscPayShouldPayCreateAtomReqBO.setName(reqBO.getName());
            fscPayShouldPayCreateAtomReqBO.setUserName(reqBO.getUserName());
            fscPayShouldPayCreateAtomReqBO.setCompanyId(reqBO.getCompanyId());
            fscPayShouldPayCreateAtomReqBO.setCompanyName(reqBO.getCompanyName());
            fscPayShouldPayCreateAtomReqBO.setOrgId(reqBO.getOrgId());
            fscPayShouldPayCreateAtomReqBO.setOrgName(reqBO.getOrgName());
            List acceptOrderCodes = this.fscShouldPayMapper.selectAcceptOrderCode(reqBO.getOrderId());
            String acceptOrderCode = Joiner.on((String)",").join((Iterable)acceptOrderCodes);
            for (FscShouldPayBO bo : fscShouldPayBOS) {
                bo.setAcceptOrderCode(acceptOrderCode);
            }
            FscPayShouldPayCreateAtomRspBO fscPayShouldPayCreateAtomRspBO = this.fscPayShouldPayCreateAtomService.dealShouldPayCreate(fscPayShouldPayCreateAtomReqBO);
            if (!"0000".equals(fscPayShouldPayCreateAtomRspBO.getRespCode())) {
                throw new FscBusinessException("193011", fscPayShouldPayCreateAtomRspBO.getRespDesc());
            }
        }
    }

    private void checkAmtTax(List<FscInvoicePO> invoicePOList, Long orderId) {
        FscOrderItemPO orderItemPO = this.fscOrderItemMapper.getSumAmt(orderId);
        if (Objects.nonNull(orderItemPO)) {
            BigDecimal taxAmt = orderItemPO.getTaxAmt();
            BigDecimal unAmt = orderItemPO.getAmt().subtract(orderItemPO.getTaxAmt());
            BigDecimal ivTaxAmt = invoicePOList.stream().map(FscInvoicePO::getTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal ivUnAmt = invoicePOList.stream().map(FscInvoicePO::getUntaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (taxAmt.compareTo(ivTaxAmt) != 0 || unAmt.compareTo(ivUnAmt) != 0) {
                FscOrderItemPO itemPO = new FscOrderItemPO();
                itemPO.setFscOrderId(orderId);
                itemPO.setTaxAmt(taxAmt.subtract(ivTaxAmt));
                itemPO.setUntaxAmt(unAmt.subtract(ivUnAmt));
                this.fscOrderItemMapper.updateFscOrderItemTax(itemPO);
            }
        }
    }

    private void checkExistProcess(Long fscOrderId) {
        int count = this.fscOrderMapper.selectStepIdCount(fscOrderId, FscConstants.AuditObjType.ORDER_APPROVAL);
        if (count > 0) {
            throw new FscBusinessException("191019", "\u8be5\u5355\u636e\u5df2\u63d0\u4ea4\u5ba1\u6279");
        }
    }
}

