/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.busi.api.FscBillUnifyRejectBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillUnifyRejectBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillUnifyRejectBusiRspBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountChargeMapper;
import com.tydic.fsc.dao.FscOrderExtMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscPurchasePushLogMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountChargePO;
import com.tydic.fsc.po.FscOrderExtPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscPurchasePushLogPo;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscBillUnifyRejectBusiServiceImpl
implements FscBillUnifyRejectBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillUnifyRejectBusiServiceImpl.class);
    @Autowired
    private FscOrderExtMapper fscOrderExtMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscPurchasePushLogMapper fscPurchasePushLogMapper;
    @Autowired
    private FscAccountChargeMapper fscAccountChargeMapper;

    @Override
    public FscBillUnifyRejectBusiRspBO dealUnifyReject(FscBillUnifyRejectBusiReqBO reqBO) {
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getOrderId());
        fscOrderPO.setOrderNo(reqBO.getOrderNo());
        FscOrderPO orderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (orderPO == null) {
            return this.dealChargeInfo(reqBO);
        }
        if (!FscConstants.FscInvoiceOrderState.TY_BUSI_AUDIT.equals(orderPO.getOrderState()) && !FscConstants.FscInvoiceOrderState.TY_FINA_AUDIT.equals(orderPO.getOrderState())) {
            throw new FscBusinessException("190000", "\u5728\u4e1a\u52a1\u5ba1\u6279\u4e2d\u6216\u8d22\u52a1\u5ba1\u6279\u4e2d\u624d\u80fd\u9a73\u56de\uff01");
        }
        FscOrderExtPO fscOrderExtPO = new FscOrderExtPO();
        fscOrderExtPO.setFscOrderId(reqBO.getOrderId());
        fscOrderExtPO.setRejectTime(reqBO.getRejectTime());
        fscOrderExtPO.setRejectCause(reqBO.getRejectCause());
        fscOrderExtPO.setUnifyPushStatus(FscConstants.pushState.NO_PUSH);
        this.fscOrderExtMapper.updateById(fscOrderExtPO);
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setOrderId(orderPO.getFscOrderId());
        fscOrderStatusFlowAtomReqBO.setCurStatus(orderPO.getOrderState());
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("auditResult", FscConstants.AuditResultFlagKey.REFUSE);
        fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        log.debug("\u7edf\u4e00\u7ed3\u7b97\u9a73\u56de\u72b6\u6001\u6d41\u8f6c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscOrderStatusFlowAtomReqBO));
        FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
        log.debug("\u7edf\u4e00\u7ed3\u7b97\u9a73\u56de\u72b6\u6001\u6d41\u8f6c\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscOrderStatusFlowAtomRspBO));
        if (!"0000".equals(fscOrderStatusFlowAtomRspBO.getRespCode())) {
            throw new FscBusinessException("190000", fscOrderStatusFlowAtomRspBO.getRespDesc());
        }
        this.saveLog(reqBO.getOrderId(), reqBO.getOrderNo(), JSON.toJSONString((Object)reqBO));
        FscBillUnifyRejectBusiRspBO rspBO = new FscBillUnifyRejectBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private FscBillUnifyRejectBusiRspBO dealChargeInfo(FscBillUnifyRejectBusiReqBO reqBO) {
        FscAccountChargePO chargePO = new FscAccountChargePO();
        chargePO.setAdvanceDepositNo(reqBO.getOrderNo());
        chargePO.setChargeId(reqBO.getOrderId());
        chargePO = this.fscAccountChargeMapper.getModelBy(chargePO);
        if (chargePO == null) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u5355\u636e\u4fe1\u606f");
        }
        chargePO.setAuditStatus(FscConstants.AuditStatus.AUDIT_REJECT);
        this.fscAccountChargeMapper.updateAuditStatusById(chargePO);
        FscBillUnifyRejectBusiRspBO rspBO = new FscBillUnifyRejectBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void saveLog(Long objectId, String objectNo, String pushData) {
        FscPurchasePushLogPo purchasePushLogPo = new FscPurchasePushLogPo();
        purchasePushLogPo.setObjectId(objectId);
        purchasePushLogPo.setObjectNo(objectNo);
        purchasePushLogPo.setCreateTime(new Date());
        purchasePushLogPo.setType(FscConstants.FscPurchasePushType.ORDER_REJECT);
        purchasePushLogPo.setPushData(pushData);
        purchasePushLogPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
        this.fscPurchasePushLogMapper.insert(purchasePushLogPo);
    }
}

