/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.excel.util.StringUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.busi.api.FscBillAddPushLogBusiService;
import com.tydic.fsc.bill.busi.api.FscPayBillDeleteBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillAddPushLogBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscPayBillDeleteBusiReqBo;
import com.tydic.fsc.bill.busi.bo.FscPayBillDeleteBusiRspBo;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscDraftReleaseOccReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleFundingPlanReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleFundingPlanRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscDraftReleaseOccService;
import com.tydic.fsc.busibase.external.api.esb.FscUnifySettleRelatedInterfacesAtomService;
import com.tydic.fsc.common.ability.api.FscUnifySettleTokenAbilityService;
import com.tydic.fsc.common.ability.bo.QryUnifySettleTokenAbilityReqBO;
import com.tydic.fsc.common.ability.bo.QryUnifySettleTokenAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscDraftInfoMapper;
import com.tydic.fsc.dao.FscOperateCapitalPlanMapper;
import com.tydic.fsc.dao.FscOrderExtMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayDetailMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscOrderPaymentDetailMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscDraftInfoPO;
import com.tydic.fsc.po.FscOperateCapitalPlanPO;
import com.tydic.fsc.po.FscOrderExtPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayDetailPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.uoc.common.ability.api.PebExtOrderSettleTypeUpdateAbilityService;
import com.tydic.uoc.common.ability.api.PebExtUnifySettlePersonQryAbilityService;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscPayBillDeleteBusiServiceImpl
implements FscPayBillDeleteBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscPayBillDeleteBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Resource
    private FscOrderPayDetailMapper fscOrderPayDetailMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private PebExtOrderSettleTypeUpdateAbilityService pebExtOrderSettleTypeUpdateAbilityService;
    @Autowired
    private FscDraftReleaseOccService draftReleaseOccService;
    @Autowired
    private FscDraftInfoMapper fscDraftInfoMapper;
    @Autowired
    private FscOperateCapitalPlanMapper fscOperateCapitalPlanMapper;
    @Autowired
    private FscUnifySettleRelatedInterfacesAtomService fscUnifySettleRelatedInterfacesAtomService;
    @Autowired
    private PebExtUnifySettlePersonQryAbilityService pebExtUnifySettlePersonQryAbilityService;
    @Autowired
    private FscUnifySettleTokenAbilityService fscUnifySettleTokenAbilityService;
    @Autowired
    private FscOrderExtMapper fscOrderExtMapper;
    @Autowired
    private FscBillAddPushLogBusiService fscBillAddPushLogBusiService;
    @Resource
    private FscOrderPaymentDetailMapper fscOrderPaymentDetailMapper;
    public static final String BUSI_NAME = "\u652f\u4ed8\u5355\u5220\u9664";
    public static final String BUSI_CODE = "1199";

    @Override
    public FscPayBillDeleteBusiRspBo payBillDelete(FscPayBillDeleteBusiReqBo reqBo) {
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBo.getOrderId());
        FscOrderPO fscOrder = this.fscOrderMapper.getModelBy(fscOrderPo);
        this.var(fscOrder, reqBo.getChFdFlag());
        if (!StringUtils.isEmpty((Object)fscOrder.getOrderFlowKey()) && reqBo.getChFdFlag().booleanValue()) {
            HashMap<String, Integer> paramMap = new HashMap<String, Integer>(4);
            paramMap.put("cancelFlag", FscConstants.BillOrderCancelFlag.DELETE_ORDER);
            FscOrderStatusFlowAtomReqBO flowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
            flowAtomReqBO.setOrderId(reqBo.getOrderId());
            flowAtomReqBO.setCurStatus(fscOrder.getOrderState());
            flowAtomReqBO.setBusiName(BUSI_NAME);
            flowAtomReqBO.setBusiCode(BUSI_CODE);
            flowAtomReqBO.setParamMap(paramMap);
            FscOrderStatusFlowAtomRspBO flowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(flowAtomReqBO);
            if (!"0000".equals(flowAtomRspBO.getRespCode())) {
                throw new FscBusinessException("193108", flowAtomRspBO.getRespDesc());
            }
        } else {
            fscOrder.setOrderState(Integer.valueOf(reqBo.getChFdFlag() != false ? 1000 : 1199));
            this.fscOrderMapper.updateById(fscOrder);
        }
        this.paymentRejectionProcess(fscOrder, reqBo.getIsprofess());
        FscOrderPayDetailPO fscOrderPayDetailPO = new FscOrderPayDetailPO();
        fscOrderPayDetailPO.setFscOrderId(reqBo.getOrderId());
        this.fscOrderPayDetailMapper.deleteByFscOrderId(fscOrderPayDetailPO);
        this.fscOrderPaymentDetailMapper.deleteByPayOrderId(reqBo.getOrderId());
        this.fscShouldPayMapper.updateRefundAmountByPayItem(reqBo.getOrderId());
        this.deleteDraft(fscOrder, reqBo);
        FscPayBillDeleteBusiRspBo rspBo = new FscPayBillDeleteBusiRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void var(FscOrderPO fscOrder, Boolean chFdFlag) {
        if (fscOrder == null) {
            throw new FscBusinessException("198888", "\u672a\u627e\u5230\u4ed8\u6b3e\u7533\u8bf7\u5355\u4fe1\u606f");
        }
        if (!FscConstants.FscPayOrderState.CANCEL.equals(fscOrder.getOrderState()) && chFdFlag.booleanValue()) {
            throw new FscBusinessException("198888", "\u53ea\u6709\u5ba1\u6279\u9a73\u56de\u72b6\u6001\u4e0b\u624d\u80fd\u5220\u9664");
        }
        if (!FscConstants.OrderFlow.PAY.equals(fscOrder.getOrderFlow())) {
            throw new FscBusinessException("198888", "\u672a\u627e\u5230\u8be5\u4ed8\u6b3e\u7533\u8bf7\u5355");
        }
    }

    private void paymentRejectionProcess(FscOrderPO reqBO, String isProfess) {
        FscOrderPayItemPO fscOrderPayItemPo = new FscOrderPayItemPO();
        fscOrderPayItemPo.setFscOrderId(reqBO.getFscOrderId());
        List fscOrderPayItemPos = this.fscOrderPayItemMapper.getList(fscOrderPayItemPo);
        for (FscOrderPayItemPO orderPayItemPo : fscOrderPayItemPos) {
            int n = this.fscShouldPayMapper.updatePayingAmt(orderPayItemPo.getShouldPayId(), orderPayItemPo.getPayAmount());
        }
    }

    private void deleteDraft(FscOrderPO fscOrder, FscPayBillDeleteBusiReqBo reqBo) {
        FscDraftInfoPO infoPO = new FscDraftInfoPO();
        infoPO.setFscOrderId(fscOrder.getFscOrderId());
        List infoPOS = this.fscDraftInfoMapper.selectList(infoPO);
        if (CollectionUtils.isEmpty((Collection)infoPOS)) {
            return;
        }
        this.fscDraftInfoMapper.deleteList(infoPO);
        FscDraftReleaseOccReqBO occReqBO = new FscDraftReleaseOccReqBO();
        occReqBO.setType("2");
        occReqBO.setYcUserId(fscOrder.getYcUserId());
        occReqBO.setDraftList(infoPOS.stream().map(FscDraftInfoPO::getDraftId).collect(Collectors.toList()));
        occReqBO.setAgentAccount(reqBo.getAgentAccount());
        occReqBO.setBillNum(fscOrder.getOrderNo());
        this.draftReleaseOccService.draftReleaseOcc(occReqBO);
    }

    private void releasePlan(Long fscOrderId) {
        FscBillAddPushLogBusiReqBO logBusiReqBO;
        block8: {
            List list = this.fscOperateCapitalPlanMapper.getListByFscOrderId(fscOrderId);
            if (CollectionUtils.isEmpty((Collection)list)) {
                return;
            }
            logBusiReqBO = new FscBillAddPushLogBusiReqBO();
            logBusiReqBO.setPushStatus(0);
            logBusiReqBO.setObjectId(fscOrderId);
            logBusiReqBO.setCreateTime(new Date());
            logBusiReqBO.setType(FscConstants.FscPushType.FSC_NEW_OCCUPY_PLAN);
            FscOrderExtPO orderExtPO = new FscOrderExtPO();
            orderExtPO.setFscOrderId(fscOrderId);
            orderExtPO = this.fscOrderExtMapper.getModelBy(orderExtPO);
            try {
                QryUnifySettleTokenAbilityReqBO qryUnifySettleTokenReqBO = new QryUnifySettleTokenAbilityReqBO();
                qryUnifySettleTokenReqBO.setUserId(orderExtPO.getAgentAccount());
                QryUnifySettleTokenAbilityRspBO qryUnifySettleTokenAbilityRspBO = this.fscUnifySettleTokenAbilityService.qryToken(qryUnifySettleTokenReqBO);
                if (!qryUnifySettleTokenAbilityRspBO.getRespCode().equals("0000")) {
                    throw new FscBusinessException(qryUnifySettleTokenAbilityRspBO.getRespCode(), "\u83b7\u53d6\u7edf\u4e00\u7ed3\u7b97\u7528\u6237token\u4fe1\u606f\u5931\u8d25\uff1a" + qryUnifySettleTokenAbilityRspBO.getMsg());
                }
                FscOrderPO fscOrderPO = new FscOrderPO();
                fscOrderPO.setFscOrderId(fscOrderId);
                FscOrderPO fscOrder = this.fscOrderMapper.getModelBy(fscOrderPO);
                logBusiReqBO.setObjectNo(fscOrder.getOrderNo());
                FscUnifySettleFundingPlanReqBO planReqBO = new FscUnifySettleFundingPlanReqBO();
                JSONObject jsonObject = new JSONObject();
                JSONArray jsonArray = new JSONArray();
                for (FscOperateCapitalPlanPO x : list) {
                    JSONObject bo = new JSONObject();
                    bo.put("period", (Object)x.getPeriod());
                    bo.put("itemId", (Object)x.getItemId());
                    bo.put("itemName", (Object)x.getItemName());
                    bo.put("controlMode", (Object)x.getControlMode());
                    bo.put("exeType", (Object)"RZY");
                    if (x.getPlanAmount() != null) {
                        bo.put("planAmount", (Object)x.getPlanAmount().negate());
                    }
                    bo.put("amount", (Object)x.getUseAmount().negate());
                    bo.put("fromSource", (Object)"EBAY");
                    bo.put("contractNum", (Object)x.getContractNum());
                    if ("BILL".equals(x.getControlMode())) {
                        bo.put("billId", (Object)fscOrderId);
                        bo.put("billNum", (Object)fscOrder.getOrderNo());
                    }
                    bo.put("recOrgName", (Object)fscOrder.getPayeeName());
                    bo.put("fromBillId", (Object)(fscOrderId + ""));
                    bo.put("fromBillLineId", (Object)x.getId());
                    bo.put("deptId", (Object)x.getDeptId());
                    bo.put("deptName", (Object)x.getDeptName());
                    bo.put("orgId", x.getOrgId() != null ? x.getOrgId() : orderExtPO.getUnifyOrgId());
                    bo.put("billType", (Object)("YFK".equals(x.getBillType()) ? "YFK" : "HTJS"));
                    bo.put("fromBillType", (Object)("YFK".equals(x.getBillType()) ? "YFK" : "FK"));
                    jsonArray.add((Object)bo);
                }
                jsonObject.put("head", (Object)jsonArray);
                JSONArray jsonArray1 = new JSONArray();
                jsonArray1.add((Object)jsonObject);
                logBusiReqBO.setPushData(jsonArray1.toJSONString());
                planReqBO.setJsonObject(jsonArray1);
                planReqBO.setToken(qryUnifySettleTokenAbilityRspBO.getData());
                FscUnifySettleFundingPlanRspBO fundingPlanRspBO = this.fscUnifySettleRelatedInterfacesAtomService.occupyFundsEabyUpdateState(planReqBO);
                logBusiReqBO.setPushParseData(fundingPlanRspBO.getPushParseData());
                logBusiReqBO.setRespData(fundingPlanRspBO.getRespData());
                logBusiReqBO.setRespParseData(fundingPlanRspBO.getRespParseData());
                if (!"0000".equals(fundingPlanRspBO.getRespCode())) {
                    throw new FscBusinessException("190000", "\u5360\u7528/\u91ca\u653e\u8d44\u91d1\u8ba1\u5212\u5931\u8d25" + fundingPlanRspBO.getRespDesc());
                }
                logBusiReqBO.setPushStatus(1);
            }
            catch (Exception e) {
                log.error("\u63a8\u9001\u8d44\u91d1\u8ba1\u5212\u5360\u7528/\u91ca\u653e\u63a5\u53e3\u5931\u8d25,\u7ed3\u7b97\u5355id{},\u5165\u53c2{}", (Object)fscOrderId, (Object)e.getMessage());
                if (logBusiReqBO.getRespData() != null) break block8;
                logBusiReqBO.setRespData(e.getMessage());
            }
        }
        this.fscBillAddPushLogBusiService.addPurchasePushLog(logBusiReqBO);
    }
}

