/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.ability.api.FscBillOrderRefundUpdateAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillOrderRefundCreateInvoiceBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderRefundUpdateAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderRefundUpdateAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillOrderRefundUpdateBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderRefundUpdateBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderRefundUpdateBusiRspBO;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.common.ability.api.FscComInvoiceSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComInvoiceListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscOrderSourceEnum;
import com.tydic.fsc.dao.FscClaimDetailChangeMapper;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscInvoiceItemMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscInvoiceRefundRelationMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscClaimDetailChangePO;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscInvoiceItemPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscInvoiceRefundRelationPO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.util.FscIdempotentCommitLimit;
import com.tydic.uoc.common.ability.api.PebExtUpdateAbnormalRefundFlagAbilityService;
import com.tydic.uoc.common.ability.api.UocAbnormalSingleDetailsListQueryAbilityService;
import com.tydic.uoc.common.ability.bo.UocAbnormalSingleDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocAbnormalSingleDetailsListQueryRspBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdShipAbnormalBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillOrderRefundUpdateAbilityService"})
public class FscBillOrderRefundUpdateAbilityServiceImpl
implements FscBillOrderRefundUpdateAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderRefundUpdateAbilityServiceImpl.class);
    @Autowired
    private FscBillOrderRefundUpdateBusiService fscBillOrderRefundUpdateBusiService;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscInvoiceRefundRelationMapper fscInvoiceRefundRelationMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;
    @Autowired
    private FscComInvoiceSyncAbilityService fscComInvoiceSyncAbilityService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private UocAbnormalSingleDetailsListQueryAbilityService uocAbnormalSingleDetailsListQueryAbilityService;
    @Autowired
    private PebExtUpdateAbnormalRefundFlagAbilityService pebExtUpdateAbnormalRefundFlagAbilityService;
    private static final Integer ABNORMAL_ALL_TAB_ID = 41001;
    private static final String ABNORMAL_STATE_TWO = "2";
    private static final String ABNORMAL_STATE_THREE = "3";
    private static final Integer ABNORMAL_PAGE_SIZE = 300;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscInvoiceItemMapper fscInvoiceItemMapper;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Value(value="${OPERATION_SUP_ID:1001693}")
    private String operationSupId;
    @Autowired
    private FscClaimDetailChangeMapper fscClaimDetailChangeMapper;

    @FscIdempotentCommitLimit(lockKey="refundId")
    @PostMapping(value={"dealRefundUpdate"})
    public FscBillOrderRefundUpdateAbilityRspBO dealRefundUpdate(@RequestBody FscBillOrderRefundUpdateAbilityReqBO reqBO) {
        FscBillOrderRefundUpdateBusiRspBO busiRspBO;
        this.valid(reqBO);
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getRefundId());
        refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
        if (refundPO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u9000\u7968\u5355\u76f8\u5173\u4fe1\u606f\uff01");
        }
        if (!(refundPO.getRefundStatus().equals(FscConstants.RefundInvoiceStatus.SAVE) || refundPO.getRefundStatus().equals(FscConstants.RefundInvoiceStatus.REFUND_BACK) || refundPO.getRefundStatus().equals(FscConstants.RefundInvoiceStatus.APPROVAL_REJECT))) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u9000\u7968\u5355\u636e\u72b6\u6001\u4e0d\u5141\u8bb8\u4fee\u6539\uff01");
        }
        reqBO.setFscOrderId(refundPO.getFscOrderId());
        if (reqBO.getFscOrderId() == null) {
            throw new FscBusinessException("198888", "\u7ed3\u7b97id\u4e3a\u7a7a\uff01");
        }
        this.checkFscClaim(reqBO, refundPO.getFscOrderId(), refundPO);
        String reqString = JSONObject.toJSONString((Object)reqBO);
        FscBillOrderRefundUpdateBusiReqBO busiReqBO = (FscBillOrderRefundUpdateBusiReqBO)((Object)JSONObject.parseObject((String)reqString, FscBillOrderRefundUpdateBusiReqBO.class));
        if (!CollectionUtils.isEmpty((Collection)reqBO.getFileList())) {
            List<FscAttachmentPO> fileList = this.buildFileInfo(reqBO, refundPO);
            busiReqBO.setFileList(fileList);
        }
        if (!(busiRspBO = this.fscBillOrderRefundUpdateBusiService.dealRefundUpdate(busiReqBO)).getRespCode().equals("0000")) {
            throw new FscBusinessException(busiRspBO.getRespCode(), "\u9000\u7968\u4e3b\u5355\u4fee\u6539\u5931\u8d25:" + busiRspBO.getRespDesc());
        }
        this.sendMq(refundPO);
        return (FscBillOrderRefundUpdateAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), FscBillOrderRefundUpdateAbilityRspBO.class);
    }

    private List<FscAttachmentPO> buildFileInfo(FscBillOrderRefundUpdateAbilityReqBO reqBO, FscOrderRefundPO refundPO) {
        ArrayList<FscAttachmentPO> fileList = new ArrayList<FscAttachmentPO>();
        Date now = new Date();
        for (AttachmentBO attachmentBO : reqBO.getFileList()) {
            FscAttachmentPO attachmentPO = new FscAttachmentPO();
            attachmentPO.setObjId(refundPO.getRefundId());
            attachmentPO.setAttachmentType(FscConstants.AttachmentType.REFUND_INVOICE);
            attachmentPO.setObjType(FscConstants.AttachmentObjType.REFUND_INVOICE);
            attachmentPO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
            attachmentPO.setAttachmentName(attachmentBO.getAttachmentName());
            attachmentPO.setAttachmentUrl(attachmentBO.getAttachmentUrl());
            attachmentPO.setCreateTime(now);
            attachmentPO.setCreateUser(reqBO.getName());
            attachmentPO.setCreateUserId(reqBO.getUserId());
            fileList.add(attachmentPO);
        }
        return fileList;
    }

    private List<FscOrderRelationPO> buildOrderInfo(FscBillOrderRefundUpdateAbilityReqBO reqBO, FscOrderRefundPO refundPO) {
        List<Object> orderList = new ArrayList<FscOrderRelationPO>();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getAcceptOrderIds())) {
            FscOrderRelationPO orderRelationPO = new FscOrderRelationPO();
            orderRelationPO.setFscOrderId(refundPO.getFscOrderId());
            orderRelationPO.setAcceptOrderIds(reqBO.getAcceptOrderIds());
            orderList = this.fscOrderRelationMapper.getListNoPage(orderRelationPO);
            for (FscOrderRelationPO fscOrderRelationPO : orderList) {
                fscOrderRelationPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                fscOrderRelationPO.setFscOrderId(null);
                fscOrderRelationPO.setRefundId(refundPO.getRefundId());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getAbnormalIds())) {
            UocAbnormalSingleDetailsListQueryReqBO detailsListQueryReqBO = new UocAbnormalSingleDetailsListQueryReqBO();
            detailsListQueryReqBO.setAbnormalVoucherIds(reqBO.getAbnormalIds());
            orderList = this.buildAbnormalOrderInfo(refundPO, detailsListQueryReqBO);
        }
        return orderList;
    }

    private List<FscInvoiceRefundRelationPO> buildInvoiceInfo(List<Long> invoiceIds, FscOrderRefundPO refundPO) {
        ArrayList<FscInvoiceRefundRelationPO> refundInvoiceList = new ArrayList<FscInvoiceRefundRelationPO>(invoiceIds.size());
        FscInvoicePO fscInvoicePO = new FscInvoicePO();
        fscInvoicePO.setInvoiceIds(invoiceIds);
        fscInvoicePO.setFscOrderId(refundPO.getFscOrderId());
        List list = this.fscInvoiceMapper.getList(fscInvoicePO);
        for (FscInvoicePO invoicePO : list) {
            FscInvoiceRefundRelationPO refundRelationPO = new FscInvoiceRefundRelationPO();
            refundRelationPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            refundRelationPO.setRefundId(refundPO.getRefundId());
            refundRelationPO.setCreateTime(new Date());
            refundRelationPO.setInvoiceId(invoicePO.getInvoiceId());
            refundRelationPO.setFscOrderId(refundPO.getFscOrderId());
            refundRelationPO.setAmt(invoicePO.getAmt());
            refundInvoiceList.add(refundRelationPO);
        }
        return refundInvoiceList;
    }

    private void sendMq(FscOrderRefundPO refundPO) {
        FscComRefundSyncAbilityReqBO syncAbilityReqBO = new FscComRefundSyncAbilityReqBO();
        syncAbilityReqBO.setRefundIds(Collections.singletonList(refundPO.getRefundId()));
        this.fscComRefundSyncAbilityService.syncRefund(syncAbilityReqBO);
        FscComInvoiceListSyncAbilityReqBO fscComInvoiceListSyncAbilityReqBO = new FscComInvoiceListSyncAbilityReqBO();
        fscComInvoiceListSyncAbilityReqBO.setFscOrderId(refundPO.getFscOrderId());
        this.fscComInvoiceSyncAbilityService.dealComOrderSyncEs(fscComInvoiceListSyncAbilityReqBO);
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(refundPO.getFscOrderId());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }

    private void dealRefundType(FscBillOrderRefundUpdateBusiReqBO reqBO, FscOrderRefundPO refundPO) {
        boolean changeFlag = false;
        if (reqBO.getRefundReasonType().equals(FscConstants.RefundReasonType.ORDER_REFUND) || refundPO.getRefundReasonType().equals(FscConstants.RefundReasonType.ORDER_REFUND)) {
            changeFlag = true;
            FscInvoiceRefundRelationPO invoiceRelationPO = new FscInvoiceRefundRelationPO();
            invoiceRelationPO.setRefundId(refundPO.getRefundId());
            List invoiceRefundRelationList = this.fscInvoiceRefundRelationMapper.getList(invoiceRelationPO);
            List<Long> delInvoiceIds = invoiceRefundRelationList.stream().map(FscInvoiceRefundRelationPO::getInvoiceId).collect(Collectors.toList());
            reqBO.setDelInvoiceIds(delInvoiceIds);
            FscOrderRelationPO orderRelationPO = new FscOrderRelationPO();
            orderRelationPO.setRefundId(refundPO.getRefundId());
            List orderRelationList = this.fscOrderRelationMapper.getListNoPage(orderRelationPO);
            List<Long> delAcceptOrderIds = orderRelationList.stream().map(FscOrderRelationPO::getAcceptOrderId).collect(Collectors.toList());
            reqBO.setDelAcceptOrderIds(delAcceptOrderIds);
        }
        if (changeFlag) {
            if (CollectionUtils.isEmpty(reqBO.getInvoiceIds())) {
                List<FscInvoiceRefundRelationPO> invoiceList = this.buildInvoiceInfo(new ArrayList<Long>(), refundPO);
                List<Long> invoiceIds = invoiceList.stream().map(FscInvoiceRefundRelationPO::getInvoiceId).collect(Collectors.toList());
                reqBO.setInvoiceIds(invoiceIds);
                reqBO.setInvoiceList(invoiceList);
            }
            if (reqBO.getRefundReasonType().equals(FscConstants.RefundReasonType.ORDER_REFUND) && CollectionUtils.isEmpty(reqBO.getAbnormalIds())) {
                FscOrderPO orderPO = new FscOrderPO();
                orderPO.setFscOrderId(refundPO.getFscOrderId());
                orderPO = this.fscOrderMapper.getModelBy(orderPO);
                FscOrderRelationPO relationPO = new FscOrderRelationPO();
                relationPO.setFscOrderId(reqBO.getFscOrderId());
                List list = this.fscOrderRelationMapper.getList(relationPO);
                if (CollectionUtils.isEmpty((Collection)list)) {
                    throw new FscBusinessException("198888", "\u67e5\u8be2\u5f00\u7968\u5173\u8054\u4fe1\u606f\u4e3a\u7a7a\uff01");
                }
                UocAbnormalSingleDetailsListQueryReqBO abnormalReqBO = new UocAbnormalSingleDetailsListQueryReqBO();
                if (orderPO.getSettleType().equals(FscConstants.SettleType.ORDER)) {
                    List orderCodeList = list.stream().map(FscOrderRelationPO::getOrderNo).collect(Collectors.toList());
                    abnormalReqBO.setSaleVoucherNoList(orderCodeList);
                } else {
                    List acceptOrderIds = list.stream().map(FscOrderRelationPO::getAcceptOrderId).collect(Collectors.toList());
                    abnormalReqBO.setInspectionVoucherIds(acceptOrderIds);
                }
                reqBO.setOrderList(this.buildAbnormalOrderInfo(refundPO, abnormalReqBO));
            } else if (!reqBO.getRefundReasonType().equals(FscConstants.RefundReasonType.ORDER_REFUND) && CollectionUtils.isEmpty(reqBO.getAcceptOrderIds())) {
                FscOrderRelationPO relationPO = new FscOrderRelationPO();
                relationPO.setFscOrderId(refundPO.getFscOrderId());
                List listNoPage = this.fscOrderRelationMapper.getListNoPage(relationPO);
                for (FscOrderRelationPO orderRelationPO : listNoPage) {
                    orderRelationPO.setFscOrderId(null);
                    orderRelationPO.setRefundId(refundPO.getRefundId());
                    orderRelationPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                }
                reqBO.setOrderList(listNoPage);
            }
        }
    }

    private void valid(FscBillOrderRefundUpdateAbilityReqBO reqBO) {
        if (reqBO.getRefundId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getOperationType() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[operationType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getCertification() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[certification]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getRefundReasonType())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundReasonType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getRefundReason())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundReason]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getRefundNote())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundNote]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getInvoiceBOS())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[invoiceBOS]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        HashSet<Long> invoiceIdSet = new HashSet<Long>();
        ArrayList beforeRelationPOS = new ArrayList();
        FscInvoiceRefundRelationPO searchRefundRelationPO = new FscInvoiceRefundRelationPO();
        searchRefundRelationPO.setRefundId(reqBO.getRefundId());
        List fscInvoiceRefundRelationPOS = this.fscInvoiceRefundRelationMapper.getList(searchRefundRelationPO);
        if (!CollectionUtils.isEmpty((Collection)fscInvoiceRefundRelationPOS)) {
            beforeRelationPOS.addAll(fscInvoiceRefundRelationPOS);
        }
        Map<Long, FscInvoiceRefundRelationPO> beforeInvoiceIdRelationMap = beforeRelationPOS.stream().collect(Collectors.toMap(FscInvoiceRefundRelationPO::getInvoiceId, o -> o));
        for (FscBillOrderRefundCreateInvoiceBO invoiceBO : reqBO.getInvoiceBOS()) {
            if (invoiceBO.getInvoiceId() == null) {
                throw new FscBusinessException("198888", "\u5165\u53c2[\u53d1\u7968Id]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (invoiceBO.getRefundAmt().compareTo(BigDecimal.ZERO) <= 0) {
                throw new FscBusinessException("198888", "\u5165\u53c2[\u9000\u7968\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (invoiceBO.getType() == null) {
                throw new FscBusinessException("198888", "\u5165\u53c2[\u53d1\u7968\u64cd\u4f5c\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!(FscConstants.refundUpdateType.ADD.equals(invoiceBO.getType()) || FscConstants.refundUpdateType.UPDATE.equals(invoiceBO.getType()) || FscConstants.refundUpdateType.DELETE.equals(invoiceBO.getType()))) {
                throw new FscBusinessException("198888", "\u5165\u53c2[\u53d1\u7968\u64cd\u4f5c\u7c7b\u578b]\u679a\u4e3e\u503c\u9519\u8bef\uff01");
            }
            if (FscConstants.refundUpdateType.ADD.equals(invoiceBO.getType()) && beforeInvoiceIdRelationMap.containsKey(invoiceBO.getInvoiceId())) {
                throw new FscBusinessException("198888", "\u53d1\u7968id" + invoiceBO.getInvoiceId() + "\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u6dfb\u52a0\u91cd\u590d\u7684\u53d1\u7968\u4fe1\u606f\uff01");
            }
            if (FscConstants.refundUpdateType.DELETE.equals(invoiceBO.getType()) && !beforeInvoiceIdRelationMap.containsKey(invoiceBO.getInvoiceId())) {
                throw new FscBusinessException("198888", "\u53d1\u7968id" + invoiceBO.getInvoiceId() + "\u4e0d\u5b58\u5728\uff0c\u8bf7\u52ff\u5220\u9664\u91cd\u590d\u7684\u53d1\u7968\u4fe1\u606f\uff01");
            }
            if (FscConstants.refundUpdateType.UPDATE.equals(invoiceBO.getType())) {
                if (!beforeInvoiceIdRelationMap.containsKey(invoiceBO.getInvoiceId())) {
                    throw new FscBusinessException("198888", "\u53d1\u7968id" + invoiceBO.getInvoiceId() + "\u4e0d\u5b58\u5728\uff0c\u8bf7\u52ff\u4fee\u6539\u53d1\u7968\u4fe1\u606f\uff01");
                }
                FscInvoiceRefundRelationPO beforeInvoice = beforeInvoiceIdRelationMap.get(invoiceBO.getInvoiceId());
                if (beforeInvoice.getRefundAmt() != null) {
                    invoiceBO.setCompareRefundAmt(invoiceBO.getRefundAmt().subtract(beforeInvoice.getRefundAmt()));
                } else {
                    invoiceBO.setCompareRefundAmt(invoiceBO.getRefundAmt());
                }
            }
            invoiceIdSet.add(invoiceBO.getInvoiceId());
        }
        if (invoiceIdSet.size() != reqBO.getInvoiceBOS().size()) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u6709\u91cd\u590d\u7684\u53d1\u7968\u4fe1\u606f\uff01");
        }
        if (reqBO.getOperationDown() != null && reqBO.getOperationDown().equals(FscConstants.OperationDown.YES) && reqBO.getOperationType().equals(FscConstants.RefundOperationType.SUBMIT)) {
            if (reqBO.getYcUserId() == null) {
                throw new FscBusinessException("198888", "\u5165\u53c2[ycUserId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (reqBO.getYcPersonId() == null) {
                throw new FscBusinessException("198888", "\u5165\u53c2[ycPersonId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)reqBO.getYcPersonName())) {
                throw new FscBusinessException("198888", "\u5165\u53c2[ycPersonName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (reqBO.getYcDeptId() == null) {
                throw new FscBusinessException("198888", "\u5165\u53c2[ycDeptId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)reqBO.getYcDeptName())) {
                throw new FscBusinessException("198888", "\u5165\u53c2[ycDeptName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)reqBO.getExt1())) {
                throw new FscBusinessException("198888", "\u5165\u53c2[\u7528\u6237\u7684erp\u8d26\u53f7]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
        if (reqBO.getIsQuality() != null && reqBO.getIsQuality() == 1) {
            if (CollectionUtils.isEmpty((Collection)reqBO.getQualityBOS())) {
                throw new FscBusinessException("198888", "\u5165\u53c2[\u8d28\u4fdd\u91d1\u4fe1\u606f]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!reqBO.getRefundReasonType().equals(FscConstants.RefundReasonType.ORDER_REFUND)) {
                throw new FscBusinessException("198888", "\u9000\u7968\u539f\u56e0\u4e0d\u662f\u9500\u8d27\u9000\u56de\uff0c\u4e0d\u80fd\u9009\u62e9\u8d28\u4fdd\u91d1\u4fe1\u606f");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getQualityBOS())) {
            if (reqBO.getIsQuality() == null || reqBO.getIsQuality() != 1) {
                throw new FscBusinessException("198888", "\u5165\u53c2[\u662f\u5426\u542b\u4e3a\u5426\u65f6\uff0c\u8d28\u4fdd\u91d1\u4fe1\u606f]\u4e0d\u80fd\u975e\u7a7a\uff01");
            }
            if (CollectionUtils.isEmpty((Collection)reqBO.getAbnormalIds())) {
                throw new FscBusinessException("198888", "\u914d\u7f6e\u8d28\u4fdd\u91d1\u8bf7\u9009\u62e9\u5bf9\u5e94\u7684\u5f02\u5e38\u5355");
            }
            BigDecimal qualityAmt = BigDecimal.ZERO;
            HashSet<Long> abnormalIdSet = new HashSet<Long>();
            ArrayList<String> failOrderNos = new ArrayList<String>();
            HashMap<Long, BigDecimal> abnormalIdQualityAmtMap = new HashMap<Long, BigDecimal>();
            for (Object qualityBO : reqBO.getQualityBOS()) {
                if (qualityBO.getAbnormalId() == null) {
                    throw new FscBusinessException("198888", "\u5165\u53c2[qualityBOS.abnormalId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (qualityBO.getOrderNo() == null) {
                    throw new FscBusinessException("198888", "\u5165\u53c2[qualityBOS.orderNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (qualityBO.getQualityAmt() == null) {
                    throw new FscBusinessException("198888", "\u5165\u53c2[qualityBOS.qualityAmt]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (qualityBO.getQualityDate() == null) {
                    throw new FscBusinessException("198888", "\u5165\u53c2[qualityBOS.qualityDate]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!reqBO.getAbnormalIds().contains(qualityBO.getAbnormalId())) {
                    failOrderNos.add(qualityBO.getOrderNo());
                }
                abnormalIdQualityAmtMap.put(qualityBO.getAbnormalId(), qualityBO.getQualityAmt());
                abnormalIdSet.add(qualityBO.getAbnormalId());
                qualityAmt = qualityAmt.add(qualityBO.getQualityAmt());
            }
            if (!CollectionUtils.isEmpty(failOrderNos)) {
                throw new FscBusinessException("198888", "\u914d\u7f6e\u8d28\u4fdd\u91d1\u8bf7\u9009\u62e9\u5bf9\u5e94\u7684\u5f02\u5e38\u5355\uff0c\u7f3a\u5c11\u7684\u7f16\u53f7\uff1a" + failOrderNos);
            }
            BigDecimal refundAmt = BigDecimal.ZERO;
            for (FscBillOrderRefundCreateInvoiceBO invoiceBO : reqBO.getInvoiceBOS()) {
                if (!FscConstants.refundUpdateType.ADD.equals(invoiceBO.getType()) && !FscConstants.refundUpdateType.UPDATE.equals(invoiceBO.getType())) continue;
                refundAmt = refundAmt.add(invoiceBO.getRefundAmt());
            }
            if (qualityAmt.compareTo(refundAmt) > 0) {
                throw new FscBusinessException("198888", "\u8d28\u4fdd\u91d1\u5927\u4e8e\u9000\u7968\u91d1\u989d\uff01");
            }
            FscOrderRefundPO refundPO = new FscOrderRefundPO();
            refundPO.setRefundId(reqBO.getRefundId());
            refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
            if (refundPO == null) {
                throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u9000\u7968\u5355\u76f8\u5173\u4fe1\u606f\uff01");
            }
            BigDecimal forwardRefundQualityAmt = BigDecimal.ZERO;
            FscOrderRelationPO relationPO = new FscOrderRelationPO();
            relationPO.setAbnormalVoucherIds(new ArrayList(abnormalIdSet));
            ArrayList<FscOrderRelationPO> refundRelationPOList = new ArrayList<FscOrderRelationPO>();
            List list = this.fscOrderRelationMapper.getListByOrderIds(relationPO);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                ArrayList<Long> occupiedRefundIds = new ArrayList<Long>();
                Set refundIdSet = list.stream().filter(e -> e.getRefundId() != null).map(FscOrderRelationPO::getRefundId).collect(Collectors.toSet());
                if (!CollectionUtils.isEmpty(refundIdSet)) {
                    FscOrderRefundPO fscOrderRefundPO = new FscOrderRefundPO();
                    fscOrderRefundPO.setRefundIdList(new ArrayList(refundIdSet));
                    List fscOrderRefundPOList = this.fscOrderRefundMapper.queryAll(fscOrderRefundPO);
                    if (!CollectionUtils.isEmpty((Collection)fscOrderRefundPOList)) {
                        for (FscOrderRefundPO orderRefundPO : fscOrderRefundPOList) {
                            if (FscConstants.RefundInvoiceStatus.DELETE.equals(orderRefundPO.getRefundStatus()) || FscConstants.RefundInvoiceStatus.CANCEL.equals(orderRefundPO.getRefundStatus()) || orderRefundPO.getRefundId().equals(reqBO.getRefundId()) || !reqBO.getFscOrderId().equals(orderRefundPO.getFscOrderId())) continue;
                            occupiedRefundIds.add(orderRefundPO.getRefundId());
                        }
                    }
                }
                list = list.stream().filter(e -> occupiedRefundIds.contains(e.getRefundId())).collect(Collectors.toList());
                for (Object po : list) {
                    if (po.getRefundId().equals(reqBO.getRefundId())) {
                        refundRelationPOList.add((FscOrderRelationPO)po);
                        continue;
                    }
                    if (po.getQualityAmt() == null || po.getRefundId() == null) continue;
                    forwardRefundQualityAmt = forwardRefundQualityAmt.add(po.getQualityAmt());
                }
            }
            BigDecimal forwardQualityAmt = BigDecimal.ZERO;
            relationPO = new FscOrderRelationPO();
            relationPO.setFscOrderId(reqBO.getFscOrderId());
            list = this.fscOrderRelationMapper.getListByOrderIds(relationPO);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                for (FscOrderRelationPO po : list) {
                    if (po.getQualityAmt() == null || po.getRefundId() != null) continue;
                    forwardQualityAmt = forwardQualityAmt.add(po.getQualityAmt());
                }
            }
            if ((forwardQualityAmt = forwardQualityAmt.subtract(forwardRefundQualityAmt)).compareTo(qualityAmt) < 0) {
                throw new FscBusinessException("198888", "\u5165\u53c2\u8d28\u4fdd\u91d1\u989d\u603b\u548c\u4e0d\u80fd\u8d85\u8fc7\u6b63\u5411\u7684\u53ef\u88ab\u5360\u7528\u7684\u8d28\u4fdd\u91d1\uff01\u5269\u4f59\u53ef\u88ab\u5360\u7528\u7684\u8d28\u4fdd\u91d1\uff1a" + forwardQualityAmt.setScale(2, 4));
            }
            Map<Long, List<FscOrderRelationPO>> abnormalVoucherIdOldMap = refundRelationPOList.stream().filter(e -> e.getQualityAmt() != null && e.getAbnormalVoucherId() != null).collect(Collectors.groupingBy(FscOrderRelationPO::getAbnormalVoucherId));
            HashMap<Long, BigDecimal> checkAbnormalIdQualityAmtMap = new HashMap<Long, BigDecimal>();
            if (CollectionUtils.isEmpty(abnormalVoucherIdOldMap)) {
                checkAbnormalIdQualityAmtMap = abnormalIdQualityAmtMap;
            } else {
                for (Long abnormalId : abnormalIdQualityAmtMap.keySet()) {
                    if (abnormalVoucherIdOldMap.containsKey(abnormalId)) {
                        BigDecimal newQualityAmt;
                        BigDecimal oldQualityAmt = abnormalVoucherIdOldMap.get(abnormalId).get(0).getQualityAmt();
                        if (oldQualityAmt.compareTo(newQualityAmt = (BigDecimal)abnormalIdQualityAmtMap.get(abnormalId)) >= 0) continue;
                        checkAbnormalIdQualityAmtMap.put(abnormalId, newQualityAmt.subtract(oldQualityAmt));
                        continue;
                    }
                    checkAbnormalIdQualityAmtMap.put(abnormalId, (BigDecimal)abnormalIdQualityAmtMap.get(abnormalId));
                }
            }
            if (!CollectionUtils.isEmpty(checkAbnormalIdQualityAmtMap)) {
                BigDecimal changeFeeMoney;
                FscOrderPO orderPO = new FscOrderPO();
                orderPO.setFscOrderId(refundPO.getFscOrderId());
                orderPO.setOrderFlow(FscConstants.OrderFlow.INVOICE);
                orderPO = this.fscOrderMapper.getModelBy(orderPO);
                if (orderPO == null) {
                    throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u4fe1\u606f\uff01");
                }
                List<Long> refundAbnormalVoucherIds = new ArrayList<Long>();
                List qryFscOrderRelationPOList = new ArrayList();
                if (refundPO.getRefundReasonType().equals(FscConstants.RefundReasonType.ORDER_REFUND)) {
                    FscOrderRelationPO qryFscOrderRelationPO = new FscOrderRelationPO();
                    qryFscOrderRelationPO.setRefundId(reqBO.getRefundId());
                    qryFscOrderRelationPOList = this.fscOrderRelationMapper.getListNoPage(qryFscOrderRelationPO);
                    if (!CollectionUtils.isEmpty(qryFscOrderRelationPOList)) {
                        refundAbnormalVoucherIds = qryFscOrderRelationPOList.stream().filter(e -> e.getAbnormalVoucherId() != null).map(FscOrderRelationPO::getAbnormalVoucherId).collect(Collectors.toList());
                    }
                }
                List<UocPebOrdShipAbnormalBO> abnormalOrderInfoList = this.qryAbnormalOrderInfo(reqBO.getAbnormalIds(), orderPO, refundAbnormalVoucherIds);
                Map<String, List<UocPebOrdShipAbnormalBO>> abnormalVoucherIdMap = abnormalOrderInfoList.stream().collect(Collectors.groupingBy(UocPebOrdShipAbnormalBO::getAbnormalVoucherId));
                HashMap<Long, BigDecimal> abnormalIdMap = new HashMap<Long, BigDecimal>();
                for (String abnormalVoucherId : abnormalVoucherIdMap.keySet()) {
                    changeFeeMoney = BigDecimal.ZERO;
                    for (UocPebOrdShipAbnormalBO uocPebOrdShipAbnormalBO : abnormalVoucherIdMap.get(abnormalVoucherId)) {
                        changeFeeMoney = changeFeeMoney.add(new BigDecimal(uocPebOrdShipAbnormalBO.getChangeFeeMoney()).abs());
                    }
                    abnormalIdMap.put(Long.valueOf(abnormalVoucherId), changeFeeMoney);
                }
                if (!CollectionUtils.isEmpty(qryFscOrderRelationPOList)) {
                    for (FscOrderRelationPO fscOrderRelationPO : qryFscOrderRelationPOList) {
                        if (fscOrderRelationPO.getAbnormalVoucherId() == null || fscOrderRelationPO.getSettleAmt() == null || !abnormalIdMap.containsKey(fscOrderRelationPO.getAbnormalVoucherId())) continue;
                        changeFeeMoney = ((BigDecimal)abnormalIdMap.get(fscOrderRelationPO.getAbnormalVoucherId())).add(fscOrderRelationPO.getSettleAmt());
                        abnormalIdMap.put(fscOrderRelationPO.getAbnormalVoucherId(), changeFeeMoney);
                    }
                }
                for (Long abnormalId : checkAbnormalIdQualityAmtMap.keySet()) {
                    BigDecimal abnormalChangeFeeMoney = (BigDecimal)abnormalIdMap.get(abnormalId);
                    BigDecimal nowQualityAmt = (BigDecimal)checkAbnormalIdQualityAmtMap.get(abnormalId);
                    if (abnormalChangeFeeMoney != null && nowQualityAmt.compareTo(abnormalChangeFeeMoney) <= 0) continue;
                    throw new FscBusinessException("198888", "\u8d28\u4fdd\u91d1\u4e0d\u80fd\u8d85\u8fc7\u5f02\u5e38\u5355\u91d1\u989d\uff01");
                }
            }
        }
    }

    private List<FscOrderRelationPO> buildAbnormalOrderInfo(FscOrderRefundPO refundPO, UocAbnormalSingleDetailsListQueryReqBO detailsListQueryReqBO) {
        detailsListQueryReqBO.setTabId(ABNORMAL_ALL_TAB_ID);
        if (FscOrderSourceEnum.ELECTRIC_MARKET.getCode().equals(refundPO.getOrderSource())) {
            detailsListQueryReqBO.setAbnormalState(ABNORMAL_STATE_TWO);
        } else {
            detailsListQueryReqBO.setAbnormalState(ABNORMAL_STATE_THREE);
        }
        if (refundPO.getReceiveType().equals(FscConstants.FscOrderReceiveType.PURCHASE)) {
            detailsListQueryReqBO.setRefundDownFlag(FscConstants.FscRefundFlag.NO);
        } else {
            detailsListQueryReqBO.setRefundUpFlag(FscConstants.FscRefundFlag.NO);
        }
        detailsListQueryReqBO.setPageSize(ABNORMAL_PAGE_SIZE.intValue());
        log.info("\u67e5\u8be2\u5f02\u5e38\u5355\u4fe1\u606f\u5165\u53c2" + JSONObject.toJSONString((Object)detailsListQueryReqBO));
        UocAbnormalSingleDetailsListQueryRspBO detailsListQueryRspBO = this.uocAbnormalSingleDetailsListQueryAbilityService.getAbnormalSingleDetailsListQuery(detailsListQueryReqBO);
        if (!"0000".equals(detailsListQueryRspBO.getRespCode())) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u8ba2\u5355\u5f02\u5e38\u53d8\u66f4\u4fe1\u606f\u5931\u8d25\uff1a" + detailsListQueryRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)detailsListQueryRspBO.getRows())) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u8ba2\u5355\u5f02\u5e38\u53d8\u66f4\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        ArrayList<FscOrderRelationPO> orderList = new ArrayList<FscOrderRelationPO>();
        for (UocPebOrdShipAbnormalBO row : detailsListQueryRspBO.getRows()) {
            FscOrderRelationPO orderRelationPO = new FscOrderRelationPO();
            orderRelationPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            orderRelationPO.setRefundId(refundPO.getRefundId());
            orderRelationPO.setAcceptOrderId(Long.valueOf(row.getInspectionVoucherId()));
            orderRelationPO.setAcceptOrderNo(row.getInspectionVoucherCode());
            orderRelationPO.setSettleAmt(new BigDecimal(row.getChangeFeeMoney()).abs());
            orderRelationPO.setOrderId(Long.valueOf(row.getOrderId()));
            orderRelationPO.setOrderNo(row.getSaleVoucherNo());
            orderRelationPO.setAbnormalVoucherId(Long.valueOf(row.getAbnormalVoucherId()));
            orderRelationPO.setAbnormalVoucherNo(row.getAbnormalVoucherNo());
            orderList.add(orderRelationPO);
        }
        return orderList;
    }

    private List<UocPebOrdShipAbnormalBO> qryAbnormalOrderInfo(List<Long> abnormalIds, FscOrderPO orderPO, List<Long> refundAbnormalVoucherIds) {
        UocAbnormalSingleDetailsListQueryReqBO abnormalReqBO = new UocAbnormalSingleDetailsListQueryReqBO();
        if (CollectionUtils.isEmpty(abnormalIds)) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u5f02\u5e38\u5355\u4fe1\u606f\u65f6\uff0c\u5f02\u5e38\u5355\u4fe1\u606f\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        abnormalReqBO.setAbnormalVoucherIds(abnormalIds);
        abnormalReqBO.setPageSize(ABNORMAL_PAGE_SIZE.intValue());
        abnormalReqBO.setTabId(ABNORMAL_ALL_TAB_ID);
        if (FscOrderSourceEnum.ELECTRIC_MARKET.getCode().equals(orderPO.getOrderSource())) {
            abnormalReqBO.setAbnormalState(ABNORMAL_STATE_TWO);
        } else {
            abnormalReqBO.setAbnormalState(ABNORMAL_STATE_THREE);
        }
        if (orderPO.getReceiveType().equals(FscConstants.FscOrderReceiveType.PURCHASE)) {
            abnormalReqBO.setRefundDownFlag(FscConstants.FscRefundFlag.NO);
        } else {
            abnormalReqBO.setRefundUpFlag(FscConstants.FscRefundFlag.NO);
        }
        abnormalReqBO.setRefundAbnormalVoucherIds(refundAbnormalVoucherIds);
        log.info("\u67e5\u8be2\u5f02\u5e38\u5355\u4fe1\u606f\u5165\u53c2" + JSONObject.toJSONString((Object)abnormalReqBO));
        UocAbnormalSingleDetailsListQueryRspBO abnormalRspBO = this.uocAbnormalSingleDetailsListQueryAbilityService.getAbnormalSingleDetailsListQuery(abnormalReqBO);
        if (!abnormalRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(abnormalRspBO.getRespCode(), "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u5f02\u5e38\u53d8\u66f4\u4fe1\u606f\u5f02\u5e38\uff1a" + abnormalRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)abnormalRspBO.getRows())) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u5f02\u5e38\u53d8\u66f4\u4fe1\u606f\uff01");
        }
        for (UocPebOrdShipAbnormalBO row : abnormalRspBO.getRows()) {
            BigDecimal changeFeeMoney = new BigDecimal(row.getChangeFeeMoney()).abs();
            if (orderPO.getReceiveType().equals(FscConstants.FscOrderReceiveType.OPERATION)) {
                if (row.getRefundUpAmt() != null) {
                    changeFeeMoney = changeFeeMoney.subtract(row.getRefundUpAmt());
                }
            } else if (row.getRefundDownAmt() != null) {
                changeFeeMoney = changeFeeMoney.subtract(row.getRefundDownAmt());
            }
            row.setChangeFeeMoney(changeFeeMoney.toString());
        }
        return abnormalRspBO.getRows();
    }

    private void getBeforeItem(FscBillOrderRefundUpdateAbilityReqBO reqBO, List<FscOrderRelationPO> beforeOrderRelationList, List<FscOrderItemPO> beforeOrderItemPOList, List<FscInvoiceItemPO> invoiceItemPOList, List<FscOrderItemPO> fscOrderItemPOList, List<FscInvoiceRefundRelationPO> beforeRelationPOS) {
        FscOrderRelationPO relationPO = new FscOrderRelationPO();
        relationPO.setRefundId(reqBO.getRefundId());
        List fscOrderRelationPOS = this.fscOrderRelationMapper.getListNoPage(relationPO);
        if (!CollectionUtils.isEmpty((Collection)fscOrderRelationPOS)) {
            beforeOrderRelationList.addAll(fscOrderRelationPOS);
        }
        FscOrderItemPO searchOrderItemPO = new FscOrderItemPO();
        searchOrderItemPO.setRefundId(reqBO.getRefundId());
        searchOrderItemPO.setOrderBy("id");
        List fscOrderItemPOS = this.fscOrderItemMapper.getListNoPage(searchOrderItemPO);
        if (!CollectionUtils.isEmpty((Collection)fscOrderItemPOS)) {
            beforeOrderItemPOList.addAll(fscOrderItemPOS);
        }
        FscInvoiceItemPO searchInvoiceItemPO = new FscInvoiceItemPO();
        searchInvoiceItemPO.setFscOrderId(reqBO.getFscOrderId());
        searchInvoiceItemPO.setOrderBy("ID");
        List fscInvoiceItemPOS = this.fscInvoiceItemMapper.getList(searchInvoiceItemPO);
        if (!CollectionUtils.isEmpty((Collection)fscInvoiceItemPOS)) {
            invoiceItemPOList.addAll(fscInvoiceItemPOS);
        }
        FscOrderItemPO searchFscOrderItemPO = new FscOrderItemPO();
        searchFscOrderItemPO.setFscOrderId(reqBO.getFscOrderId());
        searchFscOrderItemPO.setOrderBy("id");
        List fscOrderItemMapperListNoPage = this.fscOrderItemMapper.getListNoPage(searchFscOrderItemPO);
        if (!CollectionUtils.isEmpty((Collection)fscOrderItemMapperListNoPage)) {
            fscOrderItemPOList.addAll(fscOrderItemMapperListNoPage);
        }
        if (CollectionUtils.isEmpty(fscOrderItemPOList)) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u660e\u7ec6\u4fe1\u606f\uff01");
        }
        FscInvoiceRefundRelationPO searchRefundRelationPO = new FscInvoiceRefundRelationPO();
        searchRefundRelationPO.setRefundId(reqBO.getRefundId());
        List fscInvoiceRefundRelationPOS = this.fscInvoiceRefundRelationMapper.getList(searchRefundRelationPO);
        if (!CollectionUtils.isEmpty((Collection)fscInvoiceRefundRelationPOS)) {
            beforeRelationPOS.addAll(fscInvoiceRefundRelationPOS);
        }
        if (CollectionUtils.isEmpty(beforeRelationPOS)) {
            throw new FscBusinessException("198888", "\u539f\u59cb\u9000\u7968\u7684\u53d1\u7968\u9000\u7968\u91d1\u989d\u6570\u636e\u4e0d\u5b58\u5728\uff01");
        }
    }

    private void checkFscClaim(FscBillOrderRefundUpdateAbilityReqBO reqBO, Long fscOrderId, FscOrderRefundPO refundPO) {
        List payPaidList;
        if (reqBO.getOperationDown().equals(FscConstants.OperationDown.YES) && reqBO.getOperationType().equals(FscConstants.RefundOperationType.SUBMIT) && !reqBO.getRefundReasonType().equals(FscConstants.RefundReasonType.ORDER_REFUND) && (refundPO.getMakeType().equals(FscConstants.FscOrderMakeType.OPERTION) || this.operationSupId.equals(String.valueOf(refundPO.getSupplierId()))) && !CollectionUtils.isEmpty((Collection)(payPaidList = this.fscClaimDetailMapper.qryClaimListByFscOrderId(fscOrderId)))) {
            List claimDetailIdList = payPaidList.stream().map(FscClaimDetailPO::getClaimDetailId).collect(Collectors.toList());
            FscClaimDetailChangePO searchPO = new FscClaimDetailChangePO();
            searchPO.setClaimDetailIds(claimDetailIdList);
            searchPO.setPushStatus(FscConstants.FscPushStatus.SUCCESS);
            searchPO.setChangeBusiType(FscConstants.ChangeBusiType.REFUND);
            BigDecimal totalClaimChangeAmount = this.fscClaimDetailChangeMapper.queryTotalClaimChangeAmount(searchPO);
            if (totalClaimChangeAmount == null) {
                totalClaimChangeAmount = BigDecimal.ZERO;
            }
            BigDecimal totalOperationClaimAmt = BigDecimal.ZERO;
            FscOrderRelationPO orderRelationPO = new FscOrderRelationPO();
            orderRelationPO.setFscOrderId(refundPO.getFscOrderId());
            List orderRelationPOS = this.fscOrderRelationMapper.getListNoPage(orderRelationPO);
            if (!CollectionUtils.isEmpty((Collection)orderRelationPOS)) {
                for (FscOrderRelationPO po : orderRelationPOS) {
                    if (po.getOperationClaimAmt() == null) continue;
                    totalOperationClaimAmt = totalOperationClaimAmt.add(po.getOperationClaimAmt());
                }
            }
            if (totalClaimChangeAmount.compareTo(totalOperationClaimAmt) < 0) {
                throw new FscBusinessException("198888", "\u8bf7\u5148\u8fdb\u884c\u7ed3\u7b97\u5355\u7684\u6362\u7968\u9884\u8ba4\u9886\u53d8\u66f4");
            }
        }
    }
}

