/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.fsc.bill.ability.api.FscBillPayRefundConfirmAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillPayRefundConfirmAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillPayRefundConfirmAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillPayRefundConfirmBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillPayRefundConfirmBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillPayRefundConfirmBusiRspBO;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderExtMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.bo.FscPushUnifyRefundPayAbilityReqBO;
import java.util.Collections;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillPayRefundConfirmAbilityService"})
public class FscBillPayRefundConfirmAbilityServiceImpl
implements FscBillPayRefundConfirmAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillPayRefundConfirmAbilityServiceImpl.class);
    @Autowired
    private FscBillPayRefundConfirmBusiService fscBillPayRefundConfirmBusiService;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;
    @Autowired
    FscOrderExtMapper fscOrderExtMapper;
    @Value(value="${es.FSC_PUSH_UNIFY_REFUND__PAY_TOPIC:FSC_PUSH_UNIFY_REFUND__PAY_TOPIC}")
    private String fscPushUnifyRefundPayTopic;
    @Value(value="${es.FSC_PUSH_UNIFY_REFUND__PAY_TAG:FSC_PUSH_UNIFY_REFUND__PAY_TAG}")
    private String fscPushUnifyRefundPayTag;
    @Resource(name="fscPushUnifyRefundPayMqServiceProvider")
    private ProxyMessageProducer fscPushUnifyRefundPayMqServiceProvider;

    @PostMapping(value={"dealPayRefundConfirm"})
    public FscBillPayRefundConfirmAbilityRspBO dealPayRefundConfirm(@RequestBody FscBillPayRefundConfirmAbilityReqBO reqBO) {
        this.valid(reqBO);
        FscBillPayRefundConfirmBusiReqBO fscBillPayRefundConfirmBusiReqBO = (FscBillPayRefundConfirmBusiReqBO)((Object)JSON.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscBillPayRefundConfirmBusiReqBO.class));
        fscBillPayRefundConfirmBusiReqBO.setRefundId(reqBO.getRefundId());
        FscBillPayRefundConfirmBusiRspBO fscBillPayRefundConfirmBusiRspBO = this.fscBillPayRefundConfirmBusiService.dealPayRefundConfirm(fscBillPayRefundConfirmBusiReqBO);
        if (!"0000".equals(fscBillPayRefundConfirmBusiRspBO.getRespCode())) {
            return (FscBillPayRefundConfirmAbilityRspBO)JSON.parseObject((String)JSONObject.toJSONString((Object)((Object)fscBillPayRefundConfirmBusiRspBO)), FscBillPayRefundConfirmAbilityRspBO.class);
        }
        this.syncEs(reqBO);
        if (FscConstants.FscTradeMode.MATCHMAKING_MODE.equals(fscBillPayRefundConfirmBusiRspBO.getTradeMode())) {
            this.dealPushUnify(fscBillPayRefundConfirmBusiRspBO.getRefundId());
        }
        return (FscBillPayRefundConfirmAbilityRspBO)JSON.parseObject((String)JSONObject.toJSONString((Object)((Object)fscBillPayRefundConfirmBusiRspBO)), FscBillPayRefundConfirmAbilityRspBO.class);
    }

    private void dealPushUnify(Long refundId) {
        FscPushUnifyRefundPayAbilityReqBO abilityReqBO = new FscPushUnifyRefundPayAbilityReqBO();
        abilityReqBO.setRefundId(refundId);
        ProxySendResult result = this.fscPushUnifyRefundPayMqServiceProvider.send(new ProxyMessage(this.fscPushUnifyRefundPayTopic, this.fscPushUnifyRefundPayTag, JSONObject.toJSONString((Object)abilityReqBO)));
        if (!result.getStatus().equals("SEND_OK")) {
            log.error("\u5f02\u6b65\u63a8\u9001\u9000\u6b3e\u51b2\u9500\u5355\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff1a" + result.getMsgId());
        }
    }

    private void syncEs(FscBillPayRefundConfirmAbilityReqBO reqBO) {
        FscComRefundSyncAbilityReqBO refundSyncAbilityReqBO = new FscComRefundSyncAbilityReqBO();
        refundSyncAbilityReqBO.setRefundIds(Collections.singletonList(reqBO.getRefundId()));
        this.fscComRefundSyncAbilityService.syncRefund(refundSyncAbilityReqBO);
    }

    private void valid(FscBillPayRefundConfirmAbilityReqBO reqBO) {
        if (reqBO.getRefundId() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2[refundId]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
    }
}

