/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.tydic.fsc.bill.ability.api.FscFinanceSegmentBatchSetAbilityService;
import com.tydic.fsc.bill.ability.bo.FscFinanceSegmentBatchSetReqBo;
import com.tydic.fsc.bill.ability.bo.FscFinanceSegmentBatchSetRspBo;
import com.tydic.fsc.busibase.busi.bo.FscFinanceSegmentBatchSetUpdateReqBo;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscFinanceSegmentBatchSetAbilityService"})
public class FscFinanceSegmentBatchSetAbilityServiceImpl
implements FscFinanceSegmentBatchSetAbilityService {
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;

    @PostMapping(value={"dealSegmentBatchSet"})
    public FscFinanceSegmentBatchSetRspBo dealSegmentBatchSet(@RequestBody FscFinanceSegmentBatchSetReqBo reqBo) {
        this.validParam(reqBo);
        FscFinanceSegmentBatchSetUpdateReqBo updateReqBo = new FscFinanceSegmentBatchSetUpdateReqBo();
        updateReqBo.setDealType(reqBo.getDealType());
        updateReqBo.setFscOrderId(reqBo.getFscOrderId());
        updateReqBo.setBillName(reqBo.getBillName());
        updateReqBo.setBillNo(reqBo.getBillNo());
        updateReqBo.setIsAllDetails(reqBo.getIsAllDetails());
        int num = this.fscOrderItemMapper.updateBatchByFscOrderId(updateReqBo);
        FscFinanceSegmentBatchSetRspBo rspBo = new FscFinanceSegmentBatchSetRspBo();
        rspBo.setRespCode(num > 0 ? "0000" : "1");
        rspBo.setRespDesc(num > 0 ? "\u6210\u529f" : "\u5931\u8d25");
        return rspBo;
    }

    private void validParam(FscFinanceSegmentBatchSetReqBo reqBo) {
        if (null == reqBo.getFscOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBo.getDealType()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[dealType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBo.getIsAllDetails()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[isAllDetails]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getBillNo())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[billNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getBillName())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[billName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

