/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.fsc.bill.ability.api.FscInvoicePrintAbilityService;
import com.tydic.fsc.bill.ability.bo.FscInvoicePrintAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscInvoicePrintAbilityRspBO;
import com.tydic.fsc.bo.PdfCellBO;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.util.AmountUtils;
import com.tydic.fsc.util.PdfUtilsG;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscInvoicePrintAbilityService"})
public class FscInvoicePrintAbilityServiceImpl
implements FscInvoicePrintAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscInvoicePrintAbilityServiceImpl.class);
    private static final String PATH = "fsc/pdf";
    private static final String FILE_TYPE_OSS = "OSS";
    private static final String FILE_TYPE_FASTDFS = "FASTDFS";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    private FileClient fileClient;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;

    @PostMapping(value={"invoicePrint"})
    public FscInvoicePrintAbilityRspBO invoicePrint(@RequestBody FscInvoicePrintAbilityReqBO reqBO) {
        if (reqBO.getFscOrderId() == null) {
            throw new FscBusinessException("191000", "\u7ed3\u7b97\u5355Id\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FscInvoicePrintAbilityRspBO rspBO = new FscInvoicePrintAbilityRspBO();
        String pdfUrl = null;
        try {
            pdfUrl = this.createInvoicePdfPrint(reqBO);
        }
        catch (DocumentException | IOException e) {
            e.printStackTrace();
        }
        rspBO.setPrintUrl(pdfUrl);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String createInvoicePdfPrint(FscInvoicePrintAbilityReqBO reqBO) throws IOException, DocumentException {
        Document document = new Document(PageSize.A4.rotate(), -10.0f, 0.0f, 40.0f, 60.0f);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        document.open();
        List<PdfPTable> list = this.addPdfTable(reqBO);
        PdfUtilsG.addTableListToDoc((Document)document, list);
        document.close();
        return this.uploadFile("\u53d1\u7968\u9884\u89c8", byteArrayOutputStream);
    }

    public String uploadFile(String name, ByteArrayOutputStream byteArrayOutputStream) {
        String exportUrl;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        String fileName = name + System.currentTimeMillis() + ".pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            exportUrl = this.ossFileUrl + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        return exportUrl;
    }

    private List<PdfPTable> addPdfTable(FscInvoicePrintAbilityReqBO reqBO) throws IOException, DocumentException {
        LinkedList<PdfPTable> tableList = new LinkedList<PdfPTable>();
        this.addHeadTable(tableList, reqBO);
        return tableList;
    }

    private void addHeadTable(List<PdfPTable> tableList, FscInvoicePrintAbilityReqBO reqBO) throws IOException, DocumentException {
        FscOrderInvoicePO fscOrderInvoicePo = new FscOrderInvoicePO();
        fscOrderInvoicePo.setFscOrderId(reqBO.getFscOrderId());
        fscOrderInvoicePo = this.fscOrderInvoiceMapper.getModelBy(fscOrderInvoicePo);
        if (ObjectUtil.isEmpty((Object)fscOrderInvoicePo)) {
            throw new ZTBusinessException("\u53d1\u7968\u67e5\u8be2\u5931\u8d25\uff01");
        }
        FscOrderItemPO itemPO = new FscOrderItemPO();
        itemPO.setFscOrderId(reqBO.getFscOrderId());
        List orderItemList = this.fscOrderItemMapper.getList(itemPO);
        if (CollectionUtils.isEmpty((Collection)orderItemList)) {
            throw new ZTBusinessException("\u7ed3\u7b97\u5355\u660e\u7ec6\u67e5\u8be2\u4e3a\u7a7a\uff01");
        }
        BaseFont baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        Font fontFor13 = new Font(baseFont, 13.0f, 1);
        Font fontFor11 = new Font(baseFont, 11.0f, 0);
        PdfPTable table = new PdfPTable(1);
        tableList.add(table);
        PdfUtilsG.addCellToTable((PdfPTable)table, (PdfCellBO)new PdfCellBO(fontFor13, "\u9500\u9879\u7968\u4e13\u7528\u53d1\u7968\u660e\u7ec6", Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(30.0f), Integer.valueOf(0), Integer.valueOf(1), null, Arrays.asList(1, 3, 4), null));
        table = new PdfPTable(100);
        tableList.add(table);
        LinkedList<PdfCellBO> dataList = new LinkedList<PdfCellBO>();
        dataList.add(new PdfCellBO(fontFor11, "\u53d1\u7968\u4ee3\u7801\uff1a", Integer.valueOf(33), Integer.valueOf(1), Float.valueOf(28.0f), Integer.valueOf(2), Integer.valueOf(0), null));
        dataList.add(new PdfCellBO(fontFor11, "\u53d1\u7968\u7f16\u53f7\uff1a", Integer.valueOf(33), Integer.valueOf(1), Float.valueOf(28.0f), Integer.valueOf(2), Integer.valueOf(0), null));
        dataList.add(new PdfCellBO(fontFor11, "\u5f00\u7968\u65e5\u671f\uff1a", Integer.valueOf(34), Integer.valueOf(1), Float.valueOf(28.0f), Integer.valueOf(2), Integer.valueOf(0), null));
        dataList.add(new PdfCellBO(fontFor11, "\u8d2d\n\u4e70\n\u65b9", Integer.valueOf(6), Integer.valueOf(4), null, Integer.valueOf(1), Integer.valueOf(1), null));
        dataList.add(new PdfCellBO(fontFor11, "", Integer.valueOf(2), Integer.valueOf(4), null, Integer.valueOf(1), Integer.valueOf(1), null, Arrays.asList(2, 3, 4), null));
        dataList.add(new PdfCellBO(fontFor11, "\u540d     \u79f0\uff1a", Integer.valueOf(12), Integer.valueOf(1), null, Integer.valueOf(2), Integer.valueOf(1), null, Arrays.asList(2, 3, 4), null));
        dataList.add(new PdfCellBO(fontFor11, "", Integer.valueOf(2), Integer.valueOf(4), null, Integer.valueOf(1), Integer.valueOf(1), null, Arrays.asList(2, 3, 4), null));
        dataList.add(new PdfCellBO(fontFor11, fscOrderInvoicePo.getBuyName(), Integer.valueOf(45), Integer.valueOf(1), null, Integer.valueOf(0), Integer.valueOf(1), null, Arrays.asList(2, 3, 4), null));
        dataList.add(new PdfCellBO(fontFor11, "\u5bc6\n\u7801\n\u533a", Integer.valueOf(6), Integer.valueOf(4), null, Integer.valueOf(1), Integer.valueOf(1), null));
        dataList.add(new PdfCellBO(fontFor11, "", Integer.valueOf(27), Integer.valueOf(4), null, Integer.valueOf(1), Integer.valueOf(1), null));
        dataList.add(new PdfCellBO(fontFor11, "\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a", Integer.valueOf(12), Integer.valueOf(1), null, Integer.valueOf(2), Integer.valueOf(1), null, Arrays.asList(1, 2, 3, 4), null));
        dataList.add(new PdfCellBO(fontFor11, fscOrderInvoicePo.getTaxNo(), Integer.valueOf(45), Integer.valueOf(1), null, Integer.valueOf(0), Integer.valueOf(1), null, Arrays.asList(1, 2, 3, 4), null));
        dataList.add(new PdfCellBO(fontFor11, "\u5730\u5740\u3001\u7535\u8bdd\uff1a", Integer.valueOf(12), Integer.valueOf(1), null, Integer.valueOf(2), Integer.valueOf(1), null, Arrays.asList(1, 2, 3, 4), null));
        dataList.add(new PdfCellBO(fontFor11, fscOrderInvoicePo.getAddress() + "\u3001" + fscOrderInvoicePo.getPhone(), Integer.valueOf(45), Integer.valueOf(1), null, Integer.valueOf(0), Integer.valueOf(1), null, Arrays.asList(1, 2, 3, 4), null));
        dataList.add(new PdfCellBO(fontFor11, "\u5f00\u6237\u884c\u53ca\u8d26\u53f7\uff1a", Integer.valueOf(12), Integer.valueOf(1), null, Integer.valueOf(2), Integer.valueOf(1), null, Arrays.asList(1, 2, 3, 4), null));
        dataList.add(new PdfCellBO(fontFor11, fscOrderInvoicePo.getBank() + " " + fscOrderInvoicePo.getAccount(), Integer.valueOf(45), Integer.valueOf(1), null, Integer.valueOf(0), Integer.valueOf(1), null, Arrays.asList(1, 2, 3, 4), null));
        dataList.add(new PdfCellBO(fontFor11, "\u884c\u53f7", Integer.valueOf(5), Integer.valueOf(1), null, Integer.valueOf(1), Integer.valueOf(1), new BaseColor(242, 242, 242)));
        dataList.add(new PdfCellBO(fontFor11, "\u7a0e\u6536\u5206\u7c7b", Integer.valueOf(9), Integer.valueOf(1), null, Integer.valueOf(1), Integer.valueOf(1), new BaseColor(242, 242, 242)));
        dataList.add(new PdfCellBO(fontFor11, "\u8d27\u7269\u6216\u5e94\u7a0e\u52b3\u52a1\u3001\u670d\u52a1\u540d\u79f0", Integer.valueOf(21), Integer.valueOf(1), null, Integer.valueOf(1), Integer.valueOf(1), new BaseColor(242, 242, 242)));
        dataList.add(new PdfCellBO(fontFor11, "\u89c4\u683c\u578b\u53f7", Integer.valueOf(16), Integer.valueOf(1), null, Integer.valueOf(1), Integer.valueOf(1), new BaseColor(242, 242, 242)));
        dataList.add(new PdfCellBO(fontFor11, "\u5355\u4f4d", Integer.valueOf(6), Integer.valueOf(1), null, Integer.valueOf(1), Integer.valueOf(1), new BaseColor(242, 242, 242)));
        dataList.add(new PdfCellBO(fontFor11, "\u6570\u91cf", Integer.valueOf(8), Integer.valueOf(1), null, Integer.valueOf(1), Integer.valueOf(1), new BaseColor(242, 242, 242)));
        dataList.add(new PdfCellBO(fontFor11, "\u5355\u4ef7", Integer.valueOf(10), Integer.valueOf(1), null, Integer.valueOf(1), Integer.valueOf(1), new BaseColor(242, 242, 242)));
        dataList.add(new PdfCellBO(fontFor11, "\u91d1\u989d", Integer.valueOf(10), Integer.valueOf(1), null, Integer.valueOf(1), Integer.valueOf(1), new BaseColor(242, 242, 242)));
        dataList.add(new PdfCellBO(fontFor11, "\u7a0e\u7387", Integer.valueOf(5), Integer.valueOf(1), null, Integer.valueOf(1), Integer.valueOf(1), new BaseColor(242, 242, 242)));
        dataList.add(new PdfCellBO(fontFor11, "\u7a0e\u989d", Integer.valueOf(10), Integer.valueOf(1), null, Integer.valueOf(1), Integer.valueOf(1), new BaseColor(242, 242, 242)));
        int i = 1;
        BigDecimal totalPriceNoCount = new BigDecimal(0);
        BigDecimal totalPriceCount = new BigDecimal(0);
        BigDecimal totalTaxAmt = new BigDecimal(0);
        for (FscOrderItemPO orderItemPO : orderItemList) {
            BigDecimal settleNum = orderItemPO.getSettleNum() != null ? orderItemPO.getSettleNum() : orderItemPO.getNum();
            settleNum = settleNum.setScale(8, 4);
            BigDecimal settlePrice = orderItemPO.getSettlePrice() != null ? orderItemPO.getSettlePrice().divide(orderItemPO.getTaxRate().add(new BigDecimal(1)), 8, 4) : orderItemPO.getPrice().divide(orderItemPO.getTaxRate().add(new BigDecimal(1)), 8, 4);
            BigDecimal totalPrice = settlePrice.multiply(settleNum).setScale(2, 4);
            BigDecimal taxRate = orderItemPO.getTaxRate().multiply(new BigDecimal(100)).setScale(0, 4);
            dataList.add(new PdfCellBO(fontFor11, String.valueOf(i), Integer.valueOf(5), Integer.valueOf(1), null, Integer.valueOf(1), Integer.valueOf(1), null));
            dataList.add(new PdfCellBO(fontFor11, orderItemPO.getTaxCode(), Integer.valueOf(9), Integer.valueOf(1), null, Integer.valueOf(1), Integer.valueOf(1), null));
            dataList.add(new PdfCellBO(fontFor11, orderItemPO.getProductDescription(), Integer.valueOf(21), Integer.valueOf(1), null, Integer.valueOf(1), Integer.valueOf(1), null));
            dataList.add(new PdfCellBO(fontFor11, orderItemPO.getSpecificationsModel(), Integer.valueOf(16), Integer.valueOf(1), null, Integer.valueOf(1), Integer.valueOf(1), null));
            dataList.add(new PdfCellBO(fontFor11, orderItemPO.getSettleUnit() != null ? orderItemPO.getSettleUnit() : orderItemPO.getUnit(), Integer.valueOf(6), Integer.valueOf(1), null, Integer.valueOf(1), Integer.valueOf(1), null));
            dataList.add(new PdfCellBO(fontFor11, String.valueOf(settleNum), Integer.valueOf(8), Integer.valueOf(1), null, Integer.valueOf(1), Integer.valueOf(1), null));
            dataList.add(new PdfCellBO(fontFor11, String.valueOf(settlePrice), Integer.valueOf(10), Integer.valueOf(1), null, Integer.valueOf(1), Integer.valueOf(1), null));
            dataList.add(new PdfCellBO(fontFor11, String.valueOf(totalPrice), Integer.valueOf(10), Integer.valueOf(1), null, Integer.valueOf(1), Integer.valueOf(1), null));
            dataList.add(new PdfCellBO(fontFor11, taxRate + "%", Integer.valueOf(5), Integer.valueOf(1), null, Integer.valueOf(1), Integer.valueOf(1), null));
            dataList.add(new PdfCellBO(fontFor11, String.valueOf(orderItemPO.getTaxAmt().setScale(2, 4)), Integer.valueOf(10), Integer.valueOf(1), null, Integer.valueOf(1), Integer.valueOf(1), null));
            ++i;
            totalPriceNoCount = totalPriceNoCount.add(totalPrice);
            totalTaxAmt = totalTaxAmt.add(orderItemPO.getTaxAmt());
            totalPriceCount = totalPriceCount.add(orderItemPO.getAmt());
        }
        dataList.add(new PdfCellBO(fontFor11, "\u5408\u8ba1", Integer.valueOf(16), Integer.valueOf(1), null, Integer.valueOf(1), Integer.valueOf(1), null));
        dataList.add(new PdfCellBO(fontFor11, "", Integer.valueOf(59), Integer.valueOf(1), null, Integer.valueOf(1), Integer.valueOf(1), null));
        dataList.add(new PdfCellBO(fontFor11, String.valueOf(totalPriceNoCount), Integer.valueOf(10), Integer.valueOf(1), null, Integer.valueOf(1), Integer.valueOf(1), null));
        dataList.add(new PdfCellBO(fontFor11, "", Integer.valueOf(5), Integer.valueOf(1), null, Integer.valueOf(1), Integer.valueOf(1), null));
        dataList.add(new PdfCellBO(fontFor11, String.valueOf(totalTaxAmt.setScale(2, 4)), Integer.valueOf(10), Integer.valueOf(1), null, Integer.valueOf(1), Integer.valueOf(1), null));
        dataList.add(new PdfCellBO(fontFor11, "\u4ef7\u7a0e\u5408\u8ba1", Integer.valueOf(16), Integer.valueOf(1), null, Integer.valueOf(1), Integer.valueOf(1), null));
        dataList.add(new PdfCellBO(fontFor11, "(\u5927\u5199)" + AmountUtils.upper((BigDecimal)totalPriceCount.setScale(2, 4)), Integer.valueOf(62), Integer.valueOf(1), null, Integer.valueOf(1), Integer.valueOf(1), null));
        dataList.add(new PdfCellBO(fontFor11, "(\u5c0f\u5199)\uffe5" + totalPriceCount.setScale(2, 4), Integer.valueOf(22), Integer.valueOf(1), null, Integer.valueOf(1), Integer.valueOf(1), null));
        dataList.add(new PdfCellBO(fontFor11, "\u9500\n\u552e\n\u65b9", Integer.valueOf(6), Integer.valueOf(4), null, Integer.valueOf(1), Integer.valueOf(1), null));
        dataList.add(new PdfCellBO(fontFor11, "", Integer.valueOf(2), Integer.valueOf(4), null, Integer.valueOf(1), Integer.valueOf(1), null, Arrays.asList(3, 4), null));
        dataList.add(new PdfCellBO(fontFor11, "\u540d     \u79f0\uff1a", Integer.valueOf(12), Integer.valueOf(1), null, Integer.valueOf(2), Integer.valueOf(1), null, Arrays.asList(2, 3, 4), null));
        dataList.add(new PdfCellBO(fontFor11, "", Integer.valueOf(2), Integer.valueOf(4), null, Integer.valueOf(1), Integer.valueOf(1), null, Arrays.asList(3, 4), null));
        dataList.add(new PdfCellBO(fontFor11, "\u4e2d\u56fd\u7164\u70ad\u5f00\u53d1\u6709\u9650\u8d23\u4efb\u516c\u53f8", Integer.valueOf(45), Integer.valueOf(1), null, Integer.valueOf(0), Integer.valueOf(1), null, Arrays.asList(2, 3, 4), null));
        dataList.add(new PdfCellBO(fontFor11, "\u5907\n\u6ce8", Integer.valueOf(6), Integer.valueOf(4), null, Integer.valueOf(1), Integer.valueOf(1), null));
        dataList.add(new PdfCellBO(fontFor11, reqBO.getRemark(), Integer.valueOf(27), Integer.valueOf(4), null, Integer.valueOf(0), Integer.valueOf(1), null));
        dataList.add(new PdfCellBO(fontFor11, "\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a", Integer.valueOf(12), Integer.valueOf(1), null, Integer.valueOf(2), Integer.valueOf(1), null, Arrays.asList(1, 2, 3, 4), null));
        dataList.add(new PdfCellBO(fontFor11, "911110000X000093121", Integer.valueOf(45), Integer.valueOf(1), null, Integer.valueOf(0), Integer.valueOf(1), null, Arrays.asList(1, 2, 3, 4), null));
        dataList.add(new PdfCellBO(fontFor11, "\u5730\u5740\u3001\u7535\u8bdd\uff1a", Integer.valueOf(12), Integer.valueOf(1), null, Integer.valueOf(2), Integer.valueOf(1), null, Arrays.asList(1, 2, 3, 4), null));
        dataList.add(new PdfCellBO(fontFor11, "\u5317\u4eac\u5e02\u4e1c\u57ce\u533a\u5b89\u5916\u5927\u8857\u4e5988\u53f74\u5c42(\u6574\u5c42) ", Integer.valueOf(45), Integer.valueOf(1), null, Integer.valueOf(0), Integer.valueOf(1), null, Arrays.asList(1, 2, 3, 4), null));
        dataList.add(new PdfCellBO(fontFor11, "\u5f00\u6237\u884c\u53ca\u8d26\u53f7\uff1a", Integer.valueOf(12), Integer.valueOf(1), null, Integer.valueOf(2), Integer.valueOf(1), null, Arrays.asList(1, 3, 4), null));
        dataList.add(new PdfCellBO(fontFor11, "\u4e0a\u6d77\u6d66\u4e1c\u53d1\u5c55\u94f6\u884c\u5317\u4eac\u5206\u884c\u5b89\u5916\u652f\u884c", Integer.valueOf(45), Integer.valueOf(1), null, Integer.valueOf(0), Integer.valueOf(1), null, Arrays.asList(1, 3, 4), null));
        PdfUtilsG.addCellToTable((PdfPTable)table, dataList);
    }

    @Autowired
    public void setFileClient(FileClient fileClient) {
        this.fileClient = fileClient;
    }
}

