/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.fsc.bill.ability.api.FscReconciliationDataAbilityService;
import com.tydic.fsc.bill.ability.bo.FscReconciliationDataAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscReconciliationDataAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscReconcilDealBusiService;
import com.tydic.fsc.bill.busi.bo.FscReconciliationDataBusiReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscReconciliationDataReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscReconciliationDataRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscReconciliationDataService;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.uoc.common.ability.api.PebExtUnifySettlePersonQryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityRspBO;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscReconciliationDataAbilityService"})
public class FscReconciliationDataAbilityServiceImpl
implements FscReconciliationDataAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscReconciliationDataAbilityServiceImpl.class);
    @Autowired
    private FscReconciliationDataService fscReconciliationDataService;
    @Autowired
    private PebExtUnifySettlePersonQryAbilityService pebExtUnifySettlePersonQryAbilityService;
    @Value(value="${fsc.invoice.pool.account:14004065}")
    private String agentAccount;
    @Value(value="${RECONCILIATION_DATA_PAGESIZE:500}")
    private Integer pageSize;
    @Value(value="${RECONCILIATION_DATA_DATE:7}")
    private long day;
    @Resource(name="fscReconciliationDataMqServiceProvider")
    private ProxyMessageProducer fscReconciliationDataMqServiceProvider;
    @Value(value="${FSC_RECONCILIATION_DATA_TOPIC:FSC_RECONCILIATION_DATA_TOPIC}")
    private String topic;
    @Value(value="${FSC_RECONCILIATION_DATA_TAG:*}")
    private String tag;
    @Autowired
    private FscReconcilDealBusiService fscReconcilDealBusiService;

    @PostMapping(value={"getOrderData"})
    public FscReconciliationDataAbilityRspBO getOrderData(@RequestBody FscReconciliationDataAbilityReqBO reqBO) {
        FscReconciliationDataRspBO fscReconciliationDataRspBO;
        FscReconciliationDataReqBO reconciliationDataReqBO = new FscReconciliationDataReqBO();
        reconciliationDataReqBO.setToken(this.getToken());
        reconciliationDataReqBO.setPageNum(Integer.valueOf(1));
        reconciliationDataReqBO.setPageSize(this.pageSize);
        reconciliationDataReqBO.setSqlId(reqBO.getSqlId());
        if (reqBO.getFlag().booleanValue()) {
            reconciliationDataReqBO.setSTART_DATE(!StringUtils.isEmpty((Object)reqBO.getStartDate()) ? reqBO.getStartDate() : this.getDate());
            if (!StringUtils.isEmpty((Object)reqBO.getEndDate())) {
                reconciliationDataReqBO.setEND_DATE(reqBO.getEndDate());
            }
        }
        if ("0000".equals((fscReconciliationDataRspBO = this.fetchAndProcessPage(reconciliationDataReqBO)).getRespCode())) {
            int total = fscReconciliationDataRspBO.getTotal();
            log.info("sqlId\uff1a{},\u5bf9\u8d26\u5904\u7406\u6570\u636e\u603b\u6761\u6570\uff1a{}", (Object)reqBO.getSqlId(), (Object)total);
            if (total > this.pageSize) {
                int pageCount = total % this.pageSize == 0 ? total / this.pageSize : total / this.pageSize + 1;
                log.info("sqlId\uff1a{},\u5bf9\u8d26\u5904\u7406\u6570\u636e\u5206\u9875\u6570\uff1a{}", (Object)reqBO.getSqlId(), (Object)pageCount);
                for (int page = 2; page <= pageCount; ++page) {
                    reconciliationDataReqBO.setPageNum(Integer.valueOf(page));
                    this.fetchAndProcessPage(reconciliationDataReqBO);
                }
            }
            log.info("sqlId\uff1a{},\u5bf9\u8d26\u5904\u7406\u6570\u636e\u5904\u7406\u5b8c\u6210", (Object)reqBO.getSqlId());
        }
        return new FscReconciliationDataAbilityRspBO();
    }

    private FscReconciliationDataRspBO fetchAndProcessPage(FscReconciliationDataReqBO reconciliationDataReqBO) {
        FscReconciliationDataRspBO fscReconciliationDataRspBO = this.fscReconciliationDataService.getOrderData(reconciliationDataReqBO);
        if ("0000".equals(fscReconciliationDataRspBO.getRespCode())) {
            this.fscReconciliationDataMqServiceProvider.send(new ProxyMessage(this.topic, this.tag, fscReconciliationDataRspBO.getData()));
        } else {
            log.error("\u5bf9\u8d26\u6570\u636e\u9519\u8bef:{}", (Object)fscReconciliationDataRspBO.getRespDesc());
        }
        return fscReconciliationDataRspBO;
    }

    private String getToken() {
        PebExtUnifySettleTokenQryAbilityReqBO tokenQryAbilityReqBO = new PebExtUnifySettleTokenQryAbilityReqBO();
        tokenQryAbilityReqBO.setUserId(this.agentAccount);
        PebExtUnifySettleTokenQryAbilityRspBO tokenQryAbilityRspBO = this.pebExtUnifySettlePersonQryAbilityService.qryUnifyPersonToken(tokenQryAbilityReqBO);
        if (!tokenQryAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException("198888", "\u83b7\u53d6\u4e1a\u8d22\u7cfb\u7edftoken\u4fe1\u606f\u5931\u8d25:" + tokenQryAbilityRspBO.getRespDesc());
        }
        return tokenQryAbilityRspBO.getData();
    }

    private String getDate() {
        LocalDate currentDate = LocalDate.now();
        LocalDate dateMinusSevenDays = currentDate.minusDays(this.day);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        return dateMinusSevenDays.format(formatter);
    }

    @PostMapping(value={"deleteOrderData"})
    public FscReconciliationDataAbilityRspBO deleteOrderData(@RequestBody FscReconciliationDataAbilityReqBO reqBO) {
        FscReconciliationDataBusiReqBO busiReqBo = new FscReconciliationDataBusiReqBO();
        busiReqBo.setContent(reqBO.getType());
        this.fscReconcilDealBusiService.deleteData(busiReqBo);
        return new FscReconciliationDataAbilityRspBO();
    }
}

