/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.tydic.fsc.bill.ability.api.FscBillOrderInvoiceSignToYCAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillOrderInvoiceSignToYCAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderInvoiceSignToYCAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillOrderInvoiceSignToYCBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceSignToYCBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceSignToYCBusiRspBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillOrderInvoiceSignToYCAbilityService"})
public class FscBillOrderInvoiceSignToYCAbilityServiceImpl
implements FscBillOrderInvoiceSignToYCAbilityService {
    @Autowired
    private FscBillOrderInvoiceSignToYCBusiService fscBillOrderInvoiceSignToYCBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealOrderInvoiceSignToYC"})
    public FscBillOrderInvoiceSignToYCAbilityRspBO dealOrderInvoiceSignToYC(@RequestBody FscBillOrderInvoiceSignToYCAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getFscOrderIds())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fscOrderIds]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        StringBuilder sb = new StringBuilder();
        for (Long fscOrderId : reqBO.getFscOrderIds()) {
            FscBillOrderInvoiceSignToYCBusiReqBO busiReqBO = new FscBillOrderInvoiceSignToYCBusiReqBO();
            busiReqBO.setOrderId(fscOrderId);
            FscBillOrderInvoiceSignToYCBusiRspBO busiRspBO = this.fscBillOrderInvoiceSignToYCBusiService.dealOrderInvoiceSignToYC(busiReqBO);
            if (!busiRspBO.getRespCode().equals("0000")) {
                sb.append("\u7ed3\u7b97\u5355:").append(fscOrderId).append(",").append(busiRspBO.getRespCode()).append(",").append(busiRspBO.getRespDesc()).append(";");
            }
            this.sendMq(fscOrderId);
        }
        FscBillOrderInvoiceSignToYCAbilityRspBO rspBO = new FscBillOrderInvoiceSignToYCAbilityRspBO();
        if (StringUtils.isEmpty((Object)sb.toString())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        } else {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc(sb.toString());
        }
        return rspBO;
    }

    private void sendMq(Long fscOrderId) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }
}

