/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl.finance;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.ability.api.finance.FscFinanceInvoiceFolderUploadAbilityService;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceInvoiceFolderUploadReqBo;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceInvoiceFolderUploadRspBo;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceInvoiceFolderUploadRspBoData;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceShareRelatedInterfacesAtomService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.util.HttpUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.CharsetUtils;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.finance.FscFinanceInvoiceFolderUploadAbilityService"})
public class FscFinanceInvoiceFolderUploadAbilityServiceImpl
implements FscFinanceInvoiceFolderUploadAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceInvoiceFolderUploadAbilityServiceImpl.class);
    @Resource
    private FscOrderMapper fscOrderMapper;
    @Resource
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscFinanceShareRelatedInterfacesAtomService fscFinanceShareRelatedInterfacesAtomService;
    @Value(value="${finance.invoice.upload.url:}")
    private String uploadUrl;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping(value={"uploadInvoiceFolder"})
    public FscFinanceInvoiceFolderUploadRspBo uploadInvoiceFolder(@RequestBody FscFinanceInvoiceFolderUploadReqBo reqBo) {
        List fileUrls = reqBo.getFileUrl();
        if (CollectionUtil.isEmpty((Collection)fileUrls)) {
            throw new FscBusinessException("191000", "\u5fc5\u4f20\u53c2\u6570[fileUrl]\u4e3a\u7a7a");
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)reqBo.getGuid())) {
            throw new FscBusinessException("191000", "\u5fc5\u4f20\u53c2\u6570[guid]\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBo.getFscOrderId())) {
            throw new FscBusinessException("191000", "\u5fc5\u4f20\u53c2\u6570[fscOrderId]\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBo.getContractId())) {
            throw new FscBusinessException("191000", "\u5fc5\u4f20\u53c2\u6570[contractId]\u4e3a\u7a7a");
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBo.getFscOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (Objects.isNull(fscOrderPO)) {
            throw new FscBusinessException("191000", "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u7ed3\u7b97\u5355\u4fe1\u606f\uff01");
        }
        FscFinanceInvoiceFolderUploadRspBo rspBo = new FscFinanceInvoiceFolderUploadRspBo();
        String result = null;
        File file = null;
        ArrayList<File> files = new ArrayList<File>();
        for (String fileUrl : fileUrls) {
            try {
                String fileName = Sequence.getInstance().nextId() + fileUrl.substring(fileUrl.lastIndexOf("."));
                HttpUtils.httpDownload((String)fileUrl, (String)fileName);
                byte[] bytes = FscFinanceInvoiceFolderUploadAbilityServiceImpl.getBytes(fileName);
                try {
                    ByteArrayInputStream input = new ByteArrayInputStream(bytes);
                    Throwable throwable = null;
                    try {
                        Throwable throwable2;
                        file = new File(fileName);
                        files.add(file);
                        try {
                            FileOutputStream fos = new FileOutputStream(file);
                            throwable2 = null;
                            try {
                                int temp;
                                byte[] bt = new byte[10240];
                                while ((temp = input.read(bt)) != -1) {
                                    fos.write(bt, 0, temp);
                                }
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (fos == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        fos.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                fos.close();
                            }
                        }
                        catch (Exception e) {
                            rspBo.setRespCode("8888");
                            rspBo.setRespDesc("\u4e0b\u8f7d\u672c\u5730\u6587\u4ef6\u5904\u7406\u5931\u8d25\uff01" + e.getMessage());
                            throwable2 = rspBo;
                            if (input == null) return throwable2;
                            if (throwable != null) {
                                try {
                                    input.close();
                                    return throwable2;
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                    return throwable2;
                                }
                            }
                            input.close();
                            return throwable2;
                        }
                    }
                    catch (Throwable throwable6) {
                        throwable = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (input == null) continue;
                        if (throwable != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                            continue;
                        }
                        input.close();
                    }
                }
                catch (Exception e) {
                    rspBo.setRespCode("8888");
                    rspBo.setRespDesc("\u4e0b\u8f7d\u672c\u5730\u6587\u4ef6\u5904\u7406\u5931\u8d25\uff01" + e.getMessage());
                    return rspBo;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                rspBo.setRespCode("8888");
                rspBo.setRespDesc("\u4e0b\u8f7d\u672c\u5730\u6587\u4ef6\u5904\u7406\u5931\u8d25\uff01" + e.getMessage());
                return rspBo;
            }
        }
        try {
            result = this.httpUpload(this.uploadUrl, files, reqBo.getGuid());
        }
        catch (IOException e) {
            e.printStackTrace();
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5171\u4eab\u53d1\u7968\u4e0a\u4f20ocr\u5931\u8d25");
            return rspBo;
        }
        rspBo = this.parse(result);
        if (reqBo.isUpdate()) {
            return rspBo;
        }
        this.dealInsert(rspBo, reqBo);
        return rspBo;
    }

    private void dealInsert(FscFinanceInvoiceFolderUploadRspBo rspBo, FscFinanceInvoiceFolderUploadReqBo reqBo) {
        ArrayList fscInvoicePOList = new ArrayList();
        if (!CollectionUtil.isEmpty((Collection)rspBo.getData())) {
            rspBo.getData().forEach(e -> {
                FscInvoicePO fscInvoicePO = new FscInvoicePO();
                fscInvoicePO.setInvoiceId(Long.valueOf(Sequence.getInstance().nextId()));
                fscInvoicePO.setFscOrderId(reqBo.getFscOrderId());
                fscInvoicePO.setBillDate(e.getInvoiceDate());
                fscInvoicePO.setTaxAmt(new BigDecimal(e.getRmbTax()));
                fscInvoicePO.setAmt(new BigDecimal(e.getRmbAmountTax()));
                fscInvoicePO.setUntaxAmt(new BigDecimal(e.getRmbAmount()));
                fscInvoicePO.setInvoiceNo(e.getInvoiceNo());
                fscInvoicePO.setInvoiceCode(e.getInvoiceCode());
                fscInvoicePO.setBuyName(e.getBuyerName());
                fscInvoicePO.setTaxNo(e.getBuyerId());
                switch (e.getInvoiceType()) {
                    case "1010100": {
                        fscInvoicePO.setInvoiceType("00");
                        fscInvoicePO.setInvoiceCategory(FscConstants.InvoiceCategory.PAPER);
                        break;
                    }
                    case "1010101": {
                        fscInvoicePO.setInvoiceType("01");
                        fscInvoicePO.setInvoiceCategory(FscConstants.InvoiceCategory.PAPER);
                        break;
                    }
                    case "1010102": {
                        fscInvoicePO.setInvoiceType("01");
                        fscInvoicePO.setInvoiceCategory(FscConstants.InvoiceCategory.ELECTRON);
                        break;
                    }
                    case "1010107": {
                        fscInvoicePO.setInvoiceType("00");
                        fscInvoicePO.setInvoiceCategory(FscConstants.InvoiceCategory.FULL_ELECTRON);
                        break;
                    }
                    case "1010108": {
                        fscInvoicePO.setInvoiceType("03");
                        fscInvoicePO.setInvoiceCategory(FscConstants.InvoiceCategory.FULL_ELECTRON);
                        break;
                    }
                }
                fscInvoicePO.setStatus(FscConstants.FscInvoiceStatus.VALID);
                fscInvoicePO.setCreateTime(new Date());
                fscInvoicePO.setCreateOperId(String.valueOf(reqBo.getUserId()));
                fscInvoicePO.setCreateOperName(reqBo.getUserName());
                fscInvoicePO.setCreateOrgId(reqBo.getCompanyId());
                fscInvoicePO.setCreateCompanyName(reqBo.getCompanyName());
                fscInvoicePO.setUpdateTime(new Date());
                fscInvoicePO.setUpdateOperId(String.valueOf(reqBo.getUserId()));
                fscInvoicePO.setContractId(reqBo.getContractId());
                fscInvoicePO.setFinanceGuid(e.getGuid());
                fscInvoicePOList.add(fscInvoicePO);
            });
        }
        if (!CollectionUtil.isEmpty(fscInvoicePOList)) {
            this.fscInvoiceMapper.insertBatch(fscInvoicePOList);
        }
    }

    private FscFinanceInvoiceFolderUploadRspBo parse(String result) {
        FscFinanceInvoiceFolderUploadRspBo rspBO = new FscFinanceInvoiceFolderUploadRspBo();
        if (StringUtils.isEmpty((String)result)) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u6587\u4ef6\u4e0a\u4f20ocr\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        JSONObject object = JSONObject.parseObject((String)result);
        String code = object.getString("code");
        if (StringUtils.isEmpty((String)code)) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u6587\u4ef6\u4e0a\u4f20ocr\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u72b6\u6001\u7801code\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        if (!"0".equals(code)) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u6587\u4ef6\u4e0a\u4f20ocr\u63a5\u53e3\u5931\u8d25\uff1a" + object.getString("msg"));
            return rspBO;
        }
        JSONArray jsonArray = object.getJSONArray("data");
        if (jsonArray.isEmpty()) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u6587\u4ef6\u4e0a\u4f20ocr\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587data\u4e3a\u7a7a\uff1a");
            return rspBO;
        }
        String respArray = jsonArray.toJSONString();
        List list = JSONObject.parseArray((String)respArray, FscFinanceInvoiceFolderUploadRspBoData.class);
        rspBO.setData(list);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public static byte[] getBytes(String filePath) throws IOException {
        File file = new File(filePath);
        byte[] buffer = new byte[(int)file.length()];
        try (FileInputStream fis = new FileInputStream(file);){
            int bytesRead = fis.read(buffer);
            if (bytesRead != buffer.length) {
                throw new IOException("\u53ea\u8bfb\u53d6\u4e86\u90e8\u5206\u6587\u4ef6\u5185\u5bb9\uff0c\u9884\u671f=" + buffer.length + ", \u5b9e\u9645=" + bytesRead);
            }
        }
        catch (Exception e) {
            throw new IOException("\u83b7\u53d6\u6587\u4ef6\u5b57\u8282\u6d41\u5931\u8d25", e.getCause());
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String httpUpload(String actionUrl, List<File> files, String guid) throws IOException {
        String charset = "utf-8";
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost httpPost = new HttpPost(actionUrl);
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(20000).setSocketTimeout(30000).setConnectTimeout(20000).build();
        httpPost.setConfig(requestConfig);
        httpPost.setHeader("Authorization", this.fscFinanceShareRelatedInterfacesAtomService.getFinanceShareToken().getToken());
        String result = null;
        String boundary = "--------------4585696313564699";
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.RFC6532);
        multipartEntityBuilder.addPart("guid", (ContentBody)new StringBody(guid, StandardCharsets.UTF_8)).setCharset(CharsetUtils.get((String)"UTF-8"));
        for (File file : files) {
            multipartEntityBuilder.addBinaryBody("file", (InputStream)new FileInputStream(file), ContentType.MULTIPART_FORM_DATA, file.getName());
        }
        multipartEntityBuilder.setCharset(StandardCharsets.UTF_8);
        multipartEntityBuilder.setBoundary(boundary);
        HttpEntity reqEntity = multipartEntityBuilder.build();
        httpPost.setEntity(reqEntity);
        httpPost.setHeader("Content-Type", "multipart/form-data;boundary=" + boundary);
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                System.out.println("--------------------------------------");
                result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                System.out.println("Response content: " + result);
                System.out.println("--------------------------------------");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }
}

