/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl.finance;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.api.finance.FscFinanceSettleItemAddAbilityService;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceSettleItemAddAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceSettleItemAddAbilityRspBO;
import com.tydic.fsc.bill.atom.api.FscBillOrderSettleCheckAtomService;
import com.tydic.fsc.bill.atom.bo.FscBillOrderSettleCheckAtomReqBO;
import com.tydic.fsc.bill.atom.bo.FscBillOrderSettleCheckAtomRspBO;
import com.tydic.fsc.bill.busi.api.finance.FscFinanceSettleItemAddBusiService;
import com.tydic.fsc.bill.busi.bo.finance.FscFinanceSettleItemAddBusiReqBO;
import com.tydic.fsc.bill.busi.bo.finance.FscFinanceSettleItemAddBusiRspBO;
import com.tydic.fsc.busibase.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.api.FscSaleOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscSaleOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscSaleOrderListQueryAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscInvoiceCheckMapper;
import com.tydic.fsc.dao.FscOrderRelationTempMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoiceCheckPO;
import com.tydic.fsc.po.FscOrderRelationTempPO;
import com.tydic.fsc.utils.MD5Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.finance.FscFinanceSettleItemAddAbilityService"})
public class FscFinanceSettleItemAddAbilityServiceImpl
implements FscFinanceSettleItemAddAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceSettleItemAddAbilityServiceImpl.class);
    @Resource
    private FscOrderRelationTempMapper fscOrderRelationTempMapper;
    @Autowired
    private FscBillOrderSettleCheckAtomService fscBillOrderSettleCheckAtomService;
    @Autowired
    private FscAcceptOrderListQueryAtomService fscAcceptOrderListQueryAtomService;
    @Autowired
    private FscSaleOrderListQueryAtomService fscSaleOrderListQueryAtomService;
    @Autowired
    private FscInvoiceCheckMapper fscInvoiceCheckMapper;
    @Autowired
    private FscFinanceSettleItemAddBusiService fscFinanceSettleItemAddBusiService;

    @PostMapping(value={"addSettleItemTemp"})
    public FscFinanceSettleItemAddAbilityRspBO addSettleItemTemp(@RequestBody FscFinanceSettleItemAddAbilityReqBO reqBO) {
        Map fscOrderInfoBoMap;
        this.checkInput(reqBO);
        ArrayList inspectionVoucherIdList = new ArrayList();
        ArrayList<Long> orderIds = new ArrayList<Long>();
        reqBO.getRelOrderList().forEach(relOrderBO -> {
            inspectionVoucherIdList.add(relOrderBO.getAcceptOrderId());
            orderIds.add(relOrderBO.getOrderId());
        });
        FscOrderRelationTempPO fscOrderRelationTempPO = new FscOrderRelationTempPO();
        fscOrderRelationTempPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderRelationTempPO.setContractId(reqBO.getContractId());
        List relationTempPOList = this.fscOrderRelationTempMapper.getList(fscOrderRelationTempPO);
        if (!CollectionUtils.isEmpty((Collection)relationTempPOList)) {
            throw new FscBusinessException("198888", "\u5b58\u5728\u8ba2\u5355\u5df2\u6dfb\u52a0\u81f3\u5f53\u524d\u7ed3\u7b97\u5355,\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\uff01");
        }
        FscBillOrderSettleCheckAtomReqBO checkAtomReqBO = new FscBillOrderSettleCheckAtomReqBO();
        checkAtomReqBO.setOrderIds(orderIds);
        checkAtomReqBO.setSettleType(reqBO.getSettleType());
        checkAtomReqBO.setUserType(reqBO.getReceiveType());
        FscBillOrderSettleCheckAtomRspBO atomRspBO = this.fscBillOrderSettleCheckAtomService.dealOrderSettleCheck(checkAtomReqBO);
        if (!atomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
        }
        if (FscConstants.SettleType.ORDER.equals(reqBO.getSettleType())) {
            FscSaleOrderListQueryAtomReqBO fscSaleOrderListQueryAtomReqBO = new FscSaleOrderListQueryAtomReqBO();
            fscSaleOrderListQueryAtomReqBO.setOrderIds(orderIds);
            fscSaleOrderListQueryAtomReqBO.setReceiveType(reqBO.getReceiveType());
            if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType()) && FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(reqBO.getMakeType())) {
                fscSaleOrderListQueryAtomReqBO.setReceiveType(FscConstants.FscOrderReceiveType.OPERATION);
            }
            fscSaleOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.TRADE_INVOICE);
            if (FscConstants.FscOrderReceiveType.OPERATION.equals(reqBO.getReceiveType())) {
                fscSaleOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.PRO_INVOICE);
            }
            if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType()) && !FscConstants.FscOrderMakeType.OPERTION.equals(reqBO.getMakeType())) {
                fscSaleOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.MATCH_INVOICE);
            }
            if (FscConstants.FscOrderReceiveType.INDIVIDUAL.equals(reqBO.getReceiveType())) {
                fscSaleOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.INDIVIDUAL_TYPE);
            }
            fscSaleOrderListQueryAtomReqBO.setRelState(FscConstants.FscRelStatus.UNCOMMITTED);
            FscSaleOrderListQueryAtomRspBO fscSaleOrderListQueryAtomRspBO = new FscSaleOrderListQueryAtomRspBO();
            fscSaleOrderListQueryAtomRspBO = this.fscSaleOrderListQueryAtomService.qrySaleOrderList(fscSaleOrderListQueryAtomReqBO);
            if (null == fscSaleOrderListQueryAtomRspBO.getFscOrderInfoBoMap() || fscSaleOrderListQueryAtomRspBO.getFscOrderInfoBoMap().size() != inspectionVoucherIdList.size()) {
                throw new FscBusinessException("191014", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a");
            }
            fscOrderInfoBoMap = fscSaleOrderListQueryAtomRspBO.getFscOrderInfoBoMap();
        } else {
            FscAcceptOrderListQueryAtomReqBO fscAcceptOrderListQueryAtomReqBO = new FscAcceptOrderListQueryAtomReqBO();
            fscAcceptOrderListQueryAtomReqBO.setInspectionVoucherIdList(inspectionVoucherIdList);
            fscAcceptOrderListQueryAtomReqBO.setReceiveType(reqBO.getReceiveType());
            if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType()) && FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(reqBO.getMakeType())) {
                fscAcceptOrderListQueryAtomReqBO.setReceiveType(FscConstants.FscOrderReceiveType.OPERATION);
            }
            fscAcceptOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.TRADE_INVOICE);
            if (FscConstants.FscOrderReceiveType.OPERATION.equals(reqBO.getReceiveType())) {
                fscAcceptOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.PRO_INVOICE);
            }
            if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType()) && !FscConstants.FscOrderMakeType.OPERTION.equals(reqBO.getMakeType())) {
                fscAcceptOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.MATCH_INVOICE);
            }
            fscAcceptOrderListQueryAtomReqBO.setRelState(FscConstants.FscRelStatus.UNCOMMITTED);
            FscAcceptOrderListQueryAtomRspBO fscAcceptOrderListQueryAtomRspBO = this.fscAcceptOrderListQueryAtomService.query(fscAcceptOrderListQueryAtomReqBO);
            if (null == fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap() || fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap().size() != inspectionVoucherIdList.size()) {
                throw new FscBusinessException("191014", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a");
            }
            fscOrderInfoBoMap = fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap();
        }
        FscFinanceSettleItemAddBusiReqBO busiReqBO = (FscFinanceSettleItemAddBusiReqBO)((Object)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBO), FscFinanceSettleItemAddBusiReqBO.class));
        busiReqBO.setFscOrderInfoBoMap(fscOrderInfoBoMap);
        String invoiceOrderId = MD5Util.MD5Encode((String)JSONObject.toJSONString(orderIds), null);
        try {
            FscInvoiceCheckPO invoiceCheckPO = new FscInvoiceCheckPO();
            invoiceCheckPO.setOrderId(invoiceOrderId);
            invoiceCheckPO.setReceiveType(reqBO.getReceiveType());
            invoiceCheckPO.setCreateTime(new Date());
            invoiceCheckPO.setCreateUserId(reqBO.getUserId());
            int count = this.fscInvoiceCheckMapper.insert(invoiceCheckPO);
            if (count <= 0) {
                throw new FscBusinessException("198888", "\u63d2\u5165\u6570\u636e\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            log.error("\u9632\u6b62\u5e42\u7b49\u5904\u7406\u5931\u8d25\u91cd\u590d\u63d0\u7968\u5f02\u5e38\uff1a" + e);
            throw new FscBusinessException("198888", "\u5f53\u524d\u7cfb\u7edf\u5904\u7406\u7e41\u5fd9,\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
        FscFinanceSettleItemAddBusiRspBO busiRspBO = this.fscFinanceSettleItemAddBusiService.addSettleItemTemp(busiReqBO);
        this.fscInvoiceCheckMapper.deleteByIdAndType(invoiceOrderId, reqBO.getReceiveType());
        return (FscFinanceSettleItemAddAbilityRspBO)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)busiRspBO)), FscFinanceSettleItemAddAbilityRspBO.class);
    }

    private void checkInput(FscFinanceSettleItemAddAbilityReqBO reqBO) {
        if (Objects.isNull(reqBO)) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (Objects.isNull(reqBO.getFscOrderId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (Objects.isNull(reqBO.getContractId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[contractId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (Objects.isNull(reqBO.getMakeType())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[makeType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (Objects.isNull(reqBO.getReceiveType())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[receiveType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (Objects.isNull(reqBO.getSettleType())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[settleType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getRelOrderList())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u8ba2\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        reqBO.getRelOrderList().forEach(relOrderBO -> {
            if (null == relOrderBO.getAcceptOrderId()) {
                throw new FscBusinessException("191014", "\u9a8c\u6536\u5355ID\u4e3a\u7a7a");
            }
            if (null == relOrderBO.getOrderId()) {
                throw new FscBusinessException("191014", "\u8ba2\u5355ID\u4e3a\u7a7a");
            }
        });
    }
}

