/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.atom.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.atom.api.FscBillOrderRefundPayAtomService;
import com.tydic.fsc.bill.atom.bo.FscBillOrderRefundPayAtomReqBO;
import com.tydic.fsc.bill.atom.bo.FscBillOrderRefundPayAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscOrderPaymentDetailMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderShouldAmountMapper;
import com.tydic.fsc.dao.FscRefundPayItemMapper;
import com.tydic.fsc.dao.FscRefundPaymentDetailMapper;
import com.tydic.fsc.dao.FscRefundShouldAmountMapper;
import com.tydic.fsc.dao.FscRefundShouldPayDetailMapper;
import com.tydic.fsc.dao.FscRefundShouldPayMapper;
import com.tydic.fsc.dao.FscShouldPayDetailMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscOrderPaymentDetailPO;
import com.tydic.fsc.po.FscOrderRefundBO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscOrderShouldAmountPO;
import com.tydic.fsc.po.FscRefundPayItemPO;
import com.tydic.fsc.po.FscRefundPaymentDetailPO;
import com.tydic.fsc.po.FscRefundShouldAmountPO;
import com.tydic.fsc.po.FscRefundShouldPayDetailPO;
import com.tydic.fsc.po.FscRefundShouldPayPO;
import com.tydic.fsc.po.FscShouldPayDetailPO;
import com.tydic.fsc.po.FscShouldPayPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class FscBillOrderRefundPayAtomServiceImpl
implements FscBillOrderRefundPayAtomService {
    @Autowired
    private FscRefundShouldAmountMapper fscRefundShouldAmountMapper;
    @Autowired
    private FscOrderShouldAmountMapper fscOrderShouldAmountMapper;
    @Autowired
    private FscRefundShouldPayMapper fscRefundShouldPayMapper;
    @Autowired
    private FscRefundPayItemMapper fscRefundPayItemMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscOrderPaymentDetailMapper fscOrderPaymentDetailMapper;
    @Autowired
    private FscRefundShouldPayDetailMapper fscRefundShouldPayDetailMapper;
    @Autowired
    private FscShouldPayDetailMapper fscShouldPayDetailMapper;
    @Autowired
    private FscRefundPaymentDetailMapper fscRefundPaymentDetailMapper;

    @Override
    public FscBillOrderRefundPayAtomRspBO recordRefundPay(FscBillOrderRefundPayAtomReqBO reqBO) {
        this.valid(reqBO);
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getRefundId());
        refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
        if (refundPO == null) {
            throw new FscBusinessException("198888", reqBO.getRefundId() + "\u67e5\u8be2\u51b2\u9500\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getOperationType() == 1) {
            if (refundPO.getChangeAmt() == null || refundPO.getChangeAmt().compareTo(BigDecimal.ZERO) == 0) {
                this.dealRefundNew(refundPO);
            } else if (refundPO.getChangeAmt().compareTo(refundPO.getRefundAmount()) != 0) {
                this.dealRefundBack(refundPO);
                this.dealRefundNew(refundPO);
            }
        } else if (reqBO.getOperationType() == 2) {
            this.dealRefundBack(refundPO);
        }
        FscBillOrderRefundPayAtomRspBO rspBO = new FscBillOrderRefundPayAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dearRefund(FscBillOrderRefundPayAtomReqBO reqBO, FscOrderRefundPO refundPO) {
        BigDecimal writeOffAmt;
        BigDecimal shouldPayPaidAmt = BigDecimal.ZERO;
        BigDecimal toPayAmt = BigDecimal.ZERO;
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(refundPO.getFscOrderId());
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        BigDecimal bigDecimal = writeOffAmt = orderPO.getWriteOffAmount() == null ? BigDecimal.ZERO : orderPO.getWriteOffAmount();
        if (refundPO.getSettleType().equals(FscConstants.SettleType.INSPECTION)) {
            FscShouldPayPO shouldPayPO = new FscShouldPayPO();
            shouldPayPO.setObjectId(refundPO.getFscOrderId());
            shouldPayPO = this.fscShouldPayMapper.sumShouldPayInfo(shouldPayPO);
            if (!ObjectUtils.isEmpty((Object)shouldPayPO)) {
                shouldPayPaidAmt = shouldPayPO.getPaidAmount() == null ? BigDecimal.ZERO : shouldPayPO.getPaidAmount();
                toPayAmt = shouldPayPO.getShouldPayAmount().subtract(shouldPayPO.getPaidAmount());
            }
        } else {
            shouldPayPaidAmt = this.fscShouldPayMapper.sumSpecialShouldPaidAmt(orderPO.getFscOrderId());
            if (shouldPayPaidAmt == null) {
                shouldPayPaidAmt = BigDecimal.ZERO;
            }
        }
        BigDecimal changeToPayAmount = this.fscOrderRefundMapper.sumToPayAmount(refundPO.getFscOrderId(), refundPO.getRefundId());
        if (changeToPayAmount == null) {
            changeToPayAmount = BigDecimal.ZERO;
        }
        if ((toPayAmt = toPayAmt.subtract(changeToPayAmount)).compareTo(BigDecimal.ZERO) < 0) {
            toPayAmt = BigDecimal.ZERO;
        }
        if (refundPO.getRefundAmount().compareTo(toPayAmt) <= 0) {
            this.dealToPayAmount(refundPO.getRefundAmount(), refundPO);
            FscOrderRefundPO updatePo = new FscOrderRefundPO();
            updatePo.setRefundId(refundPO.getRefundId());
            updatePo.setToPayAmount(refundPO.getRefundAmount());
            updatePo.setShouldPayAmount(BigDecimal.ZERO);
            this.fscOrderRefundMapper.updateById(updatePo);
        } else if (refundPO.getRefundAmount().compareTo(toPayAmt.add(shouldPayPaidAmt)) <= 0) {
            this.dealShouldPayRefund(refundPO, toPayAmt, shouldPayPaidAmt);
        } else if (refundPO.getRefundAmount().compareTo(toPayAmt.add(shouldPayPaidAmt)) > 0) {
            this.dealPrePayRefund(refundPO, toPayAmt, shouldPayPaidAmt, writeOffAmt);
        }
    }

    private void dealToPayAmount(BigDecimal toPayAmount, FscOrderRefundPO refundPO) {
        int count;
        if (toPayAmount.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        FscShouldPayPO shouldPayPO = new FscShouldPayPO();
        shouldPayPO.setObjectId(refundPO.getFscOrderId());
        List shouldPayList = this.fscShouldPayMapper.getRefundToPayList(shouldPayPO);
        if (CollectionUtils.isEmpty((Collection)shouldPayList)) {
            return;
        }
        ArrayList<FscRefundShouldPayPO> refundShouldPayList = new ArrayList<FscRefundShouldPayPO>(shouldPayList.size());
        ArrayList<FscShouldPayPO> updateList = new ArrayList<FscShouldPayPO>(shouldPayList.size());
        for (FscShouldPayPO fscShouldPayPO : shouldPayList) {
            if (toPayAmount.compareTo(BigDecimal.ZERO) <= 0) break;
            fscShouldPayPO.setToPayAmount(fscShouldPayPO.getShouldPayAmount().subtract(fscShouldPayPO.getPaidAmount()).subtract(fscShouldPayPO.getRefundAmount()));
            FscRefundShouldPayPO refundShouldPayPO = new FscRefundShouldPayPO();
            refundShouldPayPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            refundShouldPayPO.setShouldPayId(fscShouldPayPO.getShouldPayId());
            refundShouldPayPO.setRefundId(refundPO.getRefundId());
            refundShouldPayPO.setExt1(refundPO.getFscOrderId() + "");
            if (toPayAmount.compareTo(fscShouldPayPO.getToPayAmount()) <= 0) {
                refundShouldPayPO.setAmount(toPayAmount);
                toPayAmount = BigDecimal.ZERO;
            } else {
                refundShouldPayPO.setAmount(fscShouldPayPO.getToPayAmount());
                toPayAmount = toPayAmount.subtract(fscShouldPayPO.getToPayAmount());
            }
            fscShouldPayPO.setRefundAmount(refundShouldPayPO.getAmount());
            refundShouldPayList.add(refundShouldPayPO);
            updateList.add(fscShouldPayPO);
        }
        if ((count = this.fscRefundShouldPayMapper.insertBatch(refundShouldPayList)) != refundShouldPayList.size()) {
            throw new FscBusinessException("198888", "\u4fdd\u5b58\u9000\u6b3e\u5e94\u4ed8\u4fe1\u606f\u5931\u8d25\uff01");
        }
        count = this.fscShouldPayMapper.updateRefundAmountBatch(updateList);
        if (count != updateList.size()) {
            throw new FscBusinessException("198888", "\u66f4\u65b0\u5e94\u4ed8\u51b2\u9500\u91d1\u989d\u5931\u8d25\uff01");
        }
    }

    private void dealShouldPayRefund(FscOrderRefundPO refundPO, BigDecimal toPayAmt, BigDecimal shouldPayPaidAmt) {
        BigDecimal shouldRefundAmt = refundPO.getRefundAmount().subtract(toPayAmt);
        List payItemList = this.fscOrderPayItemMapper.getRefundList(refundPO.getFscOrderId());
        ArrayList<FscOrderPayItemPO> updateItemList = new ArrayList<FscOrderPayItemPO>();
        ArrayList<FscRefundPayItemPO> refundPayItemList = new ArrayList<FscRefundPayItemPO>(payItemList.size());
        BigDecimal shouldPayAmount = BigDecimal.ZERO;
        for (FscOrderPayItemPO payItemPO : payItemList) {
            if (shouldRefundAmt.compareTo(BigDecimal.ZERO) <= 0) break;
            payItemPO.setPayAmount(payItemPO.getPayAmount().subtract(payItemPO.getRefundAmount()));
            FscRefundPayItemPO refundPayItemPO = new FscRefundPayItemPO();
            BeanUtils.copyProperties((Object)payItemPO, (Object)refundPayItemPO);
            refundPayItemPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            refundPayItemPO.setPayItemId(payItemPO.getOrderPayItemId());
            refundPayItemPO.setPayOrderId(payItemPO.getFscOrderId());
            refundPayItemPO.setRefundId(refundPO.getRefundId());
            refundPayItemPO.setFscOrderId(refundPO.getFscOrderId());
            refundPayItemPO.setCreateTime(new Date());
            if (shouldRefundAmt.compareTo(payItemPO.getPayAmount()) <= 0) {
                refundPayItemPO.setAmount(shouldRefundAmt);
                shouldRefundAmt = BigDecimal.ZERO;
            } else {
                refundPayItemPO.setAmount(payItemPO.getPayAmount());
                shouldRefundAmt = shouldRefundAmt.subtract(payItemPO.getPayAmount());
            }
            refundPayItemList.add(refundPayItemPO);
            payItemPO.setRefundAmount(refundPayItemPO.getAmount());
            shouldPayAmount = shouldPayAmount.add(refundPayItemPO.getAmount());
            updateItemList.add(payItemPO);
        }
        if (!CollectionUtils.isEmpty(refundPayItemList)) {
            int count = this.fscRefundPayItemMapper.insertBatch(refundPayItemList);
            if (count != refundPayItemList.size()) {
                throw new FscBusinessException("198888", "\u63d2\u5165\u5e94\u4ed8\u51b2\u9500\u4fe1\u606f\u5931\u8d25\uff01");
            }
            count = this.fscOrderPayItemMapper.updateRefundAmountBatch(updateItemList);
            if (count != updateItemList.size()) {
                throw new FscBusinessException("198888", "\u66f4\u65b0\u5e94\u4ed8\u51b2\u9500\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
        this.dealToPayAmount(toPayAmt, refundPO);
        FscOrderRefundPO updatePo = new FscOrderRefundPO();
        updatePo.setRefundId(refundPO.getRefundId());
        updatePo.setToPayAmount(toPayAmt);
        updatePo.setShouldPayAmount(shouldPayAmount);
        this.fscOrderRefundMapper.updateById(updatePo);
    }

    private void dealPrePayRefund(FscOrderRefundPO refundPO, BigDecimal toPayAmt, BigDecimal shouldPayPaidAmt, BigDecimal writeOffAmt) {
        this.dealShouldPayRefund(refundPO, toPayAmt, shouldPayPaidAmt);
        if (writeOffAmt.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        writeOffAmt = refundPO.getRefundAmount().subtract(toPayAmt).subtract(shouldPayPaidAmt);
        FscOrderShouldAmountPO shouldAmountPO = new FscOrderShouldAmountPO();
        shouldAmountPO.setFscOrderId(refundPO.getFscOrderId());
        List shouldAmountPOList = this.fscOrderShouldAmountMapper.getRefundList(shouldAmountPO);
        ArrayList<FscRefundShouldAmountPO> refundShouldAmountPOList = new ArrayList<FscRefundShouldAmountPO>(shouldAmountPOList.size());
        ArrayList<FscOrderShouldAmountPO> updateList = new ArrayList<FscOrderShouldAmountPO>();
        for (FscOrderShouldAmountPO fscOrderShouldAmountPO : shouldAmountPOList) {
            if (writeOffAmt.compareTo(BigDecimal.ZERO) <= 0) break;
            fscOrderShouldAmountPO.setWriteOffAmount(fscOrderShouldAmountPO.getWriteOffAmount().subtract(fscOrderShouldAmountPO.getRefundAmt()));
            if (fscOrderShouldAmountPO.getWriteOffAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
            FscRefundShouldAmountPO refundShouldAmountPO = new FscRefundShouldAmountPO();
            BeanUtils.copyProperties((Object)fscOrderShouldAmountPO, (Object)refundShouldAmountPO);
            refundShouldAmountPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            refundShouldAmountPO.setCreateTime(new Date());
            refundShouldAmountPO.setRefundId(refundPO.getRefundId());
            if (writeOffAmt.compareTo(fscOrderShouldAmountPO.getWriteOffAmount()) <= 0) {
                refundShouldAmountPO.setAmount(writeOffAmt);
                writeOffAmt = BigDecimal.ZERO;
            } else {
                refundShouldAmountPO.setAmount(fscOrderShouldAmountPO.getWriteOffAmount());
                writeOffAmt = writeOffAmt.subtract(fscOrderShouldAmountPO.getWriteOffAmount());
            }
            refundShouldAmountPOList.add(refundShouldAmountPO);
            fscOrderShouldAmountPO.setRefundAmt(refundShouldAmountPO.getAmount());
            updateList.add(fscOrderShouldAmountPO);
        }
        if (!CollectionUtils.isEmpty((Collection)shouldAmountPOList)) {
            int count = this.fscRefundShouldAmountMapper.insertBatch(refundShouldAmountPOList);
            if (count != shouldAmountPOList.size()) {
                throw new FscBusinessException("198888", "\u63d2\u5165\u91c7\u8d2d\u51b2\u9500\u6838\u9500\u4fe1\u606f\u5931\u8d25\uff01");
            }
            count = this.fscOrderShouldAmountMapper.updateRefundAmtBatch(updateList);
            if (count != updateList.size()) {
                throw new FscBusinessException("198888", "\u66f4\u65b0\u7ed3\u7b97\u6838\u9500\u51b2\u9500\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
        FscOrderRefundPO updatePo = new FscOrderRefundPO();
        updatePo.setRefundId(refundPO.getRefundId());
        updatePo.setToPayAmount(toPayAmt);
        updatePo.setShouldPayAmount(shouldPayPaidAmt);
        this.fscOrderRefundMapper.updateById(updatePo);
    }

    private void dealRefundBack(FscOrderRefundPO refundPO) {
        FscRefundShouldPayDetailPO payDetailPO = new FscRefundShouldPayDetailPO();
        payDetailPO.setRefundId(refundPO.getRefundId());
        List refundPayDetailList = this.fscRefundShouldPayDetailMapper.getList(payDetailPO);
        if (!CollectionUtils.isEmpty((Collection)refundPayDetailList)) {
            int count = this.fscRefundShouldPayDetailMapper.deleteByRefundId(refundPO.getRefundId());
            if (count != refundPayDetailList.size()) {
                throw new FscBusinessException("198888", "\u5220\u9664\u5e94\u4ed8\u51b2\u9500\u660e\u7ec6\u4fe1\u606f\u5931\u8d25\uff01");
            }
            List<FscShouldPayDetailPO> payDetailPOList = FscBillOrderRefundPayAtomServiceImpl.getDetailPOS(refundPayDetailList);
            count = this.fscShouldPayDetailMapper.updateRefundAmountBatch(payDetailPOList);
            if (count != payDetailPOList.size()) {
                throw new FscBusinessException("198888", "\u66f4\u65b0\u5e94\u4ed8\u660e\u7ec6\u4fe1\u606f\u5931\u8d25\uff01");
            }
            count = this.fscRefundShouldPayMapper.deleteByRefundId(refundPO.getRefundId());
            if (count <= 0) {
                throw new FscBusinessException("198888", "\u5220\u9664\u51b2\u9500\u4ed8\u6b3e\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
        FscRefundShouldAmountPO refundShouldAmountPO = new FscRefundShouldAmountPO();
        refundShouldAmountPO.setRefundId(refundPO.getRefundId());
        List refundShouldAmountPOList = this.fscRefundShouldAmountMapper.getList(refundShouldAmountPO);
        ArrayList<FscOrderShouldAmountPO> shouldAmountPOList = new ArrayList<FscOrderShouldAmountPO>();
        if (!CollectionUtils.isEmpty((Collection)refundShouldAmountPOList)) {
            for (FscRefundShouldAmountPO amountPO : refundShouldAmountPOList) {
                FscOrderShouldAmountPO shouldAmountPO = new FscOrderShouldAmountPO();
                BeanUtils.copyProperties((Object)amountPO, (Object)shouldAmountPO);
                shouldAmountPO.setRefundAmt(amountPO.getAmount().negate());
                shouldAmountPOList.add(shouldAmountPO);
            }
            int count = this.fscOrderShouldAmountMapper.updateRefundAmtBatch(shouldAmountPOList);
            if (count != shouldAmountPOList.size()) {
                throw new FscBusinessException("198888", "\u56de\u9000\u6838\u9500\u51b2\u9500\u91d1\u989d\u5931\u8d25\uff01");
            }
            count = this.fscRefundShouldAmountMapper.deleteByRefundId(refundPO.getRefundId());
            if (count != refundShouldAmountPOList.size()) {
                throw new FscBusinessException("198888", "\u5220\u9664\u6838\u9500\u51b2\u9500\u5173\u8054\u8868\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
        FscRefundPaymentDetailPO detailPO = new FscRefundPaymentDetailPO();
        detailPO.setRefundId(refundPO.getRefundId());
        List refundDetailList = this.fscRefundPaymentDetailMapper.getList(detailPO);
        if (!CollectionUtils.isEmpty((Collection)refundDetailList)) {
            ArrayList<FscOrderPaymentDetailPO> paymentDetailPOList = new ArrayList<FscOrderPaymentDetailPO>(refundDetailList.size());
            for (FscRefundPaymentDetailPO refundPaymentDetailPO : refundDetailList) {
                FscOrderPaymentDetailPO paymentDetailPO = new FscOrderPaymentDetailPO();
                paymentDetailPO.setPaymentDetailId(refundPaymentDetailPO.getPaymentDetailId());
                paymentDetailPO.setRefundAmount(refundPaymentDetailPO.getAmount().negate());
                paymentDetailPOList.add(paymentDetailPO);
            }
            int count = this.fscOrderPaymentDetailMapper.updateRefundAmountBatch(paymentDetailPOList);
            if (count != paymentDetailPOList.size()) {
                throw new FscBusinessException("198888", "\u66f4\u65b0\u4ed8\u6b3e\u660e\u7ec6\u51b2\u9500\u6570\u636e\u5931\u8d25\uff01");
            }
            count = this.fscRefundPaymentDetailMapper.deleteByRefundId(refundPO.getRefundId());
            if (count != refundDetailList.size()) {
                throw new FscBusinessException("198888", "\u5220\u9664\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\u5931\u8d25\uff01");
            }
            count = this.fscRefundPayItemMapper.deleteByRefundId(refundPO.getRefundId());
            if (count <= 0) {
                throw new FscBusinessException("198888", "\u5220\u9664\u4ed8\u6b3e\u51b2\u9500\u5173\u8054\u8868\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
    }

    @NotNull
    private static List<FscShouldPayDetailPO> getDetailPOS(List<FscRefundShouldPayDetailPO> refundPayDetailList) {
        ArrayList<FscShouldPayDetailPO> payDetailPOList = new ArrayList<FscShouldPayDetailPO>();
        for (FscRefundShouldPayDetailPO refundPayDetailPO : refundPayDetailList) {
            FscShouldPayDetailPO shouldPayDetailPO = new FscShouldPayDetailPO();
            shouldPayDetailPO.setId(refundPayDetailPO.getShouldPayDetailId());
            shouldPayDetailPO.setRefundAmount(refundPayDetailPO.getRefundAmount().negate());
            payDetailPOList.add(shouldPayDetailPO);
        }
        return payDetailPOList;
    }

    private void valid(FscBillOrderRefundPayAtomReqBO reqBO) {
        if (reqBO.getRefundId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getOperationType() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[operationType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void dealRefundNew(FscOrderRefundPO refundPO) {
        FscOrderShouldAmountPO fscOrderShouldAmountPO;
        FscOrderRefundBO orderRefundBO;
        FscOrderRefundBO orderRefundBO2;
        List refundBOList = this.fscOrderItemMapper.sumOrderAmtByRefundId(refundPO.getRefundId());
        HashMap<Long, FscOrderRefundBO> orderMap = new HashMap<Long, FscOrderRefundBO>(refundBOList.size());
        HashMap<Long, BigDecimal> refundAmtMap = new HashMap<Long, BigDecimal>(refundBOList.size());
        for (FscOrderRefundBO orderRefundBO3 : refundBOList) {
            orderMap.put(orderRefundBO3.getOrderId(), orderRefundBO3);
            refundAmtMap.put(orderRefundBO3.getOrderId(), orderRefundBO3.getRefundAmt());
        }
        ArrayList<FscShouldPayDetailPO> paydetailUpdList = new ArrayList<FscShouldPayDetailPO>();
        HashMap<Long, FscShouldPayPO> shouldPayUpdList = new HashMap<Long, FscShouldPayPO>();
        List payDetailPOList = new ArrayList();
        Map<Object, Object> writeOffMap = new HashMap();
        if (refundPO.getSettleType().equals(FscConstants.SettleType.INSPECTION)) {
            payDetailPOList = this.fscShouldPayDetailMapper.qryRefundList(refundPO.getFscOrderId(), orderMap.keySet());
        } else {
            payDetailPOList = this.fscShouldPayDetailMapper.qryOrderRefundList(refundPO.getFscOrderId(), orderMap.keySet());
            List writeOffList = this.fscOrderShouldAmountMapper.sumWriteOffAmtByFscOrderInfo(refundPO.getFscOrderId(), orderMap.keySet());
            writeOffMap = writeOffList.stream().collect(Collectors.toMap(FscOrderShouldAmountPO::getOrderId, FscOrderShouldAmountPO::getWriteOffAmount));
        }
        ArrayList<Long> shouldPayIds = new ArrayList<Long>();
        BigDecimal toPayAmt = BigDecimal.ZERO;
        for (FscShouldPayDetailPO fscShouldPayDetailPO : payDetailPOList) {
            FscShouldPayPO shouldPayPO;
            FscOrderRefundBO orderRefundBO4;
            shouldPayIds.add(fscShouldPayDetailPO.getShouldPayId());
            fscShouldPayDetailPO.setToPayAmt(fscShouldPayDetailPO.getShouldPayAmt().subtract(fscShouldPayDetailPO.getPayAmount()).subtract(fscShouldPayDetailPO.getRefundAmount()));
            if (refundPO.getSettleType().equals(FscConstants.SettleType.ORDER) && writeOffMap.get(fscShouldPayDetailPO.getOrderId()) != null) {
                fscShouldPayDetailPO.setToPayAmt(fscShouldPayDetailPO.getToPayAmt().subtract((BigDecimal)writeOffMap.get(fscShouldPayDetailPO.getOrderId())));
            }
            if (fscShouldPayDetailPO.getToPayAmt().compareTo(BigDecimal.ZERO) <= 0 || (orderRefundBO4 = (FscOrderRefundBO)orderMap.get(fscShouldPayDetailPO.getOrderId())) == null) continue;
            if (orderRefundBO4.getRefundAmt().compareTo(fscShouldPayDetailPO.getToPayAmt()) <= 0) {
                fscShouldPayDetailPO.setRefundAmount(orderRefundBO4.getRefundAmt());
                paydetailUpdList.add(fscShouldPayDetailPO);
                toPayAmt = toPayAmt.add(orderRefundBO4.getRefundAmt());
                orderMap.remove(orderRefundBO4.getOrderId());
                if (shouldPayUpdList.containsKey(fscShouldPayDetailPO.getShouldPayId())) {
                    shouldPayPO = (FscShouldPayPO)shouldPayUpdList.get(fscShouldPayDetailPO.getShouldPayId());
                    shouldPayPO.setRefundAmount(shouldPayPO.getRefundAmount().add(orderRefundBO4.getRefundAmt()));
                } else {
                    shouldPayPO = new FscShouldPayPO();
                    shouldPayPO.setShouldPayId(fscShouldPayDetailPO.getShouldPayId());
                    shouldPayPO.setRefundAmount(orderRefundBO4.getRefundAmt());
                }
                shouldPayUpdList.put(fscShouldPayDetailPO.getShouldPayId(), shouldPayPO);
                continue;
            }
            fscShouldPayDetailPO.setRefundAmount(fscShouldPayDetailPO.getToPayAmt());
            paydetailUpdList.add(fscShouldPayDetailPO);
            toPayAmt = toPayAmt.add(fscShouldPayDetailPO.getToPayAmt());
            orderRefundBO4.setRefundAmt(orderRefundBO4.getRefundAmt().subtract(fscShouldPayDetailPO.getToPayAmt()));
            orderMap.put(orderRefundBO4.getOrderId(), orderRefundBO4);
            if (shouldPayUpdList.containsKey(fscShouldPayDetailPO.getShouldPayId())) {
                shouldPayPO = (FscShouldPayPO)shouldPayUpdList.get(fscShouldPayDetailPO.getShouldPayId());
                shouldPayPO.setRefundAmount(shouldPayPO.getRefundAmount().add(fscShouldPayDetailPO.getToPayAmt()));
            } else {
                shouldPayPO = new FscShouldPayPO();
                shouldPayPO.setShouldPayId(fscShouldPayDetailPO.getShouldPayId());
                shouldPayPO.setRefundAmount(fscShouldPayDetailPO.getToPayAmt());
            }
            shouldPayUpdList.put(fscShouldPayDetailPO.getShouldPayId(), shouldPayPO);
        }
        refundPO.setToPayAmount(toPayAmt);
        if (CollectionUtils.isEmpty(orderMap.keySet())) {
            this.dealUpdateToPayInfo(paydetailUpdList, shouldPayUpdList, refundPO);
            return;
        }
        ArrayList<FscOrderPaymentDetailPO> updPaymentList = new ArrayList<FscOrderPaymentDetailPO>();
        BigDecimal shouldPayAmt = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(shouldPayIds)) {
            FscOrderPaymentDetailPO fscOrderPaymentDetailPO = new FscOrderPaymentDetailPO();
            fscOrderPaymentDetailPO.setShouldPayIds(shouldPayIds);
            fscOrderPaymentDetailPO.setOrderIds(orderMap.keySet());
            List paymentDetailPOList = this.fscOrderPaymentDetailMapper.getRefundList(fscOrderPaymentDetailPO);
            for (FscOrderPaymentDetailPO paymentDetailPO : paymentDetailPOList) {
                paymentDetailPO.setOrderAmount((BigDecimal)refundAmtMap.get(paymentDetailPO.getOrderId()));
                paymentDetailPO.setPayAmount(paymentDetailPO.getPayAmount().subtract(paymentDetailPO.getRefundAmount()));
                if (paymentDetailPO.getPayAmount().compareTo(BigDecimal.ZERO) <= 0 || (orderRefundBO2 = (FscOrderRefundBO)orderMap.get(paymentDetailPO.getOrderId())) == null || orderRefundBO2.getRefundAmt().compareTo(BigDecimal.ZERO) <= 0) continue;
                if (paymentDetailPO.getPayAmount().compareTo(orderRefundBO2.getRefundAmt()) >= 0) {
                    paymentDetailPO.setRefundAmount(orderRefundBO2.getRefundAmt());
                    updPaymentList.add(paymentDetailPO);
                    shouldPayAmt = shouldPayAmt.add(orderRefundBO2.getRefundAmt());
                    orderMap.remove(paymentDetailPO.getOrderId());
                    continue;
                }
                paymentDetailPO.setRefundAmount(paymentDetailPO.getPayAmount());
                updPaymentList.add(paymentDetailPO);
                shouldPayAmt = shouldPayAmt.add(paymentDetailPO.getPayAmount());
                orderRefundBO2.setRefundAmt(orderRefundBO2.getRefundAmt().subtract(paymentDetailPO.getPayAmount()));
                orderMap.put(paymentDetailPO.getOrderId(), orderRefundBO2);
            }
        }
        refundPO.setShouldPayAmount(shouldPayAmt);
        if (CollectionUtils.isEmpty(orderMap)) {
            this.dealUpdateToPayInfo(paydetailUpdList, shouldPayUpdList, refundPO);
            this.dealUpdateShouldPayInfo(updPaymentList, refundPO);
            return;
        }
        FscOrderShouldAmountPO shouldAmountPO = new FscOrderShouldAmountPO();
        shouldAmountPO.setFscOrderId(refundPO.getFscOrderId());
        shouldAmountPO.setOrderIds(orderMap.keySet());
        List shouldAmountPOList = this.fscOrderShouldAmountMapper.getRefundList(shouldAmountPO);
        ArrayList<FscRefundShouldAmountPO> refundShouldAmountPOList = new ArrayList<FscRefundShouldAmountPO>(shouldAmountPOList.size());
        ArrayList<FscOrderShouldAmountPO> updateList = new ArrayList<FscOrderShouldAmountPO>();
        orderRefundBO2 = shouldAmountPOList.iterator();
        while (orderRefundBO2.hasNext() && (orderRefundBO = (FscOrderRefundBO)orderMap.get((fscOrderShouldAmountPO = (FscOrderShouldAmountPO)orderRefundBO2.next()).getOrderId())).getRefundAmt().compareTo(BigDecimal.ZERO) > 0) {
            fscOrderShouldAmountPO.setWriteOffAmount(fscOrderShouldAmountPO.getWriteOffAmount().subtract(fscOrderShouldAmountPO.getRefundAmt()));
            if (fscOrderShouldAmountPO.getWriteOffAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
            FscRefundShouldAmountPO refundShouldAmountPO = new FscRefundShouldAmountPO();
            BeanUtils.copyProperties((Object)fscOrderShouldAmountPO, (Object)refundShouldAmountPO);
            refundShouldAmountPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            refundShouldAmountPO.setCreateTime(new Date());
            refundShouldAmountPO.setRefundId(refundPO.getRefundId());
            if (orderRefundBO.getRefundAmt().compareTo(fscOrderShouldAmountPO.getWriteOffAmount()) <= 0) {
                refundShouldAmountPO.setAmount(orderRefundBO.getRefundAmt());
                orderMap.remove(orderRefundBO.getOrderId());
            } else {
                refundShouldAmountPO.setAmount(fscOrderShouldAmountPO.getWriteOffAmount());
                orderRefundBO.setRefundAmt(orderRefundBO.getRefundAmt().subtract(fscOrderShouldAmountPO.getWriteOffAmount()));
                orderMap.put(orderRefundBO.getOrderId(), orderRefundBO);
            }
            if (fscOrderShouldAmountPO.getOrderId() != null) {
                refundShouldAmountPO.setExt1(fscOrderShouldAmountPO.getOrderId().toString());
            }
            refundShouldAmountPOList.add(refundShouldAmountPO);
            fscOrderShouldAmountPO.setRefundAmt(refundShouldAmountPO.getAmount());
            updateList.add(fscOrderShouldAmountPO);
        }
        this.dealUpdateToPayInfo(paydetailUpdList, shouldPayUpdList, refundPO);
        this.dealUpdateShouldPayInfo(updPaymentList, refundPO);
        if (!CollectionUtils.isEmpty((Collection)shouldAmountPOList)) {
            int count = this.fscRefundShouldAmountMapper.insertBatch(refundShouldAmountPOList);
            if (count != shouldAmountPOList.size()) {
                throw new FscBusinessException("198888", "\u63d2\u5165\u91c7\u8d2d\u51b2\u9500\u6838\u9500\u4fe1\u606f\u5931\u8d25\uff01");
            }
            count = this.fscOrderShouldAmountMapper.updateRefundAmtBatch(updateList);
            if (count != updateList.size()) {
                throw new FscBusinessException("198888", "\u66f4\u65b0\u7ed3\u7b97\u6838\u9500\u51b2\u9500\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
    }

    private void dealUpdateShouldPayInfo(List<FscOrderPaymentDetailPO> updPaymentList, FscOrderRefundPO refundPO) {
        if (CollectionUtils.isEmpty(updPaymentList)) {
            return;
        }
        FscOrderRefundPO updatePo = new FscOrderRefundPO();
        updatePo.setRefundId(refundPO.getRefundId());
        updatePo.setToPayAmount(refundPO.getToPayAmount());
        updatePo.setShouldPayAmount(refundPO.getShouldPayAmount());
        this.fscOrderRefundMapper.updateById(updatePo);
        ArrayList<FscRefundPaymentDetailPO> refundDetailList = new ArrayList<FscRefundPaymentDetailPO>();
        HashMap<Long, FscRefundPayItemPO> payItemPOMap = new HashMap<Long, FscRefundPayItemPO>();
        for (FscOrderPaymentDetailPO fscOrderPaymentDetailPO : updPaymentList) {
            FscRefundPaymentDetailPO refundPaymentDetailPO = new FscRefundPaymentDetailPO();
            BeanUtils.copyProperties((Object)fscOrderPaymentDetailPO, (Object)refundPaymentDetailPO);
            refundPaymentDetailPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            refundPaymentDetailPO.setRefundId(refundPO.getRefundId());
            refundPaymentDetailPO.setPayOrderId(fscOrderPaymentDetailPO.getPayOrderId());
            refundPaymentDetailPO.setExt1(fscOrderPaymentDetailPO.getOrderPayItemId() + "");
            refundPaymentDetailPO.setAmount(fscOrderPaymentDetailPO.getRefundAmount());
            refundPaymentDetailPO.setOrderAmt(fscOrderPaymentDetailPO.getOrderAmount());
            refundDetailList.add(refundPaymentDetailPO);
            FscRefundPayItemPO refundPayItemPO = (FscRefundPayItemPO)payItemPOMap.get(fscOrderPaymentDetailPO.getOrderPayItemId());
            if (refundPayItemPO == null) {
                refundPayItemPO = new FscRefundPayItemPO();
                BeanUtils.copyProperties((Object)fscOrderPaymentDetailPO, (Object)refundPayItemPO);
                refundPayItemPO.setAmount(fscOrderPaymentDetailPO.getRefundAmount());
                refundPayItemPO.setFscOrderId(refundPO.getFscOrderId());
                refundPayItemPO.setRefundId(refundPO.getRefundId());
                refundPayItemPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                refundPayItemPO.setPayItemId(fscOrderPaymentDetailPO.getOrderPayItemId());
                payItemPOMap.put(fscOrderPaymentDetailPO.getOrderPayItemId(), refundPayItemPO);
                continue;
            }
            refundPayItemPO.setAmount(refundPayItemPO.getAmount().add(fscOrderPaymentDetailPO.getRefundAmount()));
            payItemPOMap.put(fscOrderPaymentDetailPO.getOrderPayItemId(), refundPayItemPO);
        }
        ArrayList refundPayItemPOList = new ArrayList();
        for (Long key : payItemPOMap.keySet()) {
            refundPayItemPOList.add(payItemPOMap.get(key));
        }
        int n = this.fscRefundPayItemMapper.insertBatch(refundPayItemPOList);
        if (n != refundPayItemPOList.size()) {
            throw new FscBusinessException("198888", "\u63d2\u5165\u51b2\u9500\u4ed8\u6b3e\u5173\u8054\u4fe1\u606f\u5931\u8d25\uff01");
        }
        int n2 = this.fscRefundPaymentDetailMapper.insertBatch(refundDetailList);
        if (n2 != refundDetailList.size()) {
            throw new FscBusinessException("198888", "\u63d2\u5165\u51b2\u9500\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\u5931\u8d25\uff01");
        }
        int n3 = this.fscOrderPaymentDetailMapper.updateRefundAmountBatch(updPaymentList);
        if (n3 != updPaymentList.size()) {
            throw new FscBusinessException("198888", "\u66f4\u65b0\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\u5931\u8d25\uff01");
        }
    }

    private void dealUpdateToPayInfo(List<FscShouldPayDetailPO> paydetailUpdList, Map<Long, FscShouldPayPO> shouldPayUpdList, FscOrderRefundPO refundPO) {
        if (!CollectionUtils.isEmpty(paydetailUpdList)) {
            int count = this.fscShouldPayDetailMapper.updateRefundAmountBatch(paydetailUpdList);
            if (count != paydetailUpdList.size()) {
                throw new FscBusinessException("198888", "\u66f4\u65b0\u5e94\u4ed8\u660e\u7ec6\u4fe1\u606f\u5931\u8d25\uff01");
            }
            ArrayList<FscRefundShouldPayDetailPO> refundShouldPayDetailPOList = new ArrayList<FscRefundShouldPayDetailPO>();
            for (FscShouldPayDetailPO fscShouldPayDetailPO : paydetailUpdList) {
                FscRefundShouldPayDetailPO refundDetailPO = new FscRefundShouldPayDetailPO();
                BeanUtils.copyProperties((Object)fscShouldPayDetailPO, (Object)refundDetailPO);
                refundDetailPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                refundDetailPO.setFscOrderId(refundPO.getFscOrderId());
                refundDetailPO.setShouldPayDetailId(fscShouldPayDetailPO.getId());
                refundDetailPO.setRefundId(refundPO.getRefundId());
                refundShouldPayDetailPOList.add(refundDetailPO);
            }
            count = this.fscRefundShouldPayDetailMapper.insertBatch(refundShouldPayDetailPOList);
            if (count != refundShouldPayDetailPOList.size()) {
                throw new FscBusinessException("198888", "\u63d2\u5165\u5e94\u4ed8\u51b2\u9500\u660e\u7ec6\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
        if (!CollectionUtils.isEmpty(shouldPayUpdList)) {
            ArrayList<FscShouldPayPO> updateList = new ArrayList<FscShouldPayPO>();
            ArrayList<FscRefundShouldPayPO> refundShouldPayPOList = new ArrayList<FscRefundShouldPayPO>();
            for (Long key : shouldPayUpdList.keySet()) {
                FscShouldPayPO shouldPayPO = shouldPayUpdList.get(key);
                updateList.add(shouldPayPO);
                FscRefundShouldPayPO refundShouldPayPO = new FscRefundShouldPayPO();
                refundShouldPayPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                refundShouldPayPO.setRefundId(refundPO.getRefundId());
                refundShouldPayPO.setAmount(shouldPayPO.getRefundAmount());
                refundShouldPayPO.setShouldPayId(shouldPayPO.getShouldPayId());
                refundShouldPayPO.setExt1(refundPO.getFscOrderId() + "");
                refundShouldPayPO.setExt2(refundPO.getFscOrderNo());
                refundShouldPayPOList.add(refundShouldPayPO);
            }
            int count = this.fscShouldPayMapper.updateRefundAmountBatch(updateList);
            if (count != updateList.size()) {
                throw new FscBusinessException("198888", "\u66f4\u65b0\u5e94\u4ed8\u672a\u4ed8\u6b3e\u51b2\u9500\u91d1\u989d\u5931\u8d25\uff01");
            }
            count = this.fscRefundShouldPayMapper.insertBatch(refundShouldPayPOList);
            if (count != refundShouldPayPOList.size()) {
                throw new FscBusinessException("198888", "\u63d2\u5165\u9000\u6b3e\u5e94\u4ed8\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
        FscOrderRefundPO updatePO = new FscOrderRefundPO();
        updatePO.setRefundId(refundPO.getRefundId());
        updatePO.setToPayAmount(refundPO.getToPayAmount());
        updatePO.setShouldPayAmount(BigDecimal.ZERO);
        this.fscOrderRefundMapper.updateById(updatePO);
    }
}

