/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.tydic.fsc.bill.busi.api.FscComOrderRefundRejectBusiService;
import com.tydic.fsc.bill.busi.bo.FscComOrderRefundRejectBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscComOrderRefundRejectBusiRspBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscComOrderRefundRejectBusiServiceImpl
implements FscComOrderRefundRejectBusiService {
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    private static final String BUSI_NAME = "\u62d2\u7edd\u9000\u7968";
    @Value(value="${OPERATION_SUP_ID:1001693}")
    private String operationSupId;

    @Override
    @FscDuplicateCommitLimit
    public FscComOrderRefundRejectBusiRspBO dealOrderRefundReject(FscComOrderRefundRejectBusiReqBO reqBO) {
        if (reqBO.getRefundId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getRefundId());
        refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
        if (refundPO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u9000\u7968\u4e3b\u5355\u4fe1\u606f\uff01");
        }
        if (!(refundPO.getRefundStatus().equals(FscConstants.RefundInvoiceStatus.TO_REFUND) || refundPO.getRefundStatus().equals(FscConstants.RefundInvoiceStatus.APPROVAL_REJECT) || refundPO.getRefundStatus().equals(FscConstants.RefundInvoiceStatus.YC_REJECT))) {
            throw new FscBusinessException("198888", "\u5355\u636e\uff1a" + refundPO.getRefundNo() + "\u5f53\u524d\u9000\u7968\u5355\u636e\u72b6\u6001\u4e0d\u80fd\u8fdb\u884c\u62d2\u7edd\u64cd\u4f5c\uff01");
        }
        FscOrderRefundPO updatePo = new FscOrderRefundPO();
        updatePo.setRejectReason(reqBO.getRejectReason());
        updatePo.setRefundId(reqBO.getRefundId());
        if (FscConstants.AuditStatus.AUDIT_REJECT.equals(refundPO.getAuditStatus()) && (refundPO.getMakeType().equals(FscConstants.FscOrderMakeType.OPERTION) || this.operationSupId.equals(String.valueOf(refundPO.getSupplierId())))) {
            updatePo.setAuditStatus(FscConstants.AuditStatus.SAVE);
        }
        this.fscOrderRefundMapper.updateById(updatePo);
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
        fscOrderStatusFlowAtomReqBO.setOrderId(refundPO.getRefundId());
        fscOrderStatusFlowAtomReqBO.setCurStatus(refundPO.getRefundStatus());
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("confirmFlag", FscConstants.BillOrderConfirmFlag.REJECT);
        fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealRefundStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!fscOrderStatusFlowAtomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(fscOrderStatusFlowAtomRspBO.getRespCode(), fscOrderStatusFlowAtomRspBO.getRespDesc());
        }
        FscComOrderRefundRejectBusiRspBO rspBO = new FscComOrderRefundRejectBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

