/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl.finance;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.authority.busi.bo.UserBO;
import com.tydic.fsc.bill.busi.api.finance.FscFinancePurInvoiceSignApplyBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceSignWriteOffBusiReqBO;
import com.tydic.fsc.bill.busi.bo.finance.FscFinancePurInvoiceSignApplyBusiReqBO;
import com.tydic.fsc.bill.busi.bo.finance.FscFinancePurInvoiceSignApplyBusiRspBO;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscApprovalTaskQueryBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.api.FscSendNotificationExtAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscSendNotificationExtAtomReqBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.FscPayVerificationAbilityService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscInvoiceCheckResultMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.task.service.TaskTodoWaitService;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscInvoiceCheckResultPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscTaskCandidatePO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgNameListQryAbilityService;
import com.tydic.uoc.common.ability.api.UocSalesSingleDetailsListQueryAbilityService;
import com.tydic.uoc.common.ability.bo.UocPebChildOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocPebUpperOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocPhasePayListBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscFinancePurInvoiceSignApplyBusiServiceImpl
implements FscFinancePurInvoiceSignApplyBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscFinancePurInvoiceSignApplyBusiServiceImpl.class);
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscInvoiceCheckResultMapper fscInvoiceCheckResultMapper;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Autowired
    private FscSendNotificationExtAtomService fscSendNotificationExtAtomService;
    private static final String BUSI_NAME = "\u53d1\u7968\u7b7e\u6536\u7533\u8bf7";
    @Value(value="${saleOrderTabId:30001}")
    private Integer SALE_ORDER_TAB_ID;
    @Value(value="${fsc.main.pro.org:100096,100100}")
    private String proOrg;
    @Autowired
    private UmcEnterpriseOrgNameListQryAbilityService umcEnterpriseOrgNameListQryAbilityService;
    @Autowired
    private FscPayVerificationAbilityService fscPayVerificationAbilityService;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private UocSalesSingleDetailsListQueryAbilityService uocSalesSingleDetailsListQueryAbilityService;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Resource
    private FscOrderFinanceMapper fscOrderFinanceMapper;

    @Override
    public FscFinancePurInvoiceSignApplyBusiRspBO dealPurInvoiceSignApply(FscFinancePurInvoiceSignApplyBusiReqBO reqBO) {
        if (Objects.nonNull(reqBO.getBizDeptCode()) || Objects.nonNull(reqBO.getCashItemCode()) || Objects.nonNull(reqBO.getCashDetailCode())) {
            FscOrderFinancePO fscOrderFinancePO = new FscOrderFinancePO();
            fscOrderFinancePO.setFscOrderId(reqBO.getOrderId());
            fscOrderFinancePO.setBizDeptCode(reqBO.getBizDeptCode());
            fscOrderFinancePO.setBizDeptName(reqBO.getBizDeptName());
            fscOrderFinancePO.setCashItemCode(reqBO.getCashItemCode());
            fscOrderFinancePO.setCashItemName(reqBO.getCashItemName());
            fscOrderFinancePO.setCashDetailCode(reqBO.getCashDetailCode());
            fscOrderFinancePO.setCashDetailName(reqBO.getCashDetailName());
            this.fscOrderFinanceMapper.updateById(fscOrderFinancePO);
        }
        FscInvoiceCheckResultPO fscInvoiceCheckResultPO = new FscInvoiceCheckResultPO();
        fscInvoiceCheckResultPO.setFscOrderId(reqBO.getOrderId());
        this.fscInvoiceCheckResultMapper.deleteBy(fscInvoiceCheckResultPO);
        if (null != reqBO.getInvoiceCmpResult()) {
            fscInvoiceCheckResultPO.setAmountMargin(reqBO.getInvoiceCmpResult().getAmountMargin());
            fscInvoiceCheckResultPO.setCmpResult(reqBO.getInvoiceCmpResult().getCmpResultStr());
            fscInvoiceCheckResultPO.setIteNumMargin(reqBO.getInvoiceCmpResult().getItemNumMargin());
            fscInvoiceCheckResultPO.setUntaxAmtMargin(reqBO.getInvoiceCmpResult().getUntaxAmtMargin());
            fscInvoiceCheckResultPO.setTaxMargin(reqBO.getInvoiceCmpResult().getTaxMargin());
            fscInvoiceCheckResultPO.setCreateOperId(reqBO.getUserId());
            fscInvoiceCheckResultPO.setCreateOperName(reqBO.getName());
            fscInvoiceCheckResultPO.setCreateTime(new Date());
            fscInvoiceCheckResultPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscInvoiceCheckResultPO.setFscOrderId(reqBO.getOrderId());
            this.fscInvoiceCheckResultMapper.insert(fscInvoiceCheckResultPO);
        }
        this.fscOrderMapper.deleteOrderAmount(reqBO.getOrderId());
        BigDecimal writeOffAmt = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(reqBO.getPurWriteOffAmountList())) {
            for (FscBillOrderInvoiceSignWriteOffBusiReqBO writeOffBusiBO : reqBO.getPurWriteOffAmountList()) {
                FscOrderPO tempPo = new FscOrderPO();
                tempPo.setFscOrderId(reqBO.getOrderId());
                tempPo.setShouldPayId(writeOffBusiBO.getShouldPayId());
                tempPo.setWriteOffAmount(writeOffBusiBO.getWriteOffAmount());
                tempPo.setPayOrderId(writeOffBusiBO.getPayOrderId().toString());
                tempPo.setWriteOffDate(new Date());
                tempPo.setContractId(writeOffBusiBO.getContractId());
                writeOffAmt = writeOffAmt.add(writeOffBusiBO.getWriteOffAmount());
                this.fscOrderMapper.insertOrderAmount(tempPo);
            }
        }
        if (writeOffAmt.compareTo(BigDecimal.ZERO) > 0) {
            this.checkWriteOffAmt(writeOffAmt, reqBO.getOrderId(), reqBO.getPurWriteOffAmountList());
        }
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
        fscOrderStatusFlowAtomReqBO.setOrderId(reqBO.getOrderId());
        fscOrderStatusFlowAtomReqBO.setCurStatus(reqBO.getCurStatus());
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>(4);
        paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag);
        fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!"0000".equals(fscOrderStatusFlowAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193011", fscOrderStatusFlowAtomRspBO.getRespDesc());
        }
        this.invokeUacTask(reqBO);
        FscTaskCandidatePO taskPo = new FscTaskCandidatePO();
        taskPo.setFscOrderId(reqBO.getOrderId());
        List pendAuditPostIdList = this.fscTaskCandidateMapper.getPendAuditPostIdList(taskPo);
        FscOrderPO set = new FscOrderPO();
        FscOrderPO where = new FscOrderPO();
        set.setSignApplyTime(new Date());
        if (!CollectionUtils.isEmpty((Collection)pendAuditPostIdList)) {
            where.setFscOrderId(reqBO.getOrderId());
            List auditedPostIdList = pendAuditPostIdList.stream().map(FscApprovalTaskQueryBO::getTaskOperId).distinct().collect(Collectors.toList());
            set.setSignStation(Joiner.on((String)",").join(auditedPostIdList) + ",");
        }
        this.fscOrderMapper.deleteOrderSignTemp(reqBO.getOrderId());
        FscOrderPO fscSignTemp = (FscOrderPO)JSON.parseObject((String)JSONObject.toJSONString((Object)((Object)reqBO)), FscOrderPO.class);
        fscSignTemp.setFscOrderId(reqBO.getOrderId());
        FscInvoicePO fscInvoicePO = new FscInvoicePO();
        fscInvoicePO.setFscOrderId(reqBO.getOrderId());
        List invoicePOList = this.fscInvoiceMapper.getList(fscInvoicePO);
        if (!CollectionUtils.isEmpty((Collection)invoicePOList)) {
            StringBuilder invoiceNo = new StringBuilder();
            StringBuilder invoiceCode = new StringBuilder();
            for (FscInvoicePO i : invoicePOList) {
                invoiceNo.append(",").append(i.getInvoiceNo());
                invoiceCode.append(",").append(i.getInvoiceCode());
            }
            set.setInvoiceNo(invoiceNo.toString());
            set.setInvoiceCode(invoiceCode.toString());
            set.setBuyName(((FscInvoicePO)invoicePOList.get(0)).getBuyName());
            fscSignTemp.setInvoiceNo(invoiceNo.toString());
        }
        this.fscOrderMapper.insertOrderSignTemp(fscSignTemp);
        if (where.getFscOrderId() == null) {
            throw new FscBusinessException("190000", "\u7ed3\u7b97\u5355ID\u4e0d\u53ef\u4e3a\u7a7a");
        }
        this.fscOrderMapper.updateBy(set, where);
        this.checkAmtTax(invoicePOList, reqBO.getOrderId());
        FscFinancePurInvoiceSignApplyBusiRspBO rspBO = new FscFinancePurInvoiceSignApplyBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void checkWriteOffAmt(BigDecimal writeOffAmt, Long fscOrderId, List<FscBillOrderInvoiceSignWriteOffBusiReqBO> purWriteOffAmountList) {
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(fscOrderId);
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        FscOrderRelationPO relationPO = new FscOrderRelationPO();
        relationPO.setFscOrderId(fscOrderId);
        List orderRelationPOS = this.fscOrderRelationMapper.getList(relationPO);
        Long orderId = ((FscOrderRelationPO)orderRelationPOS.get(0)).getOrderId();
        UocSalesSingleDetailsListQueryReqBO saleDetailsReqBO = new UocSalesSingleDetailsListQueryReqBO();
        saleDetailsReqBO.setOrderId(orderId);
        saleDetailsReqBO.setTabId(this.SALE_ORDER_TAB_ID);
        saleDetailsReqBO.setIndividually("1");
        UocSalesSingleDetailsListQueryRspBO saleDetailsRspBO = this.uocSalesSingleDetailsListQueryAbilityService.getUocSalesSingleDetailsListQuery(saleDetailsReqBO);
        if (!saleDetailsRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(saleDetailsRspBO.getRespCode(), "\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25:" + saleDetailsRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)saleDetailsRspBO.getRows())) {
            throw new FscBusinessException("194203", "\u672a\u67e5\u8be2\u5230\u9500\u552e\u5355\u4fe1\u606f");
        }
        BigDecimal shouldPayRadio = BigDecimal.ZERO;
        if (((UocPebChildOrderAbilityBO)((UocPebUpperOrderAbilityBO)saleDetailsRspBO.getRows().get(0)).getChildOrderList().get(0)).getProPayType() != null && ((UocPebChildOrderAbilityBO)((UocPebUpperOrderAbilityBO)saleDetailsRspBO.getRows().get(0)).getChildOrderList().get(0)).getProPayType().equals(FscConstants.FscPayType.FSC_PAY_TYPE_STAGE) && !CollectionUtils.isEmpty((Collection)((UocPebChildOrderAbilityBO)((UocPebUpperOrderAbilityBO)saleDetailsRspBO.getRows().get(0)).getChildOrderList().get(0)).getProPayList())) {
            List proPayList = ((UocPebChildOrderAbilityBO)((UocPebUpperOrderAbilityBO)saleDetailsRspBO.getRows().get(0)).getChildOrderList().get(0)).getProPayList();
            for (UocPhasePayListBO uocPhasePayListBO : proPayList) {
                if (!uocPhasePayListBO.getPayType().equals(FscConstants.PaymentMethod.SHOULD_PAY) && !uocPhasePayListBO.getPayType().equals(FscConstants.PaymentMethod.DEPOSIT)) continue;
                shouldPayRadio = shouldPayRadio.add(uocPhasePayListBO.getNodePayRatio());
            }
        }
        if (shouldPayRadio.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        if (orderPO.getSettleType() != null && orderPO.getSettleType().equals(FscConstants.SettleType.ORDER)) {
            shouldPayRadio = BigDecimal.ONE;
        }
        BigDecimal shouldPayAmount = orderPO.getTotalCharge().multiply(shouldPayRadio).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP);
        BigDecimal shouldWriteOffAmount = orderPO.getTotalCharge().subtract(shouldPayAmount).setScale(2, RoundingMode.HALF_UP);
        if (writeOffAmt.compareTo(shouldWriteOffAmount) > 0) {
            throw new FscBusinessException("198888", "\u6838\u9500\u91d1\u989d[" + writeOffAmt + "]\u4e0d\u80fd\u5927\u4e8e\u7ed3\u7b97\u9884\u4ed8\u6bd4\u4f8b\u91d1\u989d[" + shouldWriteOffAmount + "]\u3002");
        }
    }

    private void invokeUacTask(FscFinancePurInvoiceSignApplyBusiReqBO reqBO) {
        UacNoTaskAuditCreateReqBO auditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        auditCreateReqBO.setCreateOperId(reqBO.getUserId().toString());
        auditCreateReqBO.setCreateOperName(reqBO.getName());
        auditCreateReqBO.setCreateOperDept(reqBO.getOrgName());
        auditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        if (reqBO.getBusiCode() != null) {
            auditCreateReqBO.setProcDefKey(reqBO.getBusiCode());
        } else {
            auditCreateReqBO.setMenuId("M001014");
        }
        auditCreateReqBO.setOrgId(String.valueOf(reqBO.getOrgId()));
        ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.ORDER_APPROVAL);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(reqBO.getOrderId());
        ArrayList<ApprovalObjBO> approvalObjBOList = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjId(reqBO.getOrderId().toString());
        approvalObjBO.setObjName("\u7ed3\u7b97\u5355\u7b7e\u7968\u5ba1\u6279");
        approvalObjBO.setObjType(FscConstants.AuditObjType.ORDER_APPROVAL);
        approvalObjBOList.add(approvalObjBO);
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjBOList);
        createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
        auditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
        this.checkExistProcess(reqBO.getOrderId());
        log.info("\u5ba1\u6279\u5165\u53c2================" + JSON.toJSONString((Object)auditCreateReqBO));
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(auditCreateReqBO);
        log.info("\u5ba1\u6279\u51fa\u53c2================" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new FscBusinessException("191019", uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        if (uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue()) {
            throw new FscBusinessException("190000", "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u7ed3\u7b97\u5355\u5ba1\u6279\u6d41\uff01");
        }
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getOrderId());
        fscOrderPo = this.fscOrderMapper.getModelBy(fscOrderPo);
        FscTaskCandidatePO taskPo = new FscTaskCandidatePO();
        taskPo.setFscOrderId(reqBO.getOrderId());
        List pendAuditPostIdList = this.fscTaskCandidateMapper.getPendAuditPostIdList(taskPo);
        if (!CollectionUtils.isEmpty((Collection)pendAuditPostIdList)) {
            DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
            dycStationOrgSelectUserNameReqBO.setStationId(Long.valueOf(((FscApprovalTaskQueryBO)pendAuditPostIdList.get(0)).getTaskOperId()));
            DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.dycStationOrgSelectUserNameService.selectUserName(dycStationOrgSelectUserNameReqBO);
            if (dycStationOrgSelectUserNameRspBO != null && !CollectionUtils.isEmpty((Collection)dycStationOrgSelectUserNameRspBO.getUserList())) {
                Map orderTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_TYPE");
                String orderTypeStr = fscOrderPo.getOrderType() == 2 && fscOrderPo.getTradeMode() != null && fscOrderPo.getTradeMode() == 2 && fscOrderPo.getOrderSource() == 3 && fscOrderPo.getSettlePlatform() != null && fscOrderPo.getSettlePlatform() == 2 ? "\u81ea\u9700\u91c7\u8d2d" : (String)orderTypeMap.get(fscOrderPo.getOrderType() + "");
                FscSendNotificationExtAtomReqBO fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
                fscSendNotificationExtAtomReqBO.setTitel(fscOrderPo.getOrderNo() + "\u91c7\u8d2d\u7ed3\u7b97_" + orderTypeStr + "_" + fscOrderPo.getTotalCharge().setScale(2, RoundingMode.HALF_UP) + "\u5f85\u5ba1\u6279");
                fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u5f85\u5ba1\u6279\u7684\u91c7\u8d2d\u7ed3\u7b97\u5355" + fscOrderPo.getOrderNo() + "\u5df2\u63d0\u4ea4\u81f3\u60a8\u5904\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
                fscSendNotificationExtAtomReqBO.setUserId(reqBO.getUserId());
                fscSendNotificationExtAtomReqBO.setReceiveIds(dycStationOrgSelectUserNameRspBO.getUserList().stream().map(UserBO::getUserId).distinct().collect(Collectors.toList()));
                this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
            }
        }
    }

    private void insertAttachment(List<AttachmentBO> attachmentBOList, Long fscOrderId) {
        if (!CollectionUtils.isEmpty(attachmentBOList)) {
            FscAttachmentPO deletPo = new FscAttachmentPO();
            deletPo.setFscOrderId(fscOrderId);
            deletPo.setObjType(FscConstants.AttachmentObjType.INVOICE_SIGN_APPLY);
            ArrayList<FscAttachmentPO> fscAttachmentPOS = this.fscAttachmentMapper.getList(deletPo);
            if (!CollectionUtils.isEmpty((Collection)fscAttachmentPOS)) {
                this.fscAttachmentMapper.deleteBy(deletPo);
            }
            fscAttachmentPOS = new ArrayList<FscAttachmentPO>();
            for (AttachmentBO attachmentBO : attachmentBOList) {
                FscAttachmentPO fscAttachmentPo = new FscAttachmentPO();
                fscAttachmentPo.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                fscAttachmentPo.setAttachmentUrl(attachmentBO.getAttachmentUrl());
                fscAttachmentPo.setAttachmentName(attachmentBO.getAttachmentName());
                fscAttachmentPo.setAttachmentType(FscConstants.AttachmentType.INVOICE_SIGN_APPLY);
                fscAttachmentPo.setObjId(fscOrderId);
                fscAttachmentPo.setObjType(FscConstants.AttachmentObjType.INVOICE_SIGN_APPLY);
                fscAttachmentPo.setFscOrderId(fscOrderId);
                fscAttachmentPOS.add(fscAttachmentPo);
            }
            this.fscAttachmentMapper.insertBatch(fscAttachmentPOS);
        }
    }

    private void checkAmtTax(List<FscInvoicePO> invoicePOList, Long orderId) {
        FscOrderItemPO orderItemPO = this.fscOrderItemMapper.getSumAmt(orderId);
        if (Objects.nonNull(orderItemPO)) {
            BigDecimal taxAmt = orderItemPO.getTaxAmt();
            BigDecimal unAmt = orderItemPO.getAmt().subtract(orderItemPO.getTaxAmt());
            BigDecimal ivTaxAmt = invoicePOList.stream().map(FscInvoicePO::getTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal ivUnAmt = invoicePOList.stream().map(FscInvoicePO::getUntaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (taxAmt.compareTo(ivTaxAmt) != 0 || unAmt.compareTo(ivUnAmt) != 0) {
                FscOrderItemPO itemPO = new FscOrderItemPO();
                itemPO.setFscOrderId(orderId);
                itemPO.setTaxAmt(taxAmt.subtract(ivTaxAmt));
                itemPO.setUntaxAmt(unAmt.subtract(ivUnAmt));
                this.fscOrderItemMapper.updateFscOrderItemTax(itemPO);
            }
        }
    }

    private void checkExistProcess(Long fscOrderId) {
        int count = this.fscOrderMapper.selectStepIdCount(fscOrderId, FscConstants.AuditObjType.ORDER_APPROVAL);
        if (count > 0) {
            throw new FscBusinessException("191019", "\u8be5\u5355\u636e\u5df2\u63d0\u4ea4\u5ba1\u6279");
        }
    }
}

