/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.fsc.base.FscRspBaseBO;
import com.tydic.fsc.bill.ability.api.FscRecvClaimListQueryAbilityService;
import com.tydic.fsc.bill.ability.bo.FscCheckCustomerNameAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscCheckCustomerNameAbilityRspBO;
import com.tydic.fsc.bill.ability.bo.FscFinancialPreClaimAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscFinancialPreClaimAbilityRspBO;
import com.tydic.fsc.bill.ability.bo.FscRecvClaimListQueryAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscRecvClaimListQueryAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscRecvClaimListQueryBusiService;
import com.tydic.fsc.bill.busi.bo.FscFinancialPreClaimBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscFinancialPreClaimBusiRspBO;
import com.tydic.fsc.bill.busi.bo.FscRecvClaimListQueryBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscRecvClaimListQueryBusiRspBO;
import com.tydic.fsc.bill.busi.bo.FscUpdateClaimDetailRspBO;
import com.tydic.fsc.bo.FscRecvClaimBO;
import com.tydic.fsc.common.ability.api.FscPushYcRecvClaimBillAbilityService;
import com.tydic.fsc.common.ability.bo.FscPushYcRecvClaimBillAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushYcRecvClaimBillAbilityRspBO;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscRecvClaimPO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.umc.general.ability.api.QryBasecEnterpriseAbilityService;
import com.tydic.umc.general.ability.bo.QryCheckBasicEnterpriseExistAbilityReqBO;
import com.tydic.umc.general.ability.bo.QryCheckBasicEnterpriseExistAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscRecvClaimListQueryAbilityService"})
public class FscRecvClaimListQueryAbilityServiceImpl
implements FscRecvClaimListQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscRecvClaimListQueryAbilityServiceImpl.class);
    @Autowired
    private FscRecvClaimListQueryBusiService fscRecvClaimListQueryBusiService;
    @Autowired
    private FscPushYcRecvClaimBillAbilityService fscPushYcRecvClaimBillAbilityService;
    @Value(value="${recvClaim.deleteManagerRole:tenant:10000:caiwujiaose}")
    private String deleteManagerRole;
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;
    @Autowired
    private QryBasecEnterpriseAbilityService qryBasecEnterpriseAbilityService;

    @PostMapping(value={"qryRecvClaimList"})
    public FscRecvClaimListQueryAbilityRspBO qryRecvClaimList(@RequestBody FscRecvClaimListQueryAbilityReqBO reqBO) {
        String jsonString = JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        FscRecvClaimListQueryBusiReqBO busiReqBO = (FscRecvClaimListQueryBusiReqBO)((Object)JSON.parseObject((String)jsonString, FscRecvClaimListQueryBusiReqBO.class));
        FscRecvClaimListQueryBusiRspBO busiRspBO = this.fscRecvClaimListQueryBusiService.qryRecvClaimList(busiReqBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new FscBusinessException("\u5931\u8d25", busiRspBO.getRespDesc());
        }
        String rspString = JSON.toJSONString((Object)((Object)busiRspBO), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        FscRecvClaimListQueryAbilityRspBO rspBO = (FscRecvClaimListQueryAbilityRspBO)JSON.parseObject((String)rspString, FscRecvClaimListQueryAbilityRspBO.class);
        if (!CollectionUtils.isEmpty((Collection)reqBO.getAuthPermission()) && reqBO.getAuthPermission().contains(this.deleteManagerRole)) {
            rspBO.setCanDeleteRecv(Boolean.valueOf(true));
        } else {
            rspBO.setCanDeleteRecv(Boolean.valueOf(false));
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getClaimIds()) && ObjectUtil.isNotEmpty((Object)rspBO.getRows())) {
            Map<Long, FscRecvClaimBO> fscClaimMap = rspBO.getRows().stream().collect(Collectors.toMap(FscRecvClaimBO::getClaimId, e -> e));
            ArrayList<FscRecvClaimBO> claimList = new ArrayList<FscRecvClaimBO>();
            for (Long claimId : reqBO.getClaimIds()) {
                if (!ObjectUtil.isNotEmpty((Object)fscClaimMap.get(claimId))) continue;
                claimList.add(fscClaimMap.get(claimId));
            }
            rspBO.setRows(claimList);
        }
        return rspBO;
    }

    @FscDuplicateCommitLimit
    @PostMapping(value={"updateRecvClaimAndDetail"})
    public FscRspBaseBO updateRecvClaimAndDetail(@RequestBody FscFinancialPreClaimAbilityReqBO reqBO) {
        FscRspBaseBO rspBO = new FscRspBaseBO();
        String jsonString = JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        FscFinancialPreClaimBusiReqBO busiReqBO = (FscFinancialPreClaimBusiReqBO)((Object)JSON.parseObject((String)jsonString, FscFinancialPreClaimBusiReqBO.class));
        FscUpdateClaimDetailRspBO rspBaseBO = this.fscRecvClaimListQueryBusiService.updateRecvClaimAndDetail(busiReqBO);
        if (!"0000".equals(rspBaseBO.getRespCode())) {
            throw new FscBusinessException("\u5931\u8d25", rspBaseBO.getRespDesc());
        }
        Map<Long, Long> map = rspBaseBO.getMap();
        for (Map.Entry<Long, Long> entry : map.entrySet()) {
            FscPushYcRecvClaimBillAbilityReqBO bo = new FscPushYcRecvClaimBillAbilityReqBO();
            bo.setClaimId(entry.getKey());
            ArrayList<Long> longList = new ArrayList<Long>();
            longList.add(entry.getValue());
            bo.setDetailIdList(longList);
            bo.setAgentAccount(reqBO.getAgentAccount());
            FscPushYcRecvClaimBillAbilityRspBO rsp = this.fscPushYcRecvClaimBillAbilityService.pushYcRecvClaimBillBatchCopy(bo);
            if ("0000".equals(rsp.getRespCode())) continue;
            rspBO.setRespCode("190000");
            rspBO.setRespDesc(rsp.getRespDesc());
            return rspBO;
        }
        return rspBO;
    }

    @PostMapping(value={"qryClaimDetailList"})
    public FscFinancialPreClaimAbilityRspBO qryClaimDetailList(@RequestBody FscFinancialPreClaimAbilityReqBO reqBO) {
        String jsonString = JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        FscFinancialPreClaimBusiReqBO busiReqBO = (FscFinancialPreClaimBusiReqBO)((Object)JSON.parseObject((String)jsonString, FscFinancialPreClaimBusiReqBO.class));
        FscFinancialPreClaimBusiRspBO rspBaseBO = this.fscRecvClaimListQueryBusiService.qryClaimDetailList(busiReqBO);
        if (!"0000".equals(rspBaseBO.getRespCode())) {
            throw new FscBusinessException("\u5931\u8d25", rspBaseBO.getRespDesc());
        }
        String rspString = JSON.toJSONString((Object)((Object)rspBaseBO), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        FscFinancialPreClaimAbilityRspBO rspBO = (FscFinancialPreClaimAbilityRspBO)JSON.parseObject((String)rspString, FscFinancialPreClaimAbilityRspBO.class);
        return rspBO;
    }

    @PostMapping(value={"getListLine"})
    public FscRecvClaimListQueryAbilityRspBO getListLine(@RequestBody FscRecvClaimListQueryAbilityReqBO reqBO) {
        String jsonString = JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        FscRecvClaimListQueryBusiReqBO busiReqBO = (FscRecvClaimListQueryBusiReqBO)((Object)JSON.parseObject((String)jsonString, FscRecvClaimListQueryBusiReqBO.class));
        FscRecvClaimListQueryBusiRspBO busiRspBO = this.fscRecvClaimListQueryBusiService.getListLine(busiReqBO);
        String rspString = JSON.toJSONString((Object)((Object)busiRspBO), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        FscRecvClaimListQueryAbilityRspBO rspBO = (FscRecvClaimListQueryAbilityRspBO)JSON.parseObject((String)rspString, FscRecvClaimListQueryAbilityRspBO.class);
        return rspBO;
    }

    @PostMapping(value={"checkCustomerName"})
    public FscCheckCustomerNameAbilityRspBO checkCustomerName(@RequestBody FscCheckCustomerNameAbilityReqBO reqBO) {
        FscCheckCustomerNameAbilityRspBO rspBO = new FscCheckCustomerNameAbilityRspBO();
        if (reqBO == null && CollectionUtils.isEmpty((Collection)reqBO.getClaimIds())) {
            return rspBO;
        }
        List fscRecvClaimPOS = this.fscRecvClaimMapper.queryByIds(reqBO.getClaimIds());
        if (CollectionUtils.isEmpty((Collection)fscRecvClaimPOS)) {
            return rspBO;
        }
        Set customerNameList = fscRecvClaimPOS.stream().map(FscRecvClaimPO::getCustomerName).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(customerNameList)) {
            return rspBO;
        }
        QryCheckBasicEnterpriseExistAbilityReqBO reqBO1 = new QryCheckBasicEnterpriseExistAbilityReqBO();
        reqBO1.setCustomerNameList(new ArrayList(customerNameList));
        reqBO1.setNum(Integer.valueOf(1));
        QryCheckBasicEnterpriseExistAbilityRspBO rspBO1 = this.qryBasecEnterpriseAbilityService.qryCheckBasicEnterpriseExist(reqBO1);
        if (CollectionUtils.isNotEmpty((Collection)rspBO1.getCustomerNameList())) {
            reqBO1.setCustomerNameList(rspBO1.getCustomerNameList());
            this.qryBasecEnterpriseAbilityService.basicCompanyInformation(reqBO1);
            reqBO1.setNum(Integer.valueOf(2));
            rspBO1 = this.qryBasecEnterpriseAbilityService.qryCheckBasicEnterpriseExist(reqBO1);
            if (CollectionUtils.isNotEmpty((Collection)rspBO1.getCustomerNameList())) {
                rspBO.setCustomerNameList(rspBO1.getCustomerNameList());
                return rspBO;
            }
        }
        return rspBO;
    }
}

