/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.ability.api.FscTracfficInvoiceCreateAbilityService;
import com.tydic.fsc.bill.ability.bo.FscTracfficInvoiceCreateAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscTracfficInvoiceCreateAbilityRspBO;
import com.tydic.fsc.bill.ability.bo.FscTracfficInvoiceCreateItemBO;
import com.tydic.fsc.bill.busi.api.FscTracfficInvoiceCreateBusiService;
import com.tydic.fsc.bill.busi.bo.FscTracfficInvoiceCreateBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscTracfficInvoiceCreateBusiRspBO;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.constants.FscBillInvoiceSerial;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscOrderFlowEnum;
import com.tydic.fsc.constants.FscOrderFlowProcKeyEnum;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.fsc.util.MoneyUtil;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgNameListQryAbilityService;
import com.tydic.umc.general.ability.bo.UmcDycEnterpriseOrgBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgNameListQryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgNameListQryAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscTracfficInvoiceCreateAbilityService"})
public class FscTracfficInvoiceCreateAbilityServiceImpl
implements FscTracfficInvoiceCreateAbilityService {
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Value(value="${fsc.main.pro.org:1000000087,1000000089}")
    private String proOrg;
    @Value(value="${fsc.tracffic.invoice.orderName:\u5e73\u53f0\u6d41\u91cf\u8d39}")
    private String orderName;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;
    @Value(value="${OPER_ORG_NAME}")
    private String operOrgName;
    @Autowired
    private UmcEnterpriseOrgNameListQryAbilityService umcEnterpriseOrgNameListQryAbilityService;
    @Autowired
    private FscTracfficInvoiceCreateBusiService fscTracfficInvoiceCreateBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;
    @Autowired
    private FscOrderMapper fscOrderMapper;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealTracfficInvoiceCreate"})
    public FscTracfficInvoiceCreateAbilityRspBO dealTracfficInvoiceCreate(@RequestBody FscTracfficInvoiceCreateAbilityReqBO reqBO) {
        this.val(reqBO);
        FscTracfficInvoiceCreateBusiRspBO busiRspBO = new FscTracfficInvoiceCreateBusiRspBO();
        if (Integer.valueOf(1).equals(reqBO.getOperType()) || Integer.valueOf(2).equals(reqBO.getOperType())) {
            Long fscOrderId = null;
            fscOrderId = Integer.valueOf(1).equals(reqBO.getOperType()) ? Long.valueOf(Sequence.getInstance().nextId()) : reqBO.getFscOrderId();
            FscOrderPO fscOrderPO = this.buildFscOrderInfo(reqBO, fscOrderId);
            FscOrderItemPO itemPo = this.buildFscOrderItemInfo(reqBO, fscOrderPO);
            FscOrderInvoicePO fscOrderInvoicePO = this.buildFscOrderInvoiceInfo(reqBO, fscOrderId);
            FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
            fscOrderRelationPO = this.buildFscOrderRelationInfo(reqBO, itemPo.getAmt(), fscOrderPO);
            List<FscAttachmentPO> fileList = this.buildFileList(reqBO, fscOrderId);
            FscTracfficInvoiceCreateBusiReqBO busiReqBO = new FscTracfficInvoiceCreateBusiReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)((Object)busiReqBO));
            busiReqBO.setFileList(fileList);
            busiReqBO.setFscOrderPO(fscOrderPO);
            busiReqBO.setItemPo(itemPo);
            busiReqBO.setFscOrderInvoicePO(fscOrderInvoicePO);
            busiReqBO.setFscOrderRelationPO(fscOrderRelationPO);
            busiReqBO.setOperType(reqBO.getOperType());
            busiReqBO.setSubmitFlag(reqBO.getSubmitFlag());
            busiReqBO.setFscOrderId(fscOrderId);
            busiRspBO = this.fscTracfficInvoiceCreateBusiService.dealTrafficeInvoiceCreate(busiReqBO);
            if ("0000".equals(busiRspBO.getRespCode()) && busiRspBO.getFscOrderId() != null) {
                this.sendMq(busiRspBO.getFscOrderId());
            }
            FscOrderRelationPO relationPO = new FscOrderRelationPO();
            relationPO.setAcceptOrderIds(Collections.singletonList(fscOrderRelationPO.getAcceptOrderId()));
            List refundIds = this.fscOrderRefundMapper.getRefundIds(relationPO);
            if (!CollectionUtils.isEmpty((Collection)refundIds)) {
                FscComRefundSyncAbilityReqBO syncAbilityReqBO = new FscComRefundSyncAbilityReqBO();
                syncAbilityReqBO.setRefundIds(refundIds);
                this.fscComRefundSyncAbilityService.syncRefund(syncAbilityReqBO);
            }
            return (FscTracfficInvoiceCreateAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), FscTracfficInvoiceCreateAbilityRspBO.class);
        }
        String errorMsg = "";
        for (Long fscOrderId : reqBO.getFscOrderIds()) {
            FscTracfficInvoiceCreateBusiReqBO busiReqBO = new FscTracfficInvoiceCreateBusiReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)((Object)busiReqBO));
            busiReqBO.setOperType(reqBO.getOperType());
            busiReqBO.setFscOrderId(fscOrderId);
            busiRspBO = this.fscTracfficInvoiceCreateBusiService.dealTrafficeInvoiceCreate(busiReqBO);
            if ("0000".equals(busiRspBO.getRespCode())) {
                this.sendMq(fscOrderId);
                if (!Integer.valueOf(3).equals(reqBO.getOperType())) continue;
                FscOrderPO orderPO = new FscOrderPO();
                orderPO.setFscOrderId(fscOrderId);
                if ((orderPO = this.fscOrderMapper.getModelBy(orderPO)).getRefundId() == null) continue;
                FscComRefundSyncAbilityReqBO syncAbilityReqBO = new FscComRefundSyncAbilityReqBO();
                syncAbilityReqBO.setRefundIds(Collections.singletonList(orderPO.getRefundId()));
                this.fscComRefundSyncAbilityService.syncRefund(syncAbilityReqBO);
                continue;
            }
            errorMsg = errorMsg + "\u7ed3\u7b97\u5355" + fscOrderId + "\u5904\u7406\u5931\u8d25\uff0c" + busiRspBO.getRespDesc() + ";";
        }
        FscTracfficInvoiceCreateAbilityRspBO rspBO = new FscTracfficInvoiceCreateAbilityRspBO();
        if (StringUtils.isEmpty((Object)errorMsg)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        } else {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc(errorMsg);
        }
        return rspBO;
    }

    @PostMapping(value={"dealDelExpireOrder"})
    public FscTracfficInvoiceCreateAbilityRspBO dealDelExpireOrder() {
        FscTracfficInvoiceCreateAbilityRspBO rspBO = new FscTracfficInvoiceCreateAbilityRspBO();
        FscOrderPO order = new FscOrderPO();
        order.setOrderFlow(FscOrderFlowEnum.TRACFFIC_FEE.getCode());
        order.setOrderState(FscConstants.FscInvoiceOrderState.DEL);
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(2, -6);
        Date beforeTime = cal.getTime();
        order.setUpdateTimeEnd(beforeTime);
        List list = this.fscOrderMapper.getList(order);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            List fscOrderIds = list.stream().map(e -> e.getFscOrderId()).collect(Collectors.toList());
            FscTracfficInvoiceCreateAbilityReqBO busiReqBO = new FscTracfficInvoiceCreateAbilityReqBO();
            busiReqBO.setFscOrderIds(fscOrderIds);
            FscTracfficInvoiceCreateAbilityRspBO abilityRspBO = this.fscTracfficInvoiceCreateBusiService.dealDelExpireOrder(busiReqBO);
            rspBO.setRespCode(abilityRspBO.getRespCode());
            rspBO.setRespDesc(abilityRspBO.getRespDesc());
        } else {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        return rspBO;
    }

    private void sendMq(Long orderId) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(orderId);
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }

    private List<FscAttachmentPO> buildFileList(FscTracfficInvoiceCreateAbilityReqBO reqBO, Long fscOrderId) {
        ArrayList<FscAttachmentPO> fileList = new ArrayList<FscAttachmentPO>();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getFileList())) {
            for (AttachmentBO attachmentBO : reqBO.getFileList()) {
                FscAttachmentPO po = new FscAttachmentPO();
                po.setFscOrderId(fscOrderId);
                po.setObjId(fscOrderId);
                po.setObjType(FscConstants.FscAttachmentObjType.ORDER);
                po.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                po.setAttachmentType(FscConstants.FscAttachmentObjType.ORDER);
                po.setAttachmentName(attachmentBO.getAttachmentName());
                po.setAttachmentUrl(attachmentBO.getAttachmentUrl());
                fileList.add(po);
            }
        }
        return fileList;
    }

    private FscOrderRelationPO buildFscOrderRelationInfo(FscTracfficInvoiceCreateAbilityReqBO reqBO, BigDecimal amt, FscOrderPO fscOrderPO) {
        FscOrderRelationPO relationPO = new FscOrderRelationPO();
        relationPO.setFscOrderId(fscOrderPO.getFscOrderId());
        relationPO.setContractName(reqBO.getContractName());
        relationPO.setAmount(amt);
        relationPO.setSettleAmt(amt);
        fscOrderPO.setTotalCharge(amt);
        if (Integer.valueOf(1).equals(reqBO.getOperType())) {
            relationPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            relationPO.setOrderId(fscOrderPO.getOrderId());
            relationPO.setAcceptOrderId(fscOrderPO.getAcceptOrderId());
        }
        return relationPO;
    }

    private FscOrderInvoicePO buildFscOrderInvoiceInfo(FscTracfficInvoiceCreateAbilityReqBO reqBO, Long fscOrderId) {
        FscOrderInvoicePO orderInvoicePo = new FscOrderInvoicePO();
        orderInvoicePo.setFscOrderId(fscOrderId);
        orderInvoicePo.setBuyName(reqBO.getInvoiceBO().getBuyName());
        orderInvoicePo.setInvoiceType(reqBO.getInvoiceBO().getInvoiceType());
        orderInvoicePo.setInvoiceCategory(Integer.valueOf(reqBO.getInvoiceBO().getInvoiceCategory()));
        orderInvoicePo.setTaxNo(reqBO.getInvoiceBO().getTaxNo());
        orderInvoicePo.setBank(reqBO.getInvoiceBO().getBank());
        orderInvoicePo.setAccount(reqBO.getInvoiceBO().getAccount());
        orderInvoicePo.setAddress(reqBO.getInvoiceBO().getAddress());
        orderInvoicePo.setPhone(reqBO.getInvoiceBO().getPhone());
        orderInvoicePo.setInvoiceId(reqBO.getInvoiceBO().getInvoiceId());
        return orderInvoicePo;
    }

    private FscOrderItemPO buildFscOrderItemInfo(FscTracfficInvoiceCreateAbilityReqBO reqBO, FscOrderPO fscOrderPO) {
        FscTracfficInvoiceCreateItemBO itemBO = reqBO.getItemBO();
        FscOrderItemPO itemPo = new FscOrderItemPO();
        Long id = itemBO.getId();
        if (itemBO.getId() == null) {
            id = Sequence.getInstance().nextId();
        }
        itemPo.setId(id);
        itemPo.setFscOrderId(fscOrderPO.getFscOrderId());
        itemPo.setSkuName(itemBO.getSkuName());
        itemPo.setSkuNo(itemBO.getSkuNo());
        itemPo.setUnit(itemBO.getUnit());
        itemPo.setNum(itemBO.getNum());
        itemPo.setTotalNum(itemBO.getNum());
        itemPo.setTaxCode(itemBO.getTaxCode());
        itemPo.setTaxRate(itemBO.getTaxRate().multiply(new BigDecimal("0.01")));
        BigDecimal price = MoneyUtil.b2b((BigDecimal)itemBO.getCgPayAmount().multiply(itemBO.getFdPercent()).multiply(new BigDecimal("0.01")), (int)8);
        BigDecimal amt = MoneyUtil.b2b((BigDecimal)price.multiply(itemBO.getNum()), (int)2);
        BigDecimal untaxAmt = amt.divide(itemBO.getTaxRate().multiply(new BigDecimal("0.01")).add(new BigDecimal("1")), 2, 4);
        BigDecimal taxAmt = amt.subtract(untaxAmt);
        if (price.compareTo(itemBO.getPrice()) != 0) {
            throw new FscBusinessException("191000", "\u5355\u4ef7\u542b\u7a0e\u524d\u540e\u7aef\u8ba1\u7b97\u4e0d\u4e00\u81f4");
        }
        if (amt.compareTo(itemBO.getAmt()) != 0) {
            throw new FscBusinessException("191000", "\u542b\u7a0e\u91d1\u989d\u524d\u540e\u7aef\u8ba1\u7b97\u4e0d\u4e00\u81f4");
        }
        if (untaxAmt.compareTo(itemBO.getUntaxAmt()) != 0) {
            throw new FscBusinessException("191000", "\u4e0d\u542b\u7a0e\u91d1\u989d\u524d\u540e\u7aef\u8ba1\u7b97\u4e0d\u4e00\u81f4");
        }
        if (taxAmt.compareTo(itemBO.getTaxAmt()) != 0) {
            throw new FscBusinessException("191000", "\u7a0e\u989d\u524d\u540e\u7aef\u8ba1\u7b97\u4e0d\u4e00\u81f4");
        }
        itemPo.setPrice(price);
        itemPo.setAmt(amt);
        itemPo.setTotalAmt(amt);
        itemPo.setUntaxAmt(untaxAmt);
        itemPo.setTaxAmt(taxAmt);
        itemPo.setFdPercent(itemBO.getFdPercent());
        itemPo.setCgPayAmount(itemBO.getCgPayAmount());
        itemPo.setOrderItemId(itemBO.getOrderItemId());
        if (Integer.valueOf(1).equals(reqBO.getOperType())) {
            if (itemPo.getOrderItemId() == null) {
                itemPo.setOrderItemId(Long.valueOf(Sequence.getInstance().nextId()));
            }
            itemPo.setOrderId(fscOrderPO.getOrderId());
            itemPo.setAcceptOrderId(fscOrderPO.getAcceptOrderId());
            itemPo.setSkuId(Long.valueOf(0L));
        }
        return itemPo;
    }

    private FscOrderPO buildFscOrderInfo(FscTracfficInvoiceCreateAbilityReqBO reqBO, Long fscOrderId) {
        int count;
        List<String> serial = this.getSerial(FscBillInvoiceSerial.TRACFFIC_FEE_ORDER_NO.getCode(), 1);
        FscOrderPO invoicePo = new FscOrderPO();
        invoicePo.setFscOrderId(fscOrderId);
        invoicePo.setMakeType(FscConstants.FscOrderMakeType.OPERTION);
        invoicePo.setReceiveType(FscConstants.FscOrderReceiveType.SUPPLIER);
        invoicePo.setOrderFlow(FscOrderFlowEnum.TRACFFIC_FEE.getCode());
        invoicePo.setOrderFlowKey(FscOrderFlowProcKeyEnum.getInstance((String)invoicePo.getOrderFlow().toString()).getDescr());
        invoicePo.setContractNo(reqBO.getContractNo());
        invoicePo.setRemark(reqBO.getRemark());
        invoicePo.setOrderType(Integer.valueOf(27));
        invoicePo.setOrderName(this.orderName);
        invoicePo.setSupplierId(reqBO.getSupplierId());
        invoicePo.setSupplierName(reqBO.getSupplierName());
        invoicePo.setOrderId(reqBO.getItemBO().getOrderId());
        invoicePo.setAcceptOrderId(reqBO.getItemBO().getAcceptOrderId());
        if (Integer.valueOf(1).equals(reqBO.getOperType())) {
            invoicePo.setOrderState(FscConstants.FscInvoiceOrderState.DRAFT);
            if (reqBO.getItemBO().getOrderId() == null) {
                invoicePo.setOrderId(Long.valueOf(Sequence.getInstance().nextId()));
                invoicePo.setAcceptOrderId(Long.valueOf(Sequence.getInstance().nextId()));
            }
            invoicePo.setPayerId(invoicePo.getSupplierId());
            invoicePo.setPayerName(invoicePo.getSupplierName());
            invoicePo.setBuyName(invoicePo.getSupplierName());
            invoicePo.setPayeeName(this.operOrgName);
            invoicePo.setPayeeId(this.operationOrgId);
            invoicePo.setOrderNo(serial.get(0));
            invoicePo.setCreateCompanyId(reqBO.getCompanyId());
            invoicePo.setCreateCompanyName(reqBO.getCompanyName());
            invoicePo.setCreateOrgId(reqBO.getOrgId());
            invoicePo.setCreateOrgName(reqBO.getOrgName());
            invoicePo.setCreateOperNo(reqBO.getUserName());
            invoicePo.setCreateOperId(reqBO.getUserId());
            invoicePo.setCreateOperName(reqBO.getName());
            invoicePo.setOperatorId(reqBO.getUserId());
            invoicePo.setOperatorName(reqBO.getName());
            this.buildOperation(reqBO, invoicePo);
            invoicePo.setCreateTime(new Date());
        }
        invoicePo.setYcDeptId(reqBO.getYcDeptId());
        invoicePo.setYcDeptName(reqBO.getYcDeptName());
        invoicePo.setYcUserId(reqBO.getYcUserId());
        invoicePo.setYcUserName(reqBO.getYcUserName());
        invoicePo.setYcPersonId(reqBO.getYcPersonId());
        invoicePo.setYcPersonName(reqBO.getYcPersonName());
        invoicePo.setRefundId(reqBO.getRefundId());
        if (reqBO.getRefundId() != null && Integer.valueOf(1).equals(reqBO.getOperType()) && (count = this.fscOrderRefundMapper.checkInvoiceReopen(reqBO.getRefundId(), invoicePo.getMakeType(), invoicePo.getReceiveType())) != 0) {
            throw new FscBusinessException("198888", "\u5df2\u5b58\u5728\u91cd\u5f00\u7ed3\u7b97\u5355,\u8bf7\u52ff\u91cd\u590d\u53d1\u8d77\uff01");
        }
        return invoicePo;
    }

    private void buildOperation(FscTracfficInvoiceCreateAbilityReqBO reqBO, FscOrderPO invoicePo) {
        String operationNo = null;
        String[] proOrgList = this.proOrg.split(",");
        if (proOrgList.length > 0) {
            for (String orgId : proOrgList) {
                if (!reqBO.getOrgTreePath().contains(orgId)) continue;
                operationNo = orgId;
                break;
            }
        }
        invoicePo.setOperationNo(operationNo);
        if (org.apache.commons.lang3.StringUtils.isNotBlank(operationNo)) {
            Map orgMap;
            UmcDycEnterpriseOrgBO umcDycEnterpriseOrgBO;
            UmcEnterpriseOrgNameListQryAbilityReqBO quryOrgNameReqBO = new UmcEnterpriseOrgNameListQryAbilityReqBO();
            List<Long> orgIds = Arrays.asList(Long.parseLong(operationNo));
            quryOrgNameReqBO.setOrgIdList(orgIds);
            UmcEnterpriseOrgNameListQryAbilityRspBO quryOrgNameRspBO = this.umcEnterpriseOrgNameListQryAbilityService.qryEnterpriseOrgNameList(quryOrgNameReqBO);
            if (quryOrgNameRspBO.getRespCode().equals("0000") && !CollectionUtils.isEmpty((Map)quryOrgNameRspBO.getOrgMap()) && (umcDycEnterpriseOrgBO = (UmcDycEnterpriseOrgBO)(orgMap = quryOrgNameRspBO.getOrgMap()).get(Long.parseLong(operationNo))) != null) {
                invoicePo.setOperationName(umcDycEnterpriseOrgBO.getOrgName());
            }
        }
    }

    private List<String> getSerial(String key, Integer num) {
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setOrgType("-1");
        encodedSerialGetServiceReqBO.setEncodedRuleCode(FscBillInvoiceSerial.getInstance((String)key).getDesc());
        encodedSerialGetServiceReqBO.setNum(num);
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        if (null == encodedSerialGetServiceRspBO || CollectionUtils.isEmpty((Collection)encodedSerialGetServiceRspBO.getSerialNoList()) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((CharSequence)encodedSerialGetServiceRspBO.getSerialNoList().get(0)))) {
            throw new FscBusinessException("191014", "\u83b7\u53d6\u914d\u7f6e\u6d41\u6c34\u53f7\u5f02\u5e38");
        }
        return encodedSerialGetServiceRspBO.getSerialNoList();
    }

    private void val(FscTracfficInvoiceCreateAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u6d41\u91cf\u8d39\u5f00\u7968\u7533\u8bf7\u63a5\u53e3\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (reqBO.getOperType() == null) {
            throw new FscBusinessException("191000", "\u6d41\u91cf\u8d39\u5f00\u7968\u7533\u8bf7\u63a5\u53e3\u5165\u53c2[operType]\u4e3a\u7a7a");
        }
        List<Integer> operTypeList = Arrays.asList(1, 2, 3, 4);
        if (!operTypeList.contains(reqBO.getOperType())) {
            throw new FscBusinessException("191000", "\u6d41\u91cf\u8d39\u5f00\u7968\u7533\u8bf7\u63a5\u53e3\u5165\u53c2[operType]\u4e0d\u7b26\u5408\u8981\u6c42");
        }
        if (reqBO.getOperType() == 2 && reqBO.getFscOrderId() == null) {
            throw new FscBusinessException("191000", "\u6d41\u91cf\u8d39\u5f00\u7968\u7533\u8bf7\u63a5\u53e3,\u4fee\u6539\u6216\u8005\u5220\u9664\u65f6\u5165\u53c2[fscOrderId]\u4e0d\u7b26\u5408\u8981\u6c42");
        }
        if (reqBO.getOperType() == 1 || reqBO.getOperType() == 2) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)reqBO.getContractNo())) {
                throw new FscBusinessException("191000", "\u6d41\u91cf\u8d39\u5f00\u7968\u7533\u8bf7\u63a5\u53e3\u5165\u53c2[contractNo]\u4e3a\u7a7a");
            }
            if (reqBO.getOrderType() == null) {
                throw new FscBusinessException("191000", "\u6d41\u91cf\u8d39\u5f00\u7968\u7533\u8bf7\u63a5\u53e3\u5165\u53c2[orderType]\u4e3a\u7a7a");
            }
            if (reqBO.getSupplierId() == null) {
                throw new FscBusinessException("191000", "\u6d41\u91cf\u8d39\u5f00\u7968\u7533\u8bf7\u63a5\u53e3\u5165\u53c2[supplierId]\u4e3a\u7a7a");
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)reqBO.getSupplierName())) {
                throw new FscBusinessException("191000", "\u6d41\u91cf\u8d39\u5f00\u7968\u7533\u8bf7\u63a5\u53e3\u5165\u53c2[supplierName]\u4e3a\u7a7a");
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)reqBO.getInvoiceBO().getBuyName())) {
                throw new FscBusinessException("191000", "\u6d41\u91cf\u8d39\u5f00\u7968\u7533\u8bf7\u63a5\u53e3\u5165\u53c2[buyName]\u4e3a\u7a7a");
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)reqBO.getInvoiceBO().getInvoiceType())) {
                throw new FscBusinessException("191000", "\u6d41\u91cf\u8d39\u5f00\u7968\u7533\u8bf7\u63a5\u53e3\u5165\u53c2[invoiceType]\u4e3a\u7a7a");
            }
            if (reqBO.getItemBO() == null) {
                throw new FscBusinessException("191000", "\u6d41\u91cf\u8d39\u5f00\u7968\u7533\u8bf7\u63a5\u53e3\u5165\u53c2[itemBO]\u4e3a\u7a7a");
            }
            if (reqBO.getItemBO().getCgPayAmount() == null) {
                throw new FscBusinessException("191000", "\u6d41\u91cf\u8d39\u5f00\u7968\u7533\u8bf7\u63a5\u53e3\u5165\u53c2[cgPayAmount]\u4e3a\u7a7a");
            }
            if (reqBO.getItemBO().getFdPercent() == null) {
                throw new FscBusinessException("191000", "\u6d41\u91cf\u8d39\u5f00\u7968\u7533\u8bf7\u63a5\u53e3\u5165\u53c2[fdPercent]\u4e3a\u7a7a");
            }
            if (reqBO.getItemBO().getTaxRate() == null) {
                throw new FscBusinessException("191000", "\u6d41\u91cf\u8d39\u5f00\u7968\u7533\u8bf7\u63a5\u53e3\u5165\u53c2[taxRate]\u4e3a\u7a7a");
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)reqBO.getItemBO().getSkuName())) {
                throw new FscBusinessException("191000", "\u6d41\u91cf\u8d39\u5f00\u7968\u7533\u8bf7\u63a5\u53e3\u5165\u53c2[skuName]\u4e3a\u7a7a");
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)reqBO.getItemBO().getTaxCode())) {
                throw new FscBusinessException("191000", "\u6d41\u91cf\u8d39\u5f00\u7968\u7533\u8bf7\u63a5\u53e3\u5165\u53c2[taxCode]\u4e3a\u7a7a");
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)reqBO.getItemBO().getUnit())) {
                throw new FscBusinessException("191000", "\u6d41\u91cf\u8d39\u5f00\u7968\u7533\u8bf7\u63a5\u53e3\u5165\u53c2[unit]\u4e3a\u7a7a");
            }
            if (reqBO.getItemBO().getNum() == null) {
                throw new FscBusinessException("191000", "\u6d41\u91cf\u8d39\u5f00\u7968\u7533\u8bf7\u63a5\u53e3\u5165\u53c2[num]\u4e3a\u7a7a");
            }
            if (reqBO.getItemBO().getPrice() == null) {
                throw new FscBusinessException("191000", "\u6d41\u91cf\u8d39\u5f00\u7968\u7533\u8bf7\u63a5\u53e3\u5165\u53c2[price]\u4e3a\u7a7a");
            }
            if (reqBO.getItemBO().getAmt() == null) {
                throw new FscBusinessException("191000", "\u6d41\u91cf\u8d39\u5f00\u7968\u7533\u8bf7\u63a5\u53e3\u5165\u53c2[amt]\u4e3a\u7a7a");
            }
            if (reqBO.getItemBO().getUntaxAmt() == null) {
                throw new FscBusinessException("191000", "\u6d41\u91cf\u8d39\u5f00\u7968\u7533\u8bf7\u63a5\u53e3\u5165\u53c2[untaxAmt]\u4e3a\u7a7a");
            }
            if (reqBO.getItemBO().getTaxAmt() == null) {
                throw new FscBusinessException("191000", "\u6d41\u91cf\u8d39\u5f00\u7968\u7533\u8bf7\u63a5\u53e3\u5165\u53c2[taxAmt]\u4e3a\u7a7a");
            }
        }
        if (reqBO.getOperType() == 3 || reqBO.getOperType() == 4) {
            if (CollectionUtils.isEmpty((Collection)reqBO.getFscOrderIds())) {
                throw new FscBusinessException("191000", "\u6d41\u91cf\u8d39\u5f00\u7968\u7533\u8bf7\u63a5\u53e3\u5165\u53c2[FscOrderIds]\u4e3a\u7a7a");
            }
            for (Long fscOrderId : reqBO.getFscOrderIds()) {
                if (fscOrderId != null) continue;
                throw new FscBusinessException("191000", "\u6d41\u91cf\u8d39\u5f00\u7968\u7533\u8bf7\u63a5\u53e3\u5165\u53c2[FscOrderIds]\u96c6\u5408\u4e2d\u5b58\u5728\u7a7a\u503c");
            }
        }
        if (reqBO.getOperType() == 4) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)reqBO.getYcDeptId())) {
                throw new FscBusinessException("191000", "\u6d41\u91cf\u8d39\u5f00\u7968\u7533\u8bf7\u63a5\u53e3\u5165\u53c2[ycDeptId]\u4e3a\u7a7a");
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)reqBO.getYcDeptName())) {
                throw new FscBusinessException("191000", "\u6d41\u91cf\u8d39\u5f00\u7968\u7533\u8bf7\u63a5\u53e3\u5165\u53c2[ycDeptName]\u4e3a\u7a7a");
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)reqBO.getYcUserId())) {
                throw new FscBusinessException("191000", "\u6d41\u91cf\u8d39\u5f00\u7968\u7533\u8bf7\u63a5\u53e3\u5165\u53c2[ycUserId]\u4e3a\u7a7a");
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)reqBO.getYcPersonId())) {
                throw new FscBusinessException("191000", "\u6d41\u91cf\u8d39\u5f00\u7968\u7533\u8bf7\u63a5\u53e3\u5165\u53c2[ycPersonId]\u4e3a\u7a7a");
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)reqBO.getYcPersonName())) {
                throw new FscBusinessException("191000", "\u6d41\u91cf\u8d39\u5f00\u7968\u7533\u8bf7\u63a5\u53e3\u5165\u53c2[ycPersonName]\u4e3a\u7a7a");
            }
        }
    }
}

