/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl.finance;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.contract.ability.FscFinanceSelectContractAmountAbilityService;
import com.tydic.contract.ability.bo.FscFinanceSelectContractAmountReqBO;
import com.tydic.contract.ability.bo.FscFinanceSelectContractAmountRspBo;
import com.tydic.contract.ability.bo.FscFinanceSelectContractAmountRspBoList;
import com.tydic.fsc.bill.ability.api.finance.FscFinancePushSettleAbilityService;
import com.tydic.fsc.bill.ability.bo.finance.FscFinancePushSettleAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.finance.FscFinancePushSettleAbilityRspBO;
import com.tydic.fsc.bill.busi.api.finance.FscFinancePushSettleBusiService;
import com.tydic.fsc.bill.busi.bo.finance.FscFinancePushSettleBusiReqBO;
import com.tydic.fsc.bill.busi.bo.finance.FscFinancePushSettleBusiRspBO;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscFinanceAttachmentBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinanceShareTokenRspBO;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceShareRelatedInterfacesAtomService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.finance.FscFinanceFileUploadAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceFileUploadAbilityReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceFileUploadAbilityRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinancePushSettleAttachmentListBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinancePushSettleBaseBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinancePushSettleContractBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinancePushSettleDetailBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinancePushSettleInvoiceBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinancePushSettleItemBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinancePushSettleItemErpBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinancePushSettleWriteItemBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscFinanceWriteOffMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscUocOrdRhDetailMapper;
import com.tydic.fsc.enums.FscFundsclaimBillTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.bo.finance.FscFinancePushPayBillAbilityRspBO;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscFinanceWriteOffPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscUocOrdRhDetailPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.uoc.common.ability.api.UocSalesSingleDetailsListQueryAbilityService;
import com.tydic.uoc.common.ability.api.finance.UocOrderInfoBatchQueryAbilityService;
import com.tydic.uoc.common.ability.bo.UocPebChildOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.finance.FscFinancePushSettleAbilityService"})
public class FscFinancePushSettleAbilityServiceImpl
implements FscFinancePushSettleAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscFinancePushSettleAbilityServiceImpl.class);
    @Value(value="${saleOrderTabId:30001}")
    private Integer SALE_ORDER_TAB_ID;
    @Resource
    private FscOrderMapper fscOrderMapper;
    @Resource
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Resource
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Resource
    private FscOrderItemMapper fscOrderItemMapper;
    @Resource
    private FscFinanceWriteOffMapper fscFinanceWriteOffMapper;
    @Resource
    private FscInvoiceMapper fscInvoiceMapper;
    @Resource
    private FscAttachmentMapper fscAttachmentMapper;
    @Resource
    private FscUocOrdRhDetailMapper fscUocOrdRhDetailMapper;
    @Autowired
    private FscFinanceSelectContractAmountAbilityService fscFinanceSelectContractAmountAbilityService;
    @Autowired
    private UocOrderInfoBatchQueryAbilityService uocOrderInfoBatchQueryAbilityService;
    @Autowired
    private UocSalesSingleDetailsListQueryAbilityService uocSalesSingleDetailsListQueryAbilityService;
    @Autowired
    private FscFinancePushSettleBusiService fscFinancePushSettleBusiService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscFinanceFileUploadAbilityService fscFinanceFileUploadAbilityService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscFinanceShareRelatedInterfacesAtomService fscFinanceShareRelatedInterfacesAtomService;

    @PostMapping(value={"pushFinanceSettle"})
    public FscFinancePushSettleAbilityRspBO pushFinanceSettle(@RequestBody FscFinancePushSettleAbilityReqBO reqBO) {
        if (reqBO.getFscOrderId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(reqBO.getFscOrderId());
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        if (orderPO == null) {
            throw new FscBusinessException("198888", reqBO.getFscOrderId() + "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u4fe1\u606f!");
        }
        FscOrderFinancePO financePO = new FscOrderFinancePO();
        financePO.setFscOrderId(reqBO.getFscOrderId());
        financePO = this.fscOrderFinanceMapper.getModelBy(financePO);
        if (financePO == null) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u7ed3\u7b97\u5171\u4eab\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (FscConstants.FscPushStatus.SUCCESS.equals(financePO.getPushFinanceStatus())) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u5355\u636e\u5df2\u63a8\u9001\u6210\u529f\uff0c\u8bf7\u52ff\u91cd\u590d\u63a8\u9001\uff01");
        }
        this.handleSettleInfo(reqBO, orderPO, financePO);
        FscFinancePushSettleAbilityRspBO rspBO = new FscFinancePushSettleAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"dealPushFinanceSettleBatch"})
    public FscFinancePushSettleAbilityRspBO dealPushFinanceSettleBatch(@RequestBody FscFinancePushSettleAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getFscOrderIds())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fscOrderIds]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        StringBuilder sb = new StringBuilder();
        for (Long fscOrderId : reqBO.getFscOrderIds()) {
            FscFinancePushSettleAbilityReqBO abilityReqBO = new FscFinancePushSettleAbilityReqBO();
            abilityReqBO.setFscOrderId(fscOrderId);
            FscFinancePushSettleAbilityRspBO abilityRspBO = this.pushFinanceSettle(abilityReqBO);
            if ("0000".equals(abilityRspBO.getRespCode())) continue;
            sb.append("\u5355\u636e[").append(fscOrderId).append("]\u63a8\u9001\u5931\u8d25\uff1a").append(abilityRspBO.getRespDesc());
        }
        FscFinancePushSettleAbilityRspBO rspBO = new FscFinancePushSettleAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (!StringUtils.isEmpty((Object)sb.toString())) {
            rspBO.setRespCode("190000");
            rspBO.setRespDesc(sb.toString());
        }
        return rspBO;
    }

    private void handleSettleInfo(FscFinancePushSettleAbilityReqBO reqBO, FscOrderPO orderPO, FscOrderFinancePO financePO) {
        try {
            FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
            fscOrderRelationPO.setFscOrderId(reqBO.getFscOrderId());
            List fscOrderRelationPOList = this.fscOrderRelationMapper.getListByContractId(fscOrderRelationPO);
            if (CollectionUtils.isEmpty((Collection)fscOrderRelationPOList)) {
                throw new FscBusinessException("198888", "\u67e5\u8be2\u7ed3\u7b97\u5173\u8054\u4fe1\u606f\u5931\u8d25\uff01");
            }
            FscAttachmentPO fscAttachmentPO = new FscAttachmentPO();
            fscAttachmentPO.setFscOrderId(reqBO.getFscOrderId());
            fscAttachmentPO.setObjType(FscConstants.AttachmentType.FSC_ORDER);
            List fscAttachmentPOList = this.fscAttachmentMapper.getList(fscAttachmentPO);
            Map<Long, List<FscAttachmentPO>> attachmentMap = fscAttachmentPOList.stream().collect(Collectors.groupingBy(FscAttachmentPO::getObjId));
            FscFinancePushSettleBaseBO fscFinancePushSettleBaseBO = this.buildSettleInfo(orderPO, financePO, fscAttachmentPOList);
            List<FscFinancePushSettleContractBO> purSettleContractList = this.buildContractInfo(fscOrderRelationPOList, reqBO, attachmentMap, financePO);
            FscFinancePushSettleDetailBO fscFinancePushSettleDetailBO = new FscFinancePushSettleDetailBO();
            fscFinancePushSettleDetailBO.setBaseInfoData(fscFinancePushSettleBaseBO);
            fscFinancePushSettleDetailBO.setPurSettleContractList(purSettleContractList);
            this.dealPush(orderPO, fscFinancePushSettleDetailBO);
        }
        catch (Exception ex) {
            log.error("\u7ed3\u7b97\u5355\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u5f02\u5e38" + ex);
            this.dealBuildFail(orderPO, ex);
        }
    }

    private List<FscFinancePushSettleContractBO> buildContractInfo(List<FscOrderRelationPO> fscOrderRelationPOList, FscFinancePushSettleAbilityReqBO reqBO, Map<Long, List<FscAttachmentPO>> attachmentMap, FscOrderFinancePO financePO) {
        ArrayList<FscFinancePushSettleContractBO> purSettleContractList = new ArrayList<FscFinancePushSettleContractBO>();
        List<Long> contractIds = fscOrderRelationPOList.stream().map(FscOrderRelationPO::getContractId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(contractIds)) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u7ed3\u7b97\u5355\u65e0\u5408\u540c\u4fe1\u606f\uff0c\u65e0\u9700\u63a8\u9001");
        }
        Map relationPOMap = fscOrderRelationPOList.stream().collect(Collectors.toMap(FscOrderRelationPO::getContractId, Function.identity(), (k1, k2) -> k1));
        List orderIds = fscOrderRelationPOList.stream().map(FscOrderRelationPO::getOrderId).collect(Collectors.toList());
        UocSalesSingleDetailsListQueryReqBO saleDetailsReqBO = new UocSalesSingleDetailsListQueryReqBO();
        saleDetailsReqBO.setOrderIdList(orderIds);
        saleDetailsReqBO.setTabId(this.SALE_ORDER_TAB_ID);
        saleDetailsReqBO.setPageSize(10000);
        saleDetailsReqBO.setIsAfterSales(Boolean.valueOf(false));
        log.debug("\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u67e5\u8be2\u9500\u552e\u5355\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)saleDetailsReqBO));
        UocSalesSingleDetailsListQueryRspBO saleDetailsRspBO = this.uocSalesSingleDetailsListQueryAbilityService.getUocSalesSingleDetailsListQuery(saleDetailsReqBO);
        log.debug("\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u67e5\u8be2\u9500\u552e\u5355\u4fe1\u606f\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)saleDetailsRspBO));
        if (!saleDetailsRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(saleDetailsRspBO.getRespCode(), "\u67e5\u8be2\u8ba2\u5355\u7269\u6599\u4fe1\u606f\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a" + saleDetailsRspBO.getRespDesc());
        }
        Map orderInfoMap = saleDetailsRspBO.getRows().stream().map(e -> (UocPebChildOrderAbilityBO)e.getChildOrderList().get(0)).collect(Collectors.toMap(UocPebChildOrderAbilityBO::getOrderId, Function.identity(), (k1, k2) -> k1));
        FscFinanceSelectContractAmountReqBO fscFinanceSelectContractAmountReqBO = new FscFinanceSelectContractAmountReqBO();
        fscFinanceSelectContractAmountReqBO.setContractIds(contractIds);
        FscFinanceSelectContractAmountRspBo fscFinanceSelectContractAmountRspBo = this.fscFinanceSelectContractAmountAbilityService.selectContractAmount(fscFinanceSelectContractAmountReqBO);
        if (Objects.nonNull(fscFinanceSelectContractAmountRspBo) && !"0000".equals(fscFinanceSelectContractAmountRspBo.getRespCode())) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u5408\u540c\u670d\u52a1\u5f02\u5e38\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)fscFinanceSelectContractAmountRspBo.getRows())) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u5408\u540c\u670d\u52a1\u83b7\u53d6\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a\uff01\uff01");
        }
        Map contractMap = fscFinanceSelectContractAmountRspBo.getRows().stream().collect(Collectors.toMap(FscFinanceSelectContractAmountRspBoList::getContractId, Function.identity(), (k1, k2) -> k1));
        contractIds.forEach(contractId -> {
            if (!relationPOMap.containsKey(contractId)) {
                throw new FscBusinessException("198888", "\u7cfb\u7edf\u5f02\u5e38\uff01");
            }
            FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
            fscOrderItemPO.setFscOrderId(reqBO.getFscOrderId());
            fscOrderItemPO.setContractId(contractId);
            List fscOrderItemPOList = this.fscOrderItemMapper.getFinanceList(fscOrderItemPO);
            if (CollectionUtils.isEmpty((Collection)fscOrderItemPOList)) {
                throw new FscBusinessException("198888", "\u5f53\u524d\u7ed3\u7b97\u5355\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u660e\u7ec6\uff0c\u8bf7\u6838\u5bf9\u540e\u91cd\u8bd5\uff01");
            }
            BigDecimal settleAmt = fscOrderItemPOList.stream().map(FscOrderItemPO::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal taxAmt = fscOrderItemPOList.stream().map(FscOrderItemPO::getTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            FscInvoicePO fscInvoicePO = new FscInvoicePO();
            fscInvoicePO.setFscOrderId(reqBO.getFscOrderId());
            fscInvoicePO.setContractId(contractId);
            List fscInvoicePOList = this.fscInvoiceMapper.getList(fscInvoicePO);
            if (CollectionUtils.isEmpty((Collection)fscInvoicePOList)) {
                throw new FscBusinessException("198888", "\u5f53\u524d\u7ed3\u7b97\u5355\u672a\u67e5\u8be2\u5230\u53d1\u7968\u660e\u7ec6\uff0c\u8bf7\u6838\u5bf9\u540e\u91cd\u8bd5\uff01");
            }
            FscFinanceWriteOffPO fscFinanceWriteOffPO = new FscFinanceWriteOffPO();
            fscFinanceWriteOffPO.setFscOrderId(reqBO.getFscOrderId());
            fscFinanceWriteOffPO.setContractId(contractId);
            List fscFinanceWriteOffPOList = this.fscFinanceWriteOffMapper.getList(fscFinanceWriteOffPO);
            List<FscFinancePushSettleInvoiceBO> invoiceList = this.buildInvoiceInfo(fscInvoicePOList);
            ArrayList<FscFinancePushSettleItemErpBO> settleEbdetailList = new ArrayList<FscFinancePushSettleItemErpBO>();
            ArrayList<FscFinancePushSettleItemBO> settleNodetailList = new ArrayList<FscFinancePushSettleItemBO>();
            this.buildSettleItem(fscOrderItemPOList, orderInfoMap, financePO, settleEbdetailList, settleNodetailList);
            List<Object> advCheckList = new ArrayList();
            BigDecimal writeOffAmt = BigDecimal.ZERO;
            if (!CollectionUtils.isEmpty((Collection)fscFinanceWriteOffPOList)) {
                writeOffAmt = fscFinanceWriteOffPOList.stream().map(FscFinanceWriteOffPO::getWriteOffAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                advCheckList = this.buildWriteOff(fscFinanceWriteOffPOList, financePO);
            }
            List<Object> cmAttachmentList = new ArrayList();
            if (!CollectionUtils.isEmpty((Map)attachmentMap) && attachmentMap.containsKey(contractId)) {
                cmAttachmentList = this.buildAttachmentInfo((List)attachmentMap.get(contractId), financePO);
            }
            FscFinancePushSettleContractBO contractBO = new FscFinancePushSettleContractBO();
            contractBO.setGuid(String.valueOf(contractId));
            contractBO.setContractCode(((FscOrderRelationPO)relationPOMap.get(contractId)).getContractNo());
            if (contractMap.containsKey(contractId)) {
                contractBO.setContractName(((FscFinanceSelectContractAmountRspBoList)contractMap.get(contractId)).getContractName());
                contractBO.setContractAmt(((FscFinanceSelectContractAmountRspBoList)contractMap.get(contractId)).getContractAmount());
            }
            contractBO.setSettleAmt(settleAmt);
            contractBO.setSettleLocalAmt(settleAmt.multiply(financePO.getExchangeRate()));
            contractBO.setCheckAdvPayAmt(writeOffAmt);
            contractBO.setCheckAdvPayLocalAmt(writeOffAmt.multiply(financePO.getExchangeRate()));
            contractBO.setSegContractCode(((FscOrderRelationPO)relationPOMap.get(contractId)).getContractSegmentCode());
            contractBO.setSegContractName(((FscOrderRelationPO)relationPOMap.get(contractId)).getContractSegmentName());
            contractBO.setTaxRateCode(null);
            contractBO.setTaxRateName(null);
            contractBO.setTaxAmt(taxAmt);
            contractBO.setTaxLocalAmt(taxAmt.multiply(financePO.getExchangeRate()));
            contractBO.setEstimateBillCode(((FscOrderRelationPO)relationPOMap.get(contractId)).getEstimateBillCode());
            contractBO.setEstimateBillGuid(((FscOrderRelationPO)relationPOMap.get(contractId)).getEstimateBillGuid());
            contractBO.setEstimateBizTypeCode(((FscOrderRelationPO)relationPOMap.get(contractId)).getEstimateBizTypeCode());
            contractBO.setInvoiceList(invoiceList);
            contractBO.setSettleEbdetailList(settleEbdetailList);
            contractBO.setSettleNodetailList(settleNodetailList);
            contractBO.setAdvCheckList(advCheckList);
            contractBO.setCmAttachmentList(cmAttachmentList);
            purSettleContractList.add(contractBO);
        });
        return purSettleContractList;
    }

    private List<FscFinancePushSettleWriteItemBO> buildWriteOff(List<FscFinanceWriteOffPO> fscFinanceWriteOffPOList, FscOrderFinancePO financePO) {
        ArrayList<FscFinancePushSettleWriteItemBO> advCheckList = new ArrayList<FscFinancePushSettleWriteItemBO>();
        List payOrderIdList = fscFinanceWriteOffPOList.stream().map(FscFinanceWriteOffPO::getPayOrderId).collect(Collectors.toList());
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderIds(payOrderIdList);
        List payOrderList = this.fscOrderMapper.getList(fscOrderPO);
        if (CollectionUtils.isEmpty((Collection)payOrderList)) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u6838\u9500\u5355\u5bf9\u5e94\u7684\u9884\u4ed8\u6b3e\u4fe1\u606f\uff01");
        }
        Map payOrderMap = payOrderList.stream().collect(Collectors.toMap(FscOrderPO::getFscOrderId, Function.identity(), (k1, k2) -> k1));
        fscFinanceWriteOffPOList.forEach(e -> {
            FscFinancePushSettleWriteItemBO writeItemBO = new FscFinancePushSettleWriteItemBO();
            writeItemBO.setGuid(String.valueOf(e.getWriteOffId()));
            writeItemBO.setApplyBillGuid(Objects.isNull(e.getPayOrderId()) ? "" : String.valueOf(e.getPayOrderId()));
            writeItemBO.setApplyBillCode(e.getPayOrderNo());
            writeItemBO.setAdvPayAmt(e.getPayAmt());
            if (!CollectionUtils.isEmpty((Map)payOrderMap) && payOrderMap.containsKey(e.getPayOrderId())) {
                writeItemBO.setAdvUncheckAmt(((FscOrderPO)payOrderMap.get(e.getPayOrderId())).getLeaveWriteOffAmount());
                writeItemBO.setAdvUncheckLocalAmt(((FscOrderPO)payOrderMap.get(e.getPayOrderId())).getLeaveWriteOffAmount().multiply(financePO.getExchangeRate()));
            }
            writeItemBO.setCheckAmt(e.getWriteOffAmt());
            writeItemBO.setAdvPayLocalAmt(e.getPayAmtLocal());
            writeItemBO.setCheckLocalAmt(e.getWriteOffAmtLocal());
            writeItemBO.setWriteOffId(String.valueOf(e.getWriteOffId()));
            advCheckList.add(writeItemBO);
        });
        return advCheckList;
    }

    private void buildSettleItem(List<FscOrderItemPO> fscOrderItemPOList, Map<String, UocPebChildOrderAbilityBO> orderInfoMap, FscOrderFinancePO financePO, List<FscFinancePushSettleItemErpBO> settleEbdetailList, List<FscFinancePushSettleItemBO> settleNodetailList) {
        List ordItemIdList = fscOrderItemPOList.stream().map(FscOrderItemPO::getOrderItemId).collect(Collectors.toList());
        FscUocOrdRhDetailPO fscUocOrdRhDetailPO = new FscUocOrdRhDetailPO();
        fscUocOrdRhDetailPO.setOrdItemIdList(ordItemIdList);
        List rhDetailPOList = this.fscUocOrdRhDetailMapper.getList(fscUocOrdRhDetailPO);
        Map<Object, Object> rhDetailPOMap = CollectionUtils.isEmpty((Collection)rhDetailPOList) ? new HashMap() : rhDetailPOList.stream().collect(Collectors.toMap(FscUocOrdRhDetailPO::getOrdItemId, Function.identity(), (k1, k2) -> k1));
        fscOrderItemPOList.forEach(item -> {
            if (!orderInfoMap.containsKey(String.valueOf(item.getOrderId()))) {
                throw new FscBusinessException("198888", "\u5f53\u524d\u7ed3\u7b97\u660e\u7ec6\u672a\u5339\u914d\u5230\u8ba2\u5355\u4fe1\u606f\uff01\u7ed3\u7b97\u660e\u7ec6ID\uff1a" + item.getId());
            }
            UocPebChildOrderAbilityBO orderInfo = (UocPebChildOrderAbilityBO)orderInfoMap.get(String.valueOf(item.getOrderId()));
            if (orderInfo.getIsPushErp() == 1) {
                FscFinancePushSettleItemErpBO erpBO = new FscFinancePushSettleItemErpBO();
                erpBO.setGuid(String.valueOf(item.getId()));
                erpBO.setSegCompanyCode(null);
                erpBO.setSegCompanyName(null);
                erpBO.setSegProductCode(item.getProductSegmentCode());
                erpBO.setSegProductName(item.getProductSegmentName());
                erpBO.setSegProjectCode(item.getProjectCode());
                erpBO.setSegProjectName(item.getProjectName());
                erpBO.setSegContractCode(financePO.getContractSegmentCode());
                erpBO.setSegContractName(financePO.getContractSegmentName());
                erpBO.setSegMainSubjectCode(null);
                erpBO.setSegMainSubjectName(null);
                erpBO.setSegSubSubjectCode(null);
                erpBO.setSegSubSubjectName(null);
                erpBO.setSegCorrespondentCode(null);
                erpBO.setSegCorrespondentName(null);
                erpBO.setSegCalcCostCode(item.getCostCenterCode());
                erpBO.setSegCalcCostName(item.getCostCenterName());
                erpBO.setSegProduceStageCode(item.getProductionLinkCode());
                erpBO.setSegProduceStageName(item.getProductionLinkName());
                erpBO.setSegBakCode(null);
                erpBO.setSegBakName(null);
                erpBO.setIsErp(String.valueOf(orderInfo.getIsPushErp()));
                erpBO.setPurchaseBillCode(orderInfo.getSaleVoucherNo());
                erpBO.setMatchLocalAmt(item.getAmt().multiply(financePO.getExchangeRate()));
                erpBO.setMatchNum(item.getNum());
                erpBO.setBudgetItemCode(item.getBudgetItemCode());
                erpBO.setBudgetItemName(item.getBudgetItemName());
                erpBO.setBudgetItemRemainAmt(item.getBudgetLeaveAmt());
                erpBO.setMaterialCode(item.getSkuNo());
                erpBO.setMaterialName(item.getSkuName());
                erpBO.setUnitCode(null);
                erpBO.setUnitName(item.getSettleUnit());
                erpBO.setRemainNum(orderInfo.getDownTotalLeaveInvoiceNum());
                erpBO.setDiffNum(null);
                erpBO.setMatchLocalAmt(item.getAmt().multiply(financePO.getExchangeRate()));
                erpBO.setMatchNum(item.getNum());
                if (Objects.isNull(item.getTaxRate())) {
                    throw new FscBusinessException("198888", "\u7ed3\u7b97\u660e\u7ec6\u7a0e\u7387\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01\u7ed3\u7b97\u660e\u7ec6ID\uff1a" + item.getId());
                }
                erpBO.setUnitPrice(item.getPrice().divide(BigDecimal.ONE.add(item.getTaxRate().divide(new BigDecimal(100), 2, RoundingMode.HALF_UP)), 8, RoundingMode.HALF_UP));
                erpBO.setUnitTaxPrice(item.getPrice());
                erpBO.setUnitLocalPrice(erpBO.getUnitPrice().multiply(financePO.getExchangeRate()));
                erpBO.setUnitLocalTaxPrice(item.getPrice().multiply(financePO.getExchangeRate()));
                erpBO.setAllAmt(item.getUntaxAmt());
                erpBO.setAllTaxAmt(item.getAmt());
                erpBO.setAllLocalAmt(item.getUntaxAmt().multiply(financePO.getExchangeRate()));
                erpBO.setAllLocalTaxAmt(item.getAmt().multiply(financePO.getExchangeRate()));
                erpBO.setTaxRateCode(Objects.nonNull(item.getTaxRate()) ? String.valueOf(item.getTaxRate().setScale(2, RoundingMode.HALF_UP)) : null);
                erpBO.setTaxRateName(item.getTaxRate().multiply(new BigDecimal(100)).setScale(0, RoundingMode.HALF_UP) + "%");
                erpBO.setTaxRateVal(null);
                erpBO.setTaxAmt(item.getTaxAmt());
                erpBO.setTaxLocalAmt(item.getTaxAmt().multiply(financePO.getExchangeRate()));
                if (!CollectionUtils.isEmpty((Map)rhDetailPOMap) && rhDetailPOMap.containsKey(item.getOrderItemId())) {
                    erpBO.setReceiveNum(((FscUocOrdRhDetailPO)rhDetailPOMap.get(item.getOrderItemId())).getReceiveNum());
                    erpBO.setReceiptNum(((FscUocOrdRhDetailPO)rhDetailPOMap.get(item.getOrderItemId())).getReceiptNum());
                    erpBO.setReceiveAreaCode(((FscUocOrdRhDetailPO)rhDetailPOMap.get(item.getOrderItemId())).getRecvAddressCode());
                    erpBO.setReceiveAreaName(((FscUocOrdRhDetailPO)rhDetailPOMap.get(item.getOrderItemId())).getRecvAddressName());
                    erpBO.setDistributeSubjectCode(((FscUocOrdRhDetailPO)rhDetailPOMap.get(item.getOrderItemId())).getDistributeSubjectCode());
                    erpBO.setDistributeSubjectName(((FscUocOrdRhDetailPO)rhDetailPOMap.get(item.getOrderItemId())).getDistributeSubjectName());
                }
                settleEbdetailList.add(erpBO);
            } else {
                FscFinancePushSettleItemBO notErpBO = new FscFinancePushSettleItemBO();
                notErpBO.setGuid(String.valueOf(item.getId()));
                notErpBO.setSegCompanyCode(null);
                notErpBO.setSegCompanyName(null);
                notErpBO.setSegProductCode(item.getProductSegmentCode());
                notErpBO.setSegProductName(item.getProductSegmentName());
                notErpBO.setSegProjectCode(item.getProjectCode());
                notErpBO.setSegProjectName(item.getProjectName());
                notErpBO.setSegContractCode(financePO.getContractSegmentCode());
                notErpBO.setSegContractName(financePO.getContractSegmentName());
                notErpBO.setSegMainSubjectCode(null);
                notErpBO.setSegMainSubjectName(null);
                notErpBO.setSegSubSubjectCode(null);
                notErpBO.setSegSubSubjectName(null);
                notErpBO.setSegCorrespondentCode(null);
                notErpBO.setSegCorrespondentName(null);
                notErpBO.setSegCalcCostCode(item.getCostCenterCode());
                notErpBO.setSegCalcCostName(item.getCostCenterName());
                notErpBO.setSegProduceStageCode(item.getProductionLinkCode());
                notErpBO.setSegProduceStageName(item.getProductionLinkName());
                notErpBO.setSegBakCode(null);
                notErpBO.setSegBakName(null);
                notErpBO.setSettleItemCode(item.getSettleItemCode());
                notErpBO.setSettleItemName(item.getSettleItemName());
                notErpBO.setNum(item.getNum());
                notErpBO.setPrice(item.getPrice());
                notErpBO.setUnitPrice(item.getPrice().divide(BigDecimal.ONE.add(item.getTaxRate().divide(new BigDecimal(100), 2, RoundingMode.HALF_UP)), 8, RoundingMode.HALF_UP));
                notErpBO.setUnitTaxPrice(item.getPrice());
                notErpBO.setUnitLocalPrice(notErpBO.getUnitPrice().multiply(financePO.getExchangeRate()));
                notErpBO.setUnitLocalTaxPrice(item.getPrice().multiply(financePO.getExchangeRate()));
                notErpBO.setAllAmt(item.getUntaxAmt());
                notErpBO.setAllTaxAmt(item.getAmt());
                notErpBO.setAllLocalAmt(item.getUntaxAmt().multiply(financePO.getExchangeRate()));
                notErpBO.setAllLocalTaxAmt(item.getAmt().multiply(financePO.getExchangeRate()));
                notErpBO.setTaxRateCode(Objects.nonNull(item.getTaxRate()) ? String.valueOf(item.getTaxRate().setScale(2, RoundingMode.HALF_UP)) : null);
                notErpBO.setTaxRateName(item.getTaxRate().multiply(new BigDecimal(100)).setScale(0, RoundingMode.HALF_UP) + "%");
                notErpBO.setTaxRateVal(null);
                notErpBO.setTaxAmt(item.getTaxAmt());
                notErpBO.setTaxLocalAmt(item.getTaxAmt().multiply(financePO.getExchangeRate()));
                notErpBO.setIsSimpleTax(Objects.isNull(item.getIsSimpleTax()) ? "" : String.valueOf(item.getIsSimpleTax()));
                notErpBO.setIsInputOut(Objects.isNull(item.getIsInputOut()) ? "" : String.valueOf(item.getIsInputOut()));
                notErpBO.setInputOutAmt(item.getIsInputOutAmt());
                notErpBO.setInputOutTypeCode(null);
                notErpBO.setInputOutTypeName(null);
                notErpBO.setProjectCode(financePO.getProjectSegmentCode());
                notErpBO.setProjectName(financePO.getProjectSegmentName());
                notErpBO.setTaskCode(null);
                notErpBO.setTaskName(null);
                notErpBO.setUnitCode(null);
                notErpBO.setUnitName(item.getSettleUnit());
                settleNodetailList.add(notErpBO);
            }
        });
    }

    private FscFinancePushSettleBaseBO buildSettleInfo(FscOrderPO orderPO, FscOrderFinancePO financePO, List<FscAttachmentPO> fscAttachmentPOList) {
        FscFinancePushSettleBaseBO fscFinancePushSettleBaseBO = new FscFinancePushSettleBaseBO();
        fscFinancePushSettleBaseBO.setSrcSys("EB");
        fscFinancePushSettleBaseBO.setSrcBillId(orderPO.getFscOrderId() + "");
        fscFinancePushSettleBaseBO.setSrcBillCode(orderPO.getOrderNo());
        fscFinancePushSettleBaseBO.setCreateUser(financePO.getCreateUserId());
        fscFinancePushSettleBaseBO.setCreateUserName(financePO.getFinanceUserName());
        fscFinancePushSettleBaseBO.setCreateDate(DateUtil.dateToStrLong((Date)orderPO.getCreateTime()));
        fscFinancePushSettleBaseBO.setDeptCode(financePO.getFinanceDeptId());
        fscFinancePushSettleBaseBO.setDeptName(financePO.getFinanceDeptName());
        fscFinancePushSettleBaseBO.setOrgId(financePO.getFinanceOrgId());
        fscFinancePushSettleBaseBO.setOrgName(financePO.getFinanceOrgName());
        fscFinancePushSettleBaseBO.setAccountEntityCode(financePO.getAccountEntityCode());
        fscFinancePushSettleBaseBO.setAccountEntityName(financePO.getAccountEntityName());
        fscFinancePushSettleBaseBO.setBillDate(DateUtil.dateToStrYYYYMMdd((Date)orderPO.getCreateTime()));
        fscFinancePushSettleBaseBO.setBizDeptCode(financePO.getBizDeptCode());
        fscFinancePushSettleBaseBO.setBizDeptName(financePO.getBizDeptName());
        fscFinancePushSettleBaseBO.setBizTypeCode(financePO.getBizTypeCode());
        fscFinancePushSettleBaseBO.setBizTypeName(financePO.getBizTypeName());
        fscFinancePushSettleBaseBO.setBizItemCode(financePO.getBusinessItemCode());
        fscFinancePushSettleBaseBO.setBizItemName(financePO.getBusinessItemName());
        fscFinancePushSettleBaseBO.setNote(financePO.getNote());
        fscFinancePushSettleBaseBO.setAttachmentNum(Integer.valueOf(CollectionUtils.isEmpty(fscAttachmentPOList) ? 0 : fscAttachmentPOList.size()));
        fscFinancePushSettleBaseBO.setSegmentCode(financePO.getSegmentCode());
        fscFinancePushSettleBaseBO.setSegmentName(financePO.getSegmentName());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(orderPO.getCreateTime());
        fscFinancePushSettleBaseBO.setBillYear(calendar.get(1) + "");
        fscFinancePushSettleBaseBO.setBillTypeCode(FscFundsclaimBillTypeEnum.SETTLE_TYPE_USED_CONTRACT.getName());
        fscFinancePushSettleBaseBO.setBillTypeName(FscFundsclaimBillTypeEnum.SETTLE_TYPE_USED_CONTRACT.getDescription());
        fscFinancePushSettleBaseBO.setSegCompanyCode(financePO.getCompanySegmentCode());
        fscFinancePushSettleBaseBO.setSegCompanyName(financePO.getCompanySegmentName());
        fscFinancePushSettleBaseBO.setSegProjectCode(financePO.getProjectSegmentCode());
        fscFinancePushSettleBaseBO.setSegProjectName(financePO.getProjectSegmentName());
        fscFinancePushSettleBaseBO.setSegContractCode(financePO.getContractSegmentCode());
        fscFinancePushSettleBaseBO.setSegContractName(financePO.getContractSegmentName());
        fscFinancePushSettleBaseBO.setSegProductCode(null);
        fscFinancePushSettleBaseBO.setSegProductName(null);
        fscFinancePushSettleBaseBO.setSegMainSubjectName(null);
        fscFinancePushSettleBaseBO.setSegMainSubjectCode(null);
        fscFinancePushSettleBaseBO.setSegSubSubjectCode(null);
        fscFinancePushSettleBaseBO.setSegSubSubjectName(null);
        fscFinancePushSettleBaseBO.setSegCorrespondentCode(null);
        fscFinancePushSettleBaseBO.setSegCorrespondentName(null);
        fscFinancePushSettleBaseBO.setSegCalcCostCode(null);
        fscFinancePushSettleBaseBO.setSegCalcCostName(null);
        fscFinancePushSettleBaseBO.setSegProduceStageCode(null);
        fscFinancePushSettleBaseBO.setSegProduceStageName(null);
        fscFinancePushSettleBaseBO.setSegBakCode(null);
        fscFinancePushSettleBaseBO.setSegBakName(null);
        fscFinancePushSettleBaseBO.setSettleAmt(orderPO.getTotalCharge());
        fscFinancePushSettleBaseBO.setSettleLocalAmt(orderPO.getTotalCharge().multiply(financePO.getExchangeRate()));
        fscFinancePushSettleBaseBO.setCheckAdvPayAmt(orderPO.getPurWriteOffAmount());
        fscFinancePushSettleBaseBO.setCheckAdvPayLocalAmt(orderPO.getPurWriteOffAmount().multiply(financePO.getExchangeRate()));
        fscFinancePushSettleBaseBO.setCashItemCode(financePO.getCashItemCode());
        fscFinancePushSettleBaseBO.setCashItemName(financePO.getCashItemName());
        fscFinancePushSettleBaseBO.setCashItemDetailCode(financePO.getCashDetailCode());
        fscFinancePushSettleBaseBO.setCashItemDetailName(financePO.getCashDetailName());
        fscFinancePushSettleBaseBO.setSupplierCode(financePO.getExt1());
        fscFinancePushSettleBaseBO.setSupplierName(orderPO.getPayeeName());
        fscFinancePushSettleBaseBO.setSupplierAreaCode(financePO.getVendorSiteId() + "");
        fscFinancePushSettleBaseBO.setSupplierAreaName(financePO.getVendorSiteName());
        Map currencTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_MONEY_UNIT");
        fscFinancePushSettleBaseBO.setCurrencyCode(financePO.getCurrency());
        fscFinancePushSettleBaseBO.setCurrencyName((String)currencTypeMap.get(financePO.getCurrency()));
        fscFinancePushSettleBaseBO.setRate(financePO.getExchangeRate());
        fscFinancePushSettleBaseBO.setBizDate(DateUtil.dateToStrYYYYMMdd((Date)orderPO.getCreateTime()));
        FscOrderItemPO itemPO = new FscOrderItemPO();
        itemPO.setFscOrderId(orderPO.getFscOrderId());
        itemPO = this.fscOrderItemMapper.getTaxAmtByFscOrder(itemPO);
        fscFinancePushSettleBaseBO.setTaxAmt(itemPO.getTaxAmtSum());
        fscFinancePushSettleBaseBO.setTaxLocalAmt(fscFinancePushSettleBaseBO.getTaxAmt().multiply(financePO.getExchangeRate()));
        fscFinancePushSettleBaseBO.setEstimateBillGuid(null);
        fscFinancePushSettleBaseBO.setEstimateBillCode(null);
        fscFinancePushSettleBaseBO.setEstimateBizTypeCode(null);
        if (FscConstants.FscOrderMakeType.OPERTION.equals(orderPO.getMakeType()) && FscConstants.FscOrderReceiveType.PURCHASE.equals(orderPO.getReceiveType())) {
            fscFinancePushSettleBaseBO.setRelatedKey(orderPO.getOrderNo());
        }
        return fscFinancePushSettleBaseBO;
    }

    private List<FscFinancePushSettleInvoiceBO> buildInvoiceInfo(List<FscInvoicePO> fscInvoicePOList) {
        ArrayList<FscFinancePushSettleInvoiceBO> invoiceList = new ArrayList<FscFinancePushSettleInvoiceBO>();
        fscInvoicePOList.forEach(invoice -> {
            if (Objects.isNull(invoice.getFinanceGuid())) {
                throw new FscBusinessException("198888", "\u5b58\u5728\u53d1\u7968\u672a\u4e0a\u4f20\u5171\u4eab\u7968\u5939\uff0c\u53d1\u7968ID\uff1a" + invoice.getInvoiceId());
            }
            FscFinancePushSettleInvoiceBO fscFinancePushSettleInvoiceBO = new FscFinancePushSettleInvoiceBO();
            fscFinancePushSettleInvoiceBO.setOriginGuid(invoice.getFinanceGuid());
            fscFinancePushSettleInvoiceBO.setGuid(String.valueOf(invoice.getInvoiceId()));
            if ("01".equals(invoice.getInvoiceType()) && FscConstants.InvoiceCategory.PAPER.equals(invoice.getInvoiceCategory())) {
                fscFinancePushSettleInvoiceBO.setInvoiceType("1010100");
            } else if ("00".equals(invoice.getInvoiceType()) && FscConstants.InvoiceCategory.PAPER.equals(invoice.getInvoiceCategory())) {
                fscFinancePushSettleInvoiceBO.setInvoiceType("1010101");
            } else if ("01".equals(invoice.getInvoiceType()) && FscConstants.InvoiceCategory.ELECTRON.equals(invoice.getInvoiceCategory())) {
                fscFinancePushSettleInvoiceBO.setInvoiceType("1010102");
            } else if ("00".equals(invoice.getInvoiceType()) && FscConstants.InvoiceCategory.FULL_ELECTRON.equals(invoice.getInvoiceCategory())) {
                fscFinancePushSettleInvoiceBO.setInvoiceType("1010107");
            } else if ("03".equals(invoice.getInvoiceType()) && FscConstants.InvoiceCategory.FULL_ELECTRON.equals(invoice.getInvoiceCategory())) {
                fscFinancePushSettleInvoiceBO.setInvoiceType("1010108");
            }
            if (Objects.nonNull(invoice.getFullElecNo()) && FscConstants.FscInvoiceCategory.FULL.equals(invoice.getInvoiceCategory())) {
                fscFinancePushSettleInvoiceBO.setInvoiceNo(invoice.getFullElecNo());
            } else {
                fscFinancePushSettleInvoiceBO.setInvoiceNo(invoice.getInvoiceNo());
            }
            fscFinancePushSettleInvoiceBO.setInvoiceCode(invoice.getInvoiceCode());
            fscFinancePushSettleInvoiceBO.setInvoiceDate(invoice.getBillDate());
            fscFinancePushSettleInvoiceBO.setInvoiceHeader(invoice.getBuyName());
            fscFinancePushSettleInvoiceBO.setRmbAmount(invoice.getUntaxAmt());
            fscFinancePushSettleInvoiceBO.setRmbTax(invoice.getTaxAmt());
            fscFinancePushSettleInvoiceBO.setRmbAmountTax(invoice.getAmt());
            fscFinancePushSettleInvoiceBO.setCurrOccAmountTax(invoice.getAmt());
            fscFinancePushSettleInvoiceBO.setCurrOccAmount(invoice.getUntaxAmt());
            fscFinancePushSettleInvoiceBO.setCurrOccTax(invoice.getTaxAmt());
            fscFinancePushSettleInvoiceBO.setIsSimpleTax(invoice.getIsSimpleTax());
            fscFinancePushSettleInvoiceBO.setIsInputOut(invoice.getIsInputOut());
            fscFinancePushSettleInvoiceBO.setInputOutAmt(invoice.getIsInputOutAmt());
            fscFinancePushSettleInvoiceBO.setInputOutTypeCode(invoice.getInputOutTypeCode());
            fscFinancePushSettleInvoiceBO.setInputOutTypeName(invoice.getInputOutTypeName());
            invoiceList.add(fscFinancePushSettleInvoiceBO);
        });
        return invoiceList;
    }

    private FscFinancePushPayBillAbilityRspBO dealPush(FscOrderPO orderPO, FscFinancePushSettleDetailBO fscFinancePushSettleDetailBO) {
        String token = this.getToken();
        FscFinancePushSettleBusiReqBO busiReqBO = new FscFinancePushSettleBusiReqBO();
        busiReqBO.setFscOrderId(orderPO.getFscOrderId());
        busiReqBO.setFscFinancePushSettleDetailBO(fscFinancePushSettleDetailBO);
        busiReqBO.setToken(token);
        busiReqBO.setOrderNo(orderPO.getOrderNo());
        FscFinancePushSettleBusiRspBO busiRspBO = this.fscFinancePushSettleBusiService.dealPushSettle(busiReqBO);
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(orderPO.getFscOrderId());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        FscFinancePushPayBillAbilityRspBO rspBO = new FscFinancePushPayBillAbilityRspBO();
        rspBO.setRespCode(busiRspBO.getRespCode());
        rspBO.setRespDesc(busiRspBO.getRespDesc());
        return rspBO;
    }

    private List<FscFinancePushSettleAttachmentListBO> buildAttachmentInfo(List<FscAttachmentPO> attachmentPOList, FscOrderFinancePO financePO) {
        if (CollectionUtils.isEmpty(attachmentPOList)) {
            return new ArrayList<FscFinancePushSettleAttachmentListBO>();
        }
        List boList = JSONObject.parseArray((String)JSONObject.toJSONString(attachmentPOList), AttachmentBO.class);
        FscFinanceFileUploadAbilityReqBO abilityReqBO = new FscFinanceFileUploadAbilityReqBO();
        abilityReqBO.setFileList(boList);
        FscFinanceFileUploadAbilityRspBO abilityRspBO = this.fscFinanceFileUploadAbilityService.dealFinanceUpload(abilityReqBO);
        if (!"0000".equals(abilityRspBO.getRespCode())) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u9644\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a" + abilityRspBO.getRespDesc());
        }
        ArrayList<FscFinancePushSettleAttachmentListBO> fileList = new ArrayList<FscFinancePushSettleAttachmentListBO>(abilityRspBO.getFileList().size());
        for (FscFinanceAttachmentBO bo : abilityRspBO.getFileList()) {
            FscFinancePushSettleAttachmentListBO pushBo = new FscFinancePushSettleAttachmentListBO();
            pushBo.setFileId(bo.getFileId());
            pushBo.setFileName(bo.getFileName());
            pushBo.setFileSize(bo.getFileSize());
            pushBo.setCreateUserName(financePO.getFinanceUserName());
            pushBo.setCreateUser(financePO.getFinanceUserId());
            pushBo.setCreateDate(DateUtil.dateToStrLong((Date)financePO.getCreateTime()));
            fileList.add(pushBo);
        }
        return fileList;
    }

    private FscFinancePushPayBillAbilityRspBO dealBuildFail(FscOrderPO orderPO, Exception e) {
        FscFinancePushSettleBusiReqBO busiReqBO = new FscFinancePushSettleBusiReqBO();
        busiReqBO.setFscOrderId(orderPO.getFscOrderId());
        busiReqBO.setOrderNo(orderPO.getOrderNo());
        busiReqBO.setFailRemark(e.getMessage());
        this.fscFinancePushSettleBusiService.updateFailLog(busiReqBO);
        FscFinancePushPayBillAbilityRspBO rspBO = new FscFinancePushPayBillAbilityRspBO();
        rspBO.setRespCode("198888");
        rspBO.setRespDesc("\u6784\u5efa\u63a8\u9001\u5171\u4eab\u7ed3\u7b97\u5355\u53c2\u6570\u5f02\u5e38\uff1a" + e.getMessage());
        return rspBO;
    }

    private String getToken() {
        FscFinanceShareTokenRspBO shareToken = this.fscFinanceShareRelatedInterfacesAtomService.getFinanceShareToken();
        if (StringUtils.isEmpty((Object)shareToken.getToken())) {
            throw new FscBusinessException("198888", "\u83b7\u53d6\u8d22\u52a1\u5171\u4eabtoken\u4fe1\u606f\u5931\u8d25\uff1a" + shareToken.getRespDesc());
        }
        return shareToken.getToken();
    }
}

