/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.atom.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.atom.api.FscBillOrderRefundChangeAtomService;
import com.tydic.fsc.bill.atom.bo.FscBillOrderRefundChangeAtomReqBO;
import com.tydic.fsc.bill.atom.bo.FscBillOrderRefundChangeAtomRspBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscOrderWriteRelationMapper;
import com.tydic.fsc.dao.FscRefundChangeItemMapper;
import com.tydic.fsc.dao.FscRefundChangeMapper;
import com.tydic.fsc.dao.FscRefundOrderRelationMapper;
import com.tydic.fsc.dao.FscRefundWriteRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRefundBO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscOrderWriteRelationPO;
import com.tydic.fsc.po.FscRefundChangeItemPO;
import com.tydic.fsc.po.FscRefundChangePO;
import com.tydic.fsc.po.FscRefundOrderRelationPO;
import com.tydic.fsc.po.FscRefundWriteRelationPO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.umc.general.ability.api.DycUmcRefundChangeCreateCodeAbilityService;
import com.tydic.umc.general.ability.bo.DycUmcRefundChangeCreateCodeAbilityReqBO;
import com.tydic.umc.general.ability.bo.DycUmcRefundChangeCreateCodeAbilityRspBO;
import com.tydic.uoc.common.ability.api.UocOrderInfoQueryAbilityService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillOrderRefundChangeAtomServiceImpl
implements FscBillOrderRefundChangeAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderRefundChangeAtomServiceImpl.class);
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private UocOrderInfoQueryAbilityService uocOrderInfoQueryAbilityService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscRefundChangeMapper fscRefundChangeMapper;
    @Autowired
    private FscRefundChangeItemMapper fscRefundChangeItemMapper;
    @Value(value="${OPER_ORG_ID}")
    private String operationOrgId;
    @Value(value="${OPER_ORG_NAME}")
    private String operationOrgName;
    @Autowired
    private FscOrderWriteRelationMapper fscOrderWriteRelationMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscRefundWriteRelationMapper fscRefundWriteRelationMapper;
    @Autowired
    private FscRefundOrderRelationMapper fscRefundOrderRelationMapper;
    @Autowired
    private DycUmcRefundChangeCreateCodeAbilityService dycUmcRefundChangeCreateCodeAbilityService;

    @Override
    @FscDuplicateCommitLimit
    public FscBillOrderRefundChangeAtomRspBO recordRefundChange(FscBillOrderRefundChangeAtomReqBO reqBO) {
        FscBillOrderRefundChangeAtomRspBO rspBO = new FscBillOrderRefundChangeAtomRspBO();
        if (reqBO.getRefundId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getOperationType() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[operationType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getRefundId());
        refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
        if (refundPO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u9000\u7968\u5355\u76f8\u5173\u4fe1\u606f\uff01");
        }
        if (refundPO.getChangeAmt() == null) {
            refundPO.setChangeAmt(BigDecimal.ZERO);
        }
        if (refundPO.getReceiveType().equals(FscConstants.FscOrderReceiveType.OPERATION)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u975e\u9500\u552e\u7ed3\u7b97\u5355\u65f6\u4e0d\u7528\u8bb0\u5f55\uff0c\u76f4\u63a5\u8fd4\u56de");
            return rspBO;
        }
        if (reqBO.getOperationType() == 1) {
            List refundChangePOS = this.fscRefundChangeMapper.queryByRefundId(reqBO.getRefundId());
            if (CollectionUtils.isEmpty((Collection)refundChangePOS)) {
                this.dearRefundNew(reqBO, refundPO);
            } else if (refundPO.getChangeAmt().compareTo(refundPO.getRefundAmount()) == 0) {
                this.updateHandleUse(reqBO, refundPO);
            } else if (refundPO.getChangeAmt().compareTo(refundPO.getRefundAmount()) != 0) {
                this.dealRefundBack(refundPO);
                this.dearRefundNew(reqBO, refundPO);
            }
        } else if (reqBO.getOperationType() == 2) {
            this.dealRefundBack(refundPO);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void updateHandleUse(FscBillOrderRefundChangeAtomReqBO reqBO, FscOrderRefundPO refundPO) {
        FscRefundChangePO updateChangePO = new FscRefundChangePO();
        updateChangePO.setRefundId(reqBO.getRefundId());
        updateChangePO.setYcUserId(refundPO.getYcUserId());
        updateChangePO.setYcUserName(refundPO.getYcPersonName());
        updateChangePO.setYcDeptId(refundPO.getYcDeptId());
        updateChangePO.setYcDeptName(refundPO.getYcDeptName());
        this.fscRefundChangeMapper.updateByRefundId(updateChangePO);
        FscRefundChangeItemPO updateChangeItemPO = new FscRefundChangeItemPO();
        updateChangeItemPO.setRefundId(reqBO.getRefundId());
        updateChangeItemPO.setHandleUserName(refundPO.getYcPersonName());
        updateChangeItemPO.setHandleUserId(refundPO.getYcUserId());
        updateChangeItemPO.setHandleDeptId(refundPO.getYcDeptId());
        updateChangeItemPO.setHandleDeptName(refundPO.getYcDeptName());
        this.fscRefundChangeItemMapper.updateByRefundId(updateChangeItemPO);
    }

    private void dearRefund(FscBillOrderRefundChangeAtomReqBO reqBO, FscOrderRefundPO refundPO) {
    }

    private void dealPrePayRefund(BigDecimal toPayAmount, BigDecimal payPaidAmt, FscOrderRefundPO refundPO) {
    }

    private List<FscClaimDetailPO> dealShouldPayRefund(BigDecimal toPayAmount, BigDecimal payPaidAmt, FscOrderRefundPO refundPO) {
        if (payPaidAmt.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        BigDecimal shouldPayChargeAmount = refundPO.getRefundAmount().subtract(toPayAmount);
        List detailPOList = this.fscClaimDetailMapper.qryListByFscOrderId(refundPO.getFscOrderId(), null);
        ArrayList<FscClaimDetailPO> updateClaimDetailList = new ArrayList<FscClaimDetailPO>();
        for (FscClaimDetailPO fscClaimDetailPO : detailPOList) {
            fscClaimDetailPO.setClaimAmt(fscClaimDetailPO.getClaimAmt().subtract(fscClaimDetailPO.getRefundAmt()));
            if (shouldPayChargeAmount.compareTo(BigDecimal.ZERO) <= 0) break;
            if (fscClaimDetailPO.getClaimAmt().compareTo(shouldPayChargeAmount) >= 0) {
                fscClaimDetailPO.setRefundAmt(shouldPayChargeAmount);
                shouldPayChargeAmount = BigDecimal.ZERO;
                updateClaimDetailList.add(fscClaimDetailPO);
                continue;
            }
            if (fscClaimDetailPO.getClaimAmt().compareTo(shouldPayChargeAmount) >= 0) continue;
            fscClaimDetailPO.setRefundAmt(fscClaimDetailPO.getClaimAmt());
            shouldPayChargeAmount = shouldPayChargeAmount.subtract(fscClaimDetailPO.getClaimAmt());
            updateClaimDetailList.add(fscClaimDetailPO);
        }
        return updateClaimDetailList;
    }

    private void dealChangeInfo(FscOrderRefundPO refundPO, List<FscClaimDetailPO> updateClaimDetailList, List<FscRefundWriteRelationPO> refundRelationPOList, List<FscOrderWriteRelationPO> orderWriteRelationPOList) {
        if (CollectionUtils.isEmpty(updateClaimDetailList)) {
            return;
        }
        Map<Long, List<FscClaimDetailPO>> claimDetailMap = updateClaimDetailList.stream().collect(Collectors.groupingBy(FscClaimDetailPO::getClaimId));
        HashMap<Long, String> changeCodeMap = new HashMap<Long, String>();
        for (FscClaimDetailPO fscClaimDetailPO : updateClaimDetailList) {
            if (changeCodeMap.containsKey(fscClaimDetailPO.getClaimId())) continue;
            changeCodeMap.put(fscClaimDetailPO.getClaimId(), fscClaimDetailPO.getClaimNo());
        }
        this.getClaimChangeCode(changeCodeMap);
        ArrayList<FscRefundChangePO> changePOList = new ArrayList<FscRefundChangePO>();
        ArrayList<FscRefundChangeItemPO> changeItemPOList = new ArrayList<FscRefundChangeItemPO>();
        HashMap<Long, Long> changeItemMap = new HashMap<Long, Long>();
        Map claimTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_VIRTUAL_CHANGE_CLAIM_TYPE");
        for (Long claimId : claimDetailMap.keySet()) {
            FscClaimDetailPO fscClaimDetailPO = claimDetailMap.get(claimId).get(0);
            FscRefundChangePO fscRefundChangePO = new FscRefundChangePO();
            fscRefundChangePO.setChangeId(Long.valueOf(Sequence.getInstance().nextId()));
            fscRefundChangePO.setRefundId(refundPO.getRefundId());
            fscRefundChangePO.setChangeNo((String)changeCodeMap.get(fscClaimDetailPO.getClaimId()));
            fscRefundChangePO.setYcUserId(refundPO.getYcUserId());
            fscRefundChangePO.setYcUserName(refundPO.getYcPersonName());
            fscRefundChangePO.setYcDeptId(refundPO.getYcDeptId());
            fscRefundChangePO.setYcDeptName(refundPO.getYcDeptName());
            fscRefundChangePO.setYcOrgId(Long.valueOf(this.operationOrgId));
            fscRefundChangePO.setYcOrgName(this.operationOrgName);
            fscRefundChangePO.setCreateUserId(refundPO.getOperatorId());
            fscRefundChangePO.setCreateTime(new Date());
            fscRefundChangePO.setClaimId(fscClaimDetailPO.getClaimId());
            fscRefundChangePO.setClaimNo(fscClaimDetailPO.getClaimNo());
            fscRefundChangePO.setDelFlag(FscConstants.DicDelFlag.NO);
            BigDecimal changeAmt = BigDecimal.ZERO;
            for (FscClaimDetailPO claimDetailPO : claimDetailMap.get(claimId)) {
                FscRefundChangeItemPO changeItemPO = new FscRefundChangeItemPO();
                changeItemPO.setChangeItemId(Long.valueOf(Sequence.getInstance().nextId()));
                changeItemMap.put(claimDetailPO.getClaimDetailId(), changeItemPO.getChangeItemId());
                changeItemPO.setPreClaimType(Integer.valueOf(claimDetailPO.getClaimType()));
                changeItemPO.setRefundId(refundPO.getRefundId());
                changeItemPO.setPreFscOrderId(claimDetailPO.getFscOrderId());
                changeItemPO.setPreFscOrderNo(claimDetailPO.getFscOrderNo());
                changeItemPO.setPreClaimId(claimDetailPO.getClaimId());
                changeItemPO.setPreClaimDetailId(claimDetailPO.getClaimDetailId());
                changeItemPO.setPreHandleUserId(claimDetailPO.getHandleUserId());
                changeItemPO.setPreHandleUserName(claimDetailPO.getHandleUserName());
                changeItemPO.setPreHandleDeptId(claimDetailPO.getHandleDeptId());
                changeItemPO.setPreHandleDeptName(claimDetailPO.getHandleDeptName());
                changeItemPO.setChangeAmt(claimDetailPO.getRefundAmt());
                if (StringUtils.isEmpty((CharSequence)((CharSequence)claimTypeMap.get(claimTypeMap.get(claimDetailPO.getClaimType()))))) {
                    throw new FscBusinessException("198888", "FSC_VIRTUAL_CHANGE_CLAIM_TYPE:" + claimDetailPO.getClaimType() + "\u5b57\u5178\u8f6c\u6362\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u5b57\u5178\uff01");
                }
                changeItemPO.setClaimType(Integer.valueOf((String)claimTypeMap.get(claimTypeMap.get(claimDetailPO.getClaimType()))));
                changeItemPO.setHandleUserName(refundPO.getYcPersonName());
                changeItemPO.setHandleUserId(refundPO.getYcUserId());
                changeItemPO.setHandleDeptId(refundPO.getYcDeptId());
                changeItemPO.setHandleDeptName(refundPO.getYcDeptName());
                changeItemPO.setClaimAmt(changeItemPO.getChangeAmt());
                changeItemPO.setDelFlag(FscConstants.DicDelFlag.NO);
                if (claimDetailPO.getOrderId() != null) {
                    changeItemPO.setExt1(claimDetailPO.getOrderId().toString());
                }
                if (!FscConstants.RefundReasonType.ORDER_REFUND.equals(refundPO.getRefundReasonType()) && claimDetailPO.getFscOrderId() != null) {
                    changeItemPO.setDelFlag(FscConstants.DicDelFlag.YES);
                } else {
                    changeAmt = changeAmt.add(claimDetailPO.getRefundAmt());
                }
                changeItemPOList.add(changeItemPO);
            }
            if (changeAmt.compareTo(BigDecimal.ZERO) == 0) {
                fscRefundChangePO.setDelFlag(FscConstants.DicDelFlag.YES);
            }
            fscRefundChangePO.setChangeAmt(changeAmt);
            changePOList.add(fscRefundChangePO);
        }
        int count = this.fscRefundChangeMapper.insertBatch(changePOList);
        if (count != changePOList.size()) {
            throw new FscBusinessException("198888", "\u5b58\u50a8\u865a\u62df\u53d8\u66f4\u5934\u4fe1\u606f\u5931\u8d25!");
        }
        count = this.fscRefundChangeItemMapper.insertBatch(changeItemPOList);
        if (count != changeItemPOList.size()) {
            throw new FscBusinessException("198888", "\u5b58\u50a8\u865a\u62df\u53d8\u66f4\u884c\u4fe1\u606f\u5931\u8d25!");
        }
        updateClaimDetailList.removeIf(e -> e.getFscOrderId() == null);
        if (!CollectionUtils.isEmpty(updateClaimDetailList) && (count = this.fscClaimDetailMapper.updateRefundAmtBatchAdd(updateClaimDetailList)) != updateClaimDetailList.size()) {
            throw new FscBusinessException("198888", "\u66f4\u8ba4\u9886\u660e\u7ec6\u884c\u51b2\u9500\u91d1\u989d\u5931\u8d25!");
        }
        if (!CollectionUtils.isEmpty(refundRelationPOList)) {
            refundRelationPOList.forEach(e -> e.setChangeItemId((Long)changeItemMap.get(e.getClaimDetailId())));
            count = this.fscRefundWriteRelationMapper.insertBatch(refundRelationPOList);
            if (count != refundRelationPOList.size()) {
                throw new FscBusinessException("198888", "\u5b58\u50a8\u51b2\u9500\u6838\u9500\u660e\u7ec6\u4fe1\u606f\u5931\u8d25!");
            }
            count = this.fscOrderWriteRelationMapper.updateRefundAmtBatchById(orderWriteRelationPOList);
            if (count != orderWriteRelationPOList.size()) {
                throw new FscBusinessException("198888", "\u66f4\u65b0\u7ed3\u7b97\u6838\u9500\u660e\u7ec6\u4fe1\u606f\u5931\u8d25!");
            }
        }
    }

    private void dealRefundBack(FscOrderRefundPO refundPO) {
        FscOrderWriteRelationPO relationPO;
        ArrayList<FscOrderWriteRelationPO> relationPOList;
        int count;
        FscRefundChangeItemPO fscRefundChangeItemPO = new FscRefundChangeItemPO();
        fscRefundChangeItemPO.setRefundId(refundPO.getRefundId());
        List changeItemPOList = this.fscRefundChangeItemMapper.getList(fscRefundChangeItemPO);
        FscRefundWriteRelationPO refundWriteRelationPO = new FscRefundWriteRelationPO();
        refundWriteRelationPO.setRefundId(refundPO.getRefundId());
        List refundWriteRelationPOList = this.fscRefundWriteRelationMapper.getList(refundWriteRelationPO);
        FscRefundOrderRelationPO refundOrderRelationPO = new FscRefundOrderRelationPO();
        refundOrderRelationPO.setRefundId(refundPO.getRefundId());
        List orderRelationPOList = this.fscRefundOrderRelationMapper.getList(refundOrderRelationPO);
        if (!CollectionUtils.isEmpty((Collection)changeItemPOList)) {
            ArrayList<FscClaimDetailPO> detailPOList = new ArrayList<FscClaimDetailPO>(changeItemPOList.size());
            for (FscRefundChangeItemPO changeItemPO : changeItemPOList) {
                if (changeItemPO.getPreFscOrderId() == null) continue;
                FscClaimDetailPO claimDetailPO = new FscClaimDetailPO();
                claimDetailPO.setRefundAmt(changeItemPO.getChangeAmt().negate());
                claimDetailPO.setClaimDetailId(changeItemPO.getPreClaimDetailId());
                detailPOList.add(claimDetailPO);
            }
            count = this.fscRefundChangeItemMapper.deleteByRefundId(refundPO.getRefundId());
            if (count < 1) {
                throw new FscBusinessException("198888", "\u5220\u9664\u53d8\u66f4\u5355\u5931\u8d25!");
            }
            count = this.fscRefundChangeMapper.deleteByRefundId(refundPO.getRefundId());
            if (count < 1) {
                throw new FscBusinessException("198888", "\u5220\u9664\u53d8\u66f4\u660e\u7ec6\u5931\u8d25!");
            }
            if (!CollectionUtils.isEmpty(detailPOList) && (count = this.fscClaimDetailMapper.updateRefundAmtBatchAdd(detailPOList)) < detailPOList.size()) {
                throw new FscBusinessException("198888", "\u56de\u9000\u8ba4\u9886\u660e\u7ec6\u51b2\u9500\u91d1\u989d\u5931\u8d25!");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)refundWriteRelationPOList)) {
            relationPOList = new ArrayList<FscOrderWriteRelationPO>(refundWriteRelationPOList.size());
            for (FscRefundWriteRelationPO fscRefundWriteRelationPO : refundWriteRelationPOList) {
                relationPO = new FscOrderWriteRelationPO();
                relationPO.setRefundAmt(fscRefundWriteRelationPO.getAmount().negate());
                relationPO.setId(fscRefundWriteRelationPO.getWriteOffId());
                relationPOList.add(relationPO);
            }
            count = this.fscRefundWriteRelationMapper.deleteByRefundId(refundPO.getRefundId());
            if (count < refundWriteRelationPOList.size()) {
                throw new FscBusinessException("198888", "\u5220\u9664\u53d8\u66f4\u6838\u9500\u4fe1\u606f\u5931\u8d25!");
            }
            count = this.fscOrderWriteRelationMapper.updateRefundAmtBatchById(relationPOList);
            if (count < relationPOList.size()) {
                throw new FscBusinessException("198888", "\u56de\u9000\u6838\u9500\u660e\u7ec6\u51b2\u9500\u91d1\u989d\u5931\u8d25!");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)orderRelationPOList)) {
            relationPOList = new ArrayList(orderRelationPOList.size());
            for (FscRefundOrderRelationPO fscRefundOrderRelationPO : orderRelationPOList) {
                relationPO = new FscOrderRelationPO();
                relationPO.setId(fscRefundOrderRelationPO.getRelationId());
                relationPO.setRefundAmt(fscRefundOrderRelationPO.getRefundAmt().negate());
                relationPOList.add(relationPO);
            }
            int count2 = this.fscOrderRelationMapper.updateRefundAmtBatch(relationPOList);
            if (count2 != relationPOList.size()) {
                throw new FscBusinessException("198888", "\u56de\u9000\u5e94\u4ed8\u5f85\u4ed8\u6b3e\u5360\u7528\u91d1\u989d\u5931\u8d25!");
            }
            count2 = this.fscRefundOrderRelationMapper.deleteByRefundId(refundPO.getRefundId());
            if (count2 != orderRelationPOList.size()) {
                throw new FscBusinessException("198888", "\u5220\u9664\u5e94\u4ed8\u5f85\u4ed8\u6b3e\u5360\u7528\u5173\u8054\u4fe1\u606f\u5931\u8d25!");
            }
        }
    }

    private void dealSplitToPayAmount(FscOrderRefundPO refundPO, BigDecimal toPayAmount) {
    }

    private void getClaimChangeCode(Map<Long, String> changeCodeMap) {
        ArrayList<String> claimNoList = new ArrayList<String>();
        claimNoList.addAll(changeCodeMap.values());
        DycUmcRefundChangeCreateCodeAbilityReqBO abilityReqBO = new DycUmcRefundChangeCreateCodeAbilityReqBO();
        abilityReqBO.setClaimNoList(claimNoList);
        DycUmcRefundChangeCreateCodeAbilityRspBO abilityRspBO = this.dycUmcRefundChangeCreateCodeAbilityService.createRefundChangeCode(abilityReqBO);
        Map claimNoMap = abilityRspBO.getClaimNoMap();
        if (!CollectionUtils.isEmpty((Map)claimNoMap)) {
            for (Long claimId : changeCodeMap.keySet()) {
                String claimIdCode = changeCodeMap.get(claimId);
                if (claimNoMap.containsKey(claimIdCode)) {
                    changeCodeMap.put(claimId, (String)claimNoMap.get(claimIdCode));
                    continue;
                }
                throw new ZTBusinessException("\u751f\u6210\u53d8\u66f4\u5355\u53f7\u5931\u8d25");
            }
        } else {
            throw new ZTBusinessException("\u751f\u6210\u53d8\u66f4\u5355\u53f7\u5931\u8d25");
        }
    }

    private void dearRefundNew(FscBillOrderRefundChangeAtomReqBO reqBO, FscOrderRefundPO refundPO) {
        List orderList = this.fscOrderItemMapper.sumOrderAmtByRefundId(refundPO.getRefundId());
        Map<Long, FscOrderRefundBO> orderMap = orderList.stream().collect(Collectors.toMap(FscOrderRefundBO::getOrderId, e -> e));
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(refundPO.getFscOrderId());
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        List toPayList = new ArrayList();
        if (orderPO.getPayType().equals(FscConstants.FscPayType.FSC_PAY_TYPE_STAGE) || orderPO.getPayType().equals(FscConstants.FscPayType.FSC_PAY_TYPE_PERIOD) && orderPO.getShouldPayType().equals(FscConstants.MerchantPayNodeRule.SIGN) || orderPO.getSettleType().equals(FscConstants.SettleType.ORDER)) {
            toPayList = this.fscOrderRelationMapper.getShouldRefundList(refundPO.getFscOrderId(), orderMap.keySet());
        }
        BigDecimal refundToPayAmt = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(toPayList)) {
            ArrayList<FscOrderRelationPO> updateRelationList = new ArrayList<FscOrderRelationPO>();
            ArrayList<FscRefundOrderRelationPO> refundList = new ArrayList<FscRefundOrderRelationPO>();
            for (Object relationPO : toPayList) {
                FscOrderRefundBO orderBO = orderMap.get(relationPO.getOrderId());
                if (orderBO == null || orderBO.getRefundAmt().compareTo(BigDecimal.ZERO) <= 0) continue;
                FscRefundOrderRelationPO refundOrderRelationPO = new FscRefundOrderRelationPO();
                BeanUtils.copyProperties((Object)relationPO, (Object)refundOrderRelationPO);
                refundOrderRelationPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                refundOrderRelationPO.setRefundId(refundPO.getRefundId());
                refundOrderRelationPO.setCreateTime(new Date());
                refundOrderRelationPO.setRelationId(relationPO.getId());
                BigDecimal availableAmt = relationPO.getAmount().subtract(relationPO.getOperationClaimAmt()).subtract(relationPO.getRefundAmt());
                if (orderBO.getRefundAmt().compareTo(availableAmt) <= 0) {
                    refundOrderRelationPO.setRefundAmt(orderBO.getRefundAmt());
                    orderBO.setRefundAmt(BigDecimal.ZERO);
                    orderMap.remove(relationPO.getOrderId());
                } else if (orderBO.getRefundAmt().compareTo(availableAmt) > 0) {
                    refundOrderRelationPO.setRefundAmt(availableAmt);
                    orderBO.setRefundAmt(orderBO.getRefundAmt().subtract(availableAmt));
                    orderMap.put(relationPO.getOrderId(), orderBO);
                }
                refundList.add(refundOrderRelationPO);
                FscOrderRelationPO updatePO = new FscOrderRelationPO();
                updatePO.setId(relationPO.getId());
                updatePO.setRefundAmt(refundOrderRelationPO.getRefundAmt());
                updateRelationList.add(updatePO);
                refundToPayAmt = refundToPayAmt.add(refundOrderRelationPO.getRefundAmt());
            }
            if (!CollectionUtils.isEmpty(refundList)) {
                int count = this.fscOrderRelationMapper.updateRefundAmtBatch(updateRelationList);
                if (count != updateRelationList.size()) {
                    throw new FscBusinessException("198888", "\u66f4\u65b0\u5e94\u4ed8\u5f85\u4ed8\u6b3e\u5360\u7528\u91d1\u989d\u5931\u8d25!");
                }
                count = this.fscRefundOrderRelationMapper.insertBatch(refundList);
                if (count != refundList.size()) {
                    throw new FscBusinessException("198888", "\u5b58\u50a8\u51b2\u9500\u7ed3\u7b97\u5173\u8054\u4fe1\u606f\u5931\u8d25!");
                }
            }
        }
        if (CollectionUtils.isEmpty(orderMap)) {
            FscOrderRefundPO updateRefundPO = new FscOrderRefundPO();
            updateRefundPO.setRefundId(refundPO.getRefundId());
            updateRefundPO.setToPayAmount(refundToPayAmt);
            updateRefundPO.setShouldPayAmount(BigDecimal.ZERO);
            updateRefundPO.setChangeAmt(refundPO.getRefundAmount());
            this.fscOrderRefundMapper.updateById(updateRefundPO);
            return;
        }
        BigDecimal refundShouldPaidAmt = BigDecimal.ZERO;
        ArrayList<FscClaimDetailPO> detailPOList = new ArrayList<FscClaimDetailPO>();
        List payPaidList = this.fscClaimDetailMapper.qryListByFscOrderId(refundPO.getFscOrderId(), orderMap.keySet());
        for (FscClaimDetailPO fscClaimDetailPO : payPaidList) {
            fscClaimDetailPO.setClaimAmt(fscClaimDetailPO.getClaimAmt().subtract(fscClaimDetailPO.getRefundAmt()));
            FscOrderRefundBO orderBO = orderMap.get(fscClaimDetailPO.getOrderId());
            if (orderBO == null || orderBO.getRefundAmt().compareTo(BigDecimal.ZERO) <= 0) continue;
            if (fscClaimDetailPO.getClaimAmt().compareTo(orderBO.getRefundAmt()) >= 0) {
                fscClaimDetailPO.setRefundAmt(orderBO.getRefundAmt());
                orderBO.setRefundAmt(BigDecimal.ZERO);
                orderMap.remove(fscClaimDetailPO.getOrderId());
            } else if (fscClaimDetailPO.getClaimAmt().compareTo(orderBO.getRefundAmt()) < 0) {
                fscClaimDetailPO.setRefundAmt(fscClaimDetailPO.getClaimAmt());
                orderBO.setRefundAmt(orderBO.getRefundAmt().subtract(fscClaimDetailPO.getClaimAmt()));
                orderMap.put(fscClaimDetailPO.getOrderId(), orderBO);
            }
            detailPOList.add(fscClaimDetailPO);
            refundShouldPaidAmt = refundShouldPaidAmt.add(fscClaimDetailPO.getRefundAmt());
        }
        FscOrderRefundPO updateRefundPO = new FscOrderRefundPO();
        updateRefundPO.setRefundId(refundPO.getRefundId());
        updateRefundPO.setToPayAmount(refundToPayAmt);
        updateRefundPO.setShouldPayAmount(refundShouldPaidAmt);
        updateRefundPO.setChangeAmt(refundPO.getRefundAmount());
        this.fscOrderRefundMapper.updateById(updateRefundPO);
        if (CollectionUtils.isEmpty(orderMap)) {
            this.dealChangeInfo(refundPO, detailPOList, null, null);
            return;
        }
        HashMap<Long, BigDecimal> claimMap = new HashMap<Long, BigDecimal>();
        ArrayList<FscRefundWriteRelationPO> refundWriteRelationPOS = new ArrayList<FscRefundWriteRelationPO>();
        ArrayList<FscOrderWriteRelationPO> fscOrderWriteRelationPOS = new ArrayList<FscOrderWriteRelationPO>();
        FscOrderWriteRelationPO writeRelationPO = new FscOrderWriteRelationPO();
        writeRelationPO.setFscOrderId(refundPO.getFscOrderId());
        writeRelationPO.setOrderIds(orderMap.keySet());
        List writeOffList = this.fscOrderWriteRelationMapper.getRefundList(writeRelationPO);
        for (FscOrderWriteRelationPO writePO : writeOffList) {
            FscOrderRefundBO orderBO = orderMap.get(writePO.getOrderId());
            if (orderBO == null || orderBO.getRefundAmt().compareTo(BigDecimal.ZERO) <= 0) continue;
            FscRefundWriteRelationPO refundWritePO = new FscRefundWriteRelationPO();
            BeanUtils.copyProperties((Object)writePO, (Object)refundWritePO);
            BigDecimal changeAmt = (BigDecimal)claimMap.get(writePO.getClaimDetailId());
            if (changeAmt == null) {
                changeAmt = BigDecimal.ZERO;
            }
            if (orderBO.getRefundAmt().compareTo(writePO.getWriteOffAmount()) <= 0) {
                changeAmt = changeAmt.add(orderBO.getRefundAmt());
                refundWritePO.setAmount(orderBO.getRefundAmt());
                orderBO.setRefundAmt(BigDecimal.ZERO);
                orderMap.remove(orderBO.getOrderId());
            } else if (orderBO.getRefundAmt().compareTo(writePO.getWriteOffAmount()) > 0) {
                changeAmt = changeAmt.add(writePO.getWriteOffAmount());
                refundWritePO.setAmount(writePO.getWriteOffAmount());
                orderBO.setRefundAmt(orderBO.getRefundAmt().subtract(writePO.getWriteOffAmount()));
                orderMap.put(writePO.getOrderId(), orderBO);
            }
            claimMap.put(writePO.getClaimDetailId(), changeAmt);
            refundWritePO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            refundWritePO.setWriteOffId(writePO.getId());
            refundWritePO.setCreateTime(new Date());
            refundWritePO.setDelFlag(FscConstants.DicDelFlag.NO);
            refundWritePO.setRefundId(refundPO.getRefundId());
            writePO.setWriteOffAmount(writePO.getWriteOffAmount().subtract(refundWritePO.getAmount()));
            refundWriteRelationPOS.add(refundWritePO);
            FscOrderWriteRelationPO orderWriteRelationPO = new FscOrderWriteRelationPO();
            orderWriteRelationPO.setId(writePO.getId());
            orderWriteRelationPO.setRefundAmt(refundWritePO.getAmount());
            fscOrderWriteRelationPOS.add(orderWriteRelationPO);
        }
        if (!CollectionUtils.isEmpty(claimMap)) {
            FscClaimDetailPO qryVo = new FscClaimDetailPO();
            qryVo.setClaimDetailIds(claimMap.keySet());
            List claimList = this.fscClaimDetailMapper.getListNoPage(qryVo);
            claimList.forEach(e -> e.setRefundAmt((BigDecimal)claimMap.get(e.getClaimDetailId())));
            detailPOList.addAll(claimList);
        }
        this.dealChangeInfo(refundPO, detailPOList, refundWriteRelationPOS, fscOrderWriteRelationPOS);
    }
}

