/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.atom.impl.finance;

import com.tydic.fsc.bill.atom.api.finance.FscFinanceBudgetAtomService;
import com.tydic.fsc.bill.atom.bo.finance.FscFinanceBudgetReleaseAtomReqBO;
import com.tydic.fsc.bill.atom.bo.finance.FscFinanceBudgetReleaseAtomRspBO;
import com.tydic.fsc.bill.atom.bo.finance.FscFinanceBudgetUseAtomReqBO;
import com.tydic.fsc.bill.atom.bo.finance.FscFinanceBudgetUseAtomRspBO;
import com.tydic.fsc.common.ability.api.finance.FscFinanceBackBudgetLedgerSaveAbilityService;
import com.tydic.fsc.common.ability.api.finance.FscFinanceSubmitLedgerSaveAbilityService;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceBackBudgetLedgerSaveListReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceBackBudgetLedgerSaveReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceBackBudgetLedgerSaveRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceSubmitLedgerSaveListReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceSubmitLedgerSaveReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceSubmitLedgerSaveRspBO;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.util.DateUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscFinanceBudgetAtomServiceImpl
implements FscFinanceBudgetAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceBudgetAtomServiceImpl.class);
    private static final String BUSI_BUDGET = "0";
    @Resource
    private FscOrderMapper fscOrderMapper;
    @Resource
    private FscOrderItemMapper fscOrderItemMapper;
    @Resource
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscFinanceSubmitLedgerSaveAbilityService fscFinanceSubmitLedgerSaveAbilityService;
    @Autowired
    private FscFinanceBackBudgetLedgerSaveAbilityService fscFinanceBackBudgetLedgerSaveAbilityService;

    @Override
    public FscFinanceBudgetUseAtomRspBO useFinanceBudget(FscFinanceBudgetUseAtomReqBO reqBO) {
        FscFinanceBudgetUseAtomRspBO rspBO = new FscFinanceBudgetUseAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setFscOrderId(reqBO.getFscOrderId());
        List budgetList = this.fscOrderItemMapper.getBudgetItemList(fscOrderItemPO);
        if (CollectionUtils.isEmpty((Collection)budgetList)) {
            return rspBO;
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        FscOrderFinancePO financePO = new FscOrderFinancePO();
        financePO.setFscOrderId(reqBO.getFscOrderId());
        FscOrderFinancePO fscOrderFinancePO = this.fscOrderFinanceMapper.getModelBy(financePO);
        if (Objects.isNull(fscOrderPO) || Objects.isNull(fscOrderFinancePO)) {
            throw new FscBusinessException("193011", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u4fe1\u606f\uff01");
        }
        ArrayList<FscFinanceSubmitLedgerSaveListReqBO> submitLedgerSaveListReqBOList = new ArrayList<FscFinanceSubmitLedgerSaveListReqBO>();
        BigDecimal leaveAmt = ((FscOrderItemPO)budgetList.get(0)).getBudgetLeaveAmt();
        for (FscOrderItemPO item : budgetList) {
            item.setBudgetLeaveAmt(leaveAmt.subtract(item.getBudgetItemAmt()));
            leaveAmt = leaveAmt.subtract(item.getBudgetItemAmt());
            FscFinanceSubmitLedgerSaveListReqBO submitLedgerSaveListReqBO = new FscFinanceSubmitLedgerSaveListReqBO();
            submitLedgerSaveListReqBO.setBillGuid(String.valueOf(reqBO.getFscOrderId()));
            submitLedgerSaveListReqBO.setBillCode(fscOrderPO.getOrderNo());
            submitLedgerSaveListReqBO.setBudgetType(BUSI_BUDGET);
            submitLedgerSaveListReqBO.setOrgId(fscOrderFinancePO.getFinanceOrgId());
            submitLedgerSaveListReqBO.setSubTypeCode(item.getSettleItemCode());
            submitLedgerSaveListReqBO.setSubTypeName(item.getSettleItemName());
            submitLedgerSaveListReqBO.setBizSmallTypeCode(financePO.getBizTypeCode());
            submitLedgerSaveListReqBO.setBizSmallTypeName(financePO.getBizTypeName());
            submitLedgerSaveListReqBO.setCostCenterCode(item.getCostCenterCode());
            submitLedgerSaveListReqBO.setCostCenterName(item.getCostCenterName());
            submitLedgerSaveListReqBO.setBudgetItemCode(item.getBudgetItemCode());
            submitLedgerSaveListReqBO.setBudgetItemName(item.getBudgetItemName());
            submitLedgerSaveListReqBO.setLocalHoldAmt(item.getBudgetItemAmt());
            submitLedgerSaveListReqBO.setBizDate(DateUtil.dateToStr((Date)fscOrderPO.getCreateTime()));
            submitLedgerSaveListReqBO.setAccountDate(DateUtil.dateToStr((Date)new Date()));
            submitLedgerSaveListReqBOList.add(submitLedgerSaveListReqBO);
        }
        this.fscOrderItemMapper.updateBatchByList(budgetList);
        FscFinanceSubmitLedgerSaveReqBO fscFinanceSubmitLedgerSaveReqBO = new FscFinanceSubmitLedgerSaveReqBO();
        fscFinanceSubmitLedgerSaveReqBO.setSubmitLedgerSaveList(submitLedgerSaveListReqBOList);
        FscFinanceSubmitLedgerSaveRspBO fscFinanceSubmitLedgerSaveRspBO = this.fscFinanceSubmitLedgerSaveAbilityService.saveSubmitLedger(fscFinanceSubmitLedgerSaveReqBO);
        if (Objects.nonNull(fscFinanceSubmitLedgerSaveRspBO) && !"0000".equals(fscFinanceSubmitLedgerSaveRspBO.getRespCode())) {
            throw new FscBusinessException("193011", "\u8d39\u7528\u9884\u7b97\u5360\u7528\u5f02\u5e38\uff1a" + fscFinanceSubmitLedgerSaveRspBO.getRespDesc());
        }
        return rspBO;
    }

    @Override
    public FscFinanceBudgetReleaseAtomRspBO releaseFinanceBudget(FscFinanceBudgetReleaseAtomReqBO reqBO) {
        FscFinanceBudgetReleaseAtomRspBO rspBO = new FscFinanceBudgetReleaseAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setFscOrderId(reqBO.getFscOrderId());
        List budgetList = this.fscOrderItemMapper.getBudgetItemList(fscOrderItemPO);
        if (CollectionUtils.isEmpty((Collection)budgetList)) {
            return rspBO;
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        FscOrderFinancePO financePO = new FscOrderFinancePO();
        financePO.setFscOrderId(reqBO.getFscOrderId());
        FscOrderFinancePO fscOrderFinancePO = this.fscOrderFinanceMapper.getModelBy(financePO);
        if (Objects.isNull(fscOrderPO) || Objects.isNull(fscOrderFinancePO)) {
            throw new FscBusinessException("193011", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u4fe1\u606f\uff01");
        }
        Optional<BigDecimal> minLeaveAmt = budgetList.stream().map(FscOrderItemPO::getBudgetLeaveAmt).min(BigDecimal::compareTo);
        BigDecimal leaveAmt = BigDecimal.ZERO;
        if (minLeaveAmt.isPresent()) {
            leaveAmt = minLeaveAmt.get();
        }
        ArrayList<FscFinanceBackBudgetLedgerSaveListReqBO> fscFinanceBackBudgetLedgerSaveListReqBOList = new ArrayList<FscFinanceBackBudgetLedgerSaveListReqBO>();
        for (FscOrderItemPO item : budgetList) {
            leaveAmt = leaveAmt.add(item.getBudgetItemAmt());
            FscFinanceBackBudgetLedgerSaveListReqBO submitLedgerSaveListReqBO = new FscFinanceBackBudgetLedgerSaveListReqBO();
            submitLedgerSaveListReqBO.setBillGuid(String.valueOf(reqBO.getFscOrderId()));
            submitLedgerSaveListReqBO.setBillCode(fscOrderPO.getOrderNo());
            submitLedgerSaveListReqBO.setBudgetType(BUSI_BUDGET);
            submitLedgerSaveListReqBO.setOrgId(fscOrderFinancePO.getFinanceOrgId());
            submitLedgerSaveListReqBO.setSubTypeCode(item.getSettleItemCode());
            submitLedgerSaveListReqBO.setSubTypeName(item.getSettleItemName());
            submitLedgerSaveListReqBO.setBizSmallTypeCode(financePO.getBizTypeCode());
            submitLedgerSaveListReqBO.setBizSmallTypeName(financePO.getBizTypeName());
            submitLedgerSaveListReqBO.setCostCenterCode(item.getCostCenterCode());
            submitLedgerSaveListReqBO.setCostCenterName(item.getCostCenterName());
            submitLedgerSaveListReqBO.setBudgetItemCode(item.getBudgetItemCode());
            submitLedgerSaveListReqBO.setBudgetItemName(item.getBudgetItemName());
            submitLedgerSaveListReqBO.setLocalHoldAmt(item.getBudgetItemAmt());
            submitLedgerSaveListReqBO.setBizDate(DateUtil.dateToStr((Date)fscOrderPO.getCreateTime()));
            submitLedgerSaveListReqBO.setAccountDate(DateUtil.dateToStr((Date)new Date()));
            fscFinanceBackBudgetLedgerSaveListReqBOList.add(submitLedgerSaveListReqBO);
        }
        BigDecimal finalLeaveAmt = leaveAmt;
        budgetList.forEach(e -> e.setBudgetLeaveAmt(finalLeaveAmt));
        this.fscOrderItemMapper.updateBatchByList(budgetList);
        FscFinanceBackBudgetLedgerSaveReqBO fscFinanceBackBudgetLedgerSaveReqBO = new FscFinanceBackBudgetLedgerSaveReqBO();
        fscFinanceBackBudgetLedgerSaveReqBO.setBackBudgetLedgerSaveList(fscFinanceBackBudgetLedgerSaveListReqBOList);
        FscFinanceBackBudgetLedgerSaveRspBO fscFinanceBackBudgetLedgerSaveRspBO = this.fscFinanceBackBudgetLedgerSaveAbilityService.saveBackBudgetLedger(fscFinanceBackBudgetLedgerSaveReqBO);
        if (Objects.nonNull(fscFinanceBackBudgetLedgerSaveRspBO) && !"0000".equals(fscFinanceBackBudgetLedgerSaveRspBO.getRespCode())) {
            throw new FscBusinessException("193011", "\u8d39\u7528\u9884\u7b97\u91ca\u653e\u5f02\u5e38\uff1a" + fscFinanceBackBudgetLedgerSaveRspBO.getRespDesc());
        }
        return rspBO;
    }
}

