/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl.finance;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.busi.api.finance.FscFinanceSettleItemAddBusiService;
import com.tydic.fsc.bill.busi.bo.finance.FscFinanceSettleItemAddBusiReqBO;
import com.tydic.fsc.bill.busi.bo.finance.FscFinanceSettleItemAddBusiRspBO;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderItemTempMapper;
import com.tydic.fsc.dao.FscOrderRelationTempMapper;
import com.tydic.fsc.po.FscOrderItemTempPO;
import com.tydic.fsc.po.FscOrderRelationTempPO;
import com.tydic.uoc.base.constants.PebExtConstant;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscFinanceSettleItemAddBusiServiceImpl
implements FscFinanceSettleItemAddBusiService {
    @Resource
    private FscOrderRelationTempMapper fscOrderRelationTempMapper;
    @Resource
    private FscOrderItemTempMapper fscOrderItemTempMapper;

    @Override
    public FscFinanceSettleItemAddBusiRspBO addSettleItemTemp(FscFinanceSettleItemAddBusiReqBO reqBO) {
        ArrayList fscOrderItemPOS = new ArrayList();
        ArrayList fscOrderRelationPOS = new ArrayList();
        reqBO.getRelOrderList().forEach(relOrderBO -> {
            FscOrderInfoBO fscOrderInfoBO = reqBO.getFscOrderInfoBoMap().get(relOrderBO.getAcceptOrderId());
            FscOrderRelationTempPO fscOrderRelationTempPO = (FscOrderRelationTempPO)JSONObject.parseObject((String)JSON.toJSONString((Object)fscOrderInfoBO), FscOrderRelationTempPO.class);
            fscOrderRelationTempPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscOrderRelationTempPO.setFscOrderId(reqBO.getFscOrderId());
            fscOrderRelationTempPO.setContractNo(fscOrderInfoBO.getModelContractNo());
            fscOrderRelationTempPO.setContractId(fscOrderInfoBO.getModelContractId());
            fscOrderRelationTempPO.setProContractId(fscOrderInfoBO.getProModelContractId());
            fscOrderRelationTempPO.setProContractName(fscOrderInfoBO.getProModelContractName());
            fscOrderRelationTempPO.setProContractNo(fscOrderInfoBO.getProModelContractNo());
            fscOrderRelationTempPO.setProContractType(fscOrderInfoBO.getProModelContractType());
            fscOrderRelationTempPO.setProContractSource(fscOrderInfoBO.getProModelContractSource());
            fscOrderRelationTempPO.setErpInspectionNo(fscOrderInfoBO.getErpInspectionVoucherCode());
            fscOrderRelationTempPO.setContractId(fscOrderInfoBO.getFinanceContractId());
            fscOrderRelationTempPO.setContractNo(fscOrderInfoBO.getFinanceContractNo());
            BigDecimal[] settleAmt = new BigDecimal[]{BigDecimal.ZERO};
            List orderItemPOS = JSONObject.parseArray((String)JSON.toJSONString((Object)fscOrderInfoBO.getFscOrderItemBOS()), FscOrderItemTempPO.class);
            orderItemPOS.forEach(fscOrderItemPO -> {
                fscOrderItemPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                fscOrderItemPO.setContractId(fscOrderInfoBO.getFinanceContractId());
                fscOrderItemPO.setContractNo(fscOrderInfoBO.getFinanceContractNo());
                if (Objects.nonNull(fscOrderInfoBO.getOrderType()) && PebExtConstant.OrderType.CX_AGR.equals(fscOrderInfoBO.getOrderType())) {
                    fscOrderItemPO.setSkuName(fscOrderItemPO.getSkuMaterialLongDesc());
                }
                if (StringUtils.isBlank((CharSequence)fscOrderItemPO.getSettleUnit()) && fscOrderItemPO.getSalesUnitRate() != null && BigDecimal.ONE.compareTo(fscOrderItemPO.getSalesUnitRate()) == 0) {
                    fscOrderItemPO.setSettleUnit(fscOrderItemPO.getUnitName());
                }
                fscOrderItemPO.setFscOrderId(reqBO.getFscOrderId());
                settleAmt[0] = settleAmt[0].add(fscOrderItemPO.getAmt());
            });
            fscOrderRelationTempPO.setSettleAmt(settleAmt[0]);
            fscOrderRelationTempPO.setAmount(FscConstants.FscPayType.FSC_PAY_TYPE_STAGE.equals(reqBO.getPayType()) ? BigDecimal.ZERO : settleAmt[0]);
            if (FscConstants.SettleType.ORDER.equals(reqBO.getSettleType())) {
                fscOrderRelationTempPO.setAmount(BigDecimal.ZERO);
            }
            fscOrderRelationPOS.add(fscOrderRelationTempPO);
            fscOrderItemPOS.addAll(orderItemPOS);
        });
        if (!CollectionUtils.isEmpty(fscOrderItemPOS)) {
            this.fscOrderItemTempMapper.insertBatch(fscOrderItemPOS);
        }
        if (!CollectionUtils.isEmpty(fscOrderRelationPOS)) {
            this.fscOrderRelationTempMapper.insertBatch(fscOrderRelationPOS);
        }
        FscFinanceSettleItemAddBusiRspBO rspBO = new FscFinanceSettleItemAddBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

