/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.consumer;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.fsc.bill.ability.api.FscXxdzCreateZipAbilityService;
import com.tydic.fsc.bill.ability.api.FscXxdzSearchAbilityService;
import com.tydic.fsc.bill.ability.bo.FscInvoiceHcBO;
import com.tydic.fsc.bill.ability.bo.FscInvoiceOrderItemBO;
import com.tydic.fsc.bill.ability.bo.FscTracfficInvoiceExportXxdzAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscTracfficInvoiceExportXxdzAbilityRspBO;
import com.tydic.fsc.bill.ability.bo.FscTracfficInvoiceExportXxdzBO;
import com.tydic.fsc.dao.FscXxdzTaskMapper;
import com.tydic.fsc.po.FscXxdzTaskPO;
import com.tydic.fsc.utils.ExportExcel;
import com.tydic.fsc.utils.UploadUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class XxdzTaskExportConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(XxdzTaskExportConsumer.class);
    @Autowired
    private FscXxdzSearchAbilityService fscXxdzSearchAbilityService;
    @Autowired
    private FscXxdzCreateZipAbilityService fscXxdzCreateZipAbilityService;
    @Autowired
    private FscXxdzTaskMapper fscXxdzTaskMapper;
    @Autowired
    private UploadUtil uploadUtil;
    @Value(value="${elementCountPerPortion:2000}")
    private int elementCountPerPortion;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        try {
            FscXxdzTaskPO fscXxdzTaskPO;
            block16: {
                log.debug("\u751f\u6210\u7ebf\u4e0b\u5bf9\u8d26\u6587\u4ef6\u6d88\u8d39\u8005\u5f00\u59cb,\u5165\u53c2{}" + message.getContent());
                FscTracfficInvoiceExportXxdzBO fscTracfficInvoiceExportXxdzBO = (FscTracfficInvoiceExportXxdzBO)JSON.parseObject((String)message.getContent(), FscTracfficInvoiceExportXxdzBO.class);
                fscXxdzTaskPO = new FscXxdzTaskPO();
                fscXxdzTaskPO.setId(fscTracfficInvoiceExportXxdzBO.getTaskId());
                FscTracfficInvoiceExportXxdzAbilityReqBO abilityReqBO = new FscTracfficInvoiceExportXxdzAbilityReqBO();
                BeanUtils.copyProperties((Object)fscTracfficInvoiceExportXxdzBO, (Object)abilityReqBO);
                FscTracfficInvoiceExportXxdzAbilityRspBO rspBO = this.fscXxdzSearchAbilityService.dealSearch(abilityReqBO);
                if ("0000".equals(rspBO.getRespCode())) {
                    Map<Integer, List<FscInvoiceHcBO>> hcMap = this.divideHcBOList(rspBO.getHcBOList(), this.elementCountPerPortion);
                    ArrayList<String> excelUrlList = new ArrayList<String>();
                    if (hcMap.keySet().size() > 0) {
                        for (Integer index : hcMap.keySet()) {
                            List<FscInvoiceHcBO> fscInvoiceHcBOS = hcMap.get(index);
                            String path = this.exportExcelForHc(fscInvoiceHcBOS, index);
                            log.error("\u7ea2\u51b2excel\u5730\u5740:" + path);
                            excelUrlList.add(path);
                        }
                    } else {
                        ArrayList<FscInvoiceHcBO> fscInvoiceHcBOS = new ArrayList<FscInvoiceHcBO>();
                        String path = this.exportExcelForHc(fscInvoiceHcBOS, 1);
                        log.error("\u7ea2\u51b2excel\u5730\u5740:" + (String)path);
                        excelUrlList.add(path);
                    }
                    Map<Integer, List<FscInvoiceOrderItemBO>> itemMap = this.divideItemBOList(rspBO.getItemList(), this.elementCountPerPortion);
                    if (itemMap.keySet().size() > 0) {
                        for (Integer index : itemMap.keySet()) {
                            List<FscInvoiceOrderItemBO> fscInvoiceOrderItemBOS = itemMap.get(index);
                            String path = this.exportExcelForOrderItem(fscInvoiceOrderItemBOS, index);
                            log.error("\u8ba2\u5355\u660e\u7ec6excel\u5730\u5740:" + path);
                            excelUrlList.add(path);
                        }
                    } else {
                        ArrayList<FscInvoiceOrderItemBO> fscInvoiceOrderItemBOS = new ArrayList<FscInvoiceOrderItemBO>();
                        String path = this.exportExcelForOrderItem(fscInvoiceOrderItemBOS, 1);
                        log.error("\u8ba2\u5355\u660e\u7ec6excel\u5730\u5740:" + path);
                        excelUrlList.add(path);
                    }
                    for (String path : excelUrlList) {
                        log.error("\u751f\u6210\u6587\u4ef6\u7684\u5730\u5740:------->" + path);
                    }
                    String zipFileName = System.getProperty("user.dir") + "/temporaryfile/" + UUID.randomUUID().toString().replaceAll("-", "") + ".zip";
                    File zipFile = new File(zipFileName);
                    try {
                        String zipTempFilePath = this.generateZipFile(excelUrlList, zipFile, zipFileName);
                        if (StringUtils.isBlank((CharSequence)zipTempFilePath)) {
                            fscXxdzTaskPO.setFileStatus(Integer.valueOf(0));
                            fscXxdzTaskPO.setExt2("\u8fd4\u56de\u538b\u7f29\u6587\u4ef6\u4e34\u65f6\u8def\u5f84\u4e3a\u7a7a,\u751f\u6210\u538b\u7f29\u6587\u4ef6\u5931\u8d25!");
                            break block16;
                        }
                        String url = this.uploadUtil.upload(zipTempFilePath);
                        for (String fileUrl : excelUrlList) {
                            this.uploadUtil.deleteFile(fileUrl);
                        }
                        if (StringUtils.isBlank((CharSequence)url)) {
                            fscXxdzTaskPO.setFileStatus(Integer.valueOf(0));
                            fscXxdzTaskPO.setExt2("\u4e0a\u4f20\u538b\u7f29\u6587\u4ef6\u5230\u6587\u4ef6\u670d\u52a1\u5668\u5931\u8d25!");
                            break block16;
                        }
                        fscXxdzTaskPO.setFileStatus(Integer.valueOf(1));
                        fscXxdzTaskPO.setFileUrl(url);
                        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
                        String dateStr = format.format(new Date());
                        String fileName = "\u5e73\u53f0\u6d41\u91cf\u8d39\u7ebf\u4e0b\u5bf9\u8d26" + dateStr;
                        fscXxdzTaskPO.setExt3(fileName);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage());
                        e.printStackTrace();
                        fscXxdzTaskPO.setFileStatus(Integer.valueOf(0));
                        fscXxdzTaskPO.setExt2("\u751f\u6210\u538b\u7f29\u6587\u4ef6\u5931\u8d25!");
                    }
                } else {
                    fscXxdzTaskPO.setFileStatus(Integer.valueOf(0));
                    fscXxdzTaskPO.setExt2("\u67e5\u8be2\u6570\u636e\u5931\u8d25:" + rspBO.getRespDesc());
                }
            }
            this.fscXxdzTaskMapper.updateById(fscXxdzTaskPO);
            log.debug("\u751f\u6210\u7ebf\u4e0b\u5bf9\u8d26\u6587\u4ef6\u6d88\u8d39\u8005\u7ed3\u675f");
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u7ebf\u4e0b\u5bf9\u8d26\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f\u4e3a:" + e.getMessage());
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
    }

    private String generateZipFile(List<String> excelUrlList, File zipFile, String zipName) {
        log.error("---->\u8fdb\u5165\u4e86\u538b\u7f29");
        ArrayList<File> subFiles = new ArrayList<File>();
        for (String fileUrl : excelUrlList) {
            subFiles.add(new File(fileUrl));
        }
        if (!zipFile.exists()) {
            try {
                zipFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileOutputStream fileOutputStream = null;
        ZipOutputStream zipOutputStream = null;
        FileInputStream fileInputStream = null;
        try {
            fileOutputStream = new FileOutputStream(zipFile);
            zipOutputStream = new ZipOutputStream(fileOutputStream);
            ZipEntry zipEntry = null;
            if (subFiles != null) {
                for (File subFile : subFiles) {
                    int len;
                    log.error("----->\u8fdb\u5165\u4e86\u538b\u7f29\u904d\u5386");
                    fileInputStream = new FileInputStream(subFile);
                    zipEntry = new ZipEntry(subFile.getName());
                    zipOutputStream.putNextEntry(zipEntry);
                    byte[] buff = new byte[1024];
                    while ((len = fileInputStream.read(buff)) != -1) {
                        zipOutputStream.write(buff, 0, len);
                    }
                }
                zipOutputStream.closeEntry();
            }
            String string = zipName;
            return string;
        }
        catch (IOException e) {
            log.error(e.getMessage());
            throw new ZTBusinessException("\u538b\u7f29\u6587\u4ef6\u751f\u6210\u5931\u8d251\uff01");
        }
        finally {
            try {
                if (zipOutputStream != null) {
                    zipOutputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private String exportExcelForHc(List<FscInvoiceHcBO> fscInvoiceHcBOS, Integer index) {
        String[] title = new String[]{"\u51fa\u8d26\u6708", "\u53d1\u7968\u53f7\u7801", "\u53d1\u7968\u91d1\u989d", "\u7a0e\u989d", "\u4e0d\u542b\u7a0e\u91d1\u989d", "\u53d1\u7968\u72b6\u6001", "\u53d1\u7968\u4ea4\u4ed8", "\u7ed3\u7b97\u5355\u53f7", "\u4ed8\u6b3e\u65f6\u95f4", "\u91c7\u8d2d\u4ed8\u6b3e\u5355\u53f7", "\u4ed8\u6b3e\u72b6\u6001", "\u5907\u6ce8"};
        String[] field = new String[]{"czMonthStr", "invoiceNo", "invoiceMoneyStr", "taxMoneyStr", "noTaxMoneyStr", "invoiceStatue", "fpjf", "fscOrderNo", "payTimeStr", "shouldPayNo", "payStatusStr", "remark"};
        Workbook workbook = ExportExcel.createWorkbook((String[])field, (String[])title, (String)JSON.toJSONString(fscInvoiceHcBOS));
        String filePath = "\u7ea2\u51b2_" + index + "_" + UUID.randomUUID().toString() + ".xlsx";
        return ExportExcel.createExcelSetFileName((Workbook)workbook, (String)filePath);
    }

    private String exportExcelForOrderItem(List<FscInvoiceOrderItemBO> itemBOS, Integer index) {
        String[] title = new String[]{"\u8d26\u5355\u6708", "\u4e1a\u52a1\u5355\u53f7", "\u8ba2\u5355\u72b6\u6001", "\u5165\u5e93\u72b6\u6001", "\u91c7\u8d2d\u5355\u4f4d", "\u53d1\u7968\u53f7\u7801", "\u53d1\u7968\u4ee3\u7801", "\u4e0b\u5355\u65f6\u95f4", "\u5b8c\u6210\u65f6\u95f4", "\u53d1\u7968\u91d1\u989d", "\u53d1\u7968\u672a\u7a0e\u91d1\u989d", "\u53d1\u7968\u7a0e\u989d", "\u5546\u54c1\u7f16\u53f7", "\u5546\u54c1\u540d\u79f0", "\u5546\u54c1\u7a0e\u7387", "\u5546\u54c1\u6570\u91cf", "\u5546\u54c1\u542b\u7a0e\u5355\u4ef7", "\u5546\u54c1\u542b\u7a0e\u603b\u989d", "\u4e00\u7ea7\u5206\u7c7b", "\u4e8c\u7ea7\u5206\u7c7b", "\u4e09\u7ea7\u5206\u7c7b"};
        String[] field = new String[]{"zdMonthStr", "ywdh", "orderStatus", "rkStatusStr", "purName", "invoiceNo", "invoiceCode", "createTimeStr", "finshTimeStr", "invoiceMoneyStr", "noTaxMoneyStr", "taxMoneyStr", "skuNo", "skuName", "taxStr", "numStr", "haveTaxPriceStr", "haveTaxAmountStr", "one", "two", "three"};
        Workbook workbook = ExportExcel.createWorkbook((String[])field, (String[])title, (String)JSON.toJSONString(itemBOS));
        String filePath = "\u660e\u7ec6_" + index + "_" + UUID.randomUUID().toString() + ".xlsx";
        return ExportExcel.createExcelSetFileName((Workbook)workbook, (String)filePath);
    }

    public Map<Integer, List<FscInvoiceHcBO>> divideHcBOList(List<FscInvoiceHcBO> hcBOList, int elementCountPerPortion) {
        int totalElements = hcBOList.size();
        int portionCount = totalElements / elementCountPerPortion;
        HashMap<Integer, List<FscInvoiceHcBO>> resultMap = new HashMap<Integer, List<FscInvoiceHcBO>>();
        if (totalElements % elementCountPerPortion != 0) {
            ++portionCount;
        }
        for (int i = 0; i < portionCount; ++i) {
            int start = i * elementCountPerPortion;
            int end = start + elementCountPerPortion;
            if (end > totalElements) {
                end = totalElements;
            }
            List<FscInvoiceHcBO> portion = hcBOList.subList(start, end);
            resultMap.put(i + 1, portion);
        }
        return resultMap;
    }

    public Map<Integer, List<FscInvoiceOrderItemBO>> divideItemBOList(List<FscInvoiceOrderItemBO> hcBOList, int elementCountPerPortion) {
        int totalElements = hcBOList.size();
        int portionCount = totalElements / elementCountPerPortion;
        HashMap<Integer, List<FscInvoiceOrderItemBO>> resultMap = new HashMap<Integer, List<FscInvoiceOrderItemBO>>();
        if (totalElements % elementCountPerPortion != 0) {
            ++portionCount;
        }
        for (int i = 0; i < portionCount; ++i) {
            int start = i * elementCountPerPortion;
            int end = start + elementCountPerPortion;
            if (end > totalElements) {
                end = totalElements;
            }
            List<FscInvoiceOrderItemBO> portion = hcBOList.subList(start, end);
            resultMap.put(i + 1, portion);
        }
        return resultMap;
    }
}

