/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.api.FscComOrderRefundAgreeAbilityService;
import com.tydic.fsc.bill.ability.bo.FscComOrderRefundAgreeAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscComOrderRefundAgreeAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscComOrderRefundAgreeBusiService;
import com.tydic.fsc.bill.busi.bo.FscComOrderRefundAgreeBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscComOrderRefundAgreeBusiRspBO;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscComOrderRefundAgreeAbilityService"})
public class FscComOrderRefundAgreeAbilityServiceImpl
implements FscComOrderRefundAgreeAbilityService {
    @Autowired
    private FscComOrderRefundAgreeBusiService fscComOrderRefundAgreeBusiService;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealOrderRefundAgree"})
    public FscComOrderRefundAgreeAbilityRspBO dealOrderRefundAgree(@RequestBody FscComOrderRefundAgreeAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getRefundIds())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundIds]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.valid(reqBO);
        String reqString = JSONObject.toJSONString((Object)reqBO);
        FscComOrderRefundAgreeBusiReqBO busiReqBO = (FscComOrderRefundAgreeBusiReqBO)((Object)JSONObject.parseObject((String)reqString, FscComOrderRefundAgreeBusiReqBO.class));
        StringBuffer stringBuffer = new StringBuffer();
        for (Long refundId : reqBO.getRefundIds()) {
            busiReqBO.setRefundId(refundId);
            FscComOrderRefundAgreeBusiRspBO busiRspBO = this.fscComOrderRefundAgreeBusiService.dealOrderRefundAgree(busiReqBO);
            if (!busiRspBO.getRespCode().equals("0000")) {
                stringBuffer.append("\u9000\u7968\u5355[").append(refundId).append("]\u5904\u7406\u540c\u610f\u5e76\u9000\u7968\u5931\u8d25\uff1a").append(busiRspBO.getRespDesc());
                continue;
            }
            this.sendMq(refundId);
        }
        FscComOrderRefundAgreeAbilityRspBO rspBO = new FscComOrderRefundAgreeAbilityRspBO();
        if (!StringUtils.isEmpty((Object)stringBuffer.toString())) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc(stringBuffer.toString());
        } else {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        return rspBO;
    }

    private void sendMq(Long refundId) {
        FscComRefundSyncAbilityReqBO syncAbilityReqBO = new FscComRefundSyncAbilityReqBO();
        syncAbilityReqBO.setRefundIds(Collections.singletonList(refundId));
        this.fscComRefundSyncAbilityService.syncRefund(syncAbilityReqBO);
    }

    private void valid(FscComOrderRefundAgreeAbilityReqBO reqBO) {
        if (reqBO.getYcUserId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[ycUserId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getYcPersonId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[ycPersonId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getYcPersonName())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[ycPersonName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getYcDeptId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[ycDeptId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getYcDeptName())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[ycDeptName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getExt1())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[\u7528\u6237\u7684erp\u8d26\u53f7]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

