/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.tydic.fsc.bill.ability.api.FscYcCancleInvoiceAbilityService;
import com.tydic.fsc.bill.ability.bo.FscYcCancleInvoiceAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscYcCancleInvoiceAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscCancleInvoiceYcBusiService;
import com.tydic.fsc.busibase.atom.api.FscUocOrderRelUpdateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscUocOrderRelUpdateAtomReqBO;
import com.tydic.fsc.common.ability.api.FscBillMailSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComInvoiceSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscBillMailListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComInvoiceListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscYcCancleInvoiceAbilityService"})
public class FscYcCancleInvoiceAbilityServiceImpl
implements FscYcCancleInvoiceAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscYcCancleInvoiceAbilityServiceImpl.class);
    @Autowired
    private FscCancleInvoiceYcBusiService fscCancleInvoiceYcBusiService;
    @Autowired
    private FscComInvoiceSyncAbilityService fscComInvoiceSyncAbilityService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscBillMailSyncAbilityService fscBillMailSyncAbilityService;
    @Autowired
    private FscUocOrderRelUpdateAtomService fscUocOrderRelUpdateAtomService;

    @PostMapping(value={"ycCancleInvoice"})
    public FscYcCancleInvoiceAbilityRspBO ycCancleInvoice(@RequestBody FscYcCancleInvoiceAbilityReqBO reqBO) {
        this.val(reqBO);
        FscYcCancleInvoiceAbilityRspBO abilityRspBO = this.fscCancleInvoiceYcBusiService.ycCancleInvoice(reqBO);
        if (abilityRspBO.getRespCode().equals("0000") && CollectionUtils.isNotEmpty((Collection)abilityRspBO.getFscOrderIds())) {
            this.syncFscES(abilityRspBO.getFscOrderIds());
        }
        return abilityRspBO;
    }

    private void syncFscES(List<Long> fscOrderIds) {
        for (Long fscOrderId : fscOrderIds) {
            FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
            fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
            this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
            FscBillMailListSyncAbilityReqBO fscBillMailListSyncAbilityReqBO = new FscBillMailListSyncAbilityReqBO();
            fscBillMailListSyncAbilityReqBO.setFscOrderId(fscOrderId);
            this.fscBillMailSyncAbilityService.syncBillMail(fscBillMailListSyncAbilityReqBO);
            FscComInvoiceListSyncAbilityReqBO fscComInvoiceListSyncAbilityReqBO = new FscComInvoiceListSyncAbilityReqBO();
            fscComInvoiceListSyncAbilityReqBO.setFscOrderId(fscOrderId);
            this.fscComInvoiceSyncAbilityService.dealComOrderSyncEs(fscComInvoiceListSyncAbilityReqBO);
            try {
                FscUocOrderRelUpdateAtomReqBO fscUocOrderRelUpdateAtomReqBO = new FscUocOrderRelUpdateAtomReqBO();
                fscUocOrderRelUpdateAtomReqBO.setFscOrderId(fscOrderId);
                fscUocOrderRelUpdateAtomReqBO.setRelState(FscConstants.FscRelStatus.BILLED);
                fscUocOrderRelUpdateAtomReqBO.setOperType(FscConstants.FscRelUpdateAtomOperType.FSC_ORDER);
                this.fscUocOrderRelUpdateAtomService.dealRelUpdate(fscUocOrderRelUpdateAtomReqBO);
            }
            catch (Exception exception) {
                log.error(fscOrderId + "\u81ea\u52a8\u5f00\u7968\u540c\u6b65\u8ba2\u5355\u72b6\u6001\u5f02\u5e38\uff1a" + exception.getMessage());
            }
        }
    }

    private void val(FscYcCancleInvoiceAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getInvoiceNos())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[invoiceNos]\u4e3a\u7a7a");
        }
    }
}

