/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.atom.impl;

import com.tydic.fsc.bill.atom.api.FscBillOrderPaymentTermsAtomService;
import com.tydic.fsc.bill.atom.bo.FscBillOrderPaymentTermsAtomReqBO;
import com.tydic.fsc.bill.atom.bo.FscBillOrderPaymentTermsAtomRspBO;
import com.tydic.fsc.bo.FscBillTaxSendPurFscPayTermsBO;
import com.tydic.fsc.bo.FscPhasePayListBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.UocInspectionDetailsListPageQueryAbilityService;
import com.tydic.uoc.common.ability.api.UocSalesSingleDetailsListQueryAbilityService;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListPageQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListPageQueryRspBO;
import com.tydic.uoc.common.ability.bo.UocPebChildOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocPebUpperOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocPhasePayListBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscBillOrderPaymentTermsAtomServiceImpl
implements FscBillOrderPaymentTermsAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderPaymentTermsAtomServiceImpl.class);
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Value(value="${saleOrderTabId:30001}")
    private Integer TAB_ID;
    @Value(value="${acceptOrderTabId:80013}")
    private Integer ACCEPT_ORDER_TAB_ID;
    @Value(value="${fsc.yc.should.pay.des:\u8ba2\u5355\u6536\u7968}")
    private String shouldPayDesc;
    @Autowired
    private UocInspectionDetailsListPageQueryAbilityService uocInspectionDetailsListPageQueryAbilityService;
    @Autowired
    private UocSalesSingleDetailsListQueryAbilityService uocSalesSingleDetailsListQueryAbilityService;

    @Override
    public FscBillOrderPaymentTermsAtomRspBO qryPaymentTerms(FscBillOrderPaymentTermsAtomReqBO reqBO) {
        if (reqBO.getFscOrderId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(reqBO.getFscOrderId());
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        if (orderPO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u4fe1\u606f");
        }
        FscOrderRelationPO orderRelationPO = new FscOrderRelationPO();
        orderRelationPO.setFscOrderId(reqBO.getFscOrderId());
        List list = this.fscOrderRelationMapper.getOrderList(orderRelationPO);
        Long orderId = ((FscOrderRelationPO)list.get(0)).getOrderId();
        List<FscPhasePayListBO> payListBOS = null;
        if (orderPO.getSettleType().equals(FscConstants.SettleType.ORDER)) {
            payListBOS = this.qrySaleOrder(orderId, orderPO);
        }
        if (orderPO.getSettleType().equals(FscConstants.SettleType.INSPECTION)) {
            payListBOS = this.qryInspection(orderId, orderPO);
        }
        if (CollectionUtils.isEmpty(payListBOS)) {
            return new FscBillOrderPaymentTermsAtomRspBO();
        }
        ArrayList<FscBillTaxSendPurFscPayTermsBO> payTerms = new ArrayList<FscBillTaxSendPurFscPayTermsBO>();
        ArrayList<FscOrderRelationPO> qualityRelationList = new ArrayList<FscOrderRelationPO>();
        FscPhasePayListBO qualityPayBO = new FscPhasePayListBO();
        for (FscOrderRelationPO relationPO : list) {
            for (FscPhasePayListBO payListBO : payListBOS) {
                FscBillTaxSendPurFscPayTermsBO payTermsBO;
                if (payListBO.getPayType().equals(FscConstants.PaymentMethod.SHOULD_PAY)) {
                    payTermsBO = this.buildPayTerms(payListBO, relationPO, reqBO, null, orderPO);
                    payTerms.add(payTermsBO);
                } else if (payListBO.getPayType().equals(FscConstants.PaymentMethod.DEPOSIT) && orderPO.getIsQuality() == null) {
                    payTermsBO = this.buildPayTerms(payListBO, relationPO, reqBO, payListBO.getNodePayCycle(), orderPO);
                    payTerms.add(payTermsBO);
                }
                if (!payListBO.getPayType().equals(FscConstants.PaymentMethod.DEPOSIT)) continue;
                qualityPayBO = payListBO;
            }
            if (relationPO.getQualityAmt() == null || relationPO.getQualityAmt().compareTo(BigDecimal.ZERO) <= 0) continue;
            qualityRelationList.add(relationPO);
        }
        if (orderPO.getIsQuality() != null && orderPO.getIsQuality().equals(FscConstants.YES)) {
            for (FscOrderRelationPO relationPO : qualityRelationList) {
                FscBillTaxSendPurFscPayTermsBO payTermsBO = new FscBillTaxSendPurFscPayTermsBO();
                payTermsBO.setCONTRACT_NUM(relationPO.getProContractNo());
                payTermsBO.setCONTRACT_NAME(relationPO.getProContractName());
                payTermsBO.setORG_ID(reqBO.getOrgId());
                payTermsBO.setEG_PAY_TERMS_ID(qualityPayBO.getPayTermsId());
                payTermsBO.setBUZ_TYPE_DIS(qualityPayBO.getPayTypeStr());
                payTermsBO.setPAY_TERMS(qualityPayBO.getNodeName());
                payTermsBO.setAMOUNT(relationPO.getQualityAmt().setScale(2, RoundingMode.HALF_UP));
                payTermsBO.setZB_MOUNTH(DateUtil.dateToStr((Date)relationPO.getQualityDate()));
                payTerms.add(payTermsBO);
            }
        }
        FscBillOrderPaymentTermsAtomRspBO rspBO = new FscBillOrderPaymentTermsAtomRspBO();
        rspBO.setPayTerms(payTerms);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private FscBillTaxSendPurFscPayTermsBO buildPayTerms(FscPhasePayListBO payListBO, FscOrderRelationPO relationPO, FscBillOrderPaymentTermsAtomReqBO reqBO, String days, FscOrderPO orderPO) {
        FscBillTaxSendPurFscPayTermsBO payTermsBO = new FscBillTaxSendPurFscPayTermsBO();
        payTermsBO.setCONTRACT_NUM(relationPO.getProContractNo());
        payTermsBO.setCONTRACT_NAME(relationPO.getProContractName());
        payTermsBO.setORG_ID(reqBO.getOrgId());
        payTermsBO.setEG_PAY_TERMS_ID(payListBO.getPayTermsId());
        payTermsBO.setBUZ_TYPE_DIS(payListBO.getPayTypeStr());
        payTermsBO.setPAY_TERMS(payListBO.getNodeName());
        payTermsBO.setAMOUNT(relationPO.getSettleAmt().multiply(payListBO.getNodePayRatio()).divide(new BigDecimal(100), 8, RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP));
        if (!StringUtils.isEmpty((Object)days) && !days.equals("null")) {
            String warrantyDate = this.warrantyPeriod(Integer.valueOf(days), relationPO.getInspectionTime(), orderPO);
            payTermsBO.setZB_MOUNTH(warrantyDate);
        }
        return payTermsBO;
    }

    private List<FscPhasePayListBO> qryInspection(Long orderId, FscOrderPO orderPO) {
        UocInspectionDetailsListPageQueryReqBO queryReqBO = new UocInspectionDetailsListPageQueryReqBO();
        queryReqBO.setIsAfterSales(Boolean.valueOf(false));
        queryReqBO.setTabId(this.ACCEPT_ORDER_TAB_ID);
        queryReqBO.setOrderId(orderId);
        UocInspectionDetailsListPageQueryRspBO queryRspBO = this.uocInspectionDetailsListPageQueryAbilityService.getInspectionDetailsList(queryReqBO);
        if (!queryRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u9a8c\u6536\u5355\u4fe1\u606f\u5931\u8d25\uff1a" + queryRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)queryRspBO.getRows())) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u9a8c\u6536\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        UocInspectionDetailsListBO detailsListBO = (UocInspectionDetailsListBO)queryRspBO.getRows().get(0);
        if (orderPO.getReceiveType().equals(FscConstants.FscOrderReceiveType.OPERATION)) {
            if (detailsListBO.getProPayType().equals(FscConstants.FscPayType.FSC_PAY_TYPE_PERIOD) && detailsListBO.getProPayNodeRule().equals(FscConstants.MerchantPayNodeRule.SIGN)) {
                return this.parseShouldPay(detailsListBO.getProPayTermsId(), detailsListBO.getProPaymentDays(), detailsListBO.getPayAccountDay());
            }
            if (detailsListBO.getProPayType().equals(FscConstants.FscPayType.FSC_PAY_TYPE_STAGE)) {
                return this.parsePayInfo(detailsListBO.getProPayList());
            }
        } else {
            if (detailsListBO.getPayType().equals(FscConstants.FscPayType.FSC_PAY_TYPE_PERIOD) && detailsListBO.getPayNodeRule().equals(FscConstants.MerchantPayNodeRule.SIGN)) {
                return this.parseShouldPay(detailsListBO.getPayTermsId(), detailsListBO.getPaymentDays(), detailsListBO.getPayAccountDay());
            }
            if (detailsListBO.getPayType().equals(FscConstants.FscPayType.FSC_PAY_TYPE_STAGE)) {
                return this.parsePayInfo(detailsListBO.getPayList());
            }
        }
        return null;
    }

    private List<FscPhasePayListBO> qrySaleOrder(Long orderId, FscOrderPO orderPO) {
        UocSalesSingleDetailsListQueryReqBO queryReqBO = new UocSalesSingleDetailsListQueryReqBO();
        queryReqBO.setIsAfterSales(Boolean.valueOf(false));
        queryReqBO.setOrderIdList(Collections.singletonList(orderId));
        queryReqBO.setTabId(this.TAB_ID);
        UocSalesSingleDetailsListQueryRspBO queryRspBO = this.uocSalesSingleDetailsListQueryAbilityService.getUocSalesSingleDetailsListQuery(queryReqBO);
        if (!queryRspBO.getRespCode().equals("0000")) {
            throw new UocProBusinessException("190000", "\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff1a" + queryRspBO.getRespCode());
        }
        if (CollectionUtils.isEmpty((Collection)queryRspBO.getRows())) {
            throw new UocProBusinessException("190000", "\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        UocPebChildOrderAbilityBO childOrderAbilityBO = (UocPebChildOrderAbilityBO)((UocPebUpperOrderAbilityBO)queryRspBO.getRows().get(0)).getChildOrderList().get(0);
        if (orderPO.getReceiveType().equals(FscConstants.FscOrderReceiveType.OPERATION)) {
            if (childOrderAbilityBO.getProPayType().equals(FscConstants.FscPayType.FSC_PAY_TYPE_PERIOD) && childOrderAbilityBO.getProPayNodeRule().equals(FscConstants.MerchantPayNodeRule.SIGN)) {
                return this.parseShouldPay(childOrderAbilityBO.getProPayTermsId(), childOrderAbilityBO.getProPaymentDays(), childOrderAbilityBO.getProPayAccountDay());
            }
            if (childOrderAbilityBO.getProPayType().equals(FscConstants.FscPayType.FSC_PAY_TYPE_STAGE)) {
                return this.parsePayInfo(childOrderAbilityBO.getProPayList());
            }
        } else {
            if (childOrderAbilityBO.getPayType().equals(FscConstants.FscPayType.FSC_PAY_TYPE_PERIOD) && childOrderAbilityBO.getPayNodeRule().equals(FscConstants.MerchantPayNodeRule.SIGN)) {
                return this.parseShouldPay(childOrderAbilityBO.getPayTermsId(), childOrderAbilityBO.getPaymentDays(), childOrderAbilityBO.getPayAccountDay());
            }
            if (childOrderAbilityBO.getPayType().equals(FscConstants.FscPayType.FSC_PAY_TYPE_STAGE)) {
                return this.parsePayInfo(childOrderAbilityBO.getPayList());
            }
        }
        return null;
    }

    private List<FscPhasePayListBO> parseShouldPay(Long payTermsId, Integer payNodeDays, Integer payAccountDay) {
        ArrayList<FscPhasePayListBO> payBOList = new ArrayList<FscPhasePayListBO>();
        FscPhasePayListBO payListBO = new FscPhasePayListBO();
        payListBO.setPayType(FscConstants.PaymentMethod.SHOULD_PAY);
        payListBO.setPayTypeStr("\u5e94\u4ed8\u6b3e");
        payListBO.setPayNode(UocCoreConstant.PayNode.SP);
        payListBO.setNodePayRatio(new BigDecimal(100));
        payListBO.setPayTermsId(payTermsId + "");
        if (payNodeDays != null) {
            payListBO.setNodeName(this.shouldPayDesc + payNodeDays + "\u5929\u4ed8" + 100 + "%");
        }
        if (payAccountDay != null) {
            payListBO.setNodeName(this.shouldPayDesc + payNodeDays + "\u5929\u4ed8" + 100 + "%");
        }
        payBOList.add(payListBO);
        return payBOList;
    }

    private List<FscPhasePayListBO> parsePayInfo(List<UocPhasePayListBO> payList) {
        ArrayList<FscPhasePayListBO> payBOList = new ArrayList<FscPhasePayListBO>();
        for (UocPhasePayListBO uocPhasePayListBO : payList) {
            FscPhasePayListBO payListBO = new FscPhasePayListBO();
            payListBO.setNodePayCycle(uocPhasePayListBO.getNodePayCycle());
            payListBO.setPayType(uocPhasePayListBO.getPayType());
            payListBO.setPayNode(uocPhasePayListBO.getPayNode());
            payListBO.setNodePayRatio(uocPhasePayListBO.getNodePayRatio());
            payListBO.setPayTermsId(uocPhasePayListBO.getPayTermsId());
            if (uocPhasePayListBO.getPayType().equals(FscConstants.PaymentMethod.SHOULD_PAY)) {
                payListBO.setPayTypeStr("\u5e94\u4ed8\u6b3e");
                if (!StringUtils.isEmpty((Object)uocPhasePayListBO.getNodePayCycle()) && !"null".equals(uocPhasePayListBO.getNodePayCycle())) {
                    payListBO.setNodeName(uocPhasePayListBO.getNodeName() + uocPhasePayListBO.getNodePayCycle() + "\u5929\u4ed8" + uocPhasePayListBO.getNodePayRatio() + "%");
                }
                payBOList.add(payListBO);
                continue;
            }
            if (!uocPhasePayListBO.getPayType().equals(FscConstants.PaymentMethod.DEPOSIT)) continue;
            payListBO.setPayTypeStr("\u8d28\u4fdd\u91d1");
            if (!StringUtils.isEmpty((Object)uocPhasePayListBO.getNodePayCycle()) && !"null".equals(uocPhasePayListBO.getNodePayCycle())) {
                payListBO.setNodeName(uocPhasePayListBO.getNodeName() + uocPhasePayListBO.getNodePayCycle() + "\u5929\u4ed8" + uocPhasePayListBO.getNodePayRatio() + "%");
            }
            payBOList.add(payListBO);
        }
        return payBOList;
    }

    private String warrantyPeriod(Integer days, Date startTime, FscOrderPO orderPO) {
        if (startTime == null) {
            startTime = orderPO.getCreateTime();
        }
        Calendar date = Calendar.getInstance();
        date.setTime(startTime);
        date.add(5, days);
        return DateUtil.dateToStr((Date)date.getTime());
    }
}

