/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.atom.impl;

import com.tydic.fsc.bill.atom.api.FscBillOrderSettleCheckAtomService;
import com.tydic.fsc.bill.atom.bo.FscBillOrderSettleCheckAtomReqBO;
import com.tydic.fsc.bill.atom.bo.FscBillOrderSettleCheckAtomRspBO;
import com.tydic.fsc.dao.FscOrderSettleTypeMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderSettleTypePO;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillOrderSettleCheckAtomServiceImpl
implements FscBillOrderSettleCheckAtomService {
    @Autowired
    private FscOrderSettleTypeMapper fscOrderSettleTypeMapper;

    @Override
    public FscBillOrderSettleCheckAtomRspBO dealOrderSettleCheck(FscBillOrderSettleCheckAtomReqBO reqBO) {
        this.valid(reqBO);
        HashSet<Long> orderIds = new HashSet<Long>(reqBO.getOrderIds());
        FscOrderSettleTypePO settleTypePO = new FscOrderSettleTypePO();
        settleTypePO.setOrderIds(orderIds);
        settleTypePO.setUserType(reqBO.getUserType());
        List settleList = this.fscOrderSettleTypeMapper.getList(settleTypePO);
        for (Object fscOrderSettleTypePO : settleList) {
            if (!fscOrderSettleTypePO.getSettleType().equals(reqBO.getSettleType())) {
                throw new FscBusinessException("198888", "\u5b58\u5728\u8ba2\u5355[" + fscOrderSettleTypePO.getOrderId() + "]\u7ed3\u7b97\u7c7b\u578b\u4e0d\u4e00\u81f4\uff01");
            }
            orderIds.remove(fscOrderSettleTypePO.getOrderId());
        }
        if (!CollectionUtils.isEmpty(orderIds)) {
            ArrayList<FscOrderSettleTypePO> settleTypeList = new ArrayList<FscOrderSettleTypePO>();
            for (Long orderId : orderIds) {
                FscOrderSettleTypePO fscOrderSettleTypePO = new FscOrderSettleTypePO();
                fscOrderSettleTypePO.setUserType(reqBO.getUserType());
                fscOrderSettleTypePO.setSettleType(reqBO.getSettleType());
                fscOrderSettleTypePO.setOrderId(orderId);
                settleTypeList.add(fscOrderSettleTypePO);
            }
            try {
                this.fscOrderSettleTypeMapper.insertBatch(settleTypeList);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new FscBusinessException("198888", "\u7cfb\u7edf\u7e41\u5fd9\uff01\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
            }
        }
        FscBillOrderSettleCheckAtomRspBO atomRspBO = new FscBillOrderSettleCheckAtomRspBO();
        atomRspBO.setRespCode("0000");
        atomRspBO.setRespDesc("\u6210\u529f");
        return atomRspBO;
    }

    private void valid(FscBillOrderSettleCheckAtomReqBO reqBO) {
        if (CollectionUtils.isEmpty(reqBO.getOrderIds())) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u8ba2\u5355id[orderIds]\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getUserType() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u7528\u6237\u7c7b\u578b[userType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getSettleType() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u7ed3\u7b97\u7c7b\u578b[settleType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

