/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.atom.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.ability.api.FscBillAddPushLogAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillDealPushLogAbilityReqBO;
import com.tydic.fsc.bill.atom.api.FscPushYcMemInvoiceAtomService;
import com.tydic.fsc.bill.atom.bo.FscPushYcMemInvoiceAtomReqBO;
import com.tydic.fsc.bill.atom.bo.FscPushYcMemInvoiceAtomRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscBillTaxSendSaleFscOrderToYCInvoiceItemBO;
import com.tydic.fsc.busibase.external.api.bo.FscBillTaxSendSaleFscOrderToYCReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscBillTaxSendSaleFscOrderToYCRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscBillTaxSendSaleFscOrderToYCSettlementInfoBO;
import com.tydic.fsc.busibase.external.api.bo.FscBillTaxSendSaleFscOrderToYCVerificationBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleDecryptionReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleDecryptionRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleEncryPtionReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleEncryPtionRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscBillTaxSendSaleFscOrderToYCService;
import com.tydic.fsc.busibase.external.api.esb.FscGetErpCustInfoService;
import com.tydic.fsc.busibase.external.api.esb.FscUnifySettleRelatedInterfacesAtomService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscDicDictionaryExernalMapper;
import com.tydic.fsc.dao.FscOrderExtMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderWriteRelationMapper;
import com.tydic.fsc.dao.FscWriteOffMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscDicDictionaryExernalPO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderWriteRelationPO;
import com.tydic.fsc.po.FscWriteOffPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.uac.exception.BusinessException;
import com.tydic.uoc.common.ability.api.PebExtUnifySettlePersonQryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscPushYcMemInvoiceAtomServiceImpl
implements FscPushYcMemInvoiceAtomService {
    @Autowired
    FscBillTaxSendSaleFscOrderToYCService fscBillTaxSendSaleFscOrderToYCService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscDicDictionaryExernalMapper fscDicDictionaryExernalMapper;
    @Value(value="${OPER_ORG_ID}")
    private String operOrgId;
    @Value(value="${OPER_ORG_NAME}")
    private String operOrgName;
    @Value(value="${fsc.invoice.priceMode:N}")
    private String priceMode;
    @Value(value="${fsc.member.invoice.taxCode.itemDescription:\u4f1a\u5458\u8d39}")
    private String itemDescription;
    @Autowired
    private FscGetErpCustInfoService fscGetErpCustInfoService;
    @Autowired
    private FscBillAddPushLogAbilityService fscBillAddPushLogAbilityService;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscWriteOffMapper fscWriteOffMapper;
    @Autowired
    private FscOrderWriteRelationMapper fscOrderWriteRelationMapper;
    @Autowired
    private PebExtUnifySettlePersonQryAbilityService pebExtUnifySettlePersonQryAbilityService;
    @Autowired
    private FscUnifySettleRelatedInterfacesAtomService fscUnifySettleRelatedInterfacesAtomService;
    @Autowired
    private FscOrderExtMapper fscOrderExtMapper;
    @Value(value="${fsc.member.invoice.agentAccount:10228059}")
    private String agent;

    @Override
    @FscDuplicateCommitLimit
    public FscPushYcMemInvoiceAtomRspBO dealPushMemInvoice(FscPushYcMemInvoiceAtomReqBO reqBO) {
        FscOrderPO orderPo = new FscOrderPO();
        orderPo.setFscOrderId(reqBO.getFscOrderId());
        orderPo = this.fscOrderMapper.getModelBy(orderPo);
        if (orderPo == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u4fe1\u606f\uff01");
        }
        FscOrderInvoicePO orderInvoicePo = new FscOrderInvoicePO();
        orderInvoicePo.setFscOrderId(reqBO.getFscOrderId());
        orderInvoicePo = this.fscOrderInvoiceMapper.getModelBy(orderInvoicePo);
        if (orderInvoicePo == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u5f00\u7968\u4fe1\u606f\uff01");
        }
        FscOrderItemPO orderItemPo = new FscOrderItemPO();
        orderItemPo.setFscOrderId(reqBO.getFscOrderId());
        orderItemPo = this.fscOrderItemMapper.getModelBy(orderItemPo);
        if (orderItemPo == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u5f00\u7968\u660e\u7ec6\u4fe1\u606f\uff01");
        }
        FscBillDealPushLogAbilityReqBO logAbilityReqBO = new FscBillDealPushLogAbilityReqBO();
        logAbilityReqBO.setCreateTime(new Date());
        logAbilityReqBO.setObjectId(orderPo.getFscOrderId());
        logAbilityReqBO.setObjectNo(orderPo.getOrderNo());
        logAbilityReqBO.setType(FscConstants.FscPushType.SETTLE);
        FscBillTaxSendSaleFscOrderToYCRspBO fscBillTaxSendSaleFscOrderToYCRspBO = null;
        try {
            FscDicDictionaryExernalPO dicDictionaryExernalPO = new FscDicDictionaryExernalPO();
            dicDictionaryExernalPO.setExernalSysCode("YC");
            List fscDicDictionaryExernalPOList = this.fscDicDictionaryExernalMapper.getListByCondition(dicDictionaryExernalPO);
            Integer orderSource = orderPo.getOrderType();
            List fscTypeList = fscDicDictionaryExernalPOList.stream().filter(p -> p.getPCode().equals("FSC_ORDER_SOURCE")).filter(p -> p.getCode().equals(orderSource + "")).map(FscDicDictionaryExernalPO::getExernalCode).collect(Collectors.toList());
            String invoiceKey = FscConstants.FscInvoiceCategory.ELEC.equals(orderInvoicePo.getInvoiceCategory()) ? "FSC_INVOICE_TYPE_SALE_ELECTORNIC" : (FscConstants.FscInvoiceCategory.FULL.equals(orderInvoicePo.getInvoiceCategory()) ? "FSC_INVOICE_TYPE_ELECTRONIC_FULL" : "FSC_INVOICE_TYPE_SALE");
            String invoiceType = orderInvoicePo.getInvoiceType();
            List invoiceTypeList = fscDicDictionaryExernalPOList.stream().filter(p -> p.getPCode().equals(invoiceKey)).filter(p -> p.getCode().equals(invoiceType)).map(FscDicDictionaryExernalPO::getExernalCode).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(fscTypeList)) {
                throw new FscBusinessException("193128", "\u7ed3\u7b97\u7c7b\u578b\u672a\u5339\u914d\u5230\u7801\u503c\uff0c\u8bf7\u901a\u77e5\u8fd0\u7ef4\u7ef4\u62a4[SYS_DIC_DICTIONARY_EXERNAL]");
            }
            if (CollectionUtils.isEmpty(invoiceTypeList)) {
                throw new FscBusinessException("193128", "\u53d1\u7968\u7c7b\u578b\u672a\u5339\u914d\u5230\u7801\u503c\uff0c\u8bf7\u901a\u77e5\u8fd0\u7ef4\u7ef4\u62a4[SYS_DIC_DICTIONARY_EXERNAL]");
            }
            FscBillTaxSendSaleFscOrderToYCSettlementInfoBO saleSettlementInfo = new FscBillTaxSendSaleFscOrderToYCSettlementInfoBO();
            saleSettlementInfo.setORG_ID(this.operOrgId);
            saleSettlementInfo.setORG_NAME(this.operOrgName);
            saleSettlementInfo.setINIT_FLAG("Y");
            saleSettlementInfo.setDEPT_ID(orderPo.getYcDeptId() + "");
            saleSettlementInfo.setDEPT_NAME(orderPo.getYcDeptName());
            saleSettlementInfo.setCHARGEMAN_ID(orderPo.getYcUserId() + "");
            saleSettlementInfo.setCHARGEMAN_NAME(orderPo.getYcUserName());
            saleSettlementInfo.setSETTLE_NUMBER(orderPo.getOrderNo());
            saleSettlementInfo.setSETTLE_NAME(orderPo.getOrderName());
            saleSettlementInfo.setOE_CNT_NUMBER(orderPo.getContractNo());
            saleSettlementInfo.setOE_CNT_NAME("");
            saleSettlementInfo.setSETTLE_TYPE((String)fscTypeList.get(0));
            saleSettlementInfo.setTWO_CUSTOMER_NAME(null);
            saleSettlementInfo.setOE_CNT_IN_TAX_AMT(null);
            saleSettlementInfo.setTHIS_SETTLE_AMT(orderPo.getTotalCharge().setScale(2, 4));
            saleSettlementInfo.setINVOICE_TYPE((String)invoiceTypeList.get(0));
            saleSettlementInfo.setIDENTIFICATION_NUMBER(orderInvoicePo.getTaxNo());
            saleSettlementInfo.setCUSTOMER_ADRESS_PHONE(orderInvoicePo.getAddress().trim() + " " + orderInvoicePo.getPhone().trim());
            saleSettlementInfo.setBANK_ACCOUNT_INFO(orderInvoicePo.getBank().trim() + " " + orderInvoicePo.getAccount().trim());
            saleSettlementInfo.setBANK_NAME(orderInvoicePo.getBank().trim());
            saleSettlementInfo.setBANK_ACC(orderInvoicePo.getAccount().trim());
            saleSettlementInfo.setCOMPANY_ADDRESS(orderInvoicePo.getAddress().trim());
            saleSettlementInfo.setCOMPANY_PHONE(orderInvoicePo.getPhone().trim());
            saleSettlementInfo.setSETTLE_DATE(DateUtil.dateToStr((Date)new Date()));
            saleSettlementInfo.setINVOICE_REMARKS(orderPo.getRemark());
            saleSettlementInfo.setTESCO_SETTLE_ID(orderPo.getFscOrderId());
            saleSettlementInfo.setTESCO_EMAIL(orderInvoicePo.getReceiveEmail());
            saleSettlementInfo.setTESCO_ID(orderPo.getFscOrderId());
            saleSettlementInfo.setTAX_RATE(orderItemPo.getTaxRate().multiply(new BigDecimal(100)));
            saleSettlementInfo.setPRICE_MODE(this.priceMode);
            saleSettlementInfo.setTHIS_BILL_AMT_IN_TAX(orderPo.getTotalCharge().setScale(2, 4));
            saleSettlementInfo.setTHIS_BILL_AMT_NO_TAX(saleSettlementInfo.getTHIS_BILL_AMT_IN_TAX().subtract(orderItemPo.getTaxAmt()));
            saleSettlementInfo.setTHIS_BILL_TAX_AMT(orderItemPo.getTaxAmt());
            saleSettlementInfo.setTHIS_COST_AMT(BigDecimal.ZERO);
            saleSettlementInfo.setTHIS_COST_AMT_IN_TAX(BigDecimal.ZERO);
            saleSettlementInfo.setINIT_FLAG("Y");
            saleSettlementInfo.setCUSTOMER_NAME(orderInvoicePo.getBuyName());
            ArrayList<FscBillTaxSendSaleFscOrderToYCInvoiceItemBO> invoiceItemBOList = new ArrayList<FscBillTaxSendSaleFscOrderToYCInvoiceItemBO>();
            FscBillTaxSendSaleFscOrderToYCInvoiceItemBO fscInvoiceItemBO = new FscBillTaxSendSaleFscOrderToYCInvoiceItemBO();
            fscInvoiceItemBO.setITEM_DESCRIPTION(this.itemDescription);
            fscInvoiceItemBO.setITEM_NUMBER(orderItemPo.getModel());
            fscInvoiceItemBO.setUNIT_OF_UOM(orderItemPo.getUnit());
            fscInvoiceItemBO.setQUANTITY(orderItemPo.getNum());
            fscInvoiceItemBO.setUNIT_PRICE_NO_TAX(orderItemPo.getPrice().divide(BigDecimal.ONE.add(orderItemPo.getTaxRate()), 8, 4));
            fscInvoiceItemBO.setUNIT_PRICE_WITH_TAX(orderItemPo.getPrice());
            fscInvoiceItemBO.setCOST(BigDecimal.ZERO);
            fscInvoiceItemBO.setTOTAL_AMT_WITH_TAX(orderItemPo.getAmt().setScale(2, 4));
            fscInvoiceItemBO.setTOTAL_AMT_NO_TAX(orderItemPo.getUntaxAmt().setScale(2, 4));
            fscInvoiceItemBO.setTAX_AMT(fscInvoiceItemBO.getTOTAL_AMT_WITH_TAX().subtract(fscInvoiceItemBO.getTOTAL_AMT_NO_TAX()));
            fscInvoiceItemBO.setVENDOR_NAME(orderPo.getSupplierName());
            fscInvoiceItemBO.setTAX_CLASS(orderItemPo.getTaxCode());
            fscInvoiceItemBO.setTESCO_ID(orderItemPo.getId());
            fscInvoiceItemBO.setTESCO_ORDER_ID(orderItemPo.getOrderId());
            fscInvoiceItemBO.setTESCO_COMMODITY_ID(orderItemPo.getSkuId());
            fscInvoiceItemBO.setTESCO_COMMODITY_NAME(orderItemPo.getSkuName());
            fscInvoiceItemBO.setTESCO_ACCEPT_ID(orderItemPo.getAcceptOrderId());
            invoiceItemBOList.add(fscInvoiceItemBO);
            ArrayList saleSettlementPaymentInfo = new ArrayList();
            ArrayList claimList = new ArrayList();
            ArrayList writeOffList = new ArrayList();
            ArrayList writeRelationList = new ArrayList();
            orderPo.setOrderId(orderItemPo.getOrderId());
            orderPo.setWriteOffAmount(BigDecimal.ZERO);
            saleSettlementInfo.setTHIS_WRITE_OFF_AMT(orderPo.getWriteOffAmount());
            FscBillTaxSendSaleFscOrderToYCReqBO sendSaleFscOrderToYCReqBO = new FscBillTaxSendSaleFscOrderToYCReqBO();
            sendSaleFscOrderToYCReqBO.setSaleSettlementInfo(saleSettlementInfo);
            sendSaleFscOrderToYCReqBO.setSaleSettlementMaterial(invoiceItemBOList);
            sendSaleFscOrderToYCReqBO.setSaleSettlementPaymentInfo(saleSettlementPaymentInfo);
            fscBillTaxSendSaleFscOrderToYCRspBO = this.dealParamToYc(reqBO.getFscOrderId(), sendSaleFscOrderToYCReqBO, logAbilityReqBO, reqBO.getAgentAccount());
            if (!fscBillTaxSendSaleFscOrderToYCRspBO.getRespCode().equals("0000")) {
                logAbilityReqBO.setStatus(FscConstants.FscPushStatus.FAIL);
            } else {
                logAbilityReqBO.setStatus(FscConstants.FscPushStatus.SUCCESS);
            }
        }
        catch (Exception e) {
            logAbilityReqBO.setStatus(FscConstants.FscPushStatus.FAIL);
            this.fscBillAddPushLogAbilityService.savePushLog(logAbilityReqBO);
            throw new FscBusinessException("191000", e.getMessage());
        }
        this.fscBillAddPushLogAbilityService.savePushLog(logAbilityReqBO);
        return (FscPushYcMemInvoiceAtomRspBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)fscBillTaxSendSaleFscOrderToYCRspBO), FscPushYcMemInvoiceAtomRspBO.class));
    }

    private void buildSettlementInfo(List<FscBillTaxSendSaleFscOrderToYCVerificationBO> saleSettlementPaymentInfo, FscOrderPO fscOrderPO, List<FscClaimDetailPO> claimList, List<FscWriteOffPO> writeOffList, List<FscOrderWriteRelationPO> writeRelationList) {
        FscOrderWriteRelationPO writeRelationPO = new FscOrderWriteRelationPO();
        writeRelationPO.setFscOrderId(fscOrderPO.getFscOrderId());
        List writeRelationPOList = this.fscOrderWriteRelationMapper.getWriteList(writeRelationPO);
        if (!CollectionUtils.isEmpty((Collection)writeRelationPOList)) {
            for (FscOrderWriteRelationPO relationPO : writeRelationPOList) {
                FscBillTaxSendSaleFscOrderToYCVerificationBO verificationBO = new FscBillTaxSendSaleFscOrderToYCVerificationBO();
                verificationBO.setRECEIPT_NUMBER(relationPO.getDetailNo());
                verificationBO.setAMOUNT(relationPO.getClaimAmt());
                verificationBO.setAMOUNT_APPLIED(BigDecimal.ZERO);
                verificationBO.setAMOUNT_UNAPPLIED(relationPO.getClaimAmt());
                verificationBO.setAPPLY_AMOUNT(relationPO.getWriteOffAmount());
                verificationBO.setTESCO_ID(relationPO.getId());
                verificationBO.setEG_FROM_TESCO_ID(relationPO.getClaimDetailId());
                saleSettlementPaymentInfo.add(verificationBO);
            }
            fscOrderPO.setWriteOffAmount(BigDecimal.ZERO);
            return;
        }
        FscClaimDetailPO fscClaimDetailPo = new FscClaimDetailPO();
        fscClaimDetailPo.setOrderIds(Collections.singleton(fscOrderPO.getOrderId()));
        List claimDetailList = this.fscClaimDetailMapper.getWriteOffPay(fscClaimDetailPo);
        if (CollectionUtils.isEmpty((Collection)claimDetailList)) {
            throw new BusinessException("198888", "\u8ba4\u9886\u660e\u7ec6\u67e5\u8be2\u4e3a\u7a7a");
        }
        BigDecimal fscOrderItemWriteOffAmount = new BigDecimal(0);
        for (FscClaimDetailPO claimDetailPO : claimDetailList) {
            if (null == claimDetailPO.getWriteOffAmount()) {
                claimDetailPO.setWriteOffAmount(new BigDecimal(0));
            }
            FscBillTaxSendSaleFscOrderToYCVerificationBO verificationBO = new FscBillTaxSendSaleFscOrderToYCVerificationBO();
            BigDecimal noWriteOffAmount = claimDetailPO.getClaimAmt().subtract(claimDetailPO.getWriteOffAmount());
            FscWriteOffPO fscWriteOffPO = new FscWriteOffPO();
            fscWriteOffPO.setWriteOffId(Long.valueOf(Sequence.getInstance().nextId()));
            fscWriteOffPO.setFscOrderId(fscOrderPO.getFscOrderId());
            fscWriteOffPO.setFscOrderNo(fscOrderPO.getOrderNo());
            fscWriteOffPO.setClaimId(claimDetailPO.getClaimId());
            fscWriteOffPO.setHandleUserId(claimDetailPO.getHandleUserId());
            fscWriteOffPO.setHandleUserName(claimDetailPO.getHandleUserName());
            fscWriteOffPO.setHandleDeptId(claimDetailPO.getHandleDeptId());
            fscWriteOffPO.setHandleDeptName(claimDetailPO.getHandleDeptName());
            fscWriteOffPO.setClaimType(claimDetailPO.getClaimType());
            fscWriteOffPO.setOrderId(claimDetailPO.getOrderId());
            fscWriteOffPO.setOrderCode(claimDetailPO.getOrderCode());
            fscWriteOffPO.setBuynerNo(fscOrderPO.getBuynerNo());
            fscWriteOffPO.setBuynerName(fscOrderPO.getBuynerName());
            fscWriteOffPO.setTotalCharge(fscOrderPO.getTotalCharge().setScale(2, 4));
            fscWriteOffPO.setOrderAmount(fscOrderPO.getTotalCharge().setScale(2, 4));
            fscWriteOffPO.setPayerId(fscOrderPO.getPayerId());
            fscWriteOffPO.setPayerName(fscOrderPO.getPayerName());
            fscWriteOffPO.setWriteOffDate(new Date());
            fscWriteOffPO.setStatus(Integer.valueOf(1));
            if (claimDetailPO.getClaimAmt().compareTo(claimDetailPO.getWriteOffAmount()) < 0 || claimDetailPO.getClaimAmt().compareTo(claimDetailPO.getWriteOffAmount()) == 0) {
                throw new FscBusinessException("191026", "\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u8ba4\u9886\u91d1\u989d\uff01");
            }
            fscWriteOffPO.setThisAmount(claimDetailPO.getClaimAmt());
            fscWriteOffPO.setWriteOffAmount(claimDetailPO.getClaimAmt());
            FscOrderWriteRelationPO fscOrderWriteRelationPO = new FscOrderWriteRelationPO();
            fscOrderWriteRelationPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscOrderWriteRelationPO.setFscOrderId(fscOrderPO.getFscOrderId());
            fscOrderWriteRelationPO.setClaimDetailId(claimDetailPO.getClaimDetailId());
            fscOrderWriteRelationPO.setClaimId(claimDetailPO.getClaimId());
            fscOrderWriteRelationPO.setClaimAmt(claimDetailPO.getClaimAmt());
            fscOrderWriteRelationPO.setWriteOffAmount(claimDetailPO.getClaimAmt());
            fscOrderWriteRelationPO.setWriteOffDate(new Date());
            fscOrderWriteRelationPO.setClaimNo(claimDetailPO.getClaimNo());
            FscOrderPO payPo = new FscOrderPO();
            payPo.setFscOrderId(claimDetailPO.getOrderId());
            payPo = this.fscOrderMapper.getModelBy(payPo);
            fscOrderWriteRelationPO.setObjectNo(payPo.getOrderNo());
            writeRelationList.add(fscOrderWriteRelationPO);
            verificationBO.setRECEIPT_NUMBER(claimDetailPO.getDetailNo());
            verificationBO.setAMOUNT(claimDetailPO.getClaimAmt());
            verificationBO.setAMOUNT_APPLIED(claimDetailPO.getWriteOffAmount());
            verificationBO.setAMOUNT_UNAPPLIED(noWriteOffAmount);
            verificationBO.setAPPLY_AMOUNT(claimDetailPO.getClaimAmt());
            verificationBO.setTESCO_ID(fscOrderWriteRelationPO.getId());
            verificationBO.setEG_FROM_TESCO_ID(claimDetailPO.getClaimDetailId());
            claimDetailPO.setWriteOffAmount(claimDetailPO.getClaimAmt());
            claimDetailPO.setWriteOffDate(new Date());
            fscOrderItemWriteOffAmount = fscOrderItemWriteOffAmount.add(verificationBO.getAPPLY_AMOUNT());
            claimList.add(claimDetailPO);
            writeOffList.add(fscWriteOffPO);
            saleSettlementPaymentInfo.add(verificationBO);
        }
        fscOrderPO.setWriteOffAmount(fscOrderItemWriteOffAmount);
    }

    private void saveWriteOff(List<FscClaimDetailPO> claimList, List<FscWriteOffPO> writeOffList, FscOrderPO orderPo, List<FscOrderWriteRelationPO> writeRelationList) {
        if (!CollectionUtils.isEmpty(claimList)) {
            this.fscClaimDetailMapper.updateWriteOffAmountBatchById(claimList);
        }
        if (!CollectionUtils.isEmpty(writeOffList)) {
            this.fscWriteOffMapper.insertBatch(writeOffList);
        }
        if (!CollectionUtils.isEmpty(writeRelationList)) {
            this.fscOrderWriteRelationMapper.insertBatch(writeRelationList);
        }
        this.fscOrderMapper.updateWriteOffAmount(orderPo);
    }

    private FscBillTaxSendSaleFscOrderToYCRspBO dealParamToYc(Long fscOrderId, FscBillTaxSendSaleFscOrderToYCReqBO saleFscOrderToYCReqBO, FscBillDealPushLogAbilityReqBO fscPushLogPO, String erpNo) {
        String agentAccount = erpNo;
        if (StringUtils.isBlank((CharSequence)agentAccount)) {
            agentAccount = this.agent;
        }
        PebExtUnifySettleTokenQryAbilityReqBO tokenQryAbilityReqBO = new PebExtUnifySettleTokenQryAbilityReqBO();
        tokenQryAbilityReqBO.setUserId(agentAccount);
        PebExtUnifySettleTokenQryAbilityRspBO tokenQryAbilityRspBO = this.pebExtUnifySettlePersonQryAbilityService.qryUnifyPersonToken(tokenQryAbilityReqBO);
        if (!tokenQryAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(tokenQryAbilityRspBO.getRespCode(), "\u83b7\u53d6\u7edf\u4e00\u7ed3\u7b97\u7528\u6237token\u4fe1\u606f\u5931\u8d25\uff1a" + tokenQryAbilityRspBO.getMsg());
        }
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("STAGE", (Object)1);
        jsonObject.put("BALANCE", (Object)saleFscOrderToYCReqBO.getSaleSettlementInfo());
        jsonObject.put("BALANCE_LINE", (Object)saleFscOrderToYCReqBO.getSaleSettlementMaterial());
        jsonObject.put("BALANCE_APPLY", (Object)saleFscOrderToYCReqBO.getSaleSettlementPaymentInfo());
        jsonArray.add((Object)jsonObject);
        fscPushLogPO.setObjData(jsonArray.toJSONString());
        FscUnifySettleEncryPtionReqBO encryptionAbilityReqBO = new FscUnifySettleEncryPtionReqBO();
        encryptionAbilityReqBO.setData(jsonArray.toString());
        FscUnifySettleEncryPtionRspBO encryPtionRspBO = this.fscUnifySettleRelatedInterfacesAtomService.dealArrayEncryption(encryptionAbilityReqBO);
        fscPushLogPO.setPushParseData(encryPtionRspBO.getData());
        FscBillTaxSendSaleFscOrderToYCReqBO fscBillTaxSendSaleFscOrderToYCReqBO = new FscBillTaxSendSaleFscOrderToYCReqBO();
        fscBillTaxSendSaleFscOrderToYCReqBO.setData(encryPtionRspBO.getData());
        fscBillTaxSendSaleFscOrderToYCReqBO.setToken(tokenQryAbilityRspBO.getData());
        FscBillTaxSendSaleFscOrderToYCRspBO fscBillTaxSendSaleFscOrderToYCRspBO = this.fscBillTaxSendSaleFscOrderToYCService.sendSaleFscOrder(fscBillTaxSendSaleFscOrderToYCReqBO);
        FscUnifySettleDecryptionReqBO decryptionAbilityReqBO = new FscUnifySettleDecryptionReqBO();
        decryptionAbilityReqBO.setData("0000".equals(fscBillTaxSendSaleFscOrderToYCRspBO.getCode()) ? fscBillTaxSendSaleFscOrderToYCRspBO.getData() : fscBillTaxSendSaleFscOrderToYCRspBO.getMsg());
        FscUnifySettleDecryptionRspBO decryptionAbilityRspBO = this.fscUnifySettleRelatedInterfacesAtomService.dealParamDecryption(decryptionAbilityReqBO);
        fscPushLogPO.setRespData(decryptionAbilityRspBO.getData());
        fscPushLogPO.setRespParseData(fscBillTaxSendSaleFscOrderToYCRspBO.getRspData());
        fscBillTaxSendSaleFscOrderToYCRspBO.setRespDesc(decryptionAbilityRspBO.getData());
        return fscBillTaxSendSaleFscOrderToYCRspBO;
    }
}

