/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.authority.busi.bo.UserBO;
import com.tydic.fsc.bill.ability.api.FscBillSendSaleFscOrderToYCAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillSendSaleFscOrderApplyAbilityReqBO;
import com.tydic.fsc.bill.busi.api.FscBillOrderCreateWelfareBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderCreateBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderCreateBusiRspBO;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscApprovalTaskQueryBO;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.bo.FscOrderItemReqBO;
import com.tydic.fsc.bo.RelOrderBO;
import com.tydic.fsc.bo.SplitOrderBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.busibase.atom.api.FscSendNotificationExtAtomService;
import com.tydic.fsc.busibase.atom.api.FscUocOrderRelUpdateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscSendNotificationExtAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscUocOrderRelUpdateAtomReqBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.enums.FscInvoiceValueTypeEnum;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscOrderSourceEnum;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscCheckTempMapper;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscInvoiceRuleMapper;
import com.tydic.fsc.dao.FscOrderExtMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscPayLogMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.enums.FscOrderSendStateEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.task.service.TaskTodoWaitService;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscCheckTempPO;
import com.tydic.fsc.po.FscInvoiceRulePO;
import com.tydic.fsc.po.FscOrderExtPO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscPayLogPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.po.FscTaskCandidatePO;
import com.tydic.fsc.util.FscCommonUtils;
import com.tydic.fsc.util.TaxUtils;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgNameListQryAbilityService;
import com.tydic.umc.general.ability.bo.UmcDycEnterpriseOrgBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgNameListQryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgNameListQryAbilityRspBO;
import com.tydic.uoc.base.constants.PebExtConstant;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillOrderCreateWelfareBusiServiceImpl
implements FscBillOrderCreateWelfareBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderCreateWelfareBusiServiceImpl.class);
    @Autowired
    private FscOrderStatusStartAtomService fscOrderStatusStartAtomService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderExtMapper fscOrderExtMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscInvoiceRuleMapper fscInvoiceRuleMapper;
    @Autowired
    private FscUocOrderRelUpdateAtomService fscUocOrderRelUpdateAtomService;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Value(value="${fsc.main.pro.org:100096,100100}")
    private String proOrg;
    @Value(value="${fsc.main.electricity.pro.org:100100}")
    private String electricityOrg;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;
    private static final String BUSI_NAME = "\u4e3b\u5355\u786e\u8ba4";
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private UmcEnterpriseOrgNameListQryAbilityService umcEnterpriseOrgNameListQryAbilityService;
    @Autowired
    private FscBillSendSaleFscOrderToYCAbilityService fscBillSendSaleFscOrderToYCAbilityService;
    @Autowired
    private FscPayLogMapper fscPayLogMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscCheckTempMapper fscCheckTempMapper;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Autowired
    private FscSendNotificationExtAtomService fscSendNotificationExtAtomService;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Value(value="${fsc.oil.taxCode:1070101070100000000,1070101070200000000}")
    private String oilTaxCode;
    @Value(value="${OPERATION_SUP_ID:1001693}")
    private Long operationSupId;

    @Override
    public FscBillOrderCreateBusiRspBO dealCreateWelfare(FscBillOrderCreateBusiReqBO reqBO) {
        ArrayList<FscOrderPO> fscOrderPOS = new ArrayList<FscOrderPO>();
        ArrayList<FscOrderExtPO> fscOrderExtPOS = new ArrayList<FscOrderExtPO>();
        ArrayList<FscOrderRelationPO> fscOrderRelationPOS = new ArrayList<FscOrderRelationPO>();
        ArrayList<FscOrderItemPO> fscOrderItemPOS = new ArrayList<FscOrderItemPO>();
        ArrayList<FscOrderInvoicePO> fscOrderInvoicePOS = new ArrayList<FscOrderInvoicePO>();
        ArrayList<FscInvoiceRulePO> fscInvoiceRulePOS = new ArrayList<FscInvoiceRulePO>();
        ArrayList<FscPayLogPO> fscPayLogUpdateList = new ArrayList<FscPayLogPO>();
        ArrayList<Long> fscOrderIds = new ArrayList<Long>();
        ArrayList<FscAttachmentPO> fscAttachmentPOList = new ArrayList<FscAttachmentPO>();
        ArrayList<Long> acceptOrderIds = new ArrayList<Long>();
        ArrayList<Long> orderIds = new ArrayList<Long>();
        Integer elecFlag = FscConstants.FscInvoiceRuleElecFlag.NO;
        if (FscConstants.FscInvoiceCategory.ELEC.equals(reqBO.getInvoiceCategory())) {
            elecFlag = FscConstants.FscInvoiceRuleElecFlag.YES;
        }
        int num = 0;
        for (SplitOrderBO splitOrderBO : reqBO.getSplitOrderList()) {
            FscOrderPO fscOrderPo = (FscOrderPO)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscOrderPO.class);
            fscOrderPo.setFscOrderId(Long.valueOf(Sequence.getInstance().nextId()));
            fscOrderPo.setCreateTime(new Date());
            fscOrderPo.setCreateOperId(reqBO.getUserId());
            fscOrderPo.setCreateOperName(reqBO.getName());
            fscOrderPo.setCreateOperNo(reqBO.getUserName());
            fscOrderPo.setCreateOrgId(reqBO.getOrgId());
            fscOrderPo.setCreateOrgName(reqBO.getOrgName());
            fscOrderPo.setCreateCompanyId(reqBO.getCompanyId());
            fscOrderPo.setCreateCompanyName(reqBO.getCompanyName());
            fscOrderPo.setTotalCharge(splitOrderBO.getAmount().setScale(2, 4));
            fscOrderPo.setToPayAmount(splitOrderBO.getAmount().setScale(2, 4));
            fscOrderPo.setOrderNo(reqBO.getOrderNos().get(num));
            fscOrderPo.setBuildAction(FscConstants.FscOrderBuildAction.HAND);
            fscOrderPo.setShouldPayType(reqBO.getPayNodeRule());
            fscOrderPo.setAutoBill(reqBO.getAutoBill());
            fscOrderPo.setBuyName(reqBO.getBuyName());
            fscOrderPo.setOperationArea(reqBO.getOperationArea());
            fscOrderPo.setSettleType(reqBO.getSettleType());
            fscOrderPo.setIsQuality(reqBO.getIsQuality());
            fscOrderPo.setOrderFlowKey("invoice_flow_key");
            if (!CollectionUtils.isEmpty(reqBO.getAttachmentList())) {
                for (AttachmentBO attachmentBO : reqBO.getAttachmentList()) {
                    FscAttachmentPO fscAttachmentPO = (FscAttachmentPO)JSONObject.parseObject((String)JSON.toJSONString((Object)attachmentBO), FscAttachmentPO.class);
                    fscAttachmentPO.setFscOrderId(fscOrderPo.getFscOrderId());
                    fscAttachmentPO.setObjId(fscOrderPo.getFscOrderId());
                    fscAttachmentPO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                    fscAttachmentPOList.add(fscAttachmentPO);
                }
            }
            if (FscConstants.FscOrderMakeType.OPERTION.equals(reqBO.getMakeType()) || FscConstants.FscOrderReceiveType.OPERATION.equals(reqBO.getReceiveType())) {
                fscOrderPo.setTradeMode(FscConstants.FscBusiModel.TRADE);
            } else {
                fscOrderPo.setTradeMode(FscConstants.FscBusiModel.MATCHING);
            }
            if (null != reqBO.getBuildAction()) {
                fscOrderPo.setBuildAction(reqBO.getBuildAction());
            }
            ++num;
            StringBuilder orderNos = new StringBuilder();
            BigDecimal[] totalCharge = new BigDecimal[]{BigDecimal.ZERO};
            BigDecimal qualityAmt = BigDecimal.ZERO;
            HashMap invoiceItemMap = new HashMap(fscOrderItemPOS.size());
            for (RelOrderBO relOrderBO : splitOrderBO.getRelOrderList()) {
                List itemReqBOList = relOrderBO.getFscOrderItemBOList();
                Map<Object, Object> itemReqBOMap = CollectionUtils.isEmpty((Collection)itemReqBOList) ? new HashMap() : itemReqBOList.stream().collect(Collectors.toMap(FscOrderItemReqBO::getInspectionItemId, e -> e, (k1, k2) -> k1));
                FscOrderInfoBO fscOrderInfoBO = reqBO.getFscOrderInfoBoMap().get(relOrderBO.getAcceptOrderId());
                if (null == fscOrderInfoBO) {
                    throw new FscBusinessException("193008", "\u83b7\u53d6\u8ba2\u5355\u5bf9\u8c61\u4e3a\u7a7a");
                }
                Integer settlePlatform = fscOrderInfoBO.getSettlePlatform();
                if (Objects.nonNull(fscOrderInfoBO.getTradeMode()) && fscOrderInfoBO.getTradeMode() == 2) {
                    if (!org.springframework.util.StringUtils.isEmpty((Object)fscOrderInfoBO.getBuynerId()) && !org.springframework.util.StringUtils.isEmpty((Object)fscOrderInfoBO.getBuynerName())) {
                        fscOrderPo.setPayerId(Long.valueOf(fscOrderInfoBO.getBuynerId()));
                        fscOrderPo.setPayerName(fscOrderInfoBO.getBuynerName());
                    }
                    if (reqBO.getOrderType() == 4 || reqBO.getOrderType() == 5) {
                        fscOrderPo.setTradeMode(fscOrderInfoBO.getTradeMode());
                    }
                }
                FscOrderRelationPO fscOrderRelationPO = (FscOrderRelationPO)JSONObject.parseObject((String)JSON.toJSONString((Object)fscOrderInfoBO), FscOrderRelationPO.class);
                fscOrderRelationPO.setContractNo(fscOrderInfoBO.getModelContractNo());
                fscOrderRelationPO.setContractId(fscOrderInfoBO.getModelContractId());
                fscOrderRelationPO.setProContractId(fscOrderInfoBO.getProModelContractId());
                fscOrderRelationPO.setProContractName(fscOrderInfoBO.getProModelContractName());
                fscOrderRelationPO.setProContractNo(fscOrderInfoBO.getProModelContractNo());
                fscOrderRelationPO.setProContractType(fscOrderInfoBO.getProModelContractType());
                fscOrderRelationPO.setProContractSource(fscOrderInfoBO.getProModelContractSource());
                fscOrderRelationPO.setExpType(relOrderBO.getExpLineType());
                fscOrderRelationPO.setExpTypeId(relOrderBO.getExpTypeCode());
                fscOrderRelationPO.setQualityAmt(relOrderBO.getQualityAmt());
                fscOrderRelationPO.setQualityDate(relOrderBO.getQualityDate());
                qualityAmt = qualityAmt.add(relOrderBO.getQualityAmt());
                if (FscConstants.SettlePlatform.YES.equals(settlePlatform) && reqBO.getReceiveType() == 1) {
                    if (fscOrderInfoBO.getContractId() == null) {
                        log.info("\u5bf9\u63a5\u652f\u4ed8\u7ed3\u7b97\u7cfb\u7edf\uff0c\u5931\u8d25\u9a8c\u6536\u5355ID\uff1a" + relOrderBO.getAcceptOrderId());
                        throw new FscBusinessException("193008", "\u5bf9\u63a5\u7edf\u4e00\u7ed3\u7b97\u5e73\u53f0\uff0c\u672a\u83b7\u53d6\u5230\u5408\u540c\u76f8\u5173\u4fe1\u606f\uff01");
                    }
                    fscOrderRelationPO.setContractNo(fscOrderInfoBO.getContractNo());
                    fscOrderRelationPO.setContractId(fscOrderInfoBO.getContractId());
                }
                fscOrderRelationPO.setErpInspectionNo(fscOrderInfoBO.getErpInspectionVoucherCode());
                fscOrderRelationPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                fscOrderRelationPO.setFscOrderId(fscOrderPo.getFscOrderId());
                acceptOrderIds.add(fscOrderRelationPO.getAcceptOrderId());
                orderIds.add(fscOrderRelationPO.getOrderId());
                List<FscOrderItemPO> orderItemPOS = JSONObject.parseArray((String)JSON.toJSONString((Object)fscOrderInfoBO.getFscOrderItemBOS()), FscOrderItemPO.class);
                BigDecimal[] settleAmt = new BigDecimal[]{BigDecimal.ZERO};
                ArrayList list = new ArrayList();
                StringBuffer sb = null;
                ArrayList exOrderItemIds = new ArrayList();
                HashSet taxRate = new HashSet();
                orderItemPOS.forEach(fscOrderItemPO -> {
                    if (Objects.nonNull(fscOrderInfoBO.getOrderType()) && PebExtConstant.OrderType.CX_AGR.equals(fscOrderInfoBO.getOrderType())) {
                        fscOrderItemPO.setSkuName(fscOrderItemPO.getSkuMaterialLongDesc());
                    }
                    if (StringUtils.isBlank((CharSequence)fscOrderItemPO.getSettleUnit()) && fscOrderItemPO.getSalesUnitRate() != null && BigDecimal.ONE.compareTo(fscOrderItemPO.getSalesUnitRate()) == 0) {
                        fscOrderItemPO.setSettleUnit(fscOrderItemPO.getUnitName());
                    }
                    fscOrderItemPO.setFscOrderId(fscOrderPo.getFscOrderId());
                    invoiceItemMap.put(fscOrderItemPO.getOrderItemId(), fscOrderItemPO);
                    if (Objects.nonNull(itemReqBOMap.get(fscOrderItemPO.getOrderItemId()))) {
                        FscOrderItemReqBO fscOrderItemReqBO = (FscOrderItemReqBO)itemReqBOMap.get(fscOrderItemPO.getOrderItemId());
                        if (Objects.nonNull(fscOrderItemReqBO.getProductDescription()) || Objects.nonNull(fscOrderItemReqBO.getSpecificationsModel())) {
                            fscOrderItemPO.setProductDescription(fscOrderItemReqBO.getProductDescription());
                            fscOrderItemPO.setSpecificationsModel(fscOrderItemReqBO.getSpecificationsModel());
                        } else {
                            this.dealDescAndModel((FscOrderItemPO)fscOrderItemPO, reqBO);
                        }
                        if (fscOrderItemReqBO.getNum() != null && fscOrderItemReqBO.getNum().compareTo(BigDecimal.ZERO) > 0) {
                            fscOrderItemPO.setNum(fscOrderItemReqBO.getNum());
                            fscOrderItemPO.setAmt(fscOrderItemReqBO.getAmt());
                            fscOrderItemPO.setTaxAmt(TaxUtils.calTaxAmt((BigDecimal)fscOrderItemPO.getAmt(), (BigDecimal)fscOrderItemPO.getTaxRate()));
                            fscOrderItemPO.setUntaxAmt(fscOrderItemPO.getAmt().subtract(fscOrderItemPO.getTaxAmt()));
                            fscOrderItemPO.setPurchaseAmt(fscOrderItemReqBO.getNum().multiply(fscOrderItemPO.getPurchasePrice()));
                            BigDecimal purchaseTaxAmt = TaxUtils.calTaxAmt((BigDecimal)fscOrderItemPO.getPurchaseAmt(), (BigDecimal)fscOrderItemPO.getTaxRate());
                            fscOrderItemPO.setPurchaseUntaxAmt(fscOrderItemPO.getPurchaseAmt().subtract(purchaseTaxAmt));
                            if (fscOrderItemPO.getSalesUnitRate() != null && fscOrderItemPO.getSalesUnitRate().compareTo(BigDecimal.ZERO) > 0) {
                                fscOrderItemPO.setSettlePrice(fscOrderItemPO.getPrice().divide(fscOrderItemPO.getSalesUnitRate(), 8, 4));
                                fscOrderItemPO.setSettleNum(fscOrderItemPO.getNum().multiply(fscOrderItemPO.getSalesUnitRate()));
                            }
                            if (fscOrderItemReqBO.getNum().multiply(fscOrderItemPO.getPrice()).setScale(2, 4).compareTo(fscOrderItemReqBO.getAmt()) != 0) {
                                throw new FscBusinessException("198888", "\u524d\u7aef\u63d0\u4ea4\u660e\u7ec6\u884c\u91d1\u989d\u4e0e\u540e\u7aef\u8ba1\u7b97\u4e0d\u4e00\u81f4\uff01");
                            }
                            taxRate.add(fscOrderItemPO.getTaxRate() == null ? 0 : fscOrderItemPO.getTaxRate().multiply(new BigDecimal(100)).intValue());
                        } else if (fscOrderItemReqBO.getNum().compareTo(BigDecimal.ZERO) == 0) {
                            exOrderItemIds.add(fscOrderItemPO.getOrderItemId());
                            fscOrderItemPO.setNum(fscOrderItemReqBO.getNum());
                            fscOrderItemPO.setAmt(BigDecimal.ZERO);
                        }
                    } else {
                        this.dealDescAndModel((FscOrderItemPO)fscOrderItemPO, reqBO);
                        taxRate.add(fscOrderItemPO.getTaxRate() == null ? 0 : fscOrderItemPO.getTaxRate().multiply(new BigDecimal(100)).intValue());
                    }
                    totalCharge[0] = totalCharge[0].add(fscOrderItemPO.getAmt());
                    settleAmt[0] = settleAmt[0].add(fscOrderItemPO.getAmt());
                });
                if (sb != null) {
                    throw new FscBusinessException("193008", sb.toString());
                }
                if (!CollectionUtils.isEmpty(exOrderItemIds) && CollectionUtils.isEmpty(orderItemPOS = orderItemPOS.stream().filter(e -> !exOrderItemIds.contains(e.getOrderItemId())).collect(Collectors.toList()))) continue;
                fscOrderItemPOS.addAll(orderItemPOS);
                fscOrderRelationPO.setSettleAmt(settleAmt[0]);
                if (!fscOrderPo.getPayType().equals(FscConstants.FscPayType.FSC_PAY_TYPE_STAGE)) {
                    fscOrderRelationPO.setAmount(settleAmt[0]);
                } else {
                    fscOrderRelationPO.setAmount(BigDecimal.ZERO);
                }
                if (FscConstants.SettleType.ORDER.equals(reqBO.getSettleType())) {
                    fscOrderRelationPO.setAmount(BigDecimal.ZERO);
                }
                if (fscOrderRelationPO.getQualityAmt().compareTo(fscOrderRelationPO.getSettleAmt()) > 0) {
                    throw new FscBusinessException("191014", fscOrderRelationPO.getOrderNo() + "\u8d28\u4fdd\u91d1\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u672c\u6b21\u5f00\u7968\u91d1\u989d\uff01");
                }
                fscOrderRelationPOS.add(fscOrderRelationPO);
                if (!org.springframework.util.StringUtils.isEmpty((Object)fscOrderInfoBO.getOperatorId())) {
                    fscOrderPo.setOperatorId(Long.valueOf(Long.parseLong(fscOrderInfoBO.getOperatorId())));
                }
                fscOrderPo.setSettlePlatform(settlePlatform);
                fscOrderPo.setOperatorName(fscOrderInfoBO.getOperatorName());
                fscOrderPo.setOperationNo(fscOrderInfoBO.getOperationNo());
                if (!org.springframework.util.StringUtils.isEmpty((Object)fscOrderInfoBO.getOperatorDeptId())) {
                    fscOrderPo.setOperatorDeptId(Long.valueOf(Long.parseLong(fscOrderInfoBO.getOperatorDeptId())));
                }
                fscOrderPo.setOperatorDeptName(fscOrderInfoBO.getOperatorDeptName());
                if ("0".equals(reqBO.getIsprofess())) {
                    if (fscOrderPo.getOperatorId() == null) {
                        fscOrderPo.setOperatorId(reqBO.getUserId());
                        fscOrderPo.setOperatorName(reqBO.getName());
                    }
                    if (fscOrderPo.getOperatorDeptId() == null) {
                        fscOrderPo.setOperatorDeptId(reqBO.getDeptId());
                        fscOrderPo.setOperatorDeptName(reqBO.getDeptName());
                    }
                    fscOrderPo.setOperationTime(new Date());
                    if (org.springframework.util.StringUtils.isEmpty((Object)fscOrderPo.getOperationNo())) {
                        String[] org = this.proOrg.split(",");
                        String[] pur = reqBO.getOrgPath().split("-");
                        String operationNo = String.valueOf(reqBO.getOrgId());
                        block3: for (String pro : org) {
                            for (String t : pur) {
                                if (!pro.equals(t)) continue;
                                operationNo = pro;
                                continue block3;
                            }
                        }
                        fscOrderPo.setOperationNo(operationNo);
                    }
                }
                if (org.springframework.util.StringUtils.isEmpty((Object)fscOrderPo.getOperationNo())) continue;
                UmcEnterpriseOrgNameListQryAbilityReqBO abilityReqBO = new UmcEnterpriseOrgNameListQryAbilityReqBO();
                ArrayList<Long> operationNos = new ArrayList<Long>();
                operationNos.add(Long.parseLong(fscOrderPo.getOperationNo()));
                abilityReqBO.setOrgIdList(operationNos);
                UmcEnterpriseOrgNameListQryAbilityRspBO rspBO = this.umcEnterpriseOrgNameListQryAbilityService.qryEnterpriseOrgNameList(abilityReqBO);
                if (rspBO.getRespCode().equals("0000") && !CollectionUtils.isEmpty((Map)rspBO.getOrgMap())) {
                    Map orgMap = rspBO.getOrgMap();
                    fscOrderPo.setOperationName(((UmcDycEnterpriseOrgBO)orgMap.get(Long.valueOf(fscOrderPo.getOperationNo()))).getOrgName());
                }
                if (!"1".equals(fscOrderPo.getOrderSource().toString())) continue;
                orderNos.append(fscOrderInfoBO.getOrderNo()).append(",");
            }
            fscOrderPo.setQualityAmt(qualityAmt);
            if (qualityAmt.compareTo(fscOrderPo.getTotalCharge()) > 0) {
                throw new FscBusinessException("198888", qualityAmt + "\u8d28\u4fdd\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u7ed3\u7b97\u91d1\u989d" + fscOrderPo.getTotalCharge());
            }
            if (reqBO.getFscOrderInfoBoMap() != null && reqBO.getFscOrderInfoBoMap().get(((RelOrderBO)splitOrderBO.getRelOrderList().get(0)).getAcceptOrderId()) != null) {
                FscOrderInfoBO fscOrderInfoBO = reqBO.getFscOrderInfoBoMap().get(((RelOrderBO)splitOrderBO.getRelOrderList().get(0)).getAcceptOrderId());
                FscOrderExtPO fscOrderExtPO = new FscOrderExtPO();
                fscOrderExtPO.setFscOrderId(fscOrderPo.getFscOrderId());
                fscOrderExtPO.setIsEquipPurchase(reqBO.getIsEquipPurchase());
                fscOrderExtPO.setVendorSiteId(fscOrderInfoBO.getVendorSiteId());
                fscOrderExtPO.setVendorSiteName(fscOrderInfoBO.getVendorSiteName());
                fscOrderExtPO.setSupplierErpCode(fscOrderInfoBO.getSupplierErpNo());
                fscOrderExtPO.setAgentAccount(reqBO.getAgentAccount());
                fscOrderExtPO.setUnifyUserName(reqBO.getUnifyUserName());
                fscOrderExtPO.setUnifyUserId(reqBO.getUnifyUserId());
                fscOrderExtPO.setUnifyDeptName(reqBO.getUnifyDeptName());
                fscOrderExtPO.setUnifyDeptId(reqBO.getUnifyDeptId());
                fscOrderExtPO.setUnifyOrgName(reqBO.getUnifyOrgName());
                fscOrderExtPO.setUnifyOrgId(reqBO.getUnifyOrgId());
                fscOrderExtPO.setUnifyComCode(reqBO.getUnifyComCode());
                fscOrderExtPO.setExt1(reqBO.getHandlerUserId());
                fscOrderExtPO.setFscType("3");
                fscOrderExtPO.setExt3(reqBO.getColmunCode());
                fscOrderExtPO.setExt4(reqBO.getColmunName());
                fscOrderExtPO.setOrgCodeIn(reqBO.getOrgCodeIn());
                fscOrderExtPOS.add(fscOrderExtPO);
            }
            FscPayLogPO fscPayLogPO = new FscPayLogPO();
            Set orderIdSet = fscOrderItemPOS.stream().map(FscOrderItemPO::getOrderId).collect(Collectors.toSet());
            fscPayLogPO.setBusiOrderIdList(orderIdSet);
            ArrayList<Integer> busiCategoryList = new ArrayList<Integer>();
            busiCategoryList.add(FscConstants.FscBusiCategory.ORDER_PAY);
            busiCategoryList.add(FscConstants.FscBusiCategory.ORDER_REFUND);
            busiCategoryList.add(FscConstants.FscBusiCategory.PERIOD_PAY);
            busiCategoryList.add(FscConstants.FscBusiCategory.ADVANCE_PAY);
            busiCategoryList.add(FscConstants.FscBusiCategory.ADVANCE_CHANGE);
            fscPayLogPO.setBusiCategoryList(busiCategoryList);
            fscPayLogPO.setPayeeId(this.operationOrgId);
            List fscPayLogPOList = this.fscPayLogMapper.getList(fscPayLogPO);
            if (!CollectionUtils.isEmpty((Collection)fscPayLogPOList)) {
                for (FscPayLogPO po : fscPayLogPOList) {
                    if (org.springframework.util.StringUtils.isEmpty((Object)po.getFscOrderNo())) {
                        po.setFscOrderNo(fscOrderPo.getOrderNo());
                        fscPayLogUpdateList.add(po);
                        continue;
                    }
                    if (po.getFscOrderNo().contains(fscOrderPo.getOrderNo())) continue;
                    po.setFscOrderNo(po.getFscOrderNo() + "," + fscOrderPo.getOrderNo());
                    fscPayLogUpdateList.add(po);
                }
            }
            if (splitOrderBO.getAmount().compareTo(totalCharge[0].setScale(2, 4)) != 0) {
                throw new FscBusinessException("198888", "\u524d\u7aef\u63d0\u4ea4\u91d1\u989d\u4e0e\u540e\u7aef\u8ba1\u7b97\u4e0d\u4e00\u81f4\uff01");
            }
            fscOrderPOS.add(fscOrderPo);
            fscOrderIds.add(fscOrderPo.getFscOrderId());
            FscOrderInvoicePO fscOrderInvoicePo = (FscOrderInvoicePO)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscOrderInvoicePO.class);
            fscOrderInvoicePo.setFscOrderId(fscOrderPo.getFscOrderId());
            fscOrderInvoicePo.setBillOperId(reqBO.getUserId().toString());
            fscOrderInvoicePo.setBillOperName(reqBO.getName());
            fscOrderInvoicePo.setBillTime(new Date());
            fscOrderInvoicePo.setBillTimeStart(new Date());
            if (this.operationOrgId.equals(fscOrderPo.getPayeeId())) {
                fscOrderInvoicePo.setInvoiceCategory(FscConstants.FscInvoiceCategory.FULL);
            }
            fscOrderInvoicePOS.add(fscOrderInvoicePo);
            FscInvoiceRulePO fscInvoiceRulePO = new FscInvoiceRulePO();
            fscInvoiceRulePO.setFscOrderId(fscOrderPo.getFscOrderId());
            fscInvoiceRulePO.setDataFlag(FscConstants.FscInvoiceRuleDataFlag.YES);
            fscInvoiceRulePO.setDataStatus(FscConstants.FscInvoiceRuleStatus.NO);
            fscInvoiceRulePO.setElecFlag(elecFlag);
            fscInvoiceRulePO.setElecStatus(FscConstants.FscInvoiceRuleStatus.NO);
            fscInvoiceRulePOS.add(fscInvoiceRulePO);
        }
        if (!CollectionUtils.isEmpty(fscOrderExtPOS)) {
            this.fscOrderExtMapper.insertBatch(fscOrderExtPOS);
        }
        if (CollectionUtils.isEmpty(fscOrderPOS) || CollectionUtils.isEmpty(fscOrderRelationPOS) || CollectionUtils.isEmpty(fscOrderItemPOS) || CollectionUtils.isEmpty(fscOrderInvoicePOS) || CollectionUtils.isEmpty(fscInvoiceRulePOS)) {
            throw new FscBusinessException("193008", "\u5f00\u7968\u4e3b\u5355\u7ec4\u88c5\u53c2\u6570\u4e3a\u7a7a");
        }
        fscOrderItemPOS.forEach(fscOrderItemPO -> {
            fscOrderItemPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            if (Objects.isNull(fscOrderItemPO.getSalesUnitRate()) && Objects.isNull(fscOrderItemPO.getSettlePrice()) && Objects.isNull(fscOrderItemPO.getSettleNum())) {
                fscOrderItemPO.setSettlePrice(fscOrderItemPO.getPrice());
                fscOrderItemPO.setSettleNum(fscOrderItemPO.getNum());
                fscOrderItemPO.setSettleUnit(fscOrderItemPO.getUnit());
                fscOrderItemPO.setSalesUnitRate(BigDecimal.ONE);
            }
        });
        this.fscOrderMapper.insertBatch(fscOrderPOS);
        this.fscOrderRelationMapper.insertBatch(fscOrderRelationPOS);
        this.fscOrderItemMapper.insertBatch(fscOrderItemPOS);
        this.fscOrderInvoiceMapper.insertBatch(fscOrderInvoicePOS);
        this.fscInvoiceRuleMapper.insertBatch(fscInvoiceRulePOS);
        if (!CollectionUtils.isEmpty(fscAttachmentPOList)) {
            this.fscAttachmentMapper.insertBatch(fscAttachmentPOList);
        }
        if (!CollectionUtils.isEmpty(fscPayLogUpdateList)) {
            this.fscPayLogMapper.updateFscOrderNo(fscPayLogUpdateList);
        }
        if (!CollectionUtils.isEmpty(reqBO.getFscShouldPayPOS())) {
            this.fscShouldPayMapper.updateStatusByBatch(reqBO.getFscShouldPayPOS());
        }
        if (reqBO.getSettleType().equals(FscConstants.SettleType.ORDER)) {
            FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
            fscShouldPayPO.setPayeeId(reqBO.getPayeeId());
            fscShouldPayPO.setShouldPayStatus(FscConstants.ShouldPayStatus.DEL);
            fscShouldPayPO.setOrderIds(orderIds);
            this.fscShouldPayMapper.updateShouldPayStatusBySettle(fscShouldPayPO);
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderIds(fscOrderIds);
        fscOrderPO.setOrderState(FscConstants.FscInvoiceOrderState.UNBILLED);
        this.fscOrderMapper.dealSave(fscOrderPO);
        FscBillOrderCreateBusiRspBO rspBO = new FscBillOrderCreateBusiRspBO();
        rspBO.setFscOrderIds(fscOrderIds);
        return rspBO;
    }

    private void checkExpenseType(FscOrderItemPO fscOrderItemPO, FscOrderInfoBO fscOrderInfoBO, StringBuffer sb) {
        if (fscOrderInfoBO.getSettlePlatform() != null && fscOrderInfoBO.getSettlePlatform() == 2 && fscOrderInfoBO.getTradeMode() != null && fscOrderInfoBO.getTradeMode() == 2 && (StringUtils.isBlank((CharSequence)fscOrderItemPO.getExpType()) || StringUtils.isBlank((CharSequence)fscOrderItemPO.getExpTypeId()))) {
            if (sb == null) {
                sb = new StringBuffer();
                sb.append("\u8ba2\u5355id\u4e3a\uff1a" + fscOrderInfoBO.getOrderId() + ",\u5546\u54c1\u540d\u79f0\u4e3a\uff1a" + fscOrderItemPO.getSkuName() + "\u7684\u8d39\u7528\u7c7b\u578b\u4e3a\u7a7a\uff01");
            } else {
                sb.append(",\u8ba2\u5355id\u662f\uff1a" + fscOrderInfoBO.getOrderId() + "\u4e0b\u5f97\u5546\u54c1\u540d\u79f0\u4e3a\uff1a" + fscOrderItemPO.getSkuName() + "\u7684\u8d39\u7528\u7c7b\u578b\u4e3a\u7a7a\uff01");
            }
        }
    }

    @Transactional(isolation=Isolation.READ_UNCOMMITTED)
    public void dealCheck(List<Long> acceptOrderIds, Integer receiveType, List<Long> fscOrderIds) {
        FscOrderPO checkPo = new FscOrderPO();
        checkPo.setAcceptOrderIds(acceptOrderIds);
        checkPo.setReceiveType(receiveType);
        checkPo.setFscOrderIds(fscOrderIds);
        int checkResult = this.fscOrderMapper.getInvoiceCheckBy(checkPo);
        if (checkResult > 0) {
            throw new FscBusinessException("198888", "\u5b58\u5728\u8ba2\u5355\u5df2\u53d1\u8d77\u7ed3\u7b97\u5355\uff0c\u4e0d\u80fd\u91cd\u590d\u53d1\u8d77\u8ba2\u5355\u7ed3\u7b97");
        }
    }

    public void dealDescAndModel(FscOrderItemPO fscOrderItemPO, FscBillOrderCreateBusiReqBO reqBO) {
        if ("2".equals(reqBO.getOrderSource())) {
            if (FscInvoiceValueTypeEnum.AGREE_MATERIAL.getCode().equals(reqBO.getInvoiceValueType()) && StringUtils.isNotBlank((CharSequence)fscOrderItemPO.getSkuMaterialName())) {
                fscOrderItemPO.setProductDescription(fscOrderItemPO.getSkuMaterialName());
                fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getMaterialSpec(), fscOrderItemPO.getMaterialModel(), fscOrderItemPO.getMaterialBj(), fscOrderItemPO.getSkuMaterialId(), reqBO.getOrderSource()));
            } else {
                fscOrderItemPO.setProductDescription(fscOrderItemPO.getSkuName());
                fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getSpec(), fscOrderItemPO.getModel(), null, null, reqBO.getOrderSource()));
            }
        } else if ("1".equals(reqBO.getOrderSource())) {
            if (FscInvoiceValueTypeEnum.PLAN_MATERIAL.getCode().equals(reqBO.getInvoiceValueType()) && StringUtils.isNotBlank((CharSequence)fscOrderItemPO.getPlanItemName())) {
                fscOrderItemPO.setProductDescription(fscOrderItemPO.getPlanItemName());
                fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getPlanItemSpecification(), null, fscOrderItemPO.getMaterialBj(), fscOrderItemPO.getPlanItemCode(), reqBO.getOrderSource()));
            } else if (FscInvoiceValueTypeEnum.ELECTRONIC.getCode().equals(reqBO.getInvoiceValueType()) && StringUtils.isNotBlank((CharSequence)fscOrderItemPO.getSkuName())) {
                fscOrderItemPO.setProductDescription(fscOrderItemPO.getSkuName());
                fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getSpec(), fscOrderItemPO.getModel(), null, null, reqBO.getOrderSource()));
            } else {
                fscOrderItemPO.setProductDescription(fscOrderItemPO.getSkuMaterialName());
                fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getSpec(), fscOrderItemPO.getModel(), fscOrderItemPO.getMaterialBj(), fscOrderItemPO.getSkuMaterialId(), reqBO.getOrderSource()));
            }
        }
    }

    public String dealSpecificationsModel(String spec, String model, String materialBJ, String materialId, String orderSource) {
        if (!org.springframework.util.StringUtils.isEmpty((Object)materialId) && materialId.startsWith("61")) {
            return "";
        }
        String specificationsModel = "";
        specificationsModel = !org.springframework.util.StringUtils.isEmpty((Object)spec) && !org.springframework.util.StringUtils.isEmpty((Object)model) && !org.springframework.util.StringUtils.isEmpty((Object)materialBJ) ? spec + "|" + model + "|" + materialBJ : (!org.springframework.util.StringUtils.isEmpty((Object)spec) && !org.springframework.util.StringUtils.isEmpty((Object)model) ? spec + "|" + model : (!org.springframework.util.StringUtils.isEmpty((Object)model) && !org.springframework.util.StringUtils.isEmpty((Object)materialBJ) ? model + "|" + materialBJ : (!org.springframework.util.StringUtils.isEmpty((Object)spec) && !org.springframework.util.StringUtils.isEmpty((Object)materialBJ) ? spec + "|" + materialBJ : (!org.springframework.util.StringUtils.isEmpty((Object)spec) ? spec : (!org.springframework.util.StringUtils.isEmpty((Object)model) ? model : materialBJ)))));
        if (!"2".equals(orderSource) && !org.springframework.util.StringUtils.isEmpty((Object)specificationsModel) && specificationsModel.length() > 40) {
            return specificationsModel.substring(0, 40);
        }
        return specificationsModel;
    }

    private void syncOrderStatus(List<Long> fscOrderIds) {
        fscOrderIds.forEach(fscOrderId -> {
            FscUocOrderRelUpdateAtomReqBO fscUocOrderRelUpdateAtomReqBO = new FscUocOrderRelUpdateAtomReqBO();
            fscUocOrderRelUpdateAtomReqBO.setFscOrderId(fscOrderId);
            fscUocOrderRelUpdateAtomReqBO.setOperType(FscConstants.FscRelUpdateAtomOperType.FSC_ORDER);
            this.fscUocOrderRelUpdateAtomService.dealRelUpdate(fscUocOrderRelUpdateAtomReqBO);
        });
    }

    private void valid(FscBillSendSaleFscOrderApplyAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getFscOrderIds())) {
            throw new FscBusinessException("191000", "\u53c2\u6570[fscOrderIds]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getWebSource() != null && reqBO.getWebSource().equals(FscConstants.FscWebSource.AGR_DOWN)) {
            if (reqBO.getDeptId() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2[deptId]\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)reqBO.getDeptName())) {
                throw new FscBusinessException("191000", "\u5165\u53c2[deptName]\u4e3a\u7a7a");
            }
            if (reqBO.getPersonId() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2[personId]\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)reqBO.getPersonName())) {
                throw new FscBusinessException("191000", "\u5165\u53c2[personName]\u4e3a\u7a7a");
            }
            if (reqBO.getYcUserId() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2[ycUserId]\u4e3a\u7a7a");
            }
        }
    }

    private void dealWorkFlow(FscOrderPO fscOrderPo) {
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
        fscOrderStatusFlowAtomReqBO.setOrderId(fscOrderPo.getFscOrderId());
        fscOrderStatusFlowAtomReqBO.setCurStatus(fscOrderPo.getOrderState());
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("confirmFlag", FscConstants.BillOrderConfirmFlag.CONFIRM);
        fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!fscOrderStatusFlowAtomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(fscOrderStatusFlowAtomRspBO.getRespCode(), fscOrderStatusFlowAtomRspBO.getRespDesc());
        }
    }

    private Boolean invokeUacTask(FscBillSendSaleFscOrderApplyAbilityReqBO reqBO, FscOrderPO order, boolean individuallyPay) {
        UacNoTaskAuditCreateReqBO auditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        auditCreateReqBO.setCreateOperId(reqBO.getUserId().toString());
        auditCreateReqBO.setCreateOperName(reqBO.getName());
        auditCreateReqBO.setCreateOperDept(reqBO.getOrgName());
        auditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(order.getFscOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (individuallyPay) {
            if (FscOrderSourceEnum.ELECTRIC_AREA.getCode().equals(fscOrderPO.getOrderSource()) && FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPO.getMakeType()) && FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrderPO.getReceiveType())) {
                auditCreateReqBO.setMenuId("FSC_ARGEE_DOWN_ORDER_INVOICE_PROCESS");
            } else {
                auditCreateReqBO.setMenuId("M001007");
            }
        } else {
            auditCreateReqBO.setMenuId("M001008");
        }
        auditCreateReqBO.setOrgId(reqBO.getOrgId().toString());
        ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.ORDER_INVOICE_APPROVAL);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(order.getFscOrderId());
        ArrayList<ApprovalObjBO> approvalObjBOList = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjId(order.getFscOrderId().toString());
        approvalObjBO.setObjName("\u9500\u552e\u7ed3\u7b97\u5355\u5ba1\u6279");
        approvalObjBO.setObjType(FscConstants.AuditObjType.ORDER_INVOICE_APPROVAL);
        approvalObjBOList.add(approvalObjBO);
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjBOList);
        createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
        auditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
        this.checkExistProcess(order.getFscOrderId());
        log.info("\u5ba1\u6279\u5165\u53c2================" + JSON.toJSONString((Object)auditCreateReqBO));
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(auditCreateReqBO);
        log.info("\u5ba1\u6279\u51fa\u53c2================" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new FscBusinessException("191019", uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        FscTaskCandidatePO taskPo = new FscTaskCandidatePO();
        taskPo.setFscOrderId(order.getFscOrderId());
        List pendAuditPostIdList = this.fscTaskCandidateMapper.getPendAuditPostIdList(taskPo);
        if (!CollectionUtils.isEmpty((Collection)pendAuditPostIdList)) {
            DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
            dycStationOrgSelectUserNameReqBO.setStationId(Long.valueOf(((FscApprovalTaskQueryBO)pendAuditPostIdList.get(0)).getTaskOperId()));
            DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.dycStationOrgSelectUserNameService.selectUserName(dycStationOrgSelectUserNameReqBO);
            if (dycStationOrgSelectUserNameRspBO != null && !CollectionUtils.isEmpty((Collection)dycStationOrgSelectUserNameRspBO.getUserList())) {
                Map orderTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_TYPE");
                String orderTypeStr = order.getOrderType() == 2 && order.getTradeMode() != null && order.getTradeMode() == 2 && order.getOrderSource() == 3 && order.getSettlePlatform() != null && order.getSettlePlatform() == 2 ? "\u81ea\u9700\u91c7\u8d2d" : (String)orderTypeMap.get(fscOrderPO.getOrderType() + "");
                FscSendNotificationExtAtomReqBO fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
                fscSendNotificationExtAtomReqBO.setTitel(order.getOrderNo() + "\u9500\u552e\u7ed3\u7b97_" + orderTypeStr + "_" + order.getTotalCharge().setScale(2, RoundingMode.HALF_UP) + "\u5f85\u5ba1\u6279");
                fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u5f85\u5ba1\u6279\u7684\u9500\u552e\u7ed3\u7b97\u5355" + order.getOrderNo() + "\u5df2\u63d0\u4ea4\u81f3\u60a8\u5904\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
                fscSendNotificationExtAtomReqBO.setUserId(reqBO.getUserId());
                fscSendNotificationExtAtomReqBO.setReceiveIds(dycStationOrgSelectUserNameRspBO.getUserList().stream().map(UserBO::getUserId).distinct().collect(Collectors.toList()));
                this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
            }
        }
        try {
            this.taskTodoWaitService.syncNotifyAccountWaitDone(order.getFscOrderId());
        }
        catch (Exception e) {
            log.error("dealCreate -\u901a\u77e5\u5f85\u529e\u5931\u8d25- error:{}", (Throwable)e);
        }
        return uacNoTaskAuditCreateRspBO.getNotFindFlag();
    }

    private void valItem(FscOrderPO fscOrderPO) {
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setFscOrderId(fscOrderPO.getFscOrderId());
        List fscOrderItemPOList = this.fscOrderItemMapper.getList(fscOrderItemPO);
        if (!CollectionUtils.isEmpty((Collection)fscOrderItemPOList)) {
            List orderIds = fscOrderItemPOList.stream().map(FscOrderItemPO::getOrderId).collect(Collectors.toList());
            FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
            fscShouldPayPO.setOrderIds(orderIds);
            fscShouldPayPO.setPayeeId(fscOrderPO.getPayeeId());
            ArrayList<Integer> statusList = new ArrayList<Integer>();
            statusList.add(FscConstants.ShouldPayStatus.TO_PAY);
            statusList.add(FscConstants.ShouldPayStatus.PART_PAY);
            statusList.add(FscConstants.ShouldPayStatus.PAYED);
            statusList.add(FscConstants.ShouldPayStatus.TO_RELIEF);
            fscShouldPayPO.setShouldPayStatusList(statusList);
            List fscShouldPayPOList = this.fscShouldPayMapper.getList(fscShouldPayPO);
            if (null != fscShouldPayPOList) {
                for (FscShouldPayPO fscShouldPayPOFor : fscShouldPayPOList) {
                    if (!FscConstants.ShouldObjectType.SALE_ORDER.equals(fscShouldPayPOFor.getObjectType()) && !FscConstants.ShouldObjectType.CHECK_ORDER.equals(fscShouldPayPOFor.getObjectType()) && !FscConstants.ShouldObjectType.DELIVER_ORDER.equals(fscShouldPayPOFor.getObjectType()) || !FscConstants.ShouldPayType.ADVANCE_PAY.equals(fscShouldPayPOFor.getShouldPayType()) && !FscConstants.ShouldPayType.ARRIVAL_SHOULD_PAY.equals(fscShouldPayPOFor.getShouldPayType()) && !FscConstants.ShouldPayType.ACCEPT_SHOULD_PAY.equals(fscShouldPayPOFor.getShouldPayType()) && !FscConstants.ShouldPayType.DEPOSIT_SHOULD_PAY.equals(fscShouldPayPOFor.getShouldPayType()) && !FscConstants.ShouldPayType.PAYMENT_PRE_PAY.equals(fscShouldPayPOFor.getShouldPayType()) || fscShouldPayPOFor.getShouldPayAmount().compareTo(fscShouldPayPOFor.getClaimAmt()) <= 0) continue;
                    throw new FscBusinessException("191026", "\u7ed3\u7b97\u5355\u4e2d\u6709\u8ba2\u5355\u4e3a\u8fdb\u884c\u9884\u6536\u8ba4\u9886\uff0c\u8bf7\u5148\u8ba4\u9886\u540e\u518d\u8fdb\u884c\u7ed3\u7b97\u5f00\u7968\u3002");
                }
            }
        }
    }

    private void dealApproval(FscBillSendSaleFscOrderApplyAbilityReqBO reqBO, FscBillOrderCreateBusiRspBO rspBO) {
        for (Long l : reqBO.getFscOrderIds()) {
            FscOrderPO order = new FscOrderPO();
            order.setFscOrderId(l);
            order = this.fscOrderMapper.getModelBy(order);
            FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
            fscOrderItemPO.setFscOrderId(l);
            List fscOrderItemList = this.fscOrderItemMapper.getList(fscOrderItemPO);
            if (CollectionUtils.isEmpty((Collection)fscOrderItemList)) {
                throw new FscBusinessException("193008", "\u9500\u552e\u7ed3\u7b97\u5355\uff1a" + order.getOrderNo() + "\uff0c\u67e5\u8be2\u7ed3\u7b97\u8ba2\u5355\u660e\u7ec6\u4e3a\u7a7a\uff01");
            }
            int index = 1;
            for (FscOrderItemPO po : fscOrderItemList) {
                if (StringUtils.isNotBlank((CharSequence)po.getSpecificationsModel()) && po.getSpecificationsModel().length() > 120) {
                    throw new FscBusinessException("193004", "\u9500\u552e\u7ed3\u7b97\u5355\uff1a" + order.getOrderNo() + "\uff0c\u7b2c" + index + "\u884c\u89c4\u683c\u578b\u53f7\u4e0d\u53ef\u8d85\u8fc7120\u5b57\u7b26\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\u4e4b\u540e\u8fdb\u884c\u63d0\u4ea4\uff01");
                }
                ++index;
            }
            this.fscOrderMapper.deleteOrderSendTemp(l);
            FscOrderPO fscSendTemp = (FscOrderPO)JSON.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscOrderPO.class);
            fscSendTemp.setFscOrderId(l);
            fscSendTemp.setYcDeptId(reqBO.getDeptId().toString());
            fscSendTemp.setYcDeptName(reqBO.getDeptName());
            fscSendTemp.setYcPersonId(reqBO.getPersonId().toString());
            fscSendTemp.setYcPersonName(reqBO.getPersonName());
            fscSendTemp.setBuynerNo(order.getBuynerNo());
            fscSendTemp.setBuynerName(order.getBuynerName());
            log.debug("========\u63a8\u9001\u9500\u552e\u5355\u7533\u8bf7\u4e34\u65f6\u4fdd\u5b58\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)fscSendTemp));
            this.fscOrderMapper.insertOrderSendTemp(fscSendTemp);
            boolean individuallyPay = !order.getReceiveType().equals(FscConstants.FscOrderReceiveType.INDIVIDUAL);
            Boolean uacFlag = this.invokeUacTask(reqBO, order, individuallyPay);
            FscOrderPO fscOrderPO = new FscOrderPO();
            if (uacFlag.booleanValue() && individuallyPay) {
                throw new FscBusinessException("190000", "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u7ed3\u7b97\u5355\u5ba1\u6279\u6d41\uff01");
            }
            if (uacFlag.booleanValue()) {
                fscOrderPO.setSendState(FscOrderSendStateEnum.NOT_AUDIT.getCode());
                fscOrderPO.setOrderState(FscConstants.FscInvoiceOrderState.APPROVAL_PASS);
                rspBO.setApprovalFlag(true);
            }
            if (!uacFlag.booleanValue()) {
                FscTaskCandidatePO taskPo = new FscTaskCandidatePO();
                taskPo.setFscOrderId(l);
                List pendAuditPostIdList = this.fscTaskCandidateMapper.getPendAuditPostIdList(taskPo);
                fscOrderPO.setSignApplyTime(new Date());
                if (!CollectionUtils.isEmpty((Collection)pendAuditPostIdList)) {
                    List auditedPostIdList = pendAuditPostIdList.stream().map(FscApprovalTaskQueryBO::getTaskOperId).distinct().collect(Collectors.toList());
                    fscOrderPO.setSendStation(Joiner.on((String)",").join(auditedPostIdList) + ",");
                }
                fscOrderPO.setSendState(FscOrderSendStateEnum.NO_AUDIT.getCode());
                fscOrderPO.setSendApplyTime(new Date());
                fscOrderPO.setSendUserId(reqBO.getUserId());
                fscOrderPO.setSendUserName(reqBO.getName());
            }
            fscOrderPO.setFscOrderId(l);
            fscOrderPO.setOperatorId(reqBO.getUserId());
            fscOrderPO.setOperatorName(reqBO.getName());
            String operationNo = String.valueOf(reqBO.getOrgId());
            String[] org = this.proOrg.split(",");
            String[] pur = reqBO.getOrgPath().split("-");
            block2: for (String pro : org) {
                for (String t : pur) {
                    if (!pro.equals(t)) continue;
                    operationNo = pro;
                    continue block2;
                }
            }
            fscOrderPO.setOperationNo(operationNo);
            this.fscOrderMapper.updateById(fscOrderPO);
            if (reqBO.getWebSource() == null || !reqBO.getWebSource().equals(FscConstants.FscWebSource.AGR_DOWN)) continue;
            this.dealWorkFlow(order);
        }
    }

    private void checkOrderBillNum(Map<Long, FscOrderItemPO> itemMap, Integer receiveType) {
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setOrderItemIdSets(itemMap.keySet());
        fscOrderItemPO.setReceiveType(receiveType);
        List orderItemPOS = this.fscOrderItemMapper.getCheckList(fscOrderItemPO);
        if (!CollectionUtils.isEmpty((Collection)orderItemPOS)) {
            for (FscOrderItemPO orderItemPO : orderItemPOS) {
                FscOrderItemPO invoiceItem = itemMap.get(orderItemPO.getOrderItemId());
                orderItemPO.setNum(orderItemPO.getNum().subtract(orderItemPO.getAlreadyRefundNum()));
                orderItemPO.setAmt(orderItemPO.getAmt().subtract(orderItemPO.getAlreadyRefundAmt()));
                if (invoiceItem.getTotalNum().subtract(orderItemPO.getNum()).compareTo(invoiceItem.getNum()) < 0) {
                    throw new FscBusinessException("198888", "\u8ba2\u5355\u660e\u7ec6\u884c[" + invoiceItem.getOrderItemId() + "]\u672c\u6b21\u63d0\u7968\u6570\u91cf\u8d85\u8fc7\u53ef\u63d0\u7968\u6570\u91cf\uff01");
                }
                if (invoiceItem.getTotalAmt().subtract(orderItemPO.getAmt()).compareTo(invoiceItem.getAmt()) >= 0) continue;
                throw new FscBusinessException("198888", "\u8ba2\u5355\u660e\u7ec6\u884c[" + invoiceItem.getOrderItemId() + "]\u672c\u6b21\u63d0\u7968\u6570\u91cf\u8d85\u8fc7\u53ef\u63d0\u7968\u6570\u91cf\uff01");
            }
        }
    }

    private void checkTemp(FscBillOrderCreateBusiReqBO reqBO, FscOrderItemPO fscOrderItemPO, RelOrderBO relOrderBO, FscOrderInfoBO fscOrderInfoBO, List<FscCheckTempPO> list) {
        if ("1".equals(reqBO.getIsprofess()) && !FscConstants.FscOrderOperType.save.equals(reqBO.getOperType())) {
            FscCheckTempPO po;
            if (StringUtils.isNotBlank((CharSequence)fscOrderItemPO.getProductDescription()) && FscCommonUtils.getLength((String)fscOrderItemPO.getProductDescription()) > 90) {
                po = new FscCheckTempPO();
                if (!StringUtils.isBlank((CharSequence)reqBO.getFscOrderNo())) {
                    po.setObjNo(reqBO.getFscOrderNo());
                }
                po.setObjId(fscOrderItemPO.getFscOrderId());
                po.setOrderId(relOrderBO.getOrderId() + "");
                po.setOrderNo(fscOrderInfoBO.getOrderNo());
                po.setSkuName(fscOrderItemPO.getSkuName());
                po.setType("0");
                po.setReason("\u5f00\u7968\u540d\u79f0\u5b57\u6bb5\u9650\u523690\u5b57\u7b26");
                list.add(po);
            }
            if (StringUtils.isBlank((CharSequence)fscOrderItemPO.getSpecificationsModel())) {
                po = new FscCheckTempPO();
                if (!StringUtils.isBlank((CharSequence)reqBO.getFscOrderNo())) {
                    po.setObjNo(reqBO.getFscOrderNo());
                }
                po.setObjId(fscOrderItemPO.getFscOrderId());
                po.setOrderId(relOrderBO.getOrderId() + "");
                po.setOrderNo(fscOrderInfoBO.getOrderNo());
                po.setSkuName(fscOrderItemPO.getSkuName());
                po.setType("1");
                po.setReason("\u89c4\u683c\u578b\u53f7\u4e3a\u7a7a");
                list.add(po);
            }
            if (StringUtils.isNotBlank((CharSequence)fscOrderItemPO.getSpecificationsModel()) && FscCommonUtils.getLength((String)fscOrderItemPO.getSpecificationsModel()) > 40) {
                po = new FscCheckTempPO();
                if (!StringUtils.isBlank((CharSequence)reqBO.getFscOrderNo())) {
                    po.setObjNo(reqBO.getFscOrderNo());
                }
                po.setObjId(fscOrderItemPO.getFscOrderId());
                po.setOrderId(relOrderBO.getOrderId() + "");
                po.setOrderNo(fscOrderInfoBO.getOrderNo());
                po.setSkuName(fscOrderItemPO.getSkuName());
                po.setType("0");
                po.setReason("\u89c4\u683c\u578b\u53f7\u5b57\u6bb5\u957f\u5ea6\u9650\u523640\u5b57\u7b26");
                list.add(po);
            }
            this.fscCheckTempMapper.deleteByObjId(fscOrderItemPO.getFscOrderId());
        }
    }

    private void checkExistProcess(Long fscOrderId) {
        int count = this.fscOrderMapper.selectStepIdCount(fscOrderId, FscConstants.AuditObjType.ORDER_INVOICE_APPROVAL);
        if (count > 0) {
            throw new FscBusinessException("191019", "\u8be5\u5355\u636e\u5df2\u63d0\u4ea4\u5ba1\u6279");
        }
    }

    private void checkOliTaxCode(List<FscOrderItemPO> pos) {
        List<FscOrderItemPO> bos = pos.stream().filter(x -> !org.springframework.util.StringUtils.isEmpty((Object)x.getTaxCode()) && this.oilTaxCode.contains(x.getTaxCode()) && Objects.nonNull(x.getNum()) && x.getNum().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(bos)) {
            log.info("\u6210\u6cb9\u54c1\u660e\u7ec6\u6821\u9a8c\uff1a{}", (Object)JSON.toJSONString(bos));
            BigDecimal submitCount = this.calOliCount(bos);
            BigDecimal downCount = this.calOliCount(this.fscOrderItemMapper.queryDownOilTaxCode(Arrays.stream(this.oilTaxCode.split(",")).collect(Collectors.toList())));
            BigDecimal upCount = this.calOliCount(this.fscOrderItemMapper.queryUpOilTaxCode(Arrays.stream(this.oilTaxCode.split(",")).collect(Collectors.toList())));
            BigDecimal maxCount = upCount.subtract(downCount);
            if (submitCount.compareTo(maxCount) > 0) {
                throw new FscBusinessException("198888", "\u6210\u54c1\u6cb9\u5df2\u6536\u53d1\u7968" + upCount + "\u5347,\u5df2\u5f00\u53d1\u7968" + downCount + "\u5347,\u6700\u5927\u53ef\u5f00\u53d1\u7968" + maxCount + "\u5347\uff0c\u5f53\u524d\u5355\u636e" + submitCount + "\u5347\uff0c\u65e0\u6cd5\u6ee1\u8db3\u5f00\u7968\u8981\u6c42\uff0c\u8bf7\u8054\u7cfb\u4e1a\u52a1\u5458\u5b8c\u6210\u6536\u7968\u5904\u7406\u540e\u518d\u7ee7\u7eed\u5f00\u7968\u3002");
            }
        }
    }

    private BigDecimal calOliCount(List<FscOrderItemPO> pos) {
        BigDecimal sgNum = pos.stream().filter(x -> "\u5347".equals(x.getUnit())).map(FscOrderItemPO::getNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal dunNum = pos.stream().filter(x -> "\u5428".equals(x.getUnit())).map(y -> y.getNum().multiply(BigDecimal.valueOf(1126L))).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal tgNum = pos.stream().filter(x -> "\u6876".equals(x.getUnit())).map(y -> (Objects.nonNull(y.getSettleNum()) ? y.getSettleNum() : y.getNum()).multiply(BigDecimal.valueOf(1126L))).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal gjNum = pos.stream().filter(x -> "\u516c\u65a4".equals(x.getUnit())).map(y -> y.getNum().multiply(BigDecimal.valueOf(1.126))).reduce(BigDecimal.ZERO, BigDecimal::add);
        return sgNum.add(dunNum).add(tgNum).add(gjNum);
    }
}

