/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.consumer;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.fsc.bill.ability.api.FscBillOrderCreateAbilityService;
import com.tydic.fsc.bill.ability.api.FscBillOrderInvoiceCreateAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillOrderCreateAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderCreateAbilityRspBO;
import com.tydic.fsc.bo.RelOrderBO;
import com.tydic.fsc.bo.SplitOrderBO;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.constants.FscConstants;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class FscDownTakeUpCreateOrderServiceConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(FscDownTakeUpCreateOrderServiceConsumer.class);
    @Autowired
    private FscBillOrderCreateAbilityService fscBillOrderCreateAbilityService;
    @Autowired
    private FscBillOrderInvoiceCreateAbilityService fscBillOrderInvoiceCreateAbilityService;
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        try {
            FscBillOrderCreateAbilityReqBO reqBO = (FscBillOrderCreateAbilityReqBO)JSON.parseObject((String)message.getContent(), FscBillOrderCreateAbilityReqBO.class);
            if (log.isDebugEnabled()) {
                log.debug("\u4e0b\u6e38\u5e26\u52a8\u4e0a\u6e38\u5f00\u7968\u6d88\u8d39\u8005\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqBO));
            }
            Map<Long, SplitOrderBO> splitMap = this.splitOrder(reqBO);
            for (Long key : splitMap.keySet()) {
                FscBillOrderCreateAbilityRspBO rspBO;
                SplitOrderBO splitOrderBO = splitMap.get(key);
                FscBillOrderCreateAbilityReqBO splitReqBO = new FscBillOrderCreateAbilityReqBO();
                BeanUtils.copyProperties((Object)reqBO, (Object)splitReqBO);
                ArrayList<SplitOrderBO> splitOrderBOList = new ArrayList<SplitOrderBO>();
                splitOrderBOList.add(splitOrderBO);
                splitReqBO.setSplitOrderList(splitOrderBOList);
                splitReqBO.setSupplierId(((RelOrderBO)splitOrderBO.getRelOrderList().get(0)).getSupId());
                splitReqBO.setSupplierName(((RelOrderBO)splitOrderBO.getRelOrderList().get(0)).getSupName());
                if (log.isDebugEnabled()) {
                    log.debug("\u4e0b\u6e38\u5e26\u52a8\u4e0a\u6e38\u5f00\u7968\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)splitReqBO));
                }
                if ("0000".equals((rspBO = reqBO.getSettleType().equals(FscConstants.SettleType.INSPECTION) ? this.fscBillOrderCreateAbilityService.dealCreate(splitReqBO) : this.fscBillOrderInvoiceCreateAbilityService.dealOrderInvoiceCreate(reqBO)).getRespCode())) continue;
                this.writeFailLog(splitReqBO, rspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private Map<Long, SplitOrderBO> splitOrder(FscBillOrderCreateAbilityReqBO reqBO) {
        HashMap<Long, SplitOrderBO> splitMap = new HashMap<Long, SplitOrderBO>(8);
        for (SplitOrderBO splitOrderBO : reqBO.getSplitOrderList()) {
            for (RelOrderBO relOrderBO : splitOrderBO.getRelOrderList()) {
                List<RelOrderBO> relOrderList;
                SplitOrderBO split;
                if (splitMap.get(relOrderBO.getSupId()) == null) {
                    split = new SplitOrderBO();
                    split.setAmount(relOrderBO.getAmount());
                    split.setOrderNum(Integer.valueOf(1));
                    relOrderList = new ArrayList<RelOrderBO>();
                    relOrderList.add(relOrderBO);
                    split.setRelOrderList(relOrderList);
                    splitMap.put(relOrderBO.getSupId(), split);
                    continue;
                }
                split = (SplitOrderBO)splitMap.get(relOrderBO.getSupId());
                split.setAmount(split.getAmount().add(relOrderBO.getAmount()));
                split.setOrderNum(Integer.valueOf(split.getOrderNum() + 1));
                relOrderList = split.getRelOrderList();
                relOrderList.add(relOrderBO);
                split.setRelOrderList(relOrderList);
            }
        }
        return splitMap;
    }

    private void writeFailLog(FscBillOrderCreateAbilityReqBO reqBO, String failDesc) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setBusiFailReq(JSON.toJSONString((Object)reqBO));
        fscOrderFailLogUpdateBusiReqBO.setBusiFailDesc(failDesc);
        fscOrderFailLogUpdateBusiReqBO.setBusiFailTime(new Date());
        fscOrderFailLogUpdateBusiReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.FSC_DOWN_TAKE_UP_FAIL);
        this.fscOrderFailLogUpdateBusiService.dealInsert(fscOrderFailLogUpdateBusiReqBO);
    }
}

