/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.fsc.bill.ability.api.FscBillOrderInvoiceItemListQueryAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillOrderInvoiceItemListExportQueryAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderInvoiceItemListExportQueryAbilityRspBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderInvoiceItemListExportQueryBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderInvoiceItemListQueryAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderInvoiceItemListQueryAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillOrderInvoiceItemListQueryBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceItemListQueryBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceItemListQueryBusiRspBO;
import com.tydic.fsc.bo.InvoiceItemBO;
import com.tydic.fsc.bo.OrderInvoiceBO;
import com.tydic.fsc.dao.FscInvoiceItemMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoiceItemPO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillOrderInvoiceItemListQueryAbilityService"})
public class FscBillOrderInvoiceItemListQueryAbilityServiceImpl
implements FscBillOrderInvoiceItemListQueryAbilityService {
    @Autowired
    private FscBillOrderInvoiceItemListQueryBusiService fscBillOrderInvoiceItemListQueryBusiService;
    @Autowired
    private FscInvoiceItemMapper fscInvoiceItemMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;

    @BigDecimalConvert(value=2)
    @PostMapping(value={"qryInvoiceItemList"})
    public FscBillOrderInvoiceItemListQueryAbilityRspBO qryInvoiceItemList(@RequestBody FscBillOrderInvoiceItemListQueryAbilityReqBO reqBO) {
        this.verification(reqBO);
        String jsonString = JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        FscBillOrderInvoiceItemListQueryBusiReqBO busiReqBO = (FscBillOrderInvoiceItemListQueryBusiReqBO)((Object)JSON.parseObject((String)jsonString, FscBillOrderInvoiceItemListQueryBusiReqBO.class));
        FscBillOrderInvoiceItemListQueryBusiRspBO busiRspBO = this.fscBillOrderInvoiceItemListQueryBusiService.qryInvoiceItemList(busiReqBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new FscBusinessException("191017", busiRspBO.getRespDesc());
        }
        String rspString = JSON.toJSONString((Object)((Object)busiRspBO), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        return (FscBillOrderInvoiceItemListQueryAbilityRspBO)JSON.parseObject((String)rspString, FscBillOrderInvoiceItemListQueryAbilityRspBO.class);
    }

    @PostMapping(value={"qryInvoiceItemListExport"})
    public FscBillOrderInvoiceItemListExportQueryAbilityRspBO qryInvoiceItemListExport(@RequestBody FscBillOrderInvoiceItemListExportQueryAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getFscOrderIds())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[fscOrderIds]\u4e3a\u7a7a");
        }
        FscBillOrderInvoiceItemListExportQueryAbilityRspBO rspBO = new FscBillOrderInvoiceItemListExportQueryAbilityRspBO();
        FscInvoiceItemPO fscInvoiceItemPO = new FscInvoiceItemPO();
        fscInvoiceItemPO.setFscOrderIdList(reqBO.getFscOrderIds());
        List fscInvoiceItemPOList = this.fscInvoiceItemMapper.getListByFscOrderIds(fscInvoiceItemPO);
        FscOrderInvoicePO fscOrderInvoicePO = new FscOrderInvoicePO();
        fscOrderInvoicePO.setFscOrderIdList(reqBO.getFscOrderIds());
        List fscOrderInvoicePOList = this.fscOrderInvoiceMapper.getList(fscOrderInvoicePO);
        Map<Long, FscOrderInvoicePO> map = null;
        if (!CollectionUtils.isEmpty((Collection)fscOrderInvoicePOList)) {
            map = fscOrderInvoicePOList.stream().collect(Collectors.toMap(FscOrderInvoicePO::getFscOrderId, x -> x));
        }
        ArrayList<FscBillOrderInvoiceItemListExportQueryBO> list = new ArrayList<FscBillOrderInvoiceItemListExportQueryBO>();
        for (FscOrderInvoicePO orderInvoicePO : fscOrderInvoicePOList) {
            List collect;
            FscBillOrderInvoiceItemListExportQueryBO queryBO = new FscBillOrderInvoiceItemListExportQueryBO();
            FscOrderInvoicePO fscOrderInvoicePO1 = map.get(orderInvoicePO.getFscOrderId());
            if (fscOrderInvoicePO1 != null) {
                queryBO.setOrderInvoiceBO((OrderInvoiceBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)fscOrderInvoicePO1), OrderInvoiceBO.class));
            }
            if (!CollectionUtils.isEmpty((Collection)fscInvoiceItemPOList) && !CollectionUtils.isEmpty(collect = fscInvoiceItemPOList.stream().filter(x -> orderInvoicePO.getFscOrderId().equals(x.getFscOrderId())).collect(Collectors.toList()))) {
                for (FscInvoiceItemPO invoiceItemPO : collect) {
                    if (!"3".equals(invoiceItemPO.getInvoiceCategory())) continue;
                    invoiceItemPO.setInvoiceNo(invoiceItemPO.getInvoiceCode() + invoiceItemPO.getInvoiceNo());
                }
                queryBO.setInvoiceItemBOList(JSONObject.parseArray((String)JSONObject.toJSONString(collect), InvoiceItemBO.class));
            }
            list.add(queryBO);
        }
        rspBO.setList(list);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void verification(FscBillOrderInvoiceItemListQueryAbilityReqBO reqBO) {
        if (null == reqBO.getFscOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[fscOrderId]\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[invoiceId]\u4e3a\u7a7a");
        }
    }
}

