/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.api.FscBillPayRefundCreateAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillPayRefundCreateAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillPayRefundCreateAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillPayRefundCreateBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillPayRefundCreateBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillPayRefundCreateBusiRspBO;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillPayRefundCreateAbilityService"})
public class FscBillPayRefundCreateAbilityServiceImpl
implements FscBillPayRefundCreateAbilityService {
    @Autowired
    private FscBillPayRefundCreateBusiService fscBillPayRefundCreateBusiService;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;
    @Value(value="${OPERATION_SUP_ID:1001693}")
    private Long operationSupId;

    @PostMapping(value={"dealPayRefundCreate"})
    public FscBillPayRefundCreateAbilityRspBO dealPayRefundCreate(@RequestBody FscBillPayRefundCreateAbilityReqBO reqBO) {
        this.valid(reqBO);
        FscBillPayRefundCreateBusiReqBO fscBillPayRefundCreateBusiReqBO = (FscBillPayRefundCreateBusiReqBO)((Object)JSON.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscBillPayRefundCreateBusiReqBO.class));
        FscBillPayRefundCreateBusiRspBO fscBillPayRefundCreateBusiRspBO = this.fscBillPayRefundCreateBusiService.dealPayRefundCreate(fscBillPayRefundCreateBusiReqBO);
        if (!"0000".equals(fscBillPayRefundCreateBusiRspBO.getRespCode())) {
            return (FscBillPayRefundCreateAbilityRspBO)JSON.parseObject((String)JSONObject.toJSONString((Object)((Object)fscBillPayRefundCreateBusiRspBO)), FscBillPayRefundCreateAbilityRspBO.class);
        }
        if (fscBillPayRefundCreateBusiRspBO.getRefundId() != null) {
            this.syncEs(fscBillPayRefundCreateBusiRspBO);
        }
        FscBillPayRefundCreateAbilityRspBO rspBO = new FscBillPayRefundCreateAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void syncEs(FscBillPayRefundCreateBusiRspBO busiRspBO) {
        FscComRefundSyncAbilityReqBO refundSyncAbilityReqBO = new FscComRefundSyncAbilityReqBO();
        refundSyncAbilityReqBO.setRefundIds(Collections.singletonList(busiRspBO.getRefundId()));
        this.fscComRefundSyncAbilityService.syncRefund(refundSyncAbilityReqBO);
    }

    private void valid(FscBillPayRefundCreateAbilityReqBO reqBO) {
        if (reqBO.getOperationType() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[operationType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getRefundNo())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getRefundDate() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundDate]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getRefundReasonType() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundReasonType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getRefundAmount() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundAmount]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getUserType() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[userType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (FscConstants.RefundUserType.PURCHASE.equals(reqBO.getUserType()) && ("0".equals(reqBO.getIsprofess()) || this.operationSupId.equals(reqBO.getOrgId()))) {
            if (reqBO.getAgentUserId() == null) {
                throw new FscBusinessException("198888", "\u5165\u53c2[agentUserId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)reqBO.getAgentUserName())) {
                throw new FscBusinessException("198888", "\u5165\u53c2[agentUserName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (reqBO.getAgentDeptId() == null) {
                throw new FscBusinessException("198888", "\u5165\u53c2[agentDeptId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)reqBO.getAgentDeptName())) {
                throw new FscBusinessException("198888", "\u5165\u53c2[agentDeptName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getFscRefundShouldPayBOS())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fscRefundShouldPayBOS]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

