/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.api.FscBillPayRefundRegisterAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillPayRefundRegisterAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillPayRefundRegisterAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillPayRefundRegisterBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillPayRefundRegisterBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillPayRefundRegisterBusiRspBO;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderRefundPO;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillPayRefundRegisterAbilityService"})
public class FscBillPayRefundRegisterAbilityServiceImpl
implements FscBillPayRefundRegisterAbilityService {
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscBillPayRefundRegisterBusiService fscBillPayRefundRegisterBusiService;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;

    @PostMapping(value={"dealPayRefundRegister"})
    public FscBillPayRefundRegisterAbilityRspBO dealPayRefundRegister(@RequestBody FscBillPayRefundRegisterAbilityReqBO reqBO) {
        FscBillPayRefundRegisterAbilityRspBO rspBO = new FscBillPayRefundRegisterAbilityRspBO();
        if (reqBO.getRefundId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getFscRefundShouldPayBOS())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fscRefundShouldPayBOS]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String reqString = JSONObject.toJSONString((Object)reqBO);
        FscBillPayRefundRegisterBusiReqBO busiReqBO = (FscBillPayRefundRegisterBusiReqBO)((Object)JSONObject.parseObject((String)reqString, FscBillPayRefundRegisterBusiReqBO.class));
        FscOrderRefundPO refundPO = this.fscOrderRefundMapper.queryById(reqBO.getRefundId());
        if (!(FscConstants.RefundPayOrderState.REFUND_COMFIR.equals(refundPO.getRefundStatus()) || FscConstants.RefundPayOrderState.REFUNDING.equals(refundPO.getRefundStatus()) || FscConstants.RefundPayOrderState.SIGNED.equals(refundPO.getRefundStatus()))) {
            throw new FscBusinessException("198888", "\u9000\u6b3e\u5355[" + refundPO.getRefundNo() + "]\u72b6\u6001\u5f02\u5e38\uff01");
        }
        FscBillPayRefundRegisterBusiRspBO busiRspBO = this.fscBillPayRefundRegisterBusiService.dealPayRefundRegister(busiReqBO);
        if (!busiRspBO.getRespCode().equals("0000")) {
            return (FscBillPayRefundRegisterAbilityRspBO)JSON.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), FscBillPayRefundRegisterAbilityRspBO.class);
        }
        rspBO.setRespCode("0000");
        this.sendMq(reqBO.getRefundId());
        return rspBO;
    }

    private void sendMq(Long refundId) {
        FscComRefundSyncAbilityReqBO syncAbilityReqBO = new FscComRefundSyncAbilityReqBO();
        syncAbilityReqBO.setRefundIds(Collections.singletonList(refundId));
        this.fscComRefundSyncAbilityService.syncRefund(syncAbilityReqBO);
    }
}

