/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.api.FscBillPayRefundSubmitAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillPayRefundSubmitAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillPayRefundSubmitAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillPayRefundSubmitBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillPayRefundSubmitBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillPayRefundSubmitBusiRspBO;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderRefundPO;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillPayRefundSubmitAbilityService"})
public class FscBillPayRefundSubmitAbilityServiceImpl
implements FscBillPayRefundSubmitAbilityService {
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscBillPayRefundSubmitBusiService fscBillPayRefundSubmitBusiService;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;

    @PostMapping(value={"dealPayRefundSubmit"})
    public FscBillPayRefundSubmitAbilityRspBO dealPayRefundSubmit(@RequestBody FscBillPayRefundSubmitAbilityReqBO reqBO) {
        FscBillPayRefundSubmitAbilityRspBO rspBO = new FscBillPayRefundSubmitAbilityRspBO();
        this.valid(reqBO);
        String reqString = JSONObject.toJSONString((Object)reqBO);
        FscBillPayRefundSubmitBusiReqBO busiReqBO = (FscBillPayRefundSubmitBusiReqBO)((Object)JSONObject.parseObject((String)reqString, FscBillPayRefundSubmitBusiReqBO.class));
        FscOrderRefundPO refundPO = this.fscOrderRefundMapper.queryById(reqBO.getRefundId());
        if (!FscConstants.RefundPayOrderState.TO_COMFIR.equals(refundPO.getRefundStatus())) {
            throw new FscBusinessException("198888", "\u9000\u6b3e\u5355[" + refundPO.getRefundNo() + "]\u72b6\u6001\u5f02\u5e38\uff01");
        }
        FscBillPayRefundSubmitBusiRspBO busiRspBO = this.fscBillPayRefundSubmitBusiService.dealPayRefundSubmit(busiReqBO);
        if (!busiRspBO.getRespCode().equals("0000")) {
            return (FscBillPayRefundSubmitAbilityRspBO)JSON.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), FscBillPayRefundSubmitAbilityRspBO.class);
        }
        rspBO.setRespCode("0000");
        this.sendMq(reqBO.getRefundId());
        return rspBO;
    }

    private void sendMq(Long refundId) {
        FscComRefundSyncAbilityReqBO syncAbilityReqBO = new FscComRefundSyncAbilityReqBO();
        syncAbilityReqBO.setRefundIds(Collections.singletonList(refundId));
        this.fscComRefundSyncAbilityService.syncRefund(syncAbilityReqBO);
    }

    private void valid(FscBillPayRefundSubmitAbilityReqBO reqBO) {
        if (reqBO.getRefundId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getAgentUserId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[agentUserId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getAgentUserName())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[agentUserName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getAgentDeptId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[agentDeptId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getAgentDeptName())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[agentDeptName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

