/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.tydic.fsc.bill.ability.api.FscBillSpecialRefundItemListQryAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillSpecialRefundItemListQryAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillSpecialRefundItemListQryAbilityRspBO;
import com.tydic.fsc.bill.ability.bo.FscTracfficInvoiceCreateInvoiceBO;
import com.tydic.fsc.bo.FscOrderItemBO;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillSpecialRefundItemListQryAbilityService"})
public class FscBillSpecialRefundItemListQryAbilityServiceImpl
implements FscBillSpecialRefundItemListQryAbilityService {
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;

    @PostMapping(value={"qrySpecialRefundItemList"})
    public FscBillSpecialRefundItemListQryAbilityRspBO qrySpecialRefundItemList(@RequestBody FscBillSpecialRefundItemListQryAbilityReqBO reqBO) {
        if (reqBO.getRefundId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u9000\u7968\u5355id[refundId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getRefundId());
        refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
        if (refundPO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u9000\u7968\u4e3b\u5355\u4fe1\u606f\uff01");
        }
        FscOrderItemPO refundItemPO = new FscOrderItemPO();
        refundItemPO.setRefundId(reqBO.getRefundId());
        List refundItemList = this.fscOrderItemMapper.getListNoPage(refundItemPO);
        FscOrderItemPO orderItemPO = new FscOrderItemPO();
        orderItemPO.setFscOrderId(refundPO.getFscOrderId());
        List invoiceItemList = this.fscOrderItemMapper.getListNoPage(orderItemPO);
        Map<Long, FscOrderItemPO> invoiceMap = invoiceItemList.stream().collect(Collectors.toMap(FscOrderItemPO::getOrderItemId, e -> e));
        HashMap<Long, FscOrderItemBO> refundMap = new HashMap<Long, FscOrderItemBO>();
        for (Object itemPO : refundItemList) {
            if (refundMap.get(itemPO.getOrderItemId()) == null) {
                FscOrderItemBO orderItemBO = new FscOrderItemBO();
                BeanUtils.copyProperties((Object)itemPO, (Object)orderItemBO);
                refundMap.put(itemPO.getOrderItemId(), orderItemBO);
                continue;
            }
            FscOrderItemBO fscOrderItemBO = (FscOrderItemBO)refundMap.get(itemPO.getOrderItemId());
            fscOrderItemBO.setAmt(fscOrderItemBO.getAmt().add(itemPO.getAmt()));
            fscOrderItemBO.setTaxAmt(fscOrderItemBO.getTaxAmt().add(itemPO.getTaxAmt()));
            fscOrderItemBO.setUntaxAmt(fscOrderItemBO.getUntaxAmt().add(itemPO.getUntaxAmt()));
            fscOrderItemBO.setNum(fscOrderItemBO.getNum().add(itemPO.getNum()));
            refundMap.put(fscOrderItemBO.getOrderItemId(), fscOrderItemBO);
        }
        ArrayList<FscOrderItemBO> itemList = new ArrayList<FscOrderItemBO>(refundMap.size());
        for (Long key : refundMap.keySet()) {
            FscOrderItemBO refundItemBO = (FscOrderItemBO)refundMap.get(key);
            FscOrderItemPO invoiceItemPO = invoiceMap.get(key);
            refundItemBO.setCgPayAmount(invoiceItemPO.getCgPayAmount());
            refundItemBO.setFdPercent(invoiceItemPO.getFdPercent());
            refundItemBO.setTaxRate(invoiceItemPO.getTaxRate());
            refundItemBO.setSkuNo(invoiceItemPO.getSkuNo());
            refundItemBO.setSkuName(invoiceItemPO.getSkuName());
            itemList.add(refundItemBO);
        }
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(refundPO.getFscOrderId());
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        FscBillSpecialRefundItemListQryAbilityRspBO rspBO = new FscBillSpecialRefundItemListQryAbilityRspBO();
        rspBO.setItemList(itemList);
        rspBO.setFscOrderId(orderPO.getFscOrderId());
        rspBO.setFscOrderNo(orderPO.getOrderNo());
        rspBO.setSupplierId(orderPO.getSupplierId());
        rspBO.setSupplierName(orderPO.getSupplierName());
        rspBO.setContractId(orderPO.getContractId());
        rspBO.setContractNo(orderPO.getContractNo());
        rspBO.setRefundId(refundPO.getRefundId());
        rspBO.setRefundNo(refundPO.getRefundNo());
        FscOrderInvoicePO orderInvoicePO = new FscOrderInvoicePO();
        orderInvoicePO.setFscOrderId(orderPO.getFscOrderId());
        orderInvoicePO = this.fscOrderInvoiceMapper.getModelBy(orderInvoicePO);
        if (orderInvoicePO != null) {
            FscTracfficInvoiceCreateInvoiceBO invoiceBO = new FscTracfficInvoiceCreateInvoiceBO();
            invoiceBO.setInvoiceId(orderInvoicePO.getInvoiceId());
            invoiceBO.setBuyName(orderInvoicePO.getBuyName());
            invoiceBO.setTaxNo(orderInvoicePO.getTaxNo());
            invoiceBO.setInvoiceType(orderInvoicePO.getInvoiceType());
            invoiceBO.setInvoiceCategory(orderInvoicePO.getInvoiceCategory().toString());
            invoiceBO.setBank(orderInvoicePO.getBank());
            invoiceBO.setAccount(orderInvoicePO.getAccount());
            invoiceBO.setAddress(orderInvoicePO.getAddress());
            invoiceBO.setPhone(orderInvoicePO.getPhone());
            if ("1".equals(orderInvoicePO.getInvoiceType())) {
                invoiceBO.setInvoiceTypeStr("\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968");
            } else if ("2".equals(orderInvoicePO.getInvoiceType())) {
                invoiceBO.setInvoiceTypeStr("\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968");
            }
            if (Integer.valueOf(1).equals(orderInvoicePO.getInvoiceCategory())) {
                invoiceBO.setInvoiceCategoryStr("\u7eb8\u8d28\u53d1\u7968");
            } else if (Integer.valueOf(2).equals(orderInvoicePO.getInvoiceCategory())) {
                invoiceBO.setInvoiceCategoryStr("\u7535\u5b50\u53d1\u7968");
            } else if (Integer.valueOf(3).equals(orderInvoicePO.getInvoiceCategory())) {
                invoiceBO.setInvoiceCategoryStr("\u5168\u7535\u7968");
            }
            rspBO.setInvoiceBO(invoiceBO);
        }
        FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
        fscOrderRelationPO.setFscOrderId(refundPO.getFscOrderId());
        fscOrderRelationPO = this.fscOrderRelationMapper.getModelBy(fscOrderRelationPO);
        if (fscOrderRelationPO != null) {
            rspBO.setContractName(fscOrderRelationPO.getContractName());
        }
        return rspBO;
    }
}

